/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.apigateway.model;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;

@Generated("software.amazon.awssdk:codegen")
final class ListOfSdkTypeCopier {
    static List<SdkType> copy(Collection<? extends SdkType> listOfSdkTypeParam) {
        List<SdkType> list;
        if (listOfSdkTypeParam == null || listOfSdkTypeParam instanceof SdkAutoConstructList) {
            list = DefaultSdkAutoConstructList.getInstance();
        } else {
            List<SdkType> modifiableList = new ArrayList<>(listOfSdkTypeParam.size());
            listOfSdkTypeParam.forEach(entry -> {
                modifiableList.add(entry);
            });
            list = Collections.unmodifiableList(modifiableList);
        }
        return list;
    }

    static List<SdkType> copyFromBuilder(Collection<? extends SdkType.Builder> listOfSdkTypeParam) {
        List<SdkType> list;
        if (listOfSdkTypeParam == null || listOfSdkTypeParam instanceof SdkAutoConstructList) {
            list = DefaultSdkAutoConstructList.getInstance();
        } else {
            List<SdkType> modifiableList = new ArrayList<>(listOfSdkTypeParam.size());
            listOfSdkTypeParam.forEach(entry -> {
                SdkType member = entry == null ? null : entry.build();
                modifiableList.add(member);
            });
            list = Collections.unmodifiableList(modifiableList);
        }
        return list;
    }

    static List<SdkType.Builder> copyToBuilder(Collection<? extends SdkType> listOfSdkTypeParam) {
        List<SdkType.Builder> list;
        if (listOfSdkTypeParam == null || listOfSdkTypeParam instanceof SdkAutoConstructList) {
            list = DefaultSdkAutoConstructList.getInstance();
        } else {
            List<SdkType.Builder> modifiableList = new ArrayList<>(listOfSdkTypeParam.size());
            listOfSdkTypeParam.forEach(entry -> {
                SdkType.Builder member = entry == null ? null : entry.toBuilder();
                modifiableList.add(member);
            });
            list = Collections.unmodifiableList(modifiableList);
        }
        return list;
    }
}
