/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.apigateway.model;

import java.time.Instant;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.MapTrait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructMap;
import software.amazon.awssdk.core.util.SdkAutoConstructMap;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * An immutable representation of a RestApi resource that can be called by users using Stages. A deployment must be
 * associated with a Stage for it to be callable over the Internet.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class GetDeploymentResponse extends ApiGatewayResponse implements
        ToCopyableBuilder<GetDeploymentResponse.Builder, GetDeploymentResponse> {
    private static final SdkField<String> ID_FIELD = SdkField.<String> builder(MarshallingType.STRING).memberName("id")
            .getter(getter(GetDeploymentResponse::id)).setter(setter(Builder::id))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("id").build()).build();

    private static final SdkField<String> DESCRIPTION_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("description").getter(getter(GetDeploymentResponse::description)).setter(setter(Builder::description))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("description").build()).build();

    private static final SdkField<Instant> CREATED_DATE_FIELD = SdkField.<Instant> builder(MarshallingType.INSTANT)
            .memberName("createdDate").getter(getter(GetDeploymentResponse::createdDate)).setter(setter(Builder::createdDate))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("createdDate").build()).build();

    private static final SdkField<Map<String, Map<String, MethodSnapshot>>> API_SUMMARY_FIELD = SdkField
            .<Map<String, Map<String, MethodSnapshot>>> builder(MarshallingType.MAP)
            .memberName("apiSummary")
            .getter(getter(GetDeploymentResponse::apiSummary))
            .setter(setter(Builder::apiSummary))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("apiSummary").build(),
                    MapTrait.builder()
                            .keyLocationName("key")
                            .valueLocationName("value")
                            .valueFieldInfo(
                                    SdkField.<Map<String, MethodSnapshot>> builder(MarshallingType.MAP)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("value").build(),
                                                    MapTrait.builder()
                                                            .keyLocationName("key")
                                                            .valueLocationName("value")
                                                            .valueFieldInfo(
                                                                    SdkField.<MethodSnapshot> builder(MarshallingType.SDK_POJO)
                                                                            .constructor(MethodSnapshot::builder)
                                                                            .traits(LocationTrait.builder()
                                                                                    .location(MarshallLocation.PAYLOAD)
                                                                                    .locationName("value").build()).build())
                                                            .build()).build()).build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(ID_FIELD, DESCRIPTION_FIELD,
            CREATED_DATE_FIELD, API_SUMMARY_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = Collections
            .unmodifiableMap(new HashMap<String, SdkField<?>>() {
                {
                    put("id", ID_FIELD);
                    put("description", DESCRIPTION_FIELD);
                    put("createdDate", CREATED_DATE_FIELD);
                    put("apiSummary", API_SUMMARY_FIELD);
                }
            });

    private final String id;

    private final String description;

    private final Instant createdDate;

    private final Map<String, Map<String, MethodSnapshot>> apiSummary;

    private GetDeploymentResponse(BuilderImpl builder) {
        super(builder);
        this.id = builder.id;
        this.description = builder.description;
        this.createdDate = builder.createdDate;
        this.apiSummary = builder.apiSummary;
    }

    /**
     * <p>
     * The identifier for the deployment resource.
     * </p>
     * 
     * @return The identifier for the deployment resource.
     */
    public final String id() {
        return id;
    }

    /**
     * <p>
     * The description for the deployment resource.
     * </p>
     * 
     * @return The description for the deployment resource.
     */
    public final String description() {
        return description;
    }

    /**
     * <p>
     * The date and time that the deployment resource was created.
     * </p>
     * 
     * @return The date and time that the deployment resource was created.
     */
    public final Instant createdDate() {
        return createdDate;
    }

    /**
     * For responses, this returns true if the service returned a value for the ApiSummary property. This DOES NOT check
     * that the value is non-empty (for which, you should check the {@code isEmpty()} method on the property). This is
     * useful because the SDK will never return a null collection or map, but you may need to differentiate between the
     * service returning nothing (or null) and the service returning an empty collection or map. For requests, this
     * returns true if a value for the property was specified in the request builder, and false if a value was not
     * specified.
     */
    public final boolean hasApiSummary() {
        return apiSummary != null && !(apiSummary instanceof SdkAutoConstructMap);
    }

    /**
     * <p>
     * A summary of the RestApi at the date and time that the deployment resource was created.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasApiSummary} method.
     * </p>
     * 
     * @return A summary of the RestApi at the date and time that the deployment resource was created.
     */
    public final Map<String, Map<String, MethodSnapshot>> apiSummary() {
        return apiSummary;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(id());
        hashCode = 31 * hashCode + Objects.hashCode(description());
        hashCode = 31 * hashCode + Objects.hashCode(createdDate());
        hashCode = 31 * hashCode + Objects.hashCode(hasApiSummary() ? apiSummary() : null);
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof GetDeploymentResponse)) {
            return false;
        }
        GetDeploymentResponse other = (GetDeploymentResponse) obj;
        return Objects.equals(id(), other.id()) && Objects.equals(description(), other.description())
                && Objects.equals(createdDate(), other.createdDate()) && hasApiSummary() == other.hasApiSummary()
                && Objects.equals(apiSummary(), other.apiSummary());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("GetDeploymentResponse").add("Id", id()).add("Description", description())
                .add("CreatedDate", createdDate()).add("ApiSummary", hasApiSummary() ? apiSummary() : null).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "id":
            return Optional.ofNullable(clazz.cast(id()));
        case "description":
            return Optional.ofNullable(clazz.cast(description()));
        case "createdDate":
            return Optional.ofNullable(clazz.cast(createdDate()));
        case "apiSummary":
            return Optional.ofNullable(clazz.cast(apiSummary()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static <T> Function<Object, T> getter(Function<GetDeploymentResponse, T> g) {
        return obj -> g.apply((GetDeploymentResponse) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends ApiGatewayResponse.Builder, SdkPojo, CopyableBuilder<Builder, GetDeploymentResponse> {
        /**
         * <p>
         * The identifier for the deployment resource.
         * </p>
         * 
         * @param id
         *        The identifier for the deployment resource.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder id(String id);

        /**
         * <p>
         * The description for the deployment resource.
         * </p>
         * 
         * @param description
         *        The description for the deployment resource.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder description(String description);

        /**
         * <p>
         * The date and time that the deployment resource was created.
         * </p>
         * 
         * @param createdDate
         *        The date and time that the deployment resource was created.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder createdDate(Instant createdDate);

        /**
         * <p>
         * A summary of the RestApi at the date and time that the deployment resource was created.
         * </p>
         * 
         * @param apiSummary
         *        A summary of the RestApi at the date and time that the deployment resource was created.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder apiSummary(Map<String, ? extends Map<String, MethodSnapshot>> apiSummary);
    }

    static final class BuilderImpl extends ApiGatewayResponse.BuilderImpl implements Builder {
        private String id;

        private String description;

        private Instant createdDate;

        private Map<String, Map<String, MethodSnapshot>> apiSummary = DefaultSdkAutoConstructMap.getInstance();

        private BuilderImpl() {
        }

        private BuilderImpl(GetDeploymentResponse model) {
            super(model);
            id(model.id);
            description(model.description);
            createdDate(model.createdDate);
            apiSummary(model.apiSummary);
        }

        public final String getId() {
            return id;
        }

        public final void setId(String id) {
            this.id = id;
        }

        @Override
        public final Builder id(String id) {
            this.id = id;
            return this;
        }

        public final String getDescription() {
            return description;
        }

        public final void setDescription(String description) {
            this.description = description;
        }

        @Override
        public final Builder description(String description) {
            this.description = description;
            return this;
        }

        public final Instant getCreatedDate() {
            return createdDate;
        }

        public final void setCreatedDate(Instant createdDate) {
            this.createdDate = createdDate;
        }

        @Override
        public final Builder createdDate(Instant createdDate) {
            this.createdDate = createdDate;
            return this;
        }

        public final Map<String, Map<String, MethodSnapshot.Builder>> getApiSummary() {
            Map<String, Map<String, MethodSnapshot.Builder>> result = PathToMapOfMethodSnapshotCopier
                    .copyToBuilder(this.apiSummary);
            if (result instanceof SdkAutoConstructMap) {
                return null;
            }
            return result;
        }

        public final void setApiSummary(Map<String, ? extends Map<String, MethodSnapshot.BuilderImpl>> apiSummary) {
            this.apiSummary = PathToMapOfMethodSnapshotCopier.copyFromBuilder(apiSummary);
        }

        @Override
        public final Builder apiSummary(Map<String, ? extends Map<String, MethodSnapshot>> apiSummary) {
            this.apiSummary = PathToMapOfMethodSnapshotCopier.copy(apiSummary);
            return this;
        }

        @Override
        public GetDeploymentResponse build() {
            return new GetDeploymentResponse(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }
}
