/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.apigateway.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * Represents an AWS account that is associated with API Gateway.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class GetAccountResponse extends ApiGatewayResponse implements
        ToCopyableBuilder<GetAccountResponse.Builder, GetAccountResponse> {
    private static final SdkField<String> CLOUDWATCH_ROLE_ARN_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("cloudwatchRoleArn").getter(getter(GetAccountResponse::cloudwatchRoleArn))
            .setter(setter(Builder::cloudwatchRoleArn))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("cloudwatchRoleArn").build()).build();

    private static final SdkField<ThrottleSettings> THROTTLE_SETTINGS_FIELD = SdkField
            .<ThrottleSettings> builder(MarshallingType.SDK_POJO).memberName("throttleSettings")
            .getter(getter(GetAccountResponse::throttleSettings)).setter(setter(Builder::throttleSettings))
            .constructor(ThrottleSettings::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("throttleSettings").build()).build();

    private static final SdkField<List<String>> FEATURES_FIELD = SdkField
            .<List<String>> builder(MarshallingType.LIST)
            .memberName("features")
            .getter(getter(GetAccountResponse::features))
            .setter(setter(Builder::features))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("features").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<String> builder(MarshallingType.STRING)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final SdkField<String> API_KEY_VERSION_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("apiKeyVersion").getter(getter(GetAccountResponse::apiKeyVersion)).setter(setter(Builder::apiKeyVersion))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("apiKeyVersion").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(CLOUDWATCH_ROLE_ARN_FIELD,
            THROTTLE_SETTINGS_FIELD, FEATURES_FIELD, API_KEY_VERSION_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = Collections
            .unmodifiableMap(new HashMap<String, SdkField<?>>() {
                {
                    put("cloudwatchRoleArn", CLOUDWATCH_ROLE_ARN_FIELD);
                    put("throttleSettings", THROTTLE_SETTINGS_FIELD);
                    put("features", FEATURES_FIELD);
                    put("apiKeyVersion", API_KEY_VERSION_FIELD);
                }
            });

    private final String cloudwatchRoleArn;

    private final ThrottleSettings throttleSettings;

    private final List<String> features;

    private final String apiKeyVersion;

    private GetAccountResponse(BuilderImpl builder) {
        super(builder);
        this.cloudwatchRoleArn = builder.cloudwatchRoleArn;
        this.throttleSettings = builder.throttleSettings;
        this.features = builder.features;
        this.apiKeyVersion = builder.apiKeyVersion;
    }

    /**
     * <p>
     * The ARN of an Amazon CloudWatch role for the current Account.
     * </p>
     * 
     * @return The ARN of an Amazon CloudWatch role for the current Account.
     */
    public final String cloudwatchRoleArn() {
        return cloudwatchRoleArn;
    }

    /**
     * <p>
     * Specifies the API request limits configured for the current Account.
     * </p>
     * 
     * @return Specifies the API request limits configured for the current Account.
     */
    public final ThrottleSettings throttleSettings() {
        return throttleSettings;
    }

    /**
     * For responses, this returns true if the service returned a value for the Features property. This DOES NOT check
     * that the value is non-empty (for which, you should check the {@code isEmpty()} method on the property). This is
     * useful because the SDK will never return a null collection or map, but you may need to differentiate between the
     * service returning nothing (or null) and the service returning an empty collection or map. For requests, this
     * returns true if a value for the property was specified in the request builder, and false if a value was not
     * specified.
     */
    public final boolean hasFeatures() {
        return features != null && !(features instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * A list of features supported for the account. When usage plans are enabled, the features list will include an
     * entry of <code>"UsagePlans"</code>.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasFeatures} method.
     * </p>
     * 
     * @return A list of features supported for the account. When usage plans are enabled, the features list will
     *         include an entry of <code>"UsagePlans"</code>.
     */
    public final List<String> features() {
        return features;
    }

    /**
     * <p>
     * The version of the API keys used for the account.
     * </p>
     * 
     * @return The version of the API keys used for the account.
     */
    public final String apiKeyVersion() {
        return apiKeyVersion;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(cloudwatchRoleArn());
        hashCode = 31 * hashCode + Objects.hashCode(throttleSettings());
        hashCode = 31 * hashCode + Objects.hashCode(hasFeatures() ? features() : null);
        hashCode = 31 * hashCode + Objects.hashCode(apiKeyVersion());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof GetAccountResponse)) {
            return false;
        }
        GetAccountResponse other = (GetAccountResponse) obj;
        return Objects.equals(cloudwatchRoleArn(), other.cloudwatchRoleArn())
                && Objects.equals(throttleSettings(), other.throttleSettings()) && hasFeatures() == other.hasFeatures()
                && Objects.equals(features(), other.features()) && Objects.equals(apiKeyVersion(), other.apiKeyVersion());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("GetAccountResponse").add("CloudwatchRoleArn", cloudwatchRoleArn())
                .add("ThrottleSettings", throttleSettings()).add("Features", hasFeatures() ? features() : null)
                .add("ApiKeyVersion", apiKeyVersion()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "cloudwatchRoleArn":
            return Optional.ofNullable(clazz.cast(cloudwatchRoleArn()));
        case "throttleSettings":
            return Optional.ofNullable(clazz.cast(throttleSettings()));
        case "features":
            return Optional.ofNullable(clazz.cast(features()));
        case "apiKeyVersion":
            return Optional.ofNullable(clazz.cast(apiKeyVersion()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static <T> Function<Object, T> getter(Function<GetAccountResponse, T> g) {
        return obj -> g.apply((GetAccountResponse) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends ApiGatewayResponse.Builder, SdkPojo, CopyableBuilder<Builder, GetAccountResponse> {
        /**
         * <p>
         * The ARN of an Amazon CloudWatch role for the current Account.
         * </p>
         * 
         * @param cloudwatchRoleArn
         *        The ARN of an Amazon CloudWatch role for the current Account.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder cloudwatchRoleArn(String cloudwatchRoleArn);

        /**
         * <p>
         * Specifies the API request limits configured for the current Account.
         * </p>
         * 
         * @param throttleSettings
         *        Specifies the API request limits configured for the current Account.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder throttleSettings(ThrottleSettings throttleSettings);

        /**
         * <p>
         * Specifies the API request limits configured for the current Account.
         * </p>
         * This is a convenience method that creates an instance of the {@link ThrottleSettings.Builder} avoiding the
         * need to create one manually via {@link ThrottleSettings#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link ThrottleSettings.Builder#build()} is called immediately and its
         * result is passed to {@link #throttleSettings(ThrottleSettings)}.
         * 
         * @param throttleSettings
         *        a consumer that will call methods on {@link ThrottleSettings.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #throttleSettings(ThrottleSettings)
         */
        default Builder throttleSettings(Consumer<ThrottleSettings.Builder> throttleSettings) {
            return throttleSettings(ThrottleSettings.builder().applyMutation(throttleSettings).build());
        }

        /**
         * <p>
         * A list of features supported for the account. When usage plans are enabled, the features list will include an
         * entry of <code>"UsagePlans"</code>.
         * </p>
         * 
         * @param features
         *        A list of features supported for the account. When usage plans are enabled, the features list will
         *        include an entry of <code>"UsagePlans"</code>.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder features(Collection<String> features);

        /**
         * <p>
         * A list of features supported for the account. When usage plans are enabled, the features list will include an
         * entry of <code>"UsagePlans"</code>.
         * </p>
         * 
         * @param features
         *        A list of features supported for the account. When usage plans are enabled, the features list will
         *        include an entry of <code>"UsagePlans"</code>.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder features(String... features);

        /**
         * <p>
         * The version of the API keys used for the account.
         * </p>
         * 
         * @param apiKeyVersion
         *        The version of the API keys used for the account.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder apiKeyVersion(String apiKeyVersion);
    }

    static final class BuilderImpl extends ApiGatewayResponse.BuilderImpl implements Builder {
        private String cloudwatchRoleArn;

        private ThrottleSettings throttleSettings;

        private List<String> features = DefaultSdkAutoConstructList.getInstance();

        private String apiKeyVersion;

        private BuilderImpl() {
        }

        private BuilderImpl(GetAccountResponse model) {
            super(model);
            cloudwatchRoleArn(model.cloudwatchRoleArn);
            throttleSettings(model.throttleSettings);
            features(model.features);
            apiKeyVersion(model.apiKeyVersion);
        }

        public final String getCloudwatchRoleArn() {
            return cloudwatchRoleArn;
        }

        public final void setCloudwatchRoleArn(String cloudwatchRoleArn) {
            this.cloudwatchRoleArn = cloudwatchRoleArn;
        }

        @Override
        public final Builder cloudwatchRoleArn(String cloudwatchRoleArn) {
            this.cloudwatchRoleArn = cloudwatchRoleArn;
            return this;
        }

        public final ThrottleSettings.Builder getThrottleSettings() {
            return throttleSettings != null ? throttleSettings.toBuilder() : null;
        }

        public final void setThrottleSettings(ThrottleSettings.BuilderImpl throttleSettings) {
            this.throttleSettings = throttleSettings != null ? throttleSettings.build() : null;
        }

        @Override
        public final Builder throttleSettings(ThrottleSettings throttleSettings) {
            this.throttleSettings = throttleSettings;
            return this;
        }

        public final Collection<String> getFeatures() {
            if (features instanceof SdkAutoConstructList) {
                return null;
            }
            return features;
        }

        public final void setFeatures(Collection<String> features) {
            this.features = ListOfStringCopier.copy(features);
        }

        @Override
        public final Builder features(Collection<String> features) {
            this.features = ListOfStringCopier.copy(features);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder features(String... features) {
            features(Arrays.asList(features));
            return this;
        }

        public final String getApiKeyVersion() {
            return apiKeyVersion;
        }

        public final void setApiKeyVersion(String apiKeyVersion) {
            this.apiKeyVersion = apiKeyVersion;
        }

        @Override
        public final Builder apiKeyVersion(String apiKeyVersion) {
            this.apiKeyVersion = apiKeyVersion;
            return this;
        }

        @Override
        public GetAccountResponse build() {
            return new GetAccountResponse(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }
}
