/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.apigateway.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * The API request rate limits.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class ThrottleSettings implements SdkPojo, Serializable,
        ToCopyableBuilder<ThrottleSettings.Builder, ThrottleSettings> {
    private static final SdkField<Integer> BURST_LIMIT_FIELD = SdkField.<Integer> builder(MarshallingType.INTEGER)
            .memberName("burstLimit").getter(getter(ThrottleSettings::burstLimit)).setter(setter(Builder::burstLimit))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("burstLimit").build()).build();

    private static final SdkField<Double> RATE_LIMIT_FIELD = SdkField.<Double> builder(MarshallingType.DOUBLE)
            .memberName("rateLimit").getter(getter(ThrottleSettings::rateLimit)).setter(setter(Builder::rateLimit))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("rateLimit").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(BURST_LIMIT_FIELD,
            RATE_LIMIT_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = Collections
            .unmodifiableMap(new HashMap<String, SdkField<?>>() {
                {
                    put("burstLimit", BURST_LIMIT_FIELD);
                    put("rateLimit", RATE_LIMIT_FIELD);
                }
            });

    private static final long serialVersionUID = 1L;

    private final Integer burstLimit;

    private final Double rateLimit;

    private ThrottleSettings(BuilderImpl builder) {
        this.burstLimit = builder.burstLimit;
        this.rateLimit = builder.rateLimit;
    }

    /**
     * <p>
     * The API target request burst rate limit. This allows more requests through for a period of time than the target
     * rate limit.
     * </p>
     * 
     * @return The API target request burst rate limit. This allows more requests through for a period of time than the
     *         target rate limit.
     */
    public final Integer burstLimit() {
        return burstLimit;
    }

    /**
     * <p>
     * The API target request rate limit.
     * </p>
     * 
     * @return The API target request rate limit.
     */
    public final Double rateLimit() {
        return rateLimit;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(burstLimit());
        hashCode = 31 * hashCode + Objects.hashCode(rateLimit());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ThrottleSettings)) {
            return false;
        }
        ThrottleSettings other = (ThrottleSettings) obj;
        return Objects.equals(burstLimit(), other.burstLimit()) && Objects.equals(rateLimit(), other.rateLimit());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("ThrottleSettings").add("BurstLimit", burstLimit()).add("RateLimit", rateLimit()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "burstLimit":
            return Optional.ofNullable(clazz.cast(burstLimit()));
        case "rateLimit":
            return Optional.ofNullable(clazz.cast(rateLimit()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static <T> Function<Object, T> getter(Function<ThrottleSettings, T> g) {
        return obj -> g.apply((ThrottleSettings) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SdkPojo, CopyableBuilder<Builder, ThrottleSettings> {
        /**
         * <p>
         * The API target request burst rate limit. This allows more requests through for a period of time than the
         * target rate limit.
         * </p>
         * 
         * @param burstLimit
         *        The API target request burst rate limit. This allows more requests through for a period of time than
         *        the target rate limit.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder burstLimit(Integer burstLimit);

        /**
         * <p>
         * The API target request rate limit.
         * </p>
         * 
         * @param rateLimit
         *        The API target request rate limit.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder rateLimit(Double rateLimit);
    }

    static final class BuilderImpl implements Builder {
        private Integer burstLimit;

        private Double rateLimit;

        private BuilderImpl() {
        }

        private BuilderImpl(ThrottleSettings model) {
            burstLimit(model.burstLimit);
            rateLimit(model.rateLimit);
        }

        public final Integer getBurstLimit() {
            return burstLimit;
        }

        public final void setBurstLimit(Integer burstLimit) {
            this.burstLimit = burstLimit;
        }

        @Override
        public final Builder burstLimit(Integer burstLimit) {
            this.burstLimit = burstLimit;
            return this;
        }

        public final Double getRateLimit() {
            return rateLimit;
        }

        public final void setRateLimit(Double rateLimit) {
            this.rateLimit = rateLimit;
        }

        @Override
        public final Builder rateLimit(Double rateLimit) {
            this.rateLimit = rateLimit;
            return this;
        }

        @Override
        public ThrottleSettings build() {
            return new ThrottleSettings(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }
}
