/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.apigateway.model;

import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.MapTrait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructMap;
import software.amazon.awssdk.core.util.SdkAutoConstructMap;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public final class CreateDomainNameAccessAssociationRequest extends ApiGatewayRequest implements
        ToCopyableBuilder<CreateDomainNameAccessAssociationRequest.Builder, CreateDomainNameAccessAssociationRequest> {
    private static final SdkField<String> DOMAIN_NAME_ARN_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("domainNameArn").getter(getter(CreateDomainNameAccessAssociationRequest::domainNameArn))
            .setter(setter(Builder::domainNameArn))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("domainNameArn").build()).build();

    private static final SdkField<String> ACCESS_ASSOCIATION_SOURCE_TYPE_FIELD = SdkField
            .<String> builder(MarshallingType.STRING)
            .memberName("accessAssociationSourceType")
            .getter(getter(CreateDomainNameAccessAssociationRequest::accessAssociationSourceTypeAsString))
            .setter(setter(Builder::accessAssociationSourceType))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("accessAssociationSourceType")
                    .build()).build();

    private static final SdkField<String> ACCESS_ASSOCIATION_SOURCE_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("accessAssociationSource")
            .getter(getter(CreateDomainNameAccessAssociationRequest::accessAssociationSource))
            .setter(setter(Builder::accessAssociationSource))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("accessAssociationSource").build())
            .build();

    private static final SdkField<Map<String, String>> TAGS_FIELD = SdkField
            .<Map<String, String>> builder(MarshallingType.MAP)
            .memberName("tags")
            .getter(getter(CreateDomainNameAccessAssociationRequest::tags))
            .setter(setter(Builder::tags))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("tags").build(),
                    MapTrait.builder()
                            .keyLocationName("key")
                            .valueLocationName("value")
                            .valueFieldInfo(
                                    SdkField.<String> builder(MarshallingType.STRING)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("value").build()).build()).build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(DOMAIN_NAME_ARN_FIELD,
            ACCESS_ASSOCIATION_SOURCE_TYPE_FIELD, ACCESS_ASSOCIATION_SOURCE_FIELD, TAGS_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = Collections
            .unmodifiableMap(new HashMap<String, SdkField<?>>() {
                {
                    put("domainNameArn", DOMAIN_NAME_ARN_FIELD);
                    put("accessAssociationSourceType", ACCESS_ASSOCIATION_SOURCE_TYPE_FIELD);
                    put("accessAssociationSource", ACCESS_ASSOCIATION_SOURCE_FIELD);
                    put("tags", TAGS_FIELD);
                }
            });

    private final String domainNameArn;

    private final String accessAssociationSourceType;

    private final String accessAssociationSource;

    private final Map<String, String> tags;

    private CreateDomainNameAccessAssociationRequest(BuilderImpl builder) {
        super(builder);
        this.domainNameArn = builder.domainNameArn;
        this.accessAssociationSourceType = builder.accessAssociationSourceType;
        this.accessAssociationSource = builder.accessAssociationSource;
        this.tags = builder.tags;
    }

    /**
     * <p>
     * The ARN of the domain name.
     * </p>
     * 
     * @return The ARN of the domain name.
     */
    public final String domainNameArn() {
        return domainNameArn;
    }

    /**
     * <p>
     * The type of the domain name access association source.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version,
     * {@link #accessAssociationSourceType} will return {@link AccessAssociationSourceType#UNKNOWN_TO_SDK_VERSION}. The
     * raw value returned by the service is available from {@link #accessAssociationSourceTypeAsString}.
     * </p>
     * 
     * @return The type of the domain name access association source.
     * @see AccessAssociationSourceType
     */
    public final AccessAssociationSourceType accessAssociationSourceType() {
        return AccessAssociationSourceType.fromValue(accessAssociationSourceType);
    }

    /**
     * <p>
     * The type of the domain name access association source.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version,
     * {@link #accessAssociationSourceType} will return {@link AccessAssociationSourceType#UNKNOWN_TO_SDK_VERSION}. The
     * raw value returned by the service is available from {@link #accessAssociationSourceTypeAsString}.
     * </p>
     * 
     * @return The type of the domain name access association source.
     * @see AccessAssociationSourceType
     */
    public final String accessAssociationSourceTypeAsString() {
        return accessAssociationSourceType;
    }

    /**
     * <p>
     * The identifier of the domain name access association source. For a VPCE, the value is the VPC endpoint ID.
     * </p>
     * 
     * @return The identifier of the domain name access association source. For a VPCE, the value is the VPC endpoint
     *         ID.
     */
    public final String accessAssociationSource() {
        return accessAssociationSource;
    }

    /**
     * For responses, this returns true if the service returned a value for the Tags property. This DOES NOT check that
     * the value is non-empty (for which, you should check the {@code isEmpty()} method on the property). This is useful
     * because the SDK will never return a null collection or map, but you may need to differentiate between the service
     * returning nothing (or null) and the service returning an empty collection or map. For requests, this returns true
     * if a value for the property was specified in the request builder, and false if a value was not specified.
     */
    public final boolean hasTags() {
        return tags != null && !(tags instanceof SdkAutoConstructMap);
    }

    /**
     * <p>
     * The key-value map of strings. The valid character set is [a-zA-Z+-=._:/]. The tag key can be up to 128 characters
     * and must not start with <code>aws:</code>. The tag value can be up to 256 characters.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasTags} method.
     * </p>
     * 
     * @return The key-value map of strings. The valid character set is [a-zA-Z+-=._:/]. The tag key can be up to 128
     *         characters and must not start with <code>aws:</code>. The tag value can be up to 256 characters.
     */
    public final Map<String, String> tags() {
        return tags;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(domainNameArn());
        hashCode = 31 * hashCode + Objects.hashCode(accessAssociationSourceTypeAsString());
        hashCode = 31 * hashCode + Objects.hashCode(accessAssociationSource());
        hashCode = 31 * hashCode + Objects.hashCode(hasTags() ? tags() : null);
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof CreateDomainNameAccessAssociationRequest)) {
            return false;
        }
        CreateDomainNameAccessAssociationRequest other = (CreateDomainNameAccessAssociationRequest) obj;
        return Objects.equals(domainNameArn(), other.domainNameArn())
                && Objects.equals(accessAssociationSourceTypeAsString(), other.accessAssociationSourceTypeAsString())
                && Objects.equals(accessAssociationSource(), other.accessAssociationSource()) && hasTags() == other.hasTags()
                && Objects.equals(tags(), other.tags());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("CreateDomainNameAccessAssociationRequest").add("DomainNameArn", domainNameArn())
                .add("AccessAssociationSourceType", accessAssociationSourceTypeAsString())
                .add("AccessAssociationSource", accessAssociationSource()).add("Tags", hasTags() ? tags() : null).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "domainNameArn":
            return Optional.ofNullable(clazz.cast(domainNameArn()));
        case "accessAssociationSourceType":
            return Optional.ofNullable(clazz.cast(accessAssociationSourceTypeAsString()));
        case "accessAssociationSource":
            return Optional.ofNullable(clazz.cast(accessAssociationSource()));
        case "tags":
            return Optional.ofNullable(clazz.cast(tags()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static <T> Function<Object, T> getter(Function<CreateDomainNameAccessAssociationRequest, T> g) {
        return obj -> g.apply((CreateDomainNameAccessAssociationRequest) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends ApiGatewayRequest.Builder, SdkPojo,
            CopyableBuilder<Builder, CreateDomainNameAccessAssociationRequest> {
        /**
         * <p>
         * The ARN of the domain name.
         * </p>
         * 
         * @param domainNameArn
         *        The ARN of the domain name.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder domainNameArn(String domainNameArn);

        /**
         * <p>
         * The type of the domain name access association source.
         * </p>
         * 
         * @param accessAssociationSourceType
         *        The type of the domain name access association source.
         * @see AccessAssociationSourceType
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see AccessAssociationSourceType
         */
        Builder accessAssociationSourceType(String accessAssociationSourceType);

        /**
         * <p>
         * The type of the domain name access association source.
         * </p>
         * 
         * @param accessAssociationSourceType
         *        The type of the domain name access association source.
         * @see AccessAssociationSourceType
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see AccessAssociationSourceType
         */
        Builder accessAssociationSourceType(AccessAssociationSourceType accessAssociationSourceType);

        /**
         * <p>
         * The identifier of the domain name access association source. For a VPCE, the value is the VPC endpoint ID.
         * </p>
         * 
         * @param accessAssociationSource
         *        The identifier of the domain name access association source. For a VPCE, the value is the VPC endpoint
         *        ID.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder accessAssociationSource(String accessAssociationSource);

        /**
         * <p>
         * The key-value map of strings. The valid character set is [a-zA-Z+-=._:/]. The tag key can be up to 128
         * characters and must not start with <code>aws:</code>. The tag value can be up to 256 characters.
         * </p>
         * 
         * @param tags
         *        The key-value map of strings. The valid character set is [a-zA-Z+-=._:/]. The tag key can be up to 128
         *        characters and must not start with <code>aws:</code>. The tag value can be up to 256 characters.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder tags(Map<String, String> tags);

        @Override
        Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration);

        @Override
        Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer);
    }

    static final class BuilderImpl extends ApiGatewayRequest.BuilderImpl implements Builder {
        private String domainNameArn;

        private String accessAssociationSourceType;

        private String accessAssociationSource;

        private Map<String, String> tags = DefaultSdkAutoConstructMap.getInstance();

        private BuilderImpl() {
        }

        private BuilderImpl(CreateDomainNameAccessAssociationRequest model) {
            super(model);
            domainNameArn(model.domainNameArn);
            accessAssociationSourceType(model.accessAssociationSourceType);
            accessAssociationSource(model.accessAssociationSource);
            tags(model.tags);
        }

        public final String getDomainNameArn() {
            return domainNameArn;
        }

        public final void setDomainNameArn(String domainNameArn) {
            this.domainNameArn = domainNameArn;
        }

        @Override
        public final Builder domainNameArn(String domainNameArn) {
            this.domainNameArn = domainNameArn;
            return this;
        }

        public final String getAccessAssociationSourceType() {
            return accessAssociationSourceType;
        }

        public final void setAccessAssociationSourceType(String accessAssociationSourceType) {
            this.accessAssociationSourceType = accessAssociationSourceType;
        }

        @Override
        public final Builder accessAssociationSourceType(String accessAssociationSourceType) {
            this.accessAssociationSourceType = accessAssociationSourceType;
            return this;
        }

        @Override
        public final Builder accessAssociationSourceType(AccessAssociationSourceType accessAssociationSourceType) {
            this.accessAssociationSourceType(accessAssociationSourceType == null ? null : accessAssociationSourceType.toString());
            return this;
        }

        public final String getAccessAssociationSource() {
            return accessAssociationSource;
        }

        public final void setAccessAssociationSource(String accessAssociationSource) {
            this.accessAssociationSource = accessAssociationSource;
        }

        @Override
        public final Builder accessAssociationSource(String accessAssociationSource) {
            this.accessAssociationSource = accessAssociationSource;
            return this;
        }

        public final Map<String, String> getTags() {
            if (tags instanceof SdkAutoConstructMap) {
                return null;
            }
            return tags;
        }

        public final void setTags(Map<String, String> tags) {
            this.tags = MapOfStringToStringCopier.copy(tags);
        }

        @Override
        public final Builder tags(Map<String, String> tags) {
            this.tags = MapOfStringToStringCopier.copy(tags);
            return this;
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public CreateDomainNameAccessAssociationRequest build() {
            return new CreateDomainNameAccessAssociationRequest(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }
}
