/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.apigateway.model;

import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.MapTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructMap;
import software.amazon.awssdk.core.util.SdkAutoConstructMap;
import software.amazon.awssdk.services.apigateway.model.AccessAssociationSourceType;
import software.amazon.awssdk.services.apigateway.model.ApiGatewayRequest;
import software.amazon.awssdk.services.apigateway.model.MapOfStringToStringCopier;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class CreateDomainNameAccessAssociationRequest
extends ApiGatewayRequest
implements ToCopyableBuilder<Builder, CreateDomainNameAccessAssociationRequest> {
    private static final SdkField<String> DOMAIN_NAME_ARN_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("domainNameArn").getter(CreateDomainNameAccessAssociationRequest.getter(CreateDomainNameAccessAssociationRequest::domainNameArn)).setter(CreateDomainNameAccessAssociationRequest.setter(Builder::domainNameArn)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("domainNameArn").build()}).build();
    private static final SdkField<String> ACCESS_ASSOCIATION_SOURCE_TYPE_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("accessAssociationSourceType").getter(CreateDomainNameAccessAssociationRequest.getter(CreateDomainNameAccessAssociationRequest::accessAssociationSourceTypeAsString)).setter(CreateDomainNameAccessAssociationRequest.setter(Builder::accessAssociationSourceType)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("accessAssociationSourceType").build()}).build();
    private static final SdkField<String> ACCESS_ASSOCIATION_SOURCE_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("accessAssociationSource").getter(CreateDomainNameAccessAssociationRequest.getter(CreateDomainNameAccessAssociationRequest::accessAssociationSource)).setter(CreateDomainNameAccessAssociationRequest.setter(Builder::accessAssociationSource)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("accessAssociationSource").build()}).build();
    private static final SdkField<Map<String, String>> TAGS_FIELD = SdkField.builder((MarshallingType)MarshallingType.MAP).memberName("tags").getter(CreateDomainNameAccessAssociationRequest.getter(CreateDomainNameAccessAssociationRequest::tags)).setter(CreateDomainNameAccessAssociationRequest.setter(Builder::tags)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("tags").build(), MapTrait.builder().keyLocationName("key").valueLocationName("value").valueFieldInfo(SdkField.builder((MarshallingType)MarshallingType.STRING).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("value").build()}).build()).build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(DOMAIN_NAME_ARN_FIELD, ACCESS_ASSOCIATION_SOURCE_TYPE_FIELD, ACCESS_ASSOCIATION_SOURCE_FIELD, TAGS_FIELD));
    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = Collections.unmodifiableMap(new HashMap<String, SdkField<?>>(){
        {
            this.put("domainNameArn", DOMAIN_NAME_ARN_FIELD);
            this.put("accessAssociationSourceType", ACCESS_ASSOCIATION_SOURCE_TYPE_FIELD);
            this.put("accessAssociationSource", ACCESS_ASSOCIATION_SOURCE_FIELD);
            this.put("tags", TAGS_FIELD);
        }
    });
    private final String domainNameArn;
    private final String accessAssociationSourceType;
    private final String accessAssociationSource;
    private final Map<String, String> tags;

    private CreateDomainNameAccessAssociationRequest(BuilderImpl builder) {
        super(builder);
        this.domainNameArn = builder.domainNameArn;
        this.accessAssociationSourceType = builder.accessAssociationSourceType;
        this.accessAssociationSource = builder.accessAssociationSource;
        this.tags = builder.tags;
    }

    public final String domainNameArn() {
        return this.domainNameArn;
    }

    public final AccessAssociationSourceType accessAssociationSourceType() {
        return AccessAssociationSourceType.fromValue(this.accessAssociationSourceType);
    }

    public final String accessAssociationSourceTypeAsString() {
        return this.accessAssociationSourceType;
    }

    public final String accessAssociationSource() {
        return this.accessAssociationSource;
    }

    public final boolean hasTags() {
        return this.tags != null && !(this.tags instanceof SdkAutoConstructMap);
    }

    public final Map<String, String> tags() {
        return this.tags;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(this.domainNameArn());
        hashCode = 31 * hashCode + Objects.hashCode(this.accessAssociationSourceTypeAsString());
        hashCode = 31 * hashCode + Objects.hashCode(this.accessAssociationSource());
        hashCode = 31 * hashCode + Objects.hashCode(this.hasTags() ? this.tags() : null);
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return super.equals(obj) && this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof CreateDomainNameAccessAssociationRequest)) {
            return false;
        }
        CreateDomainNameAccessAssociationRequest other = (CreateDomainNameAccessAssociationRequest)((Object)obj);
        return Objects.equals(this.domainNameArn(), other.domainNameArn()) && Objects.equals(this.accessAssociationSourceTypeAsString(), other.accessAssociationSourceTypeAsString()) && Objects.equals(this.accessAssociationSource(), other.accessAssociationSource()) && this.hasTags() == other.hasTags() && Objects.equals(this.tags(), other.tags());
    }

    public final String toString() {
        return ToString.builder((String)"CreateDomainNameAccessAssociationRequest").add("DomainNameArn", (Object)this.domainNameArn()).add("AccessAssociationSourceType", (Object)this.accessAssociationSourceTypeAsString()).add("AccessAssociationSource", (Object)this.accessAssociationSource()).add("Tags", this.hasTags() ? this.tags() : null).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "domainNameArn": {
                return Optional.ofNullable(clazz.cast(this.domainNameArn()));
            }
            case "accessAssociationSourceType": {
                return Optional.ofNullable(clazz.cast(this.accessAssociationSourceTypeAsString()));
            }
            case "accessAssociationSource": {
                return Optional.ofNullable(clazz.cast(this.accessAssociationSource()));
            }
            case "tags": {
                return Optional.ofNullable(clazz.cast(this.tags()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static <T> Function<Object, T> getter(Function<CreateDomainNameAccessAssociationRequest, T> g) {
        return obj -> g.apply((CreateDomainNameAccessAssociationRequest)((Object)((Object)obj)));
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    extends ApiGatewayRequest.BuilderImpl
    implements Builder {
        private String domainNameArn;
        private String accessAssociationSourceType;
        private String accessAssociationSource;
        private Map<String, String> tags = DefaultSdkAutoConstructMap.getInstance();

        private BuilderImpl() {
        }

        private BuilderImpl(CreateDomainNameAccessAssociationRequest model) {
            super(model);
            this.domainNameArn(model.domainNameArn);
            this.accessAssociationSourceType(model.accessAssociationSourceType);
            this.accessAssociationSource(model.accessAssociationSource);
            this.tags(model.tags);
        }

        public final String getDomainNameArn() {
            return this.domainNameArn;
        }

        public final void setDomainNameArn(String domainNameArn) {
            this.domainNameArn = domainNameArn;
        }

        @Override
        public final Builder domainNameArn(String domainNameArn) {
            this.domainNameArn = domainNameArn;
            return this;
        }

        public final String getAccessAssociationSourceType() {
            return this.accessAssociationSourceType;
        }

        public final void setAccessAssociationSourceType(String accessAssociationSourceType) {
            this.accessAssociationSourceType = accessAssociationSourceType;
        }

        @Override
        public final Builder accessAssociationSourceType(String accessAssociationSourceType) {
            this.accessAssociationSourceType = accessAssociationSourceType;
            return this;
        }

        @Override
        public final Builder accessAssociationSourceType(AccessAssociationSourceType accessAssociationSourceType) {
            this.accessAssociationSourceType(accessAssociationSourceType == null ? null : accessAssociationSourceType.toString());
            return this;
        }

        public final String getAccessAssociationSource() {
            return this.accessAssociationSource;
        }

        public final void setAccessAssociationSource(String accessAssociationSource) {
            this.accessAssociationSource = accessAssociationSource;
        }

        @Override
        public final Builder accessAssociationSource(String accessAssociationSource) {
            this.accessAssociationSource = accessAssociationSource;
            return this;
        }

        public final Map<String, String> getTags() {
            if (this.tags instanceof SdkAutoConstructMap) {
                return null;
            }
            return this.tags;
        }

        public final void setTags(Map<String, String> tags) {
            this.tags = MapOfStringToStringCopier.copy(tags);
        }

        @Override
        public final Builder tags(Map<String, String> tags) {
            this.tags = MapOfStringToStringCopier.copy(tags);
            return this;
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public CreateDomainNameAccessAssociationRequest build() {
            return new CreateDomainNameAccessAssociationRequest(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }

    public static interface Builder
    extends ApiGatewayRequest.Builder,
    SdkPojo,
    CopyableBuilder<Builder, CreateDomainNameAccessAssociationRequest> {
        public Builder domainNameArn(String var1);

        public Builder accessAssociationSourceType(String var1);

        public Builder accessAssociationSourceType(AccessAssociationSourceType var1);

        public Builder accessAssociationSource(String var1);

        public Builder tags(Map<String, String> var1);

        public Builder overrideConfiguration(AwsRequestOverrideConfiguration var1);

        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> var1);
    }
}

