/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.apigateway.model;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructMap;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructMap;

@Generated("software.amazon.awssdk:codegen")
final class MapOfKeyUsagesCopier {
    static Map<String, List<List<Long>>> copy(Map<String, ? extends Collection<? extends Collection<Long>>> mapOfKeyUsagesParam) {
        Map<String, List<List<Long>>> map;
        if (mapOfKeyUsagesParam == null || mapOfKeyUsagesParam instanceof SdkAutoConstructMap) {
            map = DefaultSdkAutoConstructMap.getInstance();
        } else {
            Map<String, List<List<Long>>> modifiableMap = new LinkedHashMap<>(mapOfKeyUsagesParam.size());
            mapOfKeyUsagesParam.forEach((key, value) -> {
                List<List<Long>> list;
                if (value == null || value instanceof SdkAutoConstructList) {
                    list = DefaultSdkAutoConstructList.getInstance();
                } else {
                    List<List<Long>> modifiableList = new ArrayList<>(value.size());
                    value.forEach(entry -> {
                        List<Long> list1;
                        if (entry == null || entry instanceof SdkAutoConstructList) {
                            list1 = DefaultSdkAutoConstructList.getInstance();
                        } else {
                            List<Long> modifiableList1 = new ArrayList<>(entry);
                            list1 = Collections.unmodifiableList(modifiableList1);
                        }
                        modifiableList.add(list1);
                    });
                    list = Collections.unmodifiableList(modifiableList);
                }
                modifiableMap.put(key, list);
            });
            map = Collections.unmodifiableMap(modifiableMap);
        }
        return map;
    }
}
