/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.apigateway.model;

import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.MapTrait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructMap;
import software.amazon.awssdk.core.util.SdkAutoConstructMap;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * A gateway response of a given response type and status code, with optional response parameters and mapping templates.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class GetGatewayResponseResponse extends ApiGatewayResponse implements
        ToCopyableBuilder<GetGatewayResponseResponse.Builder, GetGatewayResponseResponse> {
    private static final SdkField<String> RESPONSE_TYPE_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("responseType").getter(getter(GetGatewayResponseResponse::responseTypeAsString))
            .setter(setter(Builder::responseType))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("responseType").build()).build();

    private static final SdkField<String> STATUS_CODE_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("statusCode").getter(getter(GetGatewayResponseResponse::statusCode)).setter(setter(Builder::statusCode))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("statusCode").build()).build();

    private static final SdkField<Map<String, String>> RESPONSE_PARAMETERS_FIELD = SdkField
            .<Map<String, String>> builder(MarshallingType.MAP)
            .memberName("responseParameters")
            .getter(getter(GetGatewayResponseResponse::responseParameters))
            .setter(setter(Builder::responseParameters))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("responseParameters").build(),
                    MapTrait.builder()
                            .keyLocationName("key")
                            .valueLocationName("value")
                            .valueFieldInfo(
                                    SdkField.<String> builder(MarshallingType.STRING)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("value").build()).build()).build()).build();

    private static final SdkField<Map<String, String>> RESPONSE_TEMPLATES_FIELD = SdkField
            .<Map<String, String>> builder(MarshallingType.MAP)
            .memberName("responseTemplates")
            .getter(getter(GetGatewayResponseResponse::responseTemplates))
            .setter(setter(Builder::responseTemplates))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("responseTemplates").build(),
                    MapTrait.builder()
                            .keyLocationName("key")
                            .valueLocationName("value")
                            .valueFieldInfo(
                                    SdkField.<String> builder(MarshallingType.STRING)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("value").build()).build()).build()).build();

    private static final SdkField<Boolean> DEFAULT_RESPONSE_FIELD = SdkField.<Boolean> builder(MarshallingType.BOOLEAN)
            .memberName("defaultResponse").getter(getter(GetGatewayResponseResponse::defaultResponse))
            .setter(setter(Builder::defaultResponse))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("defaultResponse").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(RESPONSE_TYPE_FIELD,
            STATUS_CODE_FIELD, RESPONSE_PARAMETERS_FIELD, RESPONSE_TEMPLATES_FIELD, DEFAULT_RESPONSE_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = Collections
            .unmodifiableMap(new HashMap<String, SdkField<?>>() {
                {
                    put("responseType", RESPONSE_TYPE_FIELD);
                    put("statusCode", STATUS_CODE_FIELD);
                    put("responseParameters", RESPONSE_PARAMETERS_FIELD);
                    put("responseTemplates", RESPONSE_TEMPLATES_FIELD);
                    put("defaultResponse", DEFAULT_RESPONSE_FIELD);
                }
            });

    private final String responseType;

    private final String statusCodeValue;

    private final Map<String, String> responseParameters;

    private final Map<String, String> responseTemplates;

    private final Boolean defaultResponse;

    private GetGatewayResponseResponse(BuilderImpl builder) {
        super(builder);
        this.responseType = builder.responseType;
        this.statusCodeValue = builder.statusCodeValue;
        this.responseParameters = builder.responseParameters;
        this.responseTemplates = builder.responseTemplates;
        this.defaultResponse = builder.defaultResponse;
    }

    /**
     * <p>
     * The response type of the associated GatewayResponse.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #responseType} will
     * return {@link GatewayResponseType#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available
     * from {@link #responseTypeAsString}.
     * </p>
     * 
     * @return The response type of the associated GatewayResponse.
     * @see GatewayResponseType
     */
    public final GatewayResponseType responseType() {
        return GatewayResponseType.fromValue(responseType);
    }

    /**
     * <p>
     * The response type of the associated GatewayResponse.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #responseType} will
     * return {@link GatewayResponseType#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available
     * from {@link #responseTypeAsString}.
     * </p>
     * 
     * @return The response type of the associated GatewayResponse.
     * @see GatewayResponseType
     */
    public final String responseTypeAsString() {
        return responseType;
    }

    /**
     * <p>
     * The HTTP status code for this GatewayResponse.
     * </p>
     * 
     * @return The HTTP status code for this GatewayResponse.
     */
    public final String statusCode() {
        return statusCodeValue;
    }

    /**
     * For responses, this returns true if the service returned a value for the ResponseParameters property. This DOES
     * NOT check that the value is non-empty (for which, you should check the {@code isEmpty()} method on the property).
     * This is useful because the SDK will never return a null collection or map, but you may need to differentiate
     * between the service returning nothing (or null) and the service returning an empty collection or map. For
     * requests, this returns true if a value for the property was specified in the request builder, and false if a
     * value was not specified.
     */
    public final boolean hasResponseParameters() {
        return responseParameters != null && !(responseParameters instanceof SdkAutoConstructMap);
    }

    /**
     * <p>
     * Response parameters (paths, query strings and headers) of the GatewayResponse as a string-to-string map of
     * key-value pairs.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasResponseParameters} method.
     * </p>
     * 
     * @return Response parameters (paths, query strings and headers) of the GatewayResponse as a string-to-string map
     *         of key-value pairs.
     */
    public final Map<String, String> responseParameters() {
        return responseParameters;
    }

    /**
     * For responses, this returns true if the service returned a value for the ResponseTemplates property. This DOES
     * NOT check that the value is non-empty (for which, you should check the {@code isEmpty()} method on the property).
     * This is useful because the SDK will never return a null collection or map, but you may need to differentiate
     * between the service returning nothing (or null) and the service returning an empty collection or map. For
     * requests, this returns true if a value for the property was specified in the request builder, and false if a
     * value was not specified.
     */
    public final boolean hasResponseTemplates() {
        return responseTemplates != null && !(responseTemplates instanceof SdkAutoConstructMap);
    }

    /**
     * <p>
     * Response templates of the GatewayResponse as a string-to-string map of key-value pairs.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasResponseTemplates} method.
     * </p>
     * 
     * @return Response templates of the GatewayResponse as a string-to-string map of key-value pairs.
     */
    public final Map<String, String> responseTemplates() {
        return responseTemplates;
    }

    /**
     * <p>
     * A Boolean flag to indicate whether this GatewayResponse is the default gateway response (<code>true</code>) or
     * not (<code>false</code>). A default gateway response is one generated by API Gateway without any customization by
     * an API developer.
     * </p>
     * 
     * @return A Boolean flag to indicate whether this GatewayResponse is the default gateway response (
     *         <code>true</code>) or not (<code>false</code>). A default gateway response is one generated by API
     *         Gateway without any customization by an API developer.
     */
    public final Boolean defaultResponse() {
        return defaultResponse;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(responseTypeAsString());
        hashCode = 31 * hashCode + Objects.hashCode(statusCode());
        hashCode = 31 * hashCode + Objects.hashCode(hasResponseParameters() ? responseParameters() : null);
        hashCode = 31 * hashCode + Objects.hashCode(hasResponseTemplates() ? responseTemplates() : null);
        hashCode = 31 * hashCode + Objects.hashCode(defaultResponse());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof GetGatewayResponseResponse)) {
            return false;
        }
        GetGatewayResponseResponse other = (GetGatewayResponseResponse) obj;
        return Objects.equals(responseTypeAsString(), other.responseTypeAsString())
                && Objects.equals(statusCode(), other.statusCode()) && hasResponseParameters() == other.hasResponseParameters()
                && Objects.equals(responseParameters(), other.responseParameters())
                && hasResponseTemplates() == other.hasResponseTemplates()
                && Objects.equals(responseTemplates(), other.responseTemplates())
                && Objects.equals(defaultResponse(), other.defaultResponse());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("GetGatewayResponseResponse").add("ResponseType", responseTypeAsString())
                .add("StatusCode", statusCode()).add("ResponseParameters", hasResponseParameters() ? responseParameters() : null)
                .add("ResponseTemplates", hasResponseTemplates() ? responseTemplates() : null)
                .add("DefaultResponse", defaultResponse()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "responseType":
            return Optional.ofNullable(clazz.cast(responseTypeAsString()));
        case "statusCode":
            return Optional.ofNullable(clazz.cast(statusCode()));
        case "responseParameters":
            return Optional.ofNullable(clazz.cast(responseParameters()));
        case "responseTemplates":
            return Optional.ofNullable(clazz.cast(responseTemplates()));
        case "defaultResponse":
            return Optional.ofNullable(clazz.cast(defaultResponse()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static <T> Function<Object, T> getter(Function<GetGatewayResponseResponse, T> g) {
        return obj -> g.apply((GetGatewayResponseResponse) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends ApiGatewayResponse.Builder, SdkPojo, CopyableBuilder<Builder, GetGatewayResponseResponse> {
        /**
         * <p>
         * The response type of the associated GatewayResponse.
         * </p>
         * 
         * @param responseType
         *        The response type of the associated GatewayResponse.
         * @see GatewayResponseType
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see GatewayResponseType
         */
        Builder responseType(String responseType);

        /**
         * <p>
         * The response type of the associated GatewayResponse.
         * </p>
         * 
         * @param responseType
         *        The response type of the associated GatewayResponse.
         * @see GatewayResponseType
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see GatewayResponseType
         */
        Builder responseType(GatewayResponseType responseType);

        /**
         * <p>
         * The HTTP status code for this GatewayResponse.
         * </p>
         * 
         * @param statusCodeValue
         *        The HTTP status code for this GatewayResponse.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder statusCode(String statusCodeValue);

        /**
         * <p>
         * Response parameters (paths, query strings and headers) of the GatewayResponse as a string-to-string map of
         * key-value pairs.
         * </p>
         * 
         * @param responseParameters
         *        Response parameters (paths, query strings and headers) of the GatewayResponse as a string-to-string
         *        map of key-value pairs.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder responseParameters(Map<String, String> responseParameters);

        /**
         * <p>
         * Response templates of the GatewayResponse as a string-to-string map of key-value pairs.
         * </p>
         * 
         * @param responseTemplates
         *        Response templates of the GatewayResponse as a string-to-string map of key-value pairs.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder responseTemplates(Map<String, String> responseTemplates);

        /**
         * <p>
         * A Boolean flag to indicate whether this GatewayResponse is the default gateway response (<code>true</code>)
         * or not (<code>false</code>). A default gateway response is one generated by API Gateway without any
         * customization by an API developer.
         * </p>
         * 
         * @param defaultResponse
         *        A Boolean flag to indicate whether this GatewayResponse is the default gateway response (
         *        <code>true</code>) or not (<code>false</code>). A default gateway response is one generated by API
         *        Gateway without any customization by an API developer.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder defaultResponse(Boolean defaultResponse);
    }

    static final class BuilderImpl extends ApiGatewayResponse.BuilderImpl implements Builder {
        private String responseType;

        private String statusCodeValue;

        private Map<String, String> responseParameters = DefaultSdkAutoConstructMap.getInstance();

        private Map<String, String> responseTemplates = DefaultSdkAutoConstructMap.getInstance();

        private Boolean defaultResponse;

        private BuilderImpl() {
        }

        private BuilderImpl(GetGatewayResponseResponse model) {
            super(model);
            responseType(model.responseType);
            statusCode(model.statusCodeValue);
            responseParameters(model.responseParameters);
            responseTemplates(model.responseTemplates);
            defaultResponse(model.defaultResponse);
        }

        public final String getResponseType() {
            return responseType;
        }

        public final void setResponseType(String responseType) {
            this.responseType = responseType;
        }

        @Override
        public final Builder responseType(String responseType) {
            this.responseType = responseType;
            return this;
        }

        @Override
        public final Builder responseType(GatewayResponseType responseType) {
            this.responseType(responseType == null ? null : responseType.toString());
            return this;
        }

        public final String getStatusCode() {
            return statusCodeValue;
        }

        public final void setStatusCode(String statusCodeValue) {
            this.statusCodeValue = statusCodeValue;
        }

        @Override
        public final Builder statusCode(String statusCodeValue) {
            this.statusCodeValue = statusCodeValue;
            return this;
        }

        public final Map<String, String> getResponseParameters() {
            if (responseParameters instanceof SdkAutoConstructMap) {
                return null;
            }
            return responseParameters;
        }

        public final void setResponseParameters(Map<String, String> responseParameters) {
            this.responseParameters = MapOfStringToStringCopier.copy(responseParameters);
        }

        @Override
        public final Builder responseParameters(Map<String, String> responseParameters) {
            this.responseParameters = MapOfStringToStringCopier.copy(responseParameters);
            return this;
        }

        public final Map<String, String> getResponseTemplates() {
            if (responseTemplates instanceof SdkAutoConstructMap) {
                return null;
            }
            return responseTemplates;
        }

        public final void setResponseTemplates(Map<String, String> responseTemplates) {
            this.responseTemplates = MapOfStringToStringCopier.copy(responseTemplates);
        }

        @Override
        public final Builder responseTemplates(Map<String, String> responseTemplates) {
            this.responseTemplates = MapOfStringToStringCopier.copy(responseTemplates);
            return this;
        }

        public final Boolean getDefaultResponse() {
            return defaultResponse;
        }

        public final void setDefaultResponse(Boolean defaultResponse) {
            this.defaultResponse = defaultResponse;
        }

        @Override
        public final Builder defaultResponse(Boolean defaultResponse) {
            this.defaultResponse = defaultResponse;
            return this;
        }

        @Override
        public GetGatewayResponseResponse build() {
            return new GetGatewayResponseResponse(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }
}
