/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.apigateway.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.MapTrait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructMap;
import software.amazon.awssdk.core.util.SdkAutoConstructMap;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * Make a request to simulate the invocation of a Method.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class TestInvokeMethodRequest extends ApiGatewayRequest implements
        ToCopyableBuilder<TestInvokeMethodRequest.Builder, TestInvokeMethodRequest> {
    private static final SdkField<String> REST_API_ID_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("restApiId").getter(getter(TestInvokeMethodRequest::restApiId)).setter(setter(Builder::restApiId))
            .traits(LocationTrait.builder().location(MarshallLocation.PATH).locationName("restapi_id").build()).build();

    private static final SdkField<String> RESOURCE_ID_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("resourceId").getter(getter(TestInvokeMethodRequest::resourceId)).setter(setter(Builder::resourceId))
            .traits(LocationTrait.builder().location(MarshallLocation.PATH).locationName("resource_id").build()).build();

    private static final SdkField<String> HTTP_METHOD_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("httpMethod").getter(getter(TestInvokeMethodRequest::httpMethod)).setter(setter(Builder::httpMethod))
            .traits(LocationTrait.builder().location(MarshallLocation.PATH).locationName("http_method").build()).build();

    private static final SdkField<String> PATH_WITH_QUERY_STRING_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("pathWithQueryString").getter(getter(TestInvokeMethodRequest::pathWithQueryString))
            .setter(setter(Builder::pathWithQueryString))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("pathWithQueryString").build())
            .build();

    private static final SdkField<String> BODY_FIELD = SdkField.<String> builder(MarshallingType.STRING).memberName("body")
            .getter(getter(TestInvokeMethodRequest::body)).setter(setter(Builder::body))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("body").build()).build();

    private static final SdkField<Map<String, String>> HEADERS_FIELD = SdkField
            .<Map<String, String>> builder(MarshallingType.MAP)
            .memberName("headers")
            .getter(getter(TestInvokeMethodRequest::headers))
            .setter(setter(Builder::headers))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("headers").build(),
                    MapTrait.builder()
                            .keyLocationName("key")
                            .valueLocationName("value")
                            .valueFieldInfo(
                                    SdkField.<String> builder(MarshallingType.STRING)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("value").build()).build()).build()).build();

    private static final SdkField<Map<String, List<String>>> MULTI_VALUE_HEADERS_FIELD = SdkField
            .<Map<String, List<String>>> builder(MarshallingType.MAP)
            .memberName("multiValueHeaders")
            .getter(getter(TestInvokeMethodRequest::multiValueHeaders))
            .setter(setter(Builder::multiValueHeaders))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("multiValueHeaders").build(),
                    MapTrait.builder()
                            .keyLocationName("key")
                            .valueLocationName("value")
                            .valueFieldInfo(
                                    SdkField.<List<String>> builder(MarshallingType.LIST)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("value").build(),
                                                    ListTrait
                                                            .builder()
                                                            .memberLocationName(null)
                                                            .memberFieldInfo(
                                                                    SdkField.<String> builder(MarshallingType.STRING)
                                                                            .traits(LocationTrait.builder()
                                                                                    .location(MarshallLocation.PAYLOAD)
                                                                                    .locationName("member").build()).build())
                                                            .build()).build()).build()).build();

    private static final SdkField<String> CLIENT_CERTIFICATE_ID_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("clientCertificateId").getter(getter(TestInvokeMethodRequest::clientCertificateId))
            .setter(setter(Builder::clientCertificateId))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("clientCertificateId").build())
            .build();

    private static final SdkField<Map<String, String>> STAGE_VARIABLES_FIELD = SdkField
            .<Map<String, String>> builder(MarshallingType.MAP)
            .memberName("stageVariables")
            .getter(getter(TestInvokeMethodRequest::stageVariables))
            .setter(setter(Builder::stageVariables))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("stageVariables").build(),
                    MapTrait.builder()
                            .keyLocationName("key")
                            .valueLocationName("value")
                            .valueFieldInfo(
                                    SdkField.<String> builder(MarshallingType.STRING)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("value").build()).build()).build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(REST_API_ID_FIELD,
            RESOURCE_ID_FIELD, HTTP_METHOD_FIELD, PATH_WITH_QUERY_STRING_FIELD, BODY_FIELD, HEADERS_FIELD,
            MULTI_VALUE_HEADERS_FIELD, CLIENT_CERTIFICATE_ID_FIELD, STAGE_VARIABLES_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = Collections
            .unmodifiableMap(new HashMap<String, SdkField<?>>() {
                {
                    put("restapi_id", REST_API_ID_FIELD);
                    put("resource_id", RESOURCE_ID_FIELD);
                    put("http_method", HTTP_METHOD_FIELD);
                    put("pathWithQueryString", PATH_WITH_QUERY_STRING_FIELD);
                    put("body", BODY_FIELD);
                    put("headers", HEADERS_FIELD);
                    put("multiValueHeaders", MULTI_VALUE_HEADERS_FIELD);
                    put("clientCertificateId", CLIENT_CERTIFICATE_ID_FIELD);
                    put("stageVariables", STAGE_VARIABLES_FIELD);
                }
            });

    private final String restApiId;

    private final String resourceId;

    private final String httpMethod;

    private final String pathWithQueryString;

    private final String body;

    private final Map<String, String> headers;

    private final Map<String, List<String>> multiValueHeaders;

    private final String clientCertificateId;

    private final Map<String, String> stageVariables;

    private TestInvokeMethodRequest(BuilderImpl builder) {
        super(builder);
        this.restApiId = builder.restApiId;
        this.resourceId = builder.resourceId;
        this.httpMethod = builder.httpMethod;
        this.pathWithQueryString = builder.pathWithQueryString;
        this.body = builder.body;
        this.headers = builder.headers;
        this.multiValueHeaders = builder.multiValueHeaders;
        this.clientCertificateId = builder.clientCertificateId;
        this.stageVariables = builder.stageVariables;
    }

    /**
     * <p>
     * The string identifier of the associated RestApi.
     * </p>
     * 
     * @return The string identifier of the associated RestApi.
     */
    public final String restApiId() {
        return restApiId;
    }

    /**
     * <p>
     * Specifies a test invoke method request's resource ID.
     * </p>
     * 
     * @return Specifies a test invoke method request's resource ID.
     */
    public final String resourceId() {
        return resourceId;
    }

    /**
     * <p>
     * Specifies a test invoke method request's HTTP method.
     * </p>
     * 
     * @return Specifies a test invoke method request's HTTP method.
     */
    public final String httpMethod() {
        return httpMethod;
    }

    /**
     * <p>
     * The URI path, including query string, of the simulated invocation request. Use this to specify path parameters
     * and query string parameters.
     * </p>
     * 
     * @return The URI path, including query string, of the simulated invocation request. Use this to specify path
     *         parameters and query string parameters.
     */
    public final String pathWithQueryString() {
        return pathWithQueryString;
    }

    /**
     * <p>
     * The simulated request body of an incoming invocation request.
     * </p>
     * 
     * @return The simulated request body of an incoming invocation request.
     */
    public final String body() {
        return body;
    }

    /**
     * For responses, this returns true if the service returned a value for the Headers property. This DOES NOT check
     * that the value is non-empty (for which, you should check the {@code isEmpty()} method on the property). This is
     * useful because the SDK will never return a null collection or map, but you may need to differentiate between the
     * service returning nothing (or null) and the service returning an empty collection or map. For requests, this
     * returns true if a value for the property was specified in the request builder, and false if a value was not
     * specified.
     */
    public final boolean hasHeaders() {
        return headers != null && !(headers instanceof SdkAutoConstructMap);
    }

    /**
     * <p>
     * A key-value map of headers to simulate an incoming invocation request.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasHeaders} method.
     * </p>
     * 
     * @return A key-value map of headers to simulate an incoming invocation request.
     */
    public final Map<String, String> headers() {
        return headers;
    }

    /**
     * For responses, this returns true if the service returned a value for the MultiValueHeaders property. This DOES
     * NOT check that the value is non-empty (for which, you should check the {@code isEmpty()} method on the property).
     * This is useful because the SDK will never return a null collection or map, but you may need to differentiate
     * between the service returning nothing (or null) and the service returning an empty collection or map. For
     * requests, this returns true if a value for the property was specified in the request builder, and false if a
     * value was not specified.
     */
    public final boolean hasMultiValueHeaders() {
        return multiValueHeaders != null && !(multiValueHeaders instanceof SdkAutoConstructMap);
    }

    /**
     * <p>
     * The headers as a map from string to list of values to simulate an incoming invocation request.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasMultiValueHeaders} method.
     * </p>
     * 
     * @return The headers as a map from string to list of values to simulate an incoming invocation request.
     */
    public final Map<String, List<String>> multiValueHeaders() {
        return multiValueHeaders;
    }

    /**
     * <p>
     * A ClientCertificate identifier to use in the test invocation. API Gateway will use the certificate when making
     * the HTTPS request to the defined back-end endpoint.
     * </p>
     * 
     * @return A ClientCertificate identifier to use in the test invocation. API Gateway will use the certificate when
     *         making the HTTPS request to the defined back-end endpoint.
     */
    public final String clientCertificateId() {
        return clientCertificateId;
    }

    /**
     * For responses, this returns true if the service returned a value for the StageVariables property. This DOES NOT
     * check that the value is non-empty (for which, you should check the {@code isEmpty()} method on the property).
     * This is useful because the SDK will never return a null collection or map, but you may need to differentiate
     * between the service returning nothing (or null) and the service returning an empty collection or map. For
     * requests, this returns true if a value for the property was specified in the request builder, and false if a
     * value was not specified.
     */
    public final boolean hasStageVariables() {
        return stageVariables != null && !(stageVariables instanceof SdkAutoConstructMap);
    }

    /**
     * <p>
     * A key-value map of stage variables to simulate an invocation on a deployed Stage.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasStageVariables} method.
     * </p>
     * 
     * @return A key-value map of stage variables to simulate an invocation on a deployed Stage.
     */
    public final Map<String, String> stageVariables() {
        return stageVariables;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(restApiId());
        hashCode = 31 * hashCode + Objects.hashCode(resourceId());
        hashCode = 31 * hashCode + Objects.hashCode(httpMethod());
        hashCode = 31 * hashCode + Objects.hashCode(pathWithQueryString());
        hashCode = 31 * hashCode + Objects.hashCode(body());
        hashCode = 31 * hashCode + Objects.hashCode(hasHeaders() ? headers() : null);
        hashCode = 31 * hashCode + Objects.hashCode(hasMultiValueHeaders() ? multiValueHeaders() : null);
        hashCode = 31 * hashCode + Objects.hashCode(clientCertificateId());
        hashCode = 31 * hashCode + Objects.hashCode(hasStageVariables() ? stageVariables() : null);
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof TestInvokeMethodRequest)) {
            return false;
        }
        TestInvokeMethodRequest other = (TestInvokeMethodRequest) obj;
        return Objects.equals(restApiId(), other.restApiId()) && Objects.equals(resourceId(), other.resourceId())
                && Objects.equals(httpMethod(), other.httpMethod())
                && Objects.equals(pathWithQueryString(), other.pathWithQueryString()) && Objects.equals(body(), other.body())
                && hasHeaders() == other.hasHeaders() && Objects.equals(headers(), other.headers())
                && hasMultiValueHeaders() == other.hasMultiValueHeaders()
                && Objects.equals(multiValueHeaders(), other.multiValueHeaders())
                && Objects.equals(clientCertificateId(), other.clientCertificateId())
                && hasStageVariables() == other.hasStageVariables() && Objects.equals(stageVariables(), other.stageVariables());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("TestInvokeMethodRequest").add("RestApiId", restApiId()).add("ResourceId", resourceId())
                .add("HttpMethod", httpMethod()).add("PathWithQueryString", pathWithQueryString()).add("Body", body())
                .add("Headers", hasHeaders() ? headers() : null)
                .add("MultiValueHeaders", hasMultiValueHeaders() ? multiValueHeaders() : null)
                .add("ClientCertificateId", clientCertificateId())
                .add("StageVariables", hasStageVariables() ? stageVariables() : null).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "restApiId":
            return Optional.ofNullable(clazz.cast(restApiId()));
        case "resourceId":
            return Optional.ofNullable(clazz.cast(resourceId()));
        case "httpMethod":
            return Optional.ofNullable(clazz.cast(httpMethod()));
        case "pathWithQueryString":
            return Optional.ofNullable(clazz.cast(pathWithQueryString()));
        case "body":
            return Optional.ofNullable(clazz.cast(body()));
        case "headers":
            return Optional.ofNullable(clazz.cast(headers()));
        case "multiValueHeaders":
            return Optional.ofNullable(clazz.cast(multiValueHeaders()));
        case "clientCertificateId":
            return Optional.ofNullable(clazz.cast(clientCertificateId()));
        case "stageVariables":
            return Optional.ofNullable(clazz.cast(stageVariables()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static <T> Function<Object, T> getter(Function<TestInvokeMethodRequest, T> g) {
        return obj -> g.apply((TestInvokeMethodRequest) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends ApiGatewayRequest.Builder, SdkPojo, CopyableBuilder<Builder, TestInvokeMethodRequest> {
        /**
         * <p>
         * The string identifier of the associated RestApi.
         * </p>
         * 
         * @param restApiId
         *        The string identifier of the associated RestApi.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder restApiId(String restApiId);

        /**
         * <p>
         * Specifies a test invoke method request's resource ID.
         * </p>
         * 
         * @param resourceId
         *        Specifies a test invoke method request's resource ID.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder resourceId(String resourceId);

        /**
         * <p>
         * Specifies a test invoke method request's HTTP method.
         * </p>
         * 
         * @param httpMethod
         *        Specifies a test invoke method request's HTTP method.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder httpMethod(String httpMethod);

        /**
         * <p>
         * The URI path, including query string, of the simulated invocation request. Use this to specify path
         * parameters and query string parameters.
         * </p>
         * 
         * @param pathWithQueryString
         *        The URI path, including query string, of the simulated invocation request. Use this to specify path
         *        parameters and query string parameters.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder pathWithQueryString(String pathWithQueryString);

        /**
         * <p>
         * The simulated request body of an incoming invocation request.
         * </p>
         * 
         * @param body
         *        The simulated request body of an incoming invocation request.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder body(String body);

        /**
         * <p>
         * A key-value map of headers to simulate an incoming invocation request.
         * </p>
         * 
         * @param headers
         *        A key-value map of headers to simulate an incoming invocation request.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder headers(Map<String, String> headers);

        /**
         * <p>
         * The headers as a map from string to list of values to simulate an incoming invocation request.
         * </p>
         * 
         * @param multiValueHeaders
         *        The headers as a map from string to list of values to simulate an incoming invocation request.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder multiValueHeaders(Map<String, ? extends Collection<String>> multiValueHeaders);

        /**
         * <p>
         * A ClientCertificate identifier to use in the test invocation. API Gateway will use the certificate when
         * making the HTTPS request to the defined back-end endpoint.
         * </p>
         * 
         * @param clientCertificateId
         *        A ClientCertificate identifier to use in the test invocation. API Gateway will use the certificate
         *        when making the HTTPS request to the defined back-end endpoint.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder clientCertificateId(String clientCertificateId);

        /**
         * <p>
         * A key-value map of stage variables to simulate an invocation on a deployed Stage.
         * </p>
         * 
         * @param stageVariables
         *        A key-value map of stage variables to simulate an invocation on a deployed Stage.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder stageVariables(Map<String, String> stageVariables);

        @Override
        Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration);

        @Override
        Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer);
    }

    static final class BuilderImpl extends ApiGatewayRequest.BuilderImpl implements Builder {
        private String restApiId;

        private String resourceId;

        private String httpMethod;

        private String pathWithQueryString;

        private String body;

        private Map<String, String> headers = DefaultSdkAutoConstructMap.getInstance();

        private Map<String, List<String>> multiValueHeaders = DefaultSdkAutoConstructMap.getInstance();

        private String clientCertificateId;

        private Map<String, String> stageVariables = DefaultSdkAutoConstructMap.getInstance();

        private BuilderImpl() {
        }

        private BuilderImpl(TestInvokeMethodRequest model) {
            super(model);
            restApiId(model.restApiId);
            resourceId(model.resourceId);
            httpMethod(model.httpMethod);
            pathWithQueryString(model.pathWithQueryString);
            body(model.body);
            headers(model.headers);
            multiValueHeaders(model.multiValueHeaders);
            clientCertificateId(model.clientCertificateId);
            stageVariables(model.stageVariables);
        }

        public final String getRestApiId() {
            return restApiId;
        }

        public final void setRestApiId(String restApiId) {
            this.restApiId = restApiId;
        }

        @Override
        public final Builder restApiId(String restApiId) {
            this.restApiId = restApiId;
            return this;
        }

        public final String getResourceId() {
            return resourceId;
        }

        public final void setResourceId(String resourceId) {
            this.resourceId = resourceId;
        }

        @Override
        public final Builder resourceId(String resourceId) {
            this.resourceId = resourceId;
            return this;
        }

        public final String getHttpMethod() {
            return httpMethod;
        }

        public final void setHttpMethod(String httpMethod) {
            this.httpMethod = httpMethod;
        }

        @Override
        public final Builder httpMethod(String httpMethod) {
            this.httpMethod = httpMethod;
            return this;
        }

        public final String getPathWithQueryString() {
            return pathWithQueryString;
        }

        public final void setPathWithQueryString(String pathWithQueryString) {
            this.pathWithQueryString = pathWithQueryString;
        }

        @Override
        public final Builder pathWithQueryString(String pathWithQueryString) {
            this.pathWithQueryString = pathWithQueryString;
            return this;
        }

        public final String getBody() {
            return body;
        }

        public final void setBody(String body) {
            this.body = body;
        }

        @Override
        public final Builder body(String body) {
            this.body = body;
            return this;
        }

        public final Map<String, String> getHeaders() {
            if (headers instanceof SdkAutoConstructMap) {
                return null;
            }
            return headers;
        }

        public final void setHeaders(Map<String, String> headers) {
            this.headers = MapOfStringToStringCopier.copy(headers);
        }

        @Override
        public final Builder headers(Map<String, String> headers) {
            this.headers = MapOfStringToStringCopier.copy(headers);
            return this;
        }

        public final Map<String, ? extends Collection<String>> getMultiValueHeaders() {
            if (multiValueHeaders instanceof SdkAutoConstructMap) {
                return null;
            }
            return multiValueHeaders;
        }

        public final void setMultiValueHeaders(Map<String, ? extends Collection<String>> multiValueHeaders) {
            this.multiValueHeaders = MapOfStringToListCopier.copy(multiValueHeaders);
        }

        @Override
        public final Builder multiValueHeaders(Map<String, ? extends Collection<String>> multiValueHeaders) {
            this.multiValueHeaders = MapOfStringToListCopier.copy(multiValueHeaders);
            return this;
        }

        public final String getClientCertificateId() {
            return clientCertificateId;
        }

        public final void setClientCertificateId(String clientCertificateId) {
            this.clientCertificateId = clientCertificateId;
        }

        @Override
        public final Builder clientCertificateId(String clientCertificateId) {
            this.clientCertificateId = clientCertificateId;
            return this;
        }

        public final Map<String, String> getStageVariables() {
            if (stageVariables instanceof SdkAutoConstructMap) {
                return null;
            }
            return stageVariables;
        }

        public final void setStageVariables(Map<String, String> stageVariables) {
            this.stageVariables = MapOfStringToStringCopier.copy(stageVariables);
        }

        @Override
        public final Builder stageVariables(Map<String, String> stageVariables) {
            this.stageVariables = MapOfStringToStringCopier.copy(stageVariables);
            return this;
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public TestInvokeMethodRequest build() {
            return new TestInvokeMethodRequest(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }
}
