/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.apigateway.model;

import java.nio.ByteBuffer;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkBytes;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.MapTrait;
import software.amazon.awssdk.core.traits.PayloadTrait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructMap;
import software.amazon.awssdk.core.util.SdkAutoConstructMap;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * A PUT request to update an existing API, with external API definitions specified as the request body.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class PutRestApiRequest extends ApiGatewayRequest implements
        ToCopyableBuilder<PutRestApiRequest.Builder, PutRestApiRequest> {
    private static final SdkField<String> REST_API_ID_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("restApiId").getter(getter(PutRestApiRequest::restApiId)).setter(setter(Builder::restApiId))
            .traits(LocationTrait.builder().location(MarshallLocation.PATH).locationName("restapi_id").build()).build();

    private static final SdkField<String> MODE_FIELD = SdkField.<String> builder(MarshallingType.STRING).memberName("mode")
            .getter(getter(PutRestApiRequest::modeAsString)).setter(setter(Builder::mode))
            .traits(LocationTrait.builder().location(MarshallLocation.QUERY_PARAM).locationName("mode").build()).build();

    private static final SdkField<Boolean> FAIL_ON_WARNINGS_FIELD = SdkField.<Boolean> builder(MarshallingType.BOOLEAN)
            .memberName("failOnWarnings").getter(getter(PutRestApiRequest::failOnWarnings))
            .setter(setter(Builder::failOnWarnings))
            .traits(LocationTrait.builder().location(MarshallLocation.QUERY_PARAM).locationName("failonwarnings").build())
            .build();

    private static final SdkField<Map<String, String>> PARAMETERS_FIELD = SdkField
            .<Map<String, String>> builder(MarshallingType.MAP)
            .memberName("parameters")
            .getter(getter(PutRestApiRequest::parameters))
            .setter(setter(Builder::parameters))
            .traits(LocationTrait.builder().location(MarshallLocation.QUERY_PARAM).locationName("parameters").build(),
                    MapTrait.builder()
                            .keyLocationName("key")
                            .valueLocationName("value")
                            .valueFieldInfo(
                                    SdkField.<String> builder(MarshallingType.STRING)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("value").build()).build()).build()).build();

    private static final SdkField<SdkBytes> BODY_FIELD = SdkField
            .<SdkBytes> builder(MarshallingType.SDK_BYTES)
            .memberName("body")
            .getter(getter(PutRestApiRequest::body))
            .setter(setter(Builder::body))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("body").build(),
                    PayloadTrait.create()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(REST_API_ID_FIELD, MODE_FIELD,
            FAIL_ON_WARNINGS_FIELD, PARAMETERS_FIELD, BODY_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = Collections
            .unmodifiableMap(new HashMap<String, SdkField<?>>() {
                {
                    put("restapi_id", REST_API_ID_FIELD);
                    put("mode", MODE_FIELD);
                    put("failonwarnings", FAIL_ON_WARNINGS_FIELD);
                    put("parameters", PARAMETERS_FIELD);
                    put("body", BODY_FIELD);
                }
            });

    private final String restApiId;

    private final String mode;

    private final Boolean failOnWarnings;

    private final Map<String, String> parameters;

    private final SdkBytes body;

    private PutRestApiRequest(BuilderImpl builder) {
        super(builder);
        this.restApiId = builder.restApiId;
        this.mode = builder.mode;
        this.failOnWarnings = builder.failOnWarnings;
        this.parameters = builder.parameters;
        this.body = builder.body;
    }

    /**
     * <p>
     * The string identifier of the associated RestApi.
     * </p>
     * 
     * @return The string identifier of the associated RestApi.
     */
    public final String restApiId() {
        return restApiId;
    }

    /**
     * <p>
     * The <code>mode</code> query parameter to specify the update mode. Valid values are "merge" and "overwrite". By
     * default, the update mode is "merge".
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #mode} will return
     * {@link PutMode#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #modeAsString}.
     * </p>
     * 
     * @return The <code>mode</code> query parameter to specify the update mode. Valid values are "merge" and
     *         "overwrite". By default, the update mode is "merge".
     * @see PutMode
     */
    public final PutMode mode() {
        return PutMode.fromValue(mode);
    }

    /**
     * <p>
     * The <code>mode</code> query parameter to specify the update mode. Valid values are "merge" and "overwrite". By
     * default, the update mode is "merge".
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #mode} will return
     * {@link PutMode#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #modeAsString}.
     * </p>
     * 
     * @return The <code>mode</code> query parameter to specify the update mode. Valid values are "merge" and
     *         "overwrite". By default, the update mode is "merge".
     * @see PutMode
     */
    public final String modeAsString() {
        return mode;
    }

    /**
     * <p>
     * A query parameter to indicate whether to rollback the API update (<code>true</code>) or not (<code>false</code>)
     * when a warning is encountered. The default value is <code>false</code>.
     * </p>
     * 
     * @return A query parameter to indicate whether to rollback the API update (<code>true</code>) or not (
     *         <code>false</code>) when a warning is encountered. The default value is <code>false</code>.
     */
    public final Boolean failOnWarnings() {
        return failOnWarnings;
    }

    /**
     * For responses, this returns true if the service returned a value for the Parameters property. This DOES NOT check
     * that the value is non-empty (for which, you should check the {@code isEmpty()} method on the property). This is
     * useful because the SDK will never return a null collection or map, but you may need to differentiate between the
     * service returning nothing (or null) and the service returning an empty collection or map. For requests, this
     * returns true if a value for the property was specified in the request builder, and false if a value was not
     * specified.
     */
    public final boolean hasParameters() {
        return parameters != null && !(parameters instanceof SdkAutoConstructMap);
    }

    /**
     * <p>
     * Custom header parameters as part of the request. For example, to exclude DocumentationParts from an imported API,
     * set <code>ignore=documentation</code> as a <code>parameters</code> value, as in the AWS CLI command of
     * <code>aws apigateway import-rest-api --parameters ignore=documentation --body 'file:///path/to/imported-api-body.json'</code>
     * .
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasParameters} method.
     * </p>
     * 
     * @return Custom header parameters as part of the request. For example, to exclude DocumentationParts from an
     *         imported API, set <code>ignore=documentation</code> as a <code>parameters</code> value, as in the AWS CLI
     *         command of
     *         <code>aws apigateway import-rest-api --parameters ignore=documentation --body 'file:///path/to/imported-api-body.json'</code>
     *         .
     */
    public final Map<String, String> parameters() {
        return parameters;
    }

    /**
     * <p>
     * The PUT request body containing external API definitions. Currently, only OpenAPI definition JSON/YAML files are
     * supported. The maximum size of the API definition file is 6MB.
     * </p>
     * 
     * @return The PUT request body containing external API definitions. Currently, only OpenAPI definition JSON/YAML
     *         files are supported. The maximum size of the API definition file is 6MB.
     */
    public final SdkBytes body() {
        return body;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(restApiId());
        hashCode = 31 * hashCode + Objects.hashCode(modeAsString());
        hashCode = 31 * hashCode + Objects.hashCode(failOnWarnings());
        hashCode = 31 * hashCode + Objects.hashCode(hasParameters() ? parameters() : null);
        hashCode = 31 * hashCode + Objects.hashCode(body());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof PutRestApiRequest)) {
            return false;
        }
        PutRestApiRequest other = (PutRestApiRequest) obj;
        return Objects.equals(restApiId(), other.restApiId()) && Objects.equals(modeAsString(), other.modeAsString())
                && Objects.equals(failOnWarnings(), other.failOnWarnings()) && hasParameters() == other.hasParameters()
                && Objects.equals(parameters(), other.parameters()) && Objects.equals(body(), other.body());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("PutRestApiRequest").add("RestApiId", restApiId()).add("Mode", modeAsString())
                .add("FailOnWarnings", failOnWarnings()).add("Parameters", hasParameters() ? parameters() : null)
                .add("Body", body()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "restApiId":
            return Optional.ofNullable(clazz.cast(restApiId()));
        case "mode":
            return Optional.ofNullable(clazz.cast(modeAsString()));
        case "failOnWarnings":
            return Optional.ofNullable(clazz.cast(failOnWarnings()));
        case "parameters":
            return Optional.ofNullable(clazz.cast(parameters()));
        case "body":
            return Optional.ofNullable(clazz.cast(body()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static <T> Function<Object, T> getter(Function<PutRestApiRequest, T> g) {
        return obj -> g.apply((PutRestApiRequest) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends ApiGatewayRequest.Builder, SdkPojo, CopyableBuilder<Builder, PutRestApiRequest> {
        /**
         * <p>
         * The string identifier of the associated RestApi.
         * </p>
         * 
         * @param restApiId
         *        The string identifier of the associated RestApi.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder restApiId(String restApiId);

        /**
         * <p>
         * The <code>mode</code> query parameter to specify the update mode. Valid values are "merge" and "overwrite".
         * By default, the update mode is "merge".
         * </p>
         * 
         * @param mode
         *        The <code>mode</code> query parameter to specify the update mode. Valid values are "merge" and
         *        "overwrite". By default, the update mode is "merge".
         * @see PutMode
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see PutMode
         */
        Builder mode(String mode);

        /**
         * <p>
         * The <code>mode</code> query parameter to specify the update mode. Valid values are "merge" and "overwrite".
         * By default, the update mode is "merge".
         * </p>
         * 
         * @param mode
         *        The <code>mode</code> query parameter to specify the update mode. Valid values are "merge" and
         *        "overwrite". By default, the update mode is "merge".
         * @see PutMode
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see PutMode
         */
        Builder mode(PutMode mode);

        /**
         * <p>
         * A query parameter to indicate whether to rollback the API update (<code>true</code>) or not (
         * <code>false</code>) when a warning is encountered. The default value is <code>false</code>.
         * </p>
         * 
         * @param failOnWarnings
         *        A query parameter to indicate whether to rollback the API update (<code>true</code>) or not (
         *        <code>false</code>) when a warning is encountered. The default value is <code>false</code>.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder failOnWarnings(Boolean failOnWarnings);

        /**
         * <p>
         * Custom header parameters as part of the request. For example, to exclude DocumentationParts from an imported
         * API, set <code>ignore=documentation</code> as a <code>parameters</code> value, as in the AWS CLI command of
         * <code>aws apigateway import-rest-api --parameters ignore=documentation --body 'file:///path/to/imported-api-body.json'</code>
         * .
         * </p>
         * 
         * @param parameters
         *        Custom header parameters as part of the request. For example, to exclude DocumentationParts from an
         *        imported API, set <code>ignore=documentation</code> as a <code>parameters</code> value, as in the AWS
         *        CLI command of
         *        <code>aws apigateway import-rest-api --parameters ignore=documentation --body 'file:///path/to/imported-api-body.json'</code>
         *        .
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder parameters(Map<String, String> parameters);

        /**
         * <p>
         * The PUT request body containing external API definitions. Currently, only OpenAPI definition JSON/YAML files
         * are supported. The maximum size of the API definition file is 6MB.
         * </p>
         * 
         * @param body
         *        The PUT request body containing external API definitions. Currently, only OpenAPI definition JSON/YAML
         *        files are supported. The maximum size of the API definition file is 6MB.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder body(SdkBytes body);

        @Override
        Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration);

        @Override
        Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer);
    }

    static final class BuilderImpl extends ApiGatewayRequest.BuilderImpl implements Builder {
        private String restApiId;

        private String mode;

        private Boolean failOnWarnings;

        private Map<String, String> parameters = DefaultSdkAutoConstructMap.getInstance();

        private SdkBytes body;

        private BuilderImpl() {
        }

        private BuilderImpl(PutRestApiRequest model) {
            super(model);
            restApiId(model.restApiId);
            mode(model.mode);
            failOnWarnings(model.failOnWarnings);
            parameters(model.parameters);
            body(model.body);
        }

        public final String getRestApiId() {
            return restApiId;
        }

        public final void setRestApiId(String restApiId) {
            this.restApiId = restApiId;
        }

        @Override
        public final Builder restApiId(String restApiId) {
            this.restApiId = restApiId;
            return this;
        }

        public final String getMode() {
            return mode;
        }

        public final void setMode(String mode) {
            this.mode = mode;
        }

        @Override
        public final Builder mode(String mode) {
            this.mode = mode;
            return this;
        }

        @Override
        public final Builder mode(PutMode mode) {
            this.mode(mode == null ? null : mode.toString());
            return this;
        }

        public final Boolean getFailOnWarnings() {
            return failOnWarnings;
        }

        public final void setFailOnWarnings(Boolean failOnWarnings) {
            this.failOnWarnings = failOnWarnings;
        }

        @Override
        public final Builder failOnWarnings(Boolean failOnWarnings) {
            this.failOnWarnings = failOnWarnings;
            return this;
        }

        public final Map<String, String> getParameters() {
            if (parameters instanceof SdkAutoConstructMap) {
                return null;
            }
            return parameters;
        }

        public final void setParameters(Map<String, String> parameters) {
            this.parameters = MapOfStringToStringCopier.copy(parameters);
        }

        @Override
        public final Builder parameters(Map<String, String> parameters) {
            this.parameters = MapOfStringToStringCopier.copy(parameters);
            return this;
        }

        public final ByteBuffer getBody() {
            return body == null ? null : body.asByteBuffer();
        }

        public final void setBody(ByteBuffer body) {
            body(body == null ? null : SdkBytes.fromByteBuffer(body));
        }

        @Override
        public final Builder body(SdkBytes body) {
            this.body = body;
            return this;
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public PutRestApiRequest build() {
            return new PutRestApiRequest(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }
}
