/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.apigateway.model;

import java.util.Collections;
import java.util.LinkedHashMap;
import java.util.Map;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructMap;
import software.amazon.awssdk.core.util.SdkAutoConstructMap;

@Generated("software.amazon.awssdk:codegen")
final class PathToMapOfMethodSnapshotCopier {
    static Map<String, Map<String, MethodSnapshot>> copy(
            Map<String, ? extends Map<String, ? extends MethodSnapshot>> pathToMapOfMethodSnapshotParam) {
        Map<String, Map<String, MethodSnapshot>> map;
        if (pathToMapOfMethodSnapshotParam == null || pathToMapOfMethodSnapshotParam instanceof SdkAutoConstructMap) {
            map = DefaultSdkAutoConstructMap.getInstance();
        } else {
            Map<String, Map<String, MethodSnapshot>> modifiableMap = new LinkedHashMap<>(pathToMapOfMethodSnapshotParam.size());
            pathToMapOfMethodSnapshotParam.forEach((key, value) -> {
                Map<String, MethodSnapshot> map1;
                if (value == null || value instanceof SdkAutoConstructMap) {
                    map1 = DefaultSdkAutoConstructMap.getInstance();
                } else {
                    Map<String, MethodSnapshot> modifiableMap1 = new LinkedHashMap<>(value.size());
                    value.forEach((key1, value1) -> {
                        modifiableMap1.put(key1, value1);
                    });
                    map1 = Collections.unmodifiableMap(modifiableMap1);
                }
                modifiableMap.put(key, map1);
            });
            map = Collections.unmodifiableMap(modifiableMap);
        }
        return map;
    }

    static Map<String, Map<String, MethodSnapshot>> copyFromBuilder(
            Map<String, ? extends Map<String, ? extends MethodSnapshot.Builder>> pathToMapOfMethodSnapshotParam) {
        Map<String, Map<String, MethodSnapshot>> map;
        if (pathToMapOfMethodSnapshotParam == null || pathToMapOfMethodSnapshotParam instanceof SdkAutoConstructMap) {
            map = DefaultSdkAutoConstructMap.getInstance();
        } else {
            Map<String, Map<String, MethodSnapshot>> modifiableMap = new LinkedHashMap<>(pathToMapOfMethodSnapshotParam.size());
            pathToMapOfMethodSnapshotParam.forEach((key, value) -> {
                Map<String, MethodSnapshot> map1;
                if (value == null || value instanceof SdkAutoConstructMap) {
                    map1 = DefaultSdkAutoConstructMap.getInstance();
                } else {
                    Map<String, MethodSnapshot> modifiableMap1 = new LinkedHashMap<>(value.size());
                    value.forEach((key1, value1) -> {
                        MethodSnapshot member = value1 == null ? null : value1.build();
                        modifiableMap1.put(key1, member);
                    });
                    map1 = Collections.unmodifiableMap(modifiableMap1);
                }
                modifiableMap.put(key, map1);
            });
            map = Collections.unmodifiableMap(modifiableMap);
        }
        return map;
    }

    static Map<String, Map<String, MethodSnapshot.Builder>> copyToBuilder(
            Map<String, ? extends Map<String, ? extends MethodSnapshot>> pathToMapOfMethodSnapshotParam) {
        Map<String, Map<String, MethodSnapshot.Builder>> map;
        if (pathToMapOfMethodSnapshotParam == null || pathToMapOfMethodSnapshotParam instanceof SdkAutoConstructMap) {
            map = DefaultSdkAutoConstructMap.getInstance();
        } else {
            Map<String, Map<String, MethodSnapshot.Builder>> modifiableMap = new LinkedHashMap<>(
                    pathToMapOfMethodSnapshotParam.size());
            pathToMapOfMethodSnapshotParam.forEach((key, value) -> {
                Map<String, MethodSnapshot.Builder> map1;
                if (value == null || value instanceof SdkAutoConstructMap) {
                    map1 = DefaultSdkAutoConstructMap.getInstance();
                } else {
                    Map<String, MethodSnapshot.Builder> modifiableMap1 = new LinkedHashMap<>(value.size());
                    value.forEach((key1, value1) -> {
                        MethodSnapshot.Builder member = value1 == null ? null : value1.toBuilder();
                        modifiableMap1.put(key1, member);
                    });
                    map1 = Collections.unmodifiableMap(modifiableMap1);
                }
                modifiableMap.put(key, map1);
            });
            map = Collections.unmodifiableMap(modifiableMap);
        }
        return map;
    }
}
