/*
 * Copyright 2014-2019 Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.apigateway.model;

import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * A request to create a new domain name.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class CreateDomainNameRequest extends ApiGatewayRequest implements
        ToCopyableBuilder<CreateDomainNameRequest.Builder, CreateDomainNameRequest> {
    private static final SdkField<String> DOMAIN_NAME_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .getter(getter(CreateDomainNameRequest::domainName)).setter(setter(Builder::domainName))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("domainName").build()).build();

    private static final SdkField<String> CERTIFICATE_NAME_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .getter(getter(CreateDomainNameRequest::certificateName)).setter(setter(Builder::certificateName))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("certificateName").build()).build();

    private static final SdkField<String> CERTIFICATE_BODY_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .getter(getter(CreateDomainNameRequest::certificateBody)).setter(setter(Builder::certificateBody))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("certificateBody").build()).build();

    private static final SdkField<String> CERTIFICATE_PRIVATE_KEY_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .getter(getter(CreateDomainNameRequest::certificatePrivateKey)).setter(setter(Builder::certificatePrivateKey))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("certificatePrivateKey").build())
            .build();

    private static final SdkField<String> CERTIFICATE_CHAIN_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .getter(getter(CreateDomainNameRequest::certificateChain)).setter(setter(Builder::certificateChain))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("certificateChain").build()).build();

    private static final SdkField<String> CERTIFICATE_ARN_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .getter(getter(CreateDomainNameRequest::certificateArn)).setter(setter(Builder::certificateArn))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("certificateArn").build()).build();

    private static final SdkField<String> REGIONAL_CERTIFICATE_NAME_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .getter(getter(CreateDomainNameRequest::regionalCertificateName)).setter(setter(Builder::regionalCertificateName))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("regionalCertificateName").build())
            .build();

    private static final SdkField<String> REGIONAL_CERTIFICATE_ARN_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .getter(getter(CreateDomainNameRequest::regionalCertificateArn)).setter(setter(Builder::regionalCertificateArn))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("regionalCertificateArn").build())
            .build();

    private static final SdkField<EndpointConfiguration> ENDPOINT_CONFIGURATION_FIELD = SdkField
            .<EndpointConfiguration> builder(MarshallingType.SDK_POJO)
            .getter(getter(CreateDomainNameRequest::endpointConfiguration)).setter(setter(Builder::endpointConfiguration))
            .constructor(EndpointConfiguration::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("endpointConfiguration").build())
            .build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections
            .unmodifiableList(Arrays.asList(DOMAIN_NAME_FIELD, CERTIFICATE_NAME_FIELD, CERTIFICATE_BODY_FIELD,
                    CERTIFICATE_PRIVATE_KEY_FIELD, CERTIFICATE_CHAIN_FIELD, CERTIFICATE_ARN_FIELD,
                    REGIONAL_CERTIFICATE_NAME_FIELD, REGIONAL_CERTIFICATE_ARN_FIELD, ENDPOINT_CONFIGURATION_FIELD));

    private final String domainName;

    private final String certificateName;

    private final String certificateBody;

    private final String certificatePrivateKey;

    private final String certificateChain;

    private final String certificateArn;

    private final String regionalCertificateName;

    private final String regionalCertificateArn;

    private final EndpointConfiguration endpointConfiguration;

    private CreateDomainNameRequest(BuilderImpl builder) {
        super(builder);
        this.domainName = builder.domainName;
        this.certificateName = builder.certificateName;
        this.certificateBody = builder.certificateBody;
        this.certificatePrivateKey = builder.certificatePrivateKey;
        this.certificateChain = builder.certificateChain;
        this.certificateArn = builder.certificateArn;
        this.regionalCertificateName = builder.regionalCertificateName;
        this.regionalCertificateArn = builder.regionalCertificateArn;
        this.endpointConfiguration = builder.endpointConfiguration;
    }

    /**
     * <p>
     * [Required] The name of the <a>DomainName</a> resource.
     * </p>
     * 
     * @return [Required] The name of the <a>DomainName</a> resource.
     */
    public String domainName() {
        return domainName;
    }

    /**
     * <p>
     * The user-friendly name of the certificate that will be used by edge-optimized endpoint for this domain name.
     * </p>
     * 
     * @return The user-friendly name of the certificate that will be used by edge-optimized endpoint for this domain
     *         name.
     */
    public String certificateName() {
        return certificateName;
    }

    /**
     * <p>
     * [Deprecated] The body of the server certificate that will be used by edge-optimized endpoint for this domain name
     * provided by your certificate authority.
     * </p>
     * 
     * @return [Deprecated] The body of the server certificate that will be used by edge-optimized endpoint for this
     *         domain name provided by your certificate authority.
     */
    public String certificateBody() {
        return certificateBody;
    }

    /**
     * <p>
     * [Deprecated] Your edge-optimized endpoint's domain name certificate's private key.
     * </p>
     * 
     * @return [Deprecated] Your edge-optimized endpoint's domain name certificate's private key.
     */
    public String certificatePrivateKey() {
        return certificatePrivateKey;
    }

    /**
     * <p>
     * [Deprecated] The intermediate certificates and optionally the root certificate, one after the other without any
     * blank lines, used by an edge-optimized endpoint for this domain name. If you include the root certificate, your
     * certificate chain must start with intermediate certificates and end with the root certificate. Use the
     * intermediate certificates that were provided by your certificate authority. Do not include any intermediaries
     * that are not in the chain of trust path.
     * </p>
     * 
     * @return [Deprecated] The intermediate certificates and optionally the root certificate, one after the other
     *         without any blank lines, used by an edge-optimized endpoint for this domain name. If you include the root
     *         certificate, your certificate chain must start with intermediate certificates and end with the root
     *         certificate. Use the intermediate certificates that were provided by your certificate authority. Do not
     *         include any intermediaries that are not in the chain of trust path.
     */
    public String certificateChain() {
        return certificateChain;
    }

    /**
     * <p>
     * The reference to an AWS-managed certificate that will be used by edge-optimized endpoint for this domain name.
     * AWS Certificate Manager is the only supported source.
     * </p>
     * 
     * @return The reference to an AWS-managed certificate that will be used by edge-optimized endpoint for this domain
     *         name. AWS Certificate Manager is the only supported source.
     */
    public String certificateArn() {
        return certificateArn;
    }

    /**
     * <p>
     * The user-friendly name of the certificate that will be used by regional endpoint for this domain name.
     * </p>
     * 
     * @return The user-friendly name of the certificate that will be used by regional endpoint for this domain name.
     */
    public String regionalCertificateName() {
        return regionalCertificateName;
    }

    /**
     * <p>
     * The reference to an AWS-managed certificate that will be used by regional endpoint for this domain name. AWS
     * Certificate Manager is the only supported source.
     * </p>
     * 
     * @return The reference to an AWS-managed certificate that will be used by regional endpoint for this domain name.
     *         AWS Certificate Manager is the only supported source.
     */
    public String regionalCertificateArn() {
        return regionalCertificateArn;
    }

    /**
     * <p>
     * The endpoint configuration of this <a>DomainName</a> showing the endpoint types of the domain name.
     * </p>
     * 
     * @return The endpoint configuration of this <a>DomainName</a> showing the endpoint types of the domain name.
     */
    public EndpointConfiguration endpointConfiguration() {
        return endpointConfiguration;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(domainName());
        hashCode = 31 * hashCode + Objects.hashCode(certificateName());
        hashCode = 31 * hashCode + Objects.hashCode(certificateBody());
        hashCode = 31 * hashCode + Objects.hashCode(certificatePrivateKey());
        hashCode = 31 * hashCode + Objects.hashCode(certificateChain());
        hashCode = 31 * hashCode + Objects.hashCode(certificateArn());
        hashCode = 31 * hashCode + Objects.hashCode(regionalCertificateName());
        hashCode = 31 * hashCode + Objects.hashCode(regionalCertificateArn());
        hashCode = 31 * hashCode + Objects.hashCode(endpointConfiguration());
        return hashCode;
    }

    @Override
    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof CreateDomainNameRequest)) {
            return false;
        }
        CreateDomainNameRequest other = (CreateDomainNameRequest) obj;
        return Objects.equals(domainName(), other.domainName()) && Objects.equals(certificateName(), other.certificateName())
                && Objects.equals(certificateBody(), other.certificateBody())
                && Objects.equals(certificatePrivateKey(), other.certificatePrivateKey())
                && Objects.equals(certificateChain(), other.certificateChain())
                && Objects.equals(certificateArn(), other.certificateArn())
                && Objects.equals(regionalCertificateName(), other.regionalCertificateName())
                && Objects.equals(regionalCertificateArn(), other.regionalCertificateArn())
                && Objects.equals(endpointConfiguration(), other.endpointConfiguration());
    }

    @Override
    public String toString() {
        return ToString.builder("CreateDomainNameRequest").add("DomainName", domainName())
                .add("CertificateName", certificateName()).add("CertificateBody", certificateBody())
                .add("CertificatePrivateKey", certificatePrivateKey()).add("CertificateChain", certificateChain())
                .add("CertificateArn", certificateArn()).add("RegionalCertificateName", regionalCertificateName())
                .add("RegionalCertificateArn", regionalCertificateArn()).add("EndpointConfiguration", endpointConfiguration())
                .build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "domainName":
            return Optional.ofNullable(clazz.cast(domainName()));
        case "certificateName":
            return Optional.ofNullable(clazz.cast(certificateName()));
        case "certificateBody":
            return Optional.ofNullable(clazz.cast(certificateBody()));
        case "certificatePrivateKey":
            return Optional.ofNullable(clazz.cast(certificatePrivateKey()));
        case "certificateChain":
            return Optional.ofNullable(clazz.cast(certificateChain()));
        case "certificateArn":
            return Optional.ofNullable(clazz.cast(certificateArn()));
        case "regionalCertificateName":
            return Optional.ofNullable(clazz.cast(regionalCertificateName()));
        case "regionalCertificateArn":
            return Optional.ofNullable(clazz.cast(regionalCertificateArn()));
        case "endpointConfiguration":
            return Optional.ofNullable(clazz.cast(endpointConfiguration()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<CreateDomainNameRequest, T> g) {
        return obj -> g.apply((CreateDomainNameRequest) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends ApiGatewayRequest.Builder, SdkPojo, CopyableBuilder<Builder, CreateDomainNameRequest> {
        /**
         * <p>
         * [Required] The name of the <a>DomainName</a> resource.
         * </p>
         * 
         * @param domainName
         *        [Required] The name of the <a>DomainName</a> resource.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder domainName(String domainName);

        /**
         * <p>
         * The user-friendly name of the certificate that will be used by edge-optimized endpoint for this domain name.
         * </p>
         * 
         * @param certificateName
         *        The user-friendly name of the certificate that will be used by edge-optimized endpoint for this domain
         *        name.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder certificateName(String certificateName);

        /**
         * <p>
         * [Deprecated] The body of the server certificate that will be used by edge-optimized endpoint for this domain
         * name provided by your certificate authority.
         * </p>
         * 
         * @param certificateBody
         *        [Deprecated] The body of the server certificate that will be used by edge-optimized endpoint for this
         *        domain name provided by your certificate authority.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder certificateBody(String certificateBody);

        /**
         * <p>
         * [Deprecated] Your edge-optimized endpoint's domain name certificate's private key.
         * </p>
         * 
         * @param certificatePrivateKey
         *        [Deprecated] Your edge-optimized endpoint's domain name certificate's private key.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder certificatePrivateKey(String certificatePrivateKey);

        /**
         * <p>
         * [Deprecated] The intermediate certificates and optionally the root certificate, one after the other without
         * any blank lines, used by an edge-optimized endpoint for this domain name. If you include the root
         * certificate, your certificate chain must start with intermediate certificates and end with the root
         * certificate. Use the intermediate certificates that were provided by your certificate authority. Do not
         * include any intermediaries that are not in the chain of trust path.
         * </p>
         * 
         * @param certificateChain
         *        [Deprecated] The intermediate certificates and optionally the root certificate, one after the other
         *        without any blank lines, used by an edge-optimized endpoint for this domain name. If you include the
         *        root certificate, your certificate chain must start with intermediate certificates and end with the
         *        root certificate. Use the intermediate certificates that were provided by your certificate authority.
         *        Do not include any intermediaries that are not in the chain of trust path.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder certificateChain(String certificateChain);

        /**
         * <p>
         * The reference to an AWS-managed certificate that will be used by edge-optimized endpoint for this domain
         * name. AWS Certificate Manager is the only supported source.
         * </p>
         * 
         * @param certificateArn
         *        The reference to an AWS-managed certificate that will be used by edge-optimized endpoint for this
         *        domain name. AWS Certificate Manager is the only supported source.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder certificateArn(String certificateArn);

        /**
         * <p>
         * The user-friendly name of the certificate that will be used by regional endpoint for this domain name.
         * </p>
         * 
         * @param regionalCertificateName
         *        The user-friendly name of the certificate that will be used by regional endpoint for this domain name.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder regionalCertificateName(String regionalCertificateName);

        /**
         * <p>
         * The reference to an AWS-managed certificate that will be used by regional endpoint for this domain name. AWS
         * Certificate Manager is the only supported source.
         * </p>
         * 
         * @param regionalCertificateArn
         *        The reference to an AWS-managed certificate that will be used by regional endpoint for this domain
         *        name. AWS Certificate Manager is the only supported source.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder regionalCertificateArn(String regionalCertificateArn);

        /**
         * <p>
         * The endpoint configuration of this <a>DomainName</a> showing the endpoint types of the domain name.
         * </p>
         * 
         * @param endpointConfiguration
         *        The endpoint configuration of this <a>DomainName</a> showing the endpoint types of the domain name.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder endpointConfiguration(EndpointConfiguration endpointConfiguration);

        /**
         * <p>
         * The endpoint configuration of this <a>DomainName</a> showing the endpoint types of the domain name.
         * </p>
         * This is a convenience that creates an instance of the {@link EndpointConfiguration.Builder} avoiding the need
         * to create one manually via {@link EndpointConfiguration#builder()}.
         *
         * When the {@link Consumer} completes, {@link EndpointConfiguration.Builder#build()} is called immediately and
         * its result is passed to {@link #endpointConfiguration(EndpointConfiguration)}.
         * 
         * @param endpointConfiguration
         *        a consumer that will call methods on {@link EndpointConfiguration.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #endpointConfiguration(EndpointConfiguration)
         */
        default Builder endpointConfiguration(Consumer<EndpointConfiguration.Builder> endpointConfiguration) {
            return endpointConfiguration(EndpointConfiguration.builder().applyMutation(endpointConfiguration).build());
        }

        @Override
        Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration);

        @Override
        Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer);
    }

    static final class BuilderImpl extends ApiGatewayRequest.BuilderImpl implements Builder {
        private String domainName;

        private String certificateName;

        private String certificateBody;

        private String certificatePrivateKey;

        private String certificateChain;

        private String certificateArn;

        private String regionalCertificateName;

        private String regionalCertificateArn;

        private EndpointConfiguration endpointConfiguration;

        private BuilderImpl() {
        }

        private BuilderImpl(CreateDomainNameRequest model) {
            super(model);
            domainName(model.domainName);
            certificateName(model.certificateName);
            certificateBody(model.certificateBody);
            certificatePrivateKey(model.certificatePrivateKey);
            certificateChain(model.certificateChain);
            certificateArn(model.certificateArn);
            regionalCertificateName(model.regionalCertificateName);
            regionalCertificateArn(model.regionalCertificateArn);
            endpointConfiguration(model.endpointConfiguration);
        }

        public final String getDomainName() {
            return domainName;
        }

        @Override
        public final Builder domainName(String domainName) {
            this.domainName = domainName;
            return this;
        }

        public final void setDomainName(String domainName) {
            this.domainName = domainName;
        }

        public final String getCertificateName() {
            return certificateName;
        }

        @Override
        public final Builder certificateName(String certificateName) {
            this.certificateName = certificateName;
            return this;
        }

        public final void setCertificateName(String certificateName) {
            this.certificateName = certificateName;
        }

        public final String getCertificateBody() {
            return certificateBody;
        }

        @Override
        public final Builder certificateBody(String certificateBody) {
            this.certificateBody = certificateBody;
            return this;
        }

        public final void setCertificateBody(String certificateBody) {
            this.certificateBody = certificateBody;
        }

        public final String getCertificatePrivateKey() {
            return certificatePrivateKey;
        }

        @Override
        public final Builder certificatePrivateKey(String certificatePrivateKey) {
            this.certificatePrivateKey = certificatePrivateKey;
            return this;
        }

        public final void setCertificatePrivateKey(String certificatePrivateKey) {
            this.certificatePrivateKey = certificatePrivateKey;
        }

        public final String getCertificateChain() {
            return certificateChain;
        }

        @Override
        public final Builder certificateChain(String certificateChain) {
            this.certificateChain = certificateChain;
            return this;
        }

        public final void setCertificateChain(String certificateChain) {
            this.certificateChain = certificateChain;
        }

        public final String getCertificateArn() {
            return certificateArn;
        }

        @Override
        public final Builder certificateArn(String certificateArn) {
            this.certificateArn = certificateArn;
            return this;
        }

        public final void setCertificateArn(String certificateArn) {
            this.certificateArn = certificateArn;
        }

        public final String getRegionalCertificateName() {
            return regionalCertificateName;
        }

        @Override
        public final Builder regionalCertificateName(String regionalCertificateName) {
            this.regionalCertificateName = regionalCertificateName;
            return this;
        }

        public final void setRegionalCertificateName(String regionalCertificateName) {
            this.regionalCertificateName = regionalCertificateName;
        }

        public final String getRegionalCertificateArn() {
            return regionalCertificateArn;
        }

        @Override
        public final Builder regionalCertificateArn(String regionalCertificateArn) {
            this.regionalCertificateArn = regionalCertificateArn;
            return this;
        }

        public final void setRegionalCertificateArn(String regionalCertificateArn) {
            this.regionalCertificateArn = regionalCertificateArn;
        }

        public final EndpointConfiguration.Builder getEndpointConfiguration() {
            return endpointConfiguration != null ? endpointConfiguration.toBuilder() : null;
        }

        @Override
        public final Builder endpointConfiguration(EndpointConfiguration endpointConfiguration) {
            this.endpointConfiguration = endpointConfiguration;
            return this;
        }

        public final void setEndpointConfiguration(EndpointConfiguration.BuilderImpl endpointConfiguration) {
            this.endpointConfiguration = endpointConfiguration != null ? endpointConfiguration.build() : null;
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public CreateDomainNameRequest build() {
            return new CreateDomainNameRequest(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
