/*
 * Copyright 2014-2019 Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.apigateway.model;

import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * Creates a <a>RequestValidator</a> of a given <a>RestApi</a>.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class CreateRequestValidatorRequest extends ApiGatewayRequest implements
        ToCopyableBuilder<CreateRequestValidatorRequest.Builder, CreateRequestValidatorRequest> {
    private static final SdkField<String> REST_API_ID_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .getter(getter(CreateRequestValidatorRequest::restApiId)).setter(setter(Builder::restApiId))
            .traits(LocationTrait.builder().location(MarshallLocation.PATH).locationName("restapi_id").build()).build();

    private static final SdkField<String> NAME_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .getter(getter(CreateRequestValidatorRequest::name)).setter(setter(Builder::name))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("name").build()).build();

    private static final SdkField<Boolean> VALIDATE_REQUEST_BODY_FIELD = SdkField.<Boolean> builder(MarshallingType.BOOLEAN)
            .getter(getter(CreateRequestValidatorRequest::validateRequestBody)).setter(setter(Builder::validateRequestBody))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("validateRequestBody").build())
            .build();

    private static final SdkField<Boolean> VALIDATE_REQUEST_PARAMETERS_FIELD = SdkField
            .<Boolean> builder(MarshallingType.BOOLEAN).getter(getter(CreateRequestValidatorRequest::validateRequestParameters))
            .setter(setter(Builder::validateRequestParameters))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("validateRequestParameters").build())
            .build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(REST_API_ID_FIELD, NAME_FIELD,
            VALIDATE_REQUEST_BODY_FIELD, VALIDATE_REQUEST_PARAMETERS_FIELD));

    private final String restApiId;

    private final String name;

    private final Boolean validateRequestBody;

    private final Boolean validateRequestParameters;

    private CreateRequestValidatorRequest(BuilderImpl builder) {
        super(builder);
        this.restApiId = builder.restApiId;
        this.name = builder.name;
        this.validateRequestBody = builder.validateRequestBody;
        this.validateRequestParameters = builder.validateRequestParameters;
    }

    /**
     * <p>
     * [Required] The string identifier of the associated <a>RestApi</a>.
     * </p>
     * 
     * @return [Required] The string identifier of the associated <a>RestApi</a>.
     */
    public String restApiId() {
        return restApiId;
    }

    /**
     * <p>
     * The name of the to-be-created <a>RequestValidator</a>.
     * </p>
     * 
     * @return The name of the to-be-created <a>RequestValidator</a>.
     */
    public String name() {
        return name;
    }

    /**
     * <p>
     * A Boolean flag to indicate whether to validate request body according to the configured model schema for the
     * method (<code>true</code>) or not (<code>false</code>).
     * </p>
     * 
     * @return A Boolean flag to indicate whether to validate request body according to the configured model schema for
     *         the method (<code>true</code>) or not (<code>false</code>).
     */
    public Boolean validateRequestBody() {
        return validateRequestBody;
    }

    /**
     * <p>
     * A Boolean flag to indicate whether to validate request parameters, <code>true</code>, or not <code>false</code>.
     * </p>
     * 
     * @return A Boolean flag to indicate whether to validate request parameters, <code>true</code>, or not
     *         <code>false</code>.
     */
    public Boolean validateRequestParameters() {
        return validateRequestParameters;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(restApiId());
        hashCode = 31 * hashCode + Objects.hashCode(name());
        hashCode = 31 * hashCode + Objects.hashCode(validateRequestBody());
        hashCode = 31 * hashCode + Objects.hashCode(validateRequestParameters());
        return hashCode;
    }

    @Override
    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof CreateRequestValidatorRequest)) {
            return false;
        }
        CreateRequestValidatorRequest other = (CreateRequestValidatorRequest) obj;
        return Objects.equals(restApiId(), other.restApiId()) && Objects.equals(name(), other.name())
                && Objects.equals(validateRequestBody(), other.validateRequestBody())
                && Objects.equals(validateRequestParameters(), other.validateRequestParameters());
    }

    @Override
    public String toString() {
        return ToString.builder("CreateRequestValidatorRequest").add("RestApiId", restApiId()).add("Name", name())
                .add("ValidateRequestBody", validateRequestBody()).add("ValidateRequestParameters", validateRequestParameters())
                .build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "restApiId":
            return Optional.ofNullable(clazz.cast(restApiId()));
        case "name":
            return Optional.ofNullable(clazz.cast(name()));
        case "validateRequestBody":
            return Optional.ofNullable(clazz.cast(validateRequestBody()));
        case "validateRequestParameters":
            return Optional.ofNullable(clazz.cast(validateRequestParameters()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<CreateRequestValidatorRequest, T> g) {
        return obj -> g.apply((CreateRequestValidatorRequest) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends ApiGatewayRequest.Builder, SdkPojo, CopyableBuilder<Builder, CreateRequestValidatorRequest> {
        /**
         * <p>
         * [Required] The string identifier of the associated <a>RestApi</a>.
         * </p>
         * 
         * @param restApiId
         *        [Required] The string identifier of the associated <a>RestApi</a>.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder restApiId(String restApiId);

        /**
         * <p>
         * The name of the to-be-created <a>RequestValidator</a>.
         * </p>
         * 
         * @param name
         *        The name of the to-be-created <a>RequestValidator</a>.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder name(String name);

        /**
         * <p>
         * A Boolean flag to indicate whether to validate request body according to the configured model schema for the
         * method (<code>true</code>) or not (<code>false</code>).
         * </p>
         * 
         * @param validateRequestBody
         *        A Boolean flag to indicate whether to validate request body according to the configured model schema
         *        for the method (<code>true</code>) or not (<code>false</code>).
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder validateRequestBody(Boolean validateRequestBody);

        /**
         * <p>
         * A Boolean flag to indicate whether to validate request parameters, <code>true</code>, or not
         * <code>false</code>.
         * </p>
         * 
         * @param validateRequestParameters
         *        A Boolean flag to indicate whether to validate request parameters, <code>true</code>, or not
         *        <code>false</code>.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder validateRequestParameters(Boolean validateRequestParameters);

        @Override
        Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration);

        @Override
        Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer);
    }

    static final class BuilderImpl extends ApiGatewayRequest.BuilderImpl implements Builder {
        private String restApiId;

        private String name;

        private Boolean validateRequestBody;

        private Boolean validateRequestParameters;

        private BuilderImpl() {
        }

        private BuilderImpl(CreateRequestValidatorRequest model) {
            super(model);
            restApiId(model.restApiId);
            name(model.name);
            validateRequestBody(model.validateRequestBody);
            validateRequestParameters(model.validateRequestParameters);
        }

        public final String getRestApiId() {
            return restApiId;
        }

        @Override
        public final Builder restApiId(String restApiId) {
            this.restApiId = restApiId;
            return this;
        }

        public final void setRestApiId(String restApiId) {
            this.restApiId = restApiId;
        }

        public final String getName() {
            return name;
        }

        @Override
        public final Builder name(String name) {
            this.name = name;
            return this;
        }

        public final void setName(String name) {
            this.name = name;
        }

        public final Boolean getValidateRequestBody() {
            return validateRequestBody;
        }

        @Override
        public final Builder validateRequestBody(Boolean validateRequestBody) {
            this.validateRequestBody = validateRequestBody;
            return this;
        }

        public final void setValidateRequestBody(Boolean validateRequestBody) {
            this.validateRequestBody = validateRequestBody;
        }

        public final Boolean getValidateRequestParameters() {
            return validateRequestParameters;
        }

        @Override
        public final Builder validateRequestParameters(Boolean validateRequestParameters) {
            this.validateRequestParameters = validateRequestParameters;
            return this;
        }

        public final void setValidateRequestParameters(Boolean validateRequestParameters) {
            this.validateRequestParameters = validateRequestParameters;
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public CreateRequestValidatorRequest build() {
            return new CreateRequestValidatorRequest(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
