/*
 * Copyright 2014-2019 Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.apigateway.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * A collection of <a>RequestValidator</a> resources of a given <a>RestApi</a>.
 * </p>
 * <div class="remarks">
 * <p>
 * In OpenAPI, the <a>RequestValidators</a> of an API is defined by the <a href=
 * "https://docs.aws.amazon.com/apigateway/latest/developerguide/api-gateway-swagger-extensions.html#api-gateway-swagger-extensions-request-validators.html"
 * >x-amazon-apigateway-request-validators</a> extension.
 * </p>
 * </div> <div class="seeAlso"><a
 * href="https://docs.aws.amazon.com/apigateway/latest/developerguide/api-gateway-method-request-validation.html">Enable
 * Basic Request Validation in API Gateway</a></div>
 */
@Generated("software.amazon.awssdk:codegen")
public final class GetRequestValidatorsResponse extends ApiGatewayResponse implements
        ToCopyableBuilder<GetRequestValidatorsResponse.Builder, GetRequestValidatorsResponse> {
    private static final SdkField<String> POSITION_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .getter(getter(GetRequestValidatorsResponse::position)).setter(setter(Builder::position))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("position").build()).build();

    private static final SdkField<List<RequestValidator>> ITEMS_FIELD = SdkField
            .<List<RequestValidator>> builder(MarshallingType.LIST)
            .getter(getter(GetRequestValidatorsResponse::items))
            .setter(setter(Builder::items))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("item").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<RequestValidator> builder(MarshallingType.SDK_POJO)
                                            .constructor(RequestValidator::builder)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(POSITION_FIELD, ITEMS_FIELD));

    private final String position;

    private final List<RequestValidator> items;

    private GetRequestValidatorsResponse(BuilderImpl builder) {
        super(builder);
        this.position = builder.position;
        this.items = builder.items;
    }

    /**
     * Returns the value of the Position property for this object.
     * 
     * @return The value of the Position property for this object.
     */
    public String position() {
        return position;
    }

    /**
     * <p>
     * The current page of elements from this collection.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * 
     * @return The current page of elements from this collection.
     */
    public List<RequestValidator> items() {
        return items;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(position());
        hashCode = 31 * hashCode + Objects.hashCode(items());
        return hashCode;
    }

    @Override
    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof GetRequestValidatorsResponse)) {
            return false;
        }
        GetRequestValidatorsResponse other = (GetRequestValidatorsResponse) obj;
        return Objects.equals(position(), other.position()) && Objects.equals(items(), other.items());
    }

    @Override
    public String toString() {
        return ToString.builder("GetRequestValidatorsResponse").add("Position", position()).add("Items", items()).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "position":
            return Optional.ofNullable(clazz.cast(position()));
        case "items":
            return Optional.ofNullable(clazz.cast(items()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<GetRequestValidatorsResponse, T> g) {
        return obj -> g.apply((GetRequestValidatorsResponse) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends ApiGatewayResponse.Builder, SdkPojo, CopyableBuilder<Builder, GetRequestValidatorsResponse> {
        /**
         * Sets the value of the Position property for this object.
         *
         * @param position
         *        The new value for the Position property for this object.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder position(String position);

        /**
         * <p>
         * The current page of elements from this collection.
         * </p>
         * 
         * @param items
         *        The current page of elements from this collection.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder items(Collection<RequestValidator> items);

        /**
         * <p>
         * The current page of elements from this collection.
         * </p>
         * 
         * @param items
         *        The current page of elements from this collection.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder items(RequestValidator... items);

        /**
         * <p>
         * The current page of elements from this collection.
         * </p>
         * This is a convenience that creates an instance of the {@link List<RequestValidator>.Builder} avoiding the
         * need to create one manually via {@link List<RequestValidator>#builder()}.
         *
         * When the {@link Consumer} completes, {@link List<RequestValidator>.Builder#build()} is called immediately and
         * its result is passed to {@link #items(List<RequestValidator>)}.
         * 
         * @param items
         *        a consumer that will call methods on {@link List<RequestValidator>.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #items(List<RequestValidator>)
         */
        Builder items(Consumer<RequestValidator.Builder>... items);
    }

    static final class BuilderImpl extends ApiGatewayResponse.BuilderImpl implements Builder {
        private String position;

        private List<RequestValidator> items = DefaultSdkAutoConstructList.getInstance();

        private BuilderImpl() {
        }

        private BuilderImpl(GetRequestValidatorsResponse model) {
            super(model);
            position(model.position);
            items(model.items);
        }

        public final String getPosition() {
            return position;
        }

        @Override
        public final Builder position(String position) {
            this.position = position;
            return this;
        }

        public final void setPosition(String position) {
            this.position = position;
        }

        public final Collection<RequestValidator.Builder> getItems() {
            return items != null ? items.stream().map(RequestValidator::toBuilder).collect(Collectors.toList()) : null;
        }

        @Override
        public final Builder items(Collection<RequestValidator> items) {
            this.items = ListOfRequestValidatorCopier.copy(items);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder items(RequestValidator... items) {
            items(Arrays.asList(items));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder items(Consumer<RequestValidator.Builder>... items) {
            items(Stream.of(items).map(c -> RequestValidator.builder().applyMutation(c).build()).collect(Collectors.toList()));
            return this;
        }

        public final void setItems(Collection<RequestValidator.BuilderImpl> items) {
            this.items = ListOfRequestValidatorCopier.copyFromBuilder(items);
        }

        @Override
        public GetRequestValidatorsResponse build() {
            return new GetRequestValidatorsResponse(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
