/*
 * Copyright 2014-2019 Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.apigateway.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * A type of SDK that API Gateway can generate.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class GetSdkTypeResponse extends ApiGatewayResponse implements
        ToCopyableBuilder<GetSdkTypeResponse.Builder, GetSdkTypeResponse> {
    private static final SdkField<String> ID_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .getter(getter(GetSdkTypeResponse::id)).setter(setter(Builder::id))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("id").build()).build();

    private static final SdkField<String> FRIENDLY_NAME_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .getter(getter(GetSdkTypeResponse::friendlyName)).setter(setter(Builder::friendlyName))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("friendlyName").build()).build();

    private static final SdkField<String> DESCRIPTION_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .getter(getter(GetSdkTypeResponse::description)).setter(setter(Builder::description))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("description").build()).build();

    private static final SdkField<List<SdkConfigurationProperty>> CONFIGURATION_PROPERTIES_FIELD = SdkField
            .<List<SdkConfigurationProperty>> builder(MarshallingType.LIST)
            .getter(getter(GetSdkTypeResponse::configurationProperties))
            .setter(setter(Builder::configurationProperties))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("configurationProperties").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<SdkConfigurationProperty> builder(MarshallingType.SDK_POJO)
                                            .constructor(SdkConfigurationProperty::builder)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(ID_FIELD, FRIENDLY_NAME_FIELD,
            DESCRIPTION_FIELD, CONFIGURATION_PROPERTIES_FIELD));

    private final String id;

    private final String friendlyName;

    private final String description;

    private final List<SdkConfigurationProperty> configurationProperties;

    private GetSdkTypeResponse(BuilderImpl builder) {
        super(builder);
        this.id = builder.id;
        this.friendlyName = builder.friendlyName;
        this.description = builder.description;
        this.configurationProperties = builder.configurationProperties;
    }

    /**
     * <p>
     * The identifier of an <a>SdkType</a> instance.
     * </p>
     * 
     * @return The identifier of an <a>SdkType</a> instance.
     */
    public String id() {
        return id;
    }

    /**
     * <p>
     * The user-friendly name of an <a>SdkType</a> instance.
     * </p>
     * 
     * @return The user-friendly name of an <a>SdkType</a> instance.
     */
    public String friendlyName() {
        return friendlyName;
    }

    /**
     * <p>
     * The description of an <a>SdkType</a>.
     * </p>
     * 
     * @return The description of an <a>SdkType</a>.
     */
    public String description() {
        return description;
    }

    /**
     * <p>
     * A list of configuration properties of an <a>SdkType</a>.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * 
     * @return A list of configuration properties of an <a>SdkType</a>.
     */
    public List<SdkConfigurationProperty> configurationProperties() {
        return configurationProperties;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(id());
        hashCode = 31 * hashCode + Objects.hashCode(friendlyName());
        hashCode = 31 * hashCode + Objects.hashCode(description());
        hashCode = 31 * hashCode + Objects.hashCode(configurationProperties());
        return hashCode;
    }

    @Override
    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof GetSdkTypeResponse)) {
            return false;
        }
        GetSdkTypeResponse other = (GetSdkTypeResponse) obj;
        return Objects.equals(id(), other.id()) && Objects.equals(friendlyName(), other.friendlyName())
                && Objects.equals(description(), other.description())
                && Objects.equals(configurationProperties(), other.configurationProperties());
    }

    @Override
    public String toString() {
        return ToString.builder("GetSdkTypeResponse").add("Id", id()).add("FriendlyName", friendlyName())
                .add("Description", description()).add("ConfigurationProperties", configurationProperties()).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "id":
            return Optional.ofNullable(clazz.cast(id()));
        case "friendlyName":
            return Optional.ofNullable(clazz.cast(friendlyName()));
        case "description":
            return Optional.ofNullable(clazz.cast(description()));
        case "configurationProperties":
            return Optional.ofNullable(clazz.cast(configurationProperties()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<GetSdkTypeResponse, T> g) {
        return obj -> g.apply((GetSdkTypeResponse) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends ApiGatewayResponse.Builder, SdkPojo, CopyableBuilder<Builder, GetSdkTypeResponse> {
        /**
         * <p>
         * The identifier of an <a>SdkType</a> instance.
         * </p>
         * 
         * @param id
         *        The identifier of an <a>SdkType</a> instance.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder id(String id);

        /**
         * <p>
         * The user-friendly name of an <a>SdkType</a> instance.
         * </p>
         * 
         * @param friendlyName
         *        The user-friendly name of an <a>SdkType</a> instance.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder friendlyName(String friendlyName);

        /**
         * <p>
         * The description of an <a>SdkType</a>.
         * </p>
         * 
         * @param description
         *        The description of an <a>SdkType</a>.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder description(String description);

        /**
         * <p>
         * A list of configuration properties of an <a>SdkType</a>.
         * </p>
         * 
         * @param configurationProperties
         *        A list of configuration properties of an <a>SdkType</a>.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder configurationProperties(Collection<SdkConfigurationProperty> configurationProperties);

        /**
         * <p>
         * A list of configuration properties of an <a>SdkType</a>.
         * </p>
         * 
         * @param configurationProperties
         *        A list of configuration properties of an <a>SdkType</a>.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder configurationProperties(SdkConfigurationProperty... configurationProperties);

        /**
         * <p>
         * A list of configuration properties of an <a>SdkType</a>.
         * </p>
         * This is a convenience that creates an instance of the {@link List<SdkConfigurationProperty>.Builder} avoiding
         * the need to create one manually via {@link List<SdkConfigurationProperty>#builder()}.
         *
         * When the {@link Consumer} completes, {@link List<SdkConfigurationProperty>.Builder#build()} is called
         * immediately and its result is passed to {@link #configurationProperties(List<SdkConfigurationProperty>)}.
         * 
         * @param configurationProperties
         *        a consumer that will call methods on {@link List<SdkConfigurationProperty>.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #configurationProperties(List<SdkConfigurationProperty>)
         */
        Builder configurationProperties(Consumer<SdkConfigurationProperty.Builder>... configurationProperties);
    }

    static final class BuilderImpl extends ApiGatewayResponse.BuilderImpl implements Builder {
        private String id;

        private String friendlyName;

        private String description;

        private List<SdkConfigurationProperty> configurationProperties = DefaultSdkAutoConstructList.getInstance();

        private BuilderImpl() {
        }

        private BuilderImpl(GetSdkTypeResponse model) {
            super(model);
            id(model.id);
            friendlyName(model.friendlyName);
            description(model.description);
            configurationProperties(model.configurationProperties);
        }

        public final String getId() {
            return id;
        }

        @Override
        public final Builder id(String id) {
            this.id = id;
            return this;
        }

        public final void setId(String id) {
            this.id = id;
        }

        public final String getFriendlyName() {
            return friendlyName;
        }

        @Override
        public final Builder friendlyName(String friendlyName) {
            this.friendlyName = friendlyName;
            return this;
        }

        public final void setFriendlyName(String friendlyName) {
            this.friendlyName = friendlyName;
        }

        public final String getDescription() {
            return description;
        }

        @Override
        public final Builder description(String description) {
            this.description = description;
            return this;
        }

        public final void setDescription(String description) {
            this.description = description;
        }

        public final Collection<SdkConfigurationProperty.Builder> getConfigurationProperties() {
            return configurationProperties != null ? configurationProperties.stream().map(SdkConfigurationProperty::toBuilder)
                    .collect(Collectors.toList()) : null;
        }

        @Override
        public final Builder configurationProperties(Collection<SdkConfigurationProperty> configurationProperties) {
            this.configurationProperties = ListOfSdkConfigurationPropertyCopier.copy(configurationProperties);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder configurationProperties(SdkConfigurationProperty... configurationProperties) {
            configurationProperties(Arrays.asList(configurationProperties));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder configurationProperties(Consumer<SdkConfigurationProperty.Builder>... configurationProperties) {
            configurationProperties(Stream.of(configurationProperties)
                    .map(c -> SdkConfigurationProperty.builder().applyMutation(c).build()).collect(Collectors.toList()));
            return this;
        }

        public final void setConfigurationProperties(Collection<SdkConfigurationProperty.BuilderImpl> configurationProperties) {
            this.configurationProperties = ListOfSdkConfigurationPropertyCopier.copyFromBuilder(configurationProperties);
        }

        @Override
        public GetSdkTypeResponse build() {
            return new GetSdkTypeResponse(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
