/*
 * Copyright 2014-2019 Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.apigateway.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.MapTrait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructMap;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * Request to add a method to an existing <a>Resource</a> resource.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class PutMethodRequest extends ApiGatewayRequest implements
        ToCopyableBuilder<PutMethodRequest.Builder, PutMethodRequest> {
    private static final SdkField<String> REST_API_ID_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .getter(getter(PutMethodRequest::restApiId)).setter(setter(Builder::restApiId))
            .traits(LocationTrait.builder().location(MarshallLocation.PATH).locationName("restapi_id").build()).build();

    private static final SdkField<String> RESOURCE_ID_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .getter(getter(PutMethodRequest::resourceId)).setter(setter(Builder::resourceId))
            .traits(LocationTrait.builder().location(MarshallLocation.PATH).locationName("resource_id").build()).build();

    private static final SdkField<String> HTTP_METHOD_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .getter(getter(PutMethodRequest::httpMethod)).setter(setter(Builder::httpMethod))
            .traits(LocationTrait.builder().location(MarshallLocation.PATH).locationName("http_method").build()).build();

    private static final SdkField<String> AUTHORIZATION_TYPE_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .getter(getter(PutMethodRequest::authorizationType)).setter(setter(Builder::authorizationType))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("authorizationType").build()).build();

    private static final SdkField<String> AUTHORIZER_ID_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .getter(getter(PutMethodRequest::authorizerId)).setter(setter(Builder::authorizerId))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("authorizerId").build()).build();

    private static final SdkField<Boolean> API_KEY_REQUIRED_FIELD = SdkField.<Boolean> builder(MarshallingType.BOOLEAN)
            .getter(getter(PutMethodRequest::apiKeyRequired)).setter(setter(Builder::apiKeyRequired))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("apiKeyRequired").build()).build();

    private static final SdkField<String> OPERATION_NAME_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .getter(getter(PutMethodRequest::operationName)).setter(setter(Builder::operationName))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("operationName").build()).build();

    private static final SdkField<Map<String, Boolean>> REQUEST_PARAMETERS_FIELD = SdkField
            .<Map<String, Boolean>> builder(MarshallingType.MAP)
            .getter(getter(PutMethodRequest::requestParameters))
            .setter(setter(Builder::requestParameters))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("requestParameters").build(),
                    MapTrait.builder()
                            .keyLocationName("key")
                            .valueLocationName("value")
                            .valueFieldInfo(
                                    SdkField.<Boolean> builder(MarshallingType.BOOLEAN)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("value").build()).build()).build()).build();

    private static final SdkField<Map<String, String>> REQUEST_MODELS_FIELD = SdkField
            .<Map<String, String>> builder(MarshallingType.MAP)
            .getter(getter(PutMethodRequest::requestModels))
            .setter(setter(Builder::requestModels))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("requestModels").build(),
                    MapTrait.builder()
                            .keyLocationName("key")
                            .valueLocationName("value")
                            .valueFieldInfo(
                                    SdkField.<String> builder(MarshallingType.STRING)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("value").build()).build()).build()).build();

    private static final SdkField<String> REQUEST_VALIDATOR_ID_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .getter(getter(PutMethodRequest::requestValidatorId)).setter(setter(Builder::requestValidatorId))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("requestValidatorId").build())
            .build();

    private static final SdkField<List<String>> AUTHORIZATION_SCOPES_FIELD = SdkField
            .<List<String>> builder(MarshallingType.LIST)
            .getter(getter(PutMethodRequest::authorizationScopes))
            .setter(setter(Builder::authorizationScopes))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("authorizationScopes").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<String> builder(MarshallingType.STRING)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(REST_API_ID_FIELD,
            RESOURCE_ID_FIELD, HTTP_METHOD_FIELD, AUTHORIZATION_TYPE_FIELD, AUTHORIZER_ID_FIELD, API_KEY_REQUIRED_FIELD,
            OPERATION_NAME_FIELD, REQUEST_PARAMETERS_FIELD, REQUEST_MODELS_FIELD, REQUEST_VALIDATOR_ID_FIELD,
            AUTHORIZATION_SCOPES_FIELD));

    private final String restApiId;

    private final String resourceId;

    private final String httpMethod;

    private final String authorizationType;

    private final String authorizerId;

    private final Boolean apiKeyRequired;

    private final String operationName;

    private final Map<String, Boolean> requestParameters;

    private final Map<String, String> requestModels;

    private final String requestValidatorId;

    private final List<String> authorizationScopes;

    private PutMethodRequest(BuilderImpl builder) {
        super(builder);
        this.restApiId = builder.restApiId;
        this.resourceId = builder.resourceId;
        this.httpMethod = builder.httpMethod;
        this.authorizationType = builder.authorizationType;
        this.authorizerId = builder.authorizerId;
        this.apiKeyRequired = builder.apiKeyRequired;
        this.operationName = builder.operationName;
        this.requestParameters = builder.requestParameters;
        this.requestModels = builder.requestModels;
        this.requestValidatorId = builder.requestValidatorId;
        this.authorizationScopes = builder.authorizationScopes;
    }

    /**
     * <p>
     * [Required] The string identifier of the associated <a>RestApi</a>.
     * </p>
     * 
     * @return [Required] The string identifier of the associated <a>RestApi</a>.
     */
    public String restApiId() {
        return restApiId;
    }

    /**
     * <p>
     * [Required] The <a>Resource</a> identifier for the new <a>Method</a> resource.
     * </p>
     * 
     * @return [Required] The <a>Resource</a> identifier for the new <a>Method</a> resource.
     */
    public String resourceId() {
        return resourceId;
    }

    /**
     * <p>
     * [Required] Specifies the method request's HTTP method type.
     * </p>
     * 
     * @return [Required] Specifies the method request's HTTP method type.
     */
    public String httpMethod() {
        return httpMethod;
    }

    /**
     * <p>
     * [Required] The method's authorization type. Valid values are <code>NONE</code> for open access,
     * <code>AWS_IAM</code> for using AWS IAM permissions, <code>CUSTOM</code> for using a custom authorizer, or
     * <code>COGNITO_USER_POOLS</code> for using a Cognito user pool.
     * </p>
     * 
     * @return [Required] The method's authorization type. Valid values are <code>NONE</code> for open access,
     *         <code>AWS_IAM</code> for using AWS IAM permissions, <code>CUSTOM</code> for using a custom authorizer, or
     *         <code>COGNITO_USER_POOLS</code> for using a Cognito user pool.
     */
    public String authorizationType() {
        return authorizationType;
    }

    /**
     * <p>
     * Specifies the identifier of an <a>Authorizer</a> to use on this Method, if the type is CUSTOM or
     * COGNITO_USER_POOLS. The authorizer identifier is generated by API Gateway when you created the authorizer.
     * </p>
     * 
     * @return Specifies the identifier of an <a>Authorizer</a> to use on this Method, if the type is CUSTOM or
     *         COGNITO_USER_POOLS. The authorizer identifier is generated by API Gateway when you created the
     *         authorizer.
     */
    public String authorizerId() {
        return authorizerId;
    }

    /**
     * <p>
     * Specifies whether the method required a valid <a>ApiKey</a>.
     * </p>
     * 
     * @return Specifies whether the method required a valid <a>ApiKey</a>.
     */
    public Boolean apiKeyRequired() {
        return apiKeyRequired;
    }

    /**
     * <p>
     * A human-friendly operation identifier for the method. For example, you can assign the <code>operationName</code>
     * of <code>ListPets</code> for the <code>GET /pets</code> method in <a
     * href="https://petstore-demo-endpoint.execute-api.com/petstore/pets">PetStore</a> example.
     * </p>
     * 
     * @return A human-friendly operation identifier for the method. For example, you can assign the
     *         <code>operationName</code> of <code>ListPets</code> for the <code>GET /pets</code> method in <a
     *         href="https://petstore-demo-endpoint.execute-api.com/petstore/pets">PetStore</a> example.
     */
    public String operationName() {
        return operationName;
    }

    /**
     * <p>
     * A key-value map defining required or optional method request parameters that can be accepted by API Gateway. A
     * key defines a method request parameter name matching the pattern of <code>method.request.{location}.{name}</code>
     * , where <code>location</code> is <code>querystring</code>, <code>path</code>, or <code>header</code> and
     * <code>name</code> is a valid and unique parameter name. The value associated with the key is a Boolean flag
     * indicating whether the parameter is required (<code>true</code>) or optional (<code>false</code>). The method
     * request parameter names defined here are available in <a>Integration</a> to be mapped to integration request
     * parameters or body-mapping templates.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * 
     * @return A key-value map defining required or optional method request parameters that can be accepted by API
     *         Gateway. A key defines a method request parameter name matching the pattern of
     *         <code>method.request.{location}.{name}</code>, where <code>location</code> is <code>querystring</code>,
     *         <code>path</code>, or <code>header</code> and <code>name</code> is a valid and unique parameter name. The
     *         value associated with the key is a Boolean flag indicating whether the parameter is required (
     *         <code>true</code>) or optional (<code>false</code>). The method request parameter names defined here are
     *         available in <a>Integration</a> to be mapped to integration request parameters or body-mapping templates.
     */
    public Map<String, Boolean> requestParameters() {
        return requestParameters;
    }

    /**
     * <p>
     * Specifies the <a>Model</a> resources used for the request's content type. Request models are represented as a
     * key/value map, with a content type as the key and a <a>Model</a> name as the value.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * 
     * @return Specifies the <a>Model</a> resources used for the request's content type. Request models are represented
     *         as a key/value map, with a content type as the key and a <a>Model</a> name as the value.
     */
    public Map<String, String> requestModels() {
        return requestModels;
    }

    /**
     * <p>
     * The identifier of a <a>RequestValidator</a> for validating the method request.
     * </p>
     * 
     * @return The identifier of a <a>RequestValidator</a> for validating the method request.
     */
    public String requestValidatorId() {
        return requestValidatorId;
    }

    /**
     * <p>
     * A list of authorization scopes configured on the method. The scopes are used with a
     * <code>COGNITO_USER_POOLS</code> authorizer to authorize the method invocation. The authorization works by
     * matching the method scopes against the scopes parsed from the access token in the incoming request. The method
     * invocation is authorized if any method scopes matches a claimed scope in the access token. Otherwise, the
     * invocation is not authorized. When the method scope is configured, the client must provide an access token
     * instead of an identity token for authorization purposes.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * 
     * @return A list of authorization scopes configured on the method. The scopes are used with a
     *         <code>COGNITO_USER_POOLS</code> authorizer to authorize the method invocation. The authorization works by
     *         matching the method scopes against the scopes parsed from the access token in the incoming request. The
     *         method invocation is authorized if any method scopes matches a claimed scope in the access token.
     *         Otherwise, the invocation is not authorized. When the method scope is configured, the client must provide
     *         an access token instead of an identity token for authorization purposes.
     */
    public List<String> authorizationScopes() {
        return authorizationScopes;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(restApiId());
        hashCode = 31 * hashCode + Objects.hashCode(resourceId());
        hashCode = 31 * hashCode + Objects.hashCode(httpMethod());
        hashCode = 31 * hashCode + Objects.hashCode(authorizationType());
        hashCode = 31 * hashCode + Objects.hashCode(authorizerId());
        hashCode = 31 * hashCode + Objects.hashCode(apiKeyRequired());
        hashCode = 31 * hashCode + Objects.hashCode(operationName());
        hashCode = 31 * hashCode + Objects.hashCode(requestParameters());
        hashCode = 31 * hashCode + Objects.hashCode(requestModels());
        hashCode = 31 * hashCode + Objects.hashCode(requestValidatorId());
        hashCode = 31 * hashCode + Objects.hashCode(authorizationScopes());
        return hashCode;
    }

    @Override
    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof PutMethodRequest)) {
            return false;
        }
        PutMethodRequest other = (PutMethodRequest) obj;
        return Objects.equals(restApiId(), other.restApiId()) && Objects.equals(resourceId(), other.resourceId())
                && Objects.equals(httpMethod(), other.httpMethod())
                && Objects.equals(authorizationType(), other.authorizationType())
                && Objects.equals(authorizerId(), other.authorizerId())
                && Objects.equals(apiKeyRequired(), other.apiKeyRequired())
                && Objects.equals(operationName(), other.operationName())
                && Objects.equals(requestParameters(), other.requestParameters())
                && Objects.equals(requestModels(), other.requestModels())
                && Objects.equals(requestValidatorId(), other.requestValidatorId())
                && Objects.equals(authorizationScopes(), other.authorizationScopes());
    }

    @Override
    public String toString() {
        return ToString.builder("PutMethodRequest").add("RestApiId", restApiId()).add("ResourceId", resourceId())
                .add("HttpMethod", httpMethod()).add("AuthorizationType", authorizationType())
                .add("AuthorizerId", authorizerId()).add("ApiKeyRequired", apiKeyRequired())
                .add("OperationName", operationName()).add("RequestParameters", requestParameters())
                .add("RequestModels", requestModels()).add("RequestValidatorId", requestValidatorId())
                .add("AuthorizationScopes", authorizationScopes()).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "restApiId":
            return Optional.ofNullable(clazz.cast(restApiId()));
        case "resourceId":
            return Optional.ofNullable(clazz.cast(resourceId()));
        case "httpMethod":
            return Optional.ofNullable(clazz.cast(httpMethod()));
        case "authorizationType":
            return Optional.ofNullable(clazz.cast(authorizationType()));
        case "authorizerId":
            return Optional.ofNullable(clazz.cast(authorizerId()));
        case "apiKeyRequired":
            return Optional.ofNullable(clazz.cast(apiKeyRequired()));
        case "operationName":
            return Optional.ofNullable(clazz.cast(operationName()));
        case "requestParameters":
            return Optional.ofNullable(clazz.cast(requestParameters()));
        case "requestModels":
            return Optional.ofNullable(clazz.cast(requestModels()));
        case "requestValidatorId":
            return Optional.ofNullable(clazz.cast(requestValidatorId()));
        case "authorizationScopes":
            return Optional.ofNullable(clazz.cast(authorizationScopes()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<PutMethodRequest, T> g) {
        return obj -> g.apply((PutMethodRequest) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends ApiGatewayRequest.Builder, SdkPojo, CopyableBuilder<Builder, PutMethodRequest> {
        /**
         * <p>
         * [Required] The string identifier of the associated <a>RestApi</a>.
         * </p>
         * 
         * @param restApiId
         *        [Required] The string identifier of the associated <a>RestApi</a>.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder restApiId(String restApiId);

        /**
         * <p>
         * [Required] The <a>Resource</a> identifier for the new <a>Method</a> resource.
         * </p>
         * 
         * @param resourceId
         *        [Required] The <a>Resource</a> identifier for the new <a>Method</a> resource.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder resourceId(String resourceId);

        /**
         * <p>
         * [Required] Specifies the method request's HTTP method type.
         * </p>
         * 
         * @param httpMethod
         *        [Required] Specifies the method request's HTTP method type.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder httpMethod(String httpMethod);

        /**
         * <p>
         * [Required] The method's authorization type. Valid values are <code>NONE</code> for open access,
         * <code>AWS_IAM</code> for using AWS IAM permissions, <code>CUSTOM</code> for using a custom authorizer, or
         * <code>COGNITO_USER_POOLS</code> for using a Cognito user pool.
         * </p>
         * 
         * @param authorizationType
         *        [Required] The method's authorization type. Valid values are <code>NONE</code> for open access,
         *        <code>AWS_IAM</code> for using AWS IAM permissions, <code>CUSTOM</code> for using a custom authorizer,
         *        or <code>COGNITO_USER_POOLS</code> for using a Cognito user pool.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder authorizationType(String authorizationType);

        /**
         * <p>
         * Specifies the identifier of an <a>Authorizer</a> to use on this Method, if the type is CUSTOM or
         * COGNITO_USER_POOLS. The authorizer identifier is generated by API Gateway when you created the authorizer.
         * </p>
         * 
         * @param authorizerId
         *        Specifies the identifier of an <a>Authorizer</a> to use on this Method, if the type is CUSTOM or
         *        COGNITO_USER_POOLS. The authorizer identifier is generated by API Gateway when you created the
         *        authorizer.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder authorizerId(String authorizerId);

        /**
         * <p>
         * Specifies whether the method required a valid <a>ApiKey</a>.
         * </p>
         * 
         * @param apiKeyRequired
         *        Specifies whether the method required a valid <a>ApiKey</a>.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder apiKeyRequired(Boolean apiKeyRequired);

        /**
         * <p>
         * A human-friendly operation identifier for the method. For example, you can assign the
         * <code>operationName</code> of <code>ListPets</code> for the <code>GET /pets</code> method in <a
         * href="https://petstore-demo-endpoint.execute-api.com/petstore/pets">PetStore</a> example.
         * </p>
         * 
         * @param operationName
         *        A human-friendly operation identifier for the method. For example, you can assign the
         *        <code>operationName</code> of <code>ListPets</code> for the <code>GET /pets</code> method in <a
         *        href="https://petstore-demo-endpoint.execute-api.com/petstore/pets">PetStore</a> example.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder operationName(String operationName);

        /**
         * <p>
         * A key-value map defining required or optional method request parameters that can be accepted by API Gateway.
         * A key defines a method request parameter name matching the pattern of
         * <code>method.request.{location}.{name}</code>, where <code>location</code> is <code>querystring</code>,
         * <code>path</code>, or <code>header</code> and <code>name</code> is a valid and unique parameter name. The
         * value associated with the key is a Boolean flag indicating whether the parameter is required (
         * <code>true</code>) or optional (<code>false</code>). The method request parameter names defined here are
         * available in <a>Integration</a> to be mapped to integration request parameters or body-mapping templates.
         * </p>
         * 
         * @param requestParameters
         *        A key-value map defining required or optional method request parameters that can be accepted by API
         *        Gateway. A key defines a method request parameter name matching the pattern of
         *        <code>method.request.{location}.{name}</code>, where <code>location</code> is <code>querystring</code>
         *        , <code>path</code>, or <code>header</code> and <code>name</code> is a valid and unique parameter
         *        name. The value associated with the key is a Boolean flag indicating whether the parameter is required
         *        (<code>true</code>) or optional (<code>false</code>). The method request parameter names defined here
         *        are available in <a>Integration</a> to be mapped to integration request parameters or body-mapping
         *        templates.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder requestParameters(Map<String, Boolean> requestParameters);

        /**
         * <p>
         * Specifies the <a>Model</a> resources used for the request's content type. Request models are represented as a
         * key/value map, with a content type as the key and a <a>Model</a> name as the value.
         * </p>
         * 
         * @param requestModels
         *        Specifies the <a>Model</a> resources used for the request's content type. Request models are
         *        represented as a key/value map, with a content type as the key and a <a>Model</a> name as the value.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder requestModels(Map<String, String> requestModels);

        /**
         * <p>
         * The identifier of a <a>RequestValidator</a> for validating the method request.
         * </p>
         * 
         * @param requestValidatorId
         *        The identifier of a <a>RequestValidator</a> for validating the method request.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder requestValidatorId(String requestValidatorId);

        /**
         * <p>
         * A list of authorization scopes configured on the method. The scopes are used with a
         * <code>COGNITO_USER_POOLS</code> authorizer to authorize the method invocation. The authorization works by
         * matching the method scopes against the scopes parsed from the access token in the incoming request. The
         * method invocation is authorized if any method scopes matches a claimed scope in the access token. Otherwise,
         * the invocation is not authorized. When the method scope is configured, the client must provide an access
         * token instead of an identity token for authorization purposes.
         * </p>
         * 
         * @param authorizationScopes
         *        A list of authorization scopes configured on the method. The scopes are used with a
         *        <code>COGNITO_USER_POOLS</code> authorizer to authorize the method invocation. The authorization works
         *        by matching the method scopes against the scopes parsed from the access token in the incoming request.
         *        The method invocation is authorized if any method scopes matches a claimed scope in the access token.
         *        Otherwise, the invocation is not authorized. When the method scope is configured, the client must
         *        provide an access token instead of an identity token for authorization purposes.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder authorizationScopes(Collection<String> authorizationScopes);

        /**
         * <p>
         * A list of authorization scopes configured on the method. The scopes are used with a
         * <code>COGNITO_USER_POOLS</code> authorizer to authorize the method invocation. The authorization works by
         * matching the method scopes against the scopes parsed from the access token in the incoming request. The
         * method invocation is authorized if any method scopes matches a claimed scope in the access token. Otherwise,
         * the invocation is not authorized. When the method scope is configured, the client must provide an access
         * token instead of an identity token for authorization purposes.
         * </p>
         * 
         * @param authorizationScopes
         *        A list of authorization scopes configured on the method. The scopes are used with a
         *        <code>COGNITO_USER_POOLS</code> authorizer to authorize the method invocation. The authorization works
         *        by matching the method scopes against the scopes parsed from the access token in the incoming request.
         *        The method invocation is authorized if any method scopes matches a claimed scope in the access token.
         *        Otherwise, the invocation is not authorized. When the method scope is configured, the client must
         *        provide an access token instead of an identity token for authorization purposes.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder authorizationScopes(String... authorizationScopes);

        @Override
        Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration);

        @Override
        Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer);
    }

    static final class BuilderImpl extends ApiGatewayRequest.BuilderImpl implements Builder {
        private String restApiId;

        private String resourceId;

        private String httpMethod;

        private String authorizationType;

        private String authorizerId;

        private Boolean apiKeyRequired;

        private String operationName;

        private Map<String, Boolean> requestParameters = DefaultSdkAutoConstructMap.getInstance();

        private Map<String, String> requestModels = DefaultSdkAutoConstructMap.getInstance();

        private String requestValidatorId;

        private List<String> authorizationScopes = DefaultSdkAutoConstructList.getInstance();

        private BuilderImpl() {
        }

        private BuilderImpl(PutMethodRequest model) {
            super(model);
            restApiId(model.restApiId);
            resourceId(model.resourceId);
            httpMethod(model.httpMethod);
            authorizationType(model.authorizationType);
            authorizerId(model.authorizerId);
            apiKeyRequired(model.apiKeyRequired);
            operationName(model.operationName);
            requestParameters(model.requestParameters);
            requestModels(model.requestModels);
            requestValidatorId(model.requestValidatorId);
            authorizationScopes(model.authorizationScopes);
        }

        public final String getRestApiId() {
            return restApiId;
        }

        @Override
        public final Builder restApiId(String restApiId) {
            this.restApiId = restApiId;
            return this;
        }

        public final void setRestApiId(String restApiId) {
            this.restApiId = restApiId;
        }

        public final String getResourceId() {
            return resourceId;
        }

        @Override
        public final Builder resourceId(String resourceId) {
            this.resourceId = resourceId;
            return this;
        }

        public final void setResourceId(String resourceId) {
            this.resourceId = resourceId;
        }

        public final String getHttpMethod() {
            return httpMethod;
        }

        @Override
        public final Builder httpMethod(String httpMethod) {
            this.httpMethod = httpMethod;
            return this;
        }

        public final void setHttpMethod(String httpMethod) {
            this.httpMethod = httpMethod;
        }

        public final String getAuthorizationType() {
            return authorizationType;
        }

        @Override
        public final Builder authorizationType(String authorizationType) {
            this.authorizationType = authorizationType;
            return this;
        }

        public final void setAuthorizationType(String authorizationType) {
            this.authorizationType = authorizationType;
        }

        public final String getAuthorizerId() {
            return authorizerId;
        }

        @Override
        public final Builder authorizerId(String authorizerId) {
            this.authorizerId = authorizerId;
            return this;
        }

        public final void setAuthorizerId(String authorizerId) {
            this.authorizerId = authorizerId;
        }

        public final Boolean getApiKeyRequired() {
            return apiKeyRequired;
        }

        @Override
        public final Builder apiKeyRequired(Boolean apiKeyRequired) {
            this.apiKeyRequired = apiKeyRequired;
            return this;
        }

        public final void setApiKeyRequired(Boolean apiKeyRequired) {
            this.apiKeyRequired = apiKeyRequired;
        }

        public final String getOperationName() {
            return operationName;
        }

        @Override
        public final Builder operationName(String operationName) {
            this.operationName = operationName;
            return this;
        }

        public final void setOperationName(String operationName) {
            this.operationName = operationName;
        }

        public final Map<String, Boolean> getRequestParameters() {
            return requestParameters;
        }

        @Override
        public final Builder requestParameters(Map<String, Boolean> requestParameters) {
            this.requestParameters = MapOfStringToBooleanCopier.copy(requestParameters);
            return this;
        }

        public final void setRequestParameters(Map<String, Boolean> requestParameters) {
            this.requestParameters = MapOfStringToBooleanCopier.copy(requestParameters);
        }

        public final Map<String, String> getRequestModels() {
            return requestModels;
        }

        @Override
        public final Builder requestModels(Map<String, String> requestModels) {
            this.requestModels = MapOfStringToStringCopier.copy(requestModels);
            return this;
        }

        public final void setRequestModels(Map<String, String> requestModels) {
            this.requestModels = MapOfStringToStringCopier.copy(requestModels);
        }

        public final String getRequestValidatorId() {
            return requestValidatorId;
        }

        @Override
        public final Builder requestValidatorId(String requestValidatorId) {
            this.requestValidatorId = requestValidatorId;
            return this;
        }

        public final void setRequestValidatorId(String requestValidatorId) {
            this.requestValidatorId = requestValidatorId;
        }

        public final Collection<String> getAuthorizationScopes() {
            return authorizationScopes;
        }

        @Override
        public final Builder authorizationScopes(Collection<String> authorizationScopes) {
            this.authorizationScopes = ListOfStringCopier.copy(authorizationScopes);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder authorizationScopes(String... authorizationScopes) {
            authorizationScopes(Arrays.asList(authorizationScopes));
            return this;
        }

        public final void setAuthorizationScopes(Collection<String> authorizationScopes) {
            this.authorizationScopes = ListOfStringCopier.copy(authorizationScopes);
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public PutMethodRequest build() {
            return new PutMethodRequest(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
