/*
 * Copyright 2014-2019 Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.apigateway.model;

import java.time.Instant;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * Represents a client certificate used to configure client-side SSL authentication while sending requests to the
 * integration endpoint.
 * </p>
 * <div class="remarks">Client certificates are used to authenticate an API by the backend server. To authenticate an
 * API client (or user), use IAM roles and policies, a custom <a>Authorizer</a> or an Amazon Cognito user pool.</div>
 * <div class="seeAlso"> <a href=
 * "https://docs.aws.amazon.com/apigateway/latest/developerguide/getting-started-client-side-ssl-authentication.html"
 * >Use Client-Side Certificate</a> </div>
 */
@Generated("software.amazon.awssdk:codegen")
public final class UpdateClientCertificateResponse extends ApiGatewayResponse implements
        ToCopyableBuilder<UpdateClientCertificateResponse.Builder, UpdateClientCertificateResponse> {
    private static final SdkField<String> CLIENT_CERTIFICATE_ID_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .getter(getter(UpdateClientCertificateResponse::clientCertificateId)).setter(setter(Builder::clientCertificateId))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("clientCertificateId").build())
            .build();

    private static final SdkField<String> DESCRIPTION_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .getter(getter(UpdateClientCertificateResponse::description)).setter(setter(Builder::description))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("description").build()).build();

    private static final SdkField<String> PEM_ENCODED_CERTIFICATE_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .getter(getter(UpdateClientCertificateResponse::pemEncodedCertificate))
            .setter(setter(Builder::pemEncodedCertificate))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("pemEncodedCertificate").build())
            .build();

    private static final SdkField<Instant> CREATED_DATE_FIELD = SdkField.<Instant> builder(MarshallingType.INSTANT)
            .getter(getter(UpdateClientCertificateResponse::createdDate)).setter(setter(Builder::createdDate))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("createdDate").build()).build();

    private static final SdkField<Instant> EXPIRATION_DATE_FIELD = SdkField.<Instant> builder(MarshallingType.INSTANT)
            .getter(getter(UpdateClientCertificateResponse::expirationDate)).setter(setter(Builder::expirationDate))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("expirationDate").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(CLIENT_CERTIFICATE_ID_FIELD,
            DESCRIPTION_FIELD, PEM_ENCODED_CERTIFICATE_FIELD, CREATED_DATE_FIELD, EXPIRATION_DATE_FIELD));

    private final String clientCertificateId;

    private final String description;

    private final String pemEncodedCertificate;

    private final Instant createdDate;

    private final Instant expirationDate;

    private UpdateClientCertificateResponse(BuilderImpl builder) {
        super(builder);
        this.clientCertificateId = builder.clientCertificateId;
        this.description = builder.description;
        this.pemEncodedCertificate = builder.pemEncodedCertificate;
        this.createdDate = builder.createdDate;
        this.expirationDate = builder.expirationDate;
    }

    /**
     * <p>
     * The identifier of the client certificate.
     * </p>
     * 
     * @return The identifier of the client certificate.
     */
    public String clientCertificateId() {
        return clientCertificateId;
    }

    /**
     * <p>
     * The description of the client certificate.
     * </p>
     * 
     * @return The description of the client certificate.
     */
    public String description() {
        return description;
    }

    /**
     * <p>
     * The PEM-encoded public key of the client certificate, which can be used to configure certificate authentication
     * in the integration endpoint .
     * </p>
     * 
     * @return The PEM-encoded public key of the client certificate, which can be used to configure certificate
     *         authentication in the integration endpoint .
     */
    public String pemEncodedCertificate() {
        return pemEncodedCertificate;
    }

    /**
     * <p>
     * The timestamp when the client certificate was created.
     * </p>
     * 
     * @return The timestamp when the client certificate was created.
     */
    public Instant createdDate() {
        return createdDate;
    }

    /**
     * <p>
     * The timestamp when the client certificate will expire.
     * </p>
     * 
     * @return The timestamp when the client certificate will expire.
     */
    public Instant expirationDate() {
        return expirationDate;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(clientCertificateId());
        hashCode = 31 * hashCode + Objects.hashCode(description());
        hashCode = 31 * hashCode + Objects.hashCode(pemEncodedCertificate());
        hashCode = 31 * hashCode + Objects.hashCode(createdDate());
        hashCode = 31 * hashCode + Objects.hashCode(expirationDate());
        return hashCode;
    }

    @Override
    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof UpdateClientCertificateResponse)) {
            return false;
        }
        UpdateClientCertificateResponse other = (UpdateClientCertificateResponse) obj;
        return Objects.equals(clientCertificateId(), other.clientCertificateId())
                && Objects.equals(description(), other.description())
                && Objects.equals(pemEncodedCertificate(), other.pemEncodedCertificate())
                && Objects.equals(createdDate(), other.createdDate()) && Objects.equals(expirationDate(), other.expirationDate());
    }

    @Override
    public String toString() {
        return ToString.builder("UpdateClientCertificateResponse").add("ClientCertificateId", clientCertificateId())
                .add("Description", description()).add("PemEncodedCertificate", pemEncodedCertificate())
                .add("CreatedDate", createdDate()).add("ExpirationDate", expirationDate()).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "clientCertificateId":
            return Optional.ofNullable(clazz.cast(clientCertificateId()));
        case "description":
            return Optional.ofNullable(clazz.cast(description()));
        case "pemEncodedCertificate":
            return Optional.ofNullable(clazz.cast(pemEncodedCertificate()));
        case "createdDate":
            return Optional.ofNullable(clazz.cast(createdDate()));
        case "expirationDate":
            return Optional.ofNullable(clazz.cast(expirationDate()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<UpdateClientCertificateResponse, T> g) {
        return obj -> g.apply((UpdateClientCertificateResponse) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends ApiGatewayResponse.Builder, SdkPojo,
            CopyableBuilder<Builder, UpdateClientCertificateResponse> {
        /**
         * <p>
         * The identifier of the client certificate.
         * </p>
         * 
         * @param clientCertificateId
         *        The identifier of the client certificate.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder clientCertificateId(String clientCertificateId);

        /**
         * <p>
         * The description of the client certificate.
         * </p>
         * 
         * @param description
         *        The description of the client certificate.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder description(String description);

        /**
         * <p>
         * The PEM-encoded public key of the client certificate, which can be used to configure certificate
         * authentication in the integration endpoint .
         * </p>
         * 
         * @param pemEncodedCertificate
         *        The PEM-encoded public key of the client certificate, which can be used to configure certificate
         *        authentication in the integration endpoint .
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder pemEncodedCertificate(String pemEncodedCertificate);

        /**
         * <p>
         * The timestamp when the client certificate was created.
         * </p>
         * 
         * @param createdDate
         *        The timestamp when the client certificate was created.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder createdDate(Instant createdDate);

        /**
         * <p>
         * The timestamp when the client certificate will expire.
         * </p>
         * 
         * @param expirationDate
         *        The timestamp when the client certificate will expire.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder expirationDate(Instant expirationDate);
    }

    static final class BuilderImpl extends ApiGatewayResponse.BuilderImpl implements Builder {
        private String clientCertificateId;

        private String description;

        private String pemEncodedCertificate;

        private Instant createdDate;

        private Instant expirationDate;

        private BuilderImpl() {
        }

        private BuilderImpl(UpdateClientCertificateResponse model) {
            super(model);
            clientCertificateId(model.clientCertificateId);
            description(model.description);
            pemEncodedCertificate(model.pemEncodedCertificate);
            createdDate(model.createdDate);
            expirationDate(model.expirationDate);
        }

        public final String getClientCertificateId() {
            return clientCertificateId;
        }

        @Override
        public final Builder clientCertificateId(String clientCertificateId) {
            this.clientCertificateId = clientCertificateId;
            return this;
        }

        public final void setClientCertificateId(String clientCertificateId) {
            this.clientCertificateId = clientCertificateId;
        }

        public final String getDescription() {
            return description;
        }

        @Override
        public final Builder description(String description) {
            this.description = description;
            return this;
        }

        public final void setDescription(String description) {
            this.description = description;
        }

        public final String getPemEncodedCertificate() {
            return pemEncodedCertificate;
        }

        @Override
        public final Builder pemEncodedCertificate(String pemEncodedCertificate) {
            this.pemEncodedCertificate = pemEncodedCertificate;
            return this;
        }

        public final void setPemEncodedCertificate(String pemEncodedCertificate) {
            this.pemEncodedCertificate = pemEncodedCertificate;
        }

        public final Instant getCreatedDate() {
            return createdDate;
        }

        @Override
        public final Builder createdDate(Instant createdDate) {
            this.createdDate = createdDate;
            return this;
        }

        public final void setCreatedDate(Instant createdDate) {
            this.createdDate = createdDate;
        }

        public final Instant getExpirationDate() {
            return expirationDate;
        }

        @Override
        public final Builder expirationDate(Instant expirationDate) {
            this.expirationDate = expirationDate;
            return this;
        }

        public final void setExpirationDate(Instant expirationDate) {
            this.expirationDate = expirationDate;
        }

        @Override
        public UpdateClientCertificateResponse build() {
            return new UpdateClientCertificateResponse(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
