/*
 * Copyright 2014-2019 Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.apigateway.model;

import java.nio.ByteBuffer;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkBytes;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.adapter.StandardMemberCopier;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.PayloadTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * The binary blob response to <a>GetExport</a>, which contains the generated SDK.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class GetExportResponse extends ApiGatewayResponse implements
        ToCopyableBuilder<GetExportResponse.Builder, GetExportResponse> {
    private static final SdkField<String> CONTENT_TYPE_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .getter(getter(GetExportResponse::contentType)).setter(setter(Builder::contentType))
            .traits(LocationTrait.builder().location(MarshallLocation.HEADER).locationName("Content-Type").build()).build();

    private static final SdkField<String> CONTENT_DISPOSITION_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .getter(getter(GetExportResponse::contentDisposition)).setter(setter(Builder::contentDisposition))
            .traits(LocationTrait.builder().location(MarshallLocation.HEADER).locationName("Content-Disposition").build())
            .build();

    private static final SdkField<SdkBytes> BODY_FIELD = SdkField
            .<SdkBytes> builder(MarshallingType.SDK_BYTES)
            .getter(getter(GetExportResponse::body))
            .setter(setter(Builder::body))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("body").build(),
                    PayloadTrait.create()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(CONTENT_TYPE_FIELD,
            CONTENT_DISPOSITION_FIELD, BODY_FIELD));

    private final String contentType;

    private final String contentDisposition;

    private final SdkBytes body;

    private GetExportResponse(BuilderImpl builder) {
        super(builder);
        this.contentType = builder.contentType;
        this.contentDisposition = builder.contentDisposition;
        this.body = builder.body;
    }

    /**
     * <p>
     * The content-type header value in the HTTP response. This will correspond to a valid 'accept' type in the request.
     * </p>
     * 
     * @return The content-type header value in the HTTP response. This will correspond to a valid 'accept' type in the
     *         request.
     */
    public String contentType() {
        return contentType;
    }

    /**
     * <p>
     * The content-disposition header value in the HTTP response.
     * </p>
     * 
     * @return The content-disposition header value in the HTTP response.
     */
    public String contentDisposition() {
        return contentDisposition;
    }

    /**
     * <p>
     * The binary blob response to <a>GetExport</a>, which contains the export.
     * </p>
     * 
     * @return The binary blob response to <a>GetExport</a>, which contains the export.
     */
    public SdkBytes body() {
        return body;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(contentType());
        hashCode = 31 * hashCode + Objects.hashCode(contentDisposition());
        hashCode = 31 * hashCode + Objects.hashCode(body());
        return hashCode;
    }

    @Override
    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof GetExportResponse)) {
            return false;
        }
        GetExportResponse other = (GetExportResponse) obj;
        return Objects.equals(contentType(), other.contentType())
                && Objects.equals(contentDisposition(), other.contentDisposition()) && Objects.equals(body(), other.body());
    }

    @Override
    public String toString() {
        return ToString.builder("GetExportResponse").add("ContentType", contentType())
                .add("ContentDisposition", contentDisposition()).add("Body", body()).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "contentType":
            return Optional.ofNullable(clazz.cast(contentType()));
        case "contentDisposition":
            return Optional.ofNullable(clazz.cast(contentDisposition()));
        case "body":
            return Optional.ofNullable(clazz.cast(body()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<GetExportResponse, T> g) {
        return obj -> g.apply((GetExportResponse) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends ApiGatewayResponse.Builder, SdkPojo, CopyableBuilder<Builder, GetExportResponse> {
        /**
         * <p>
         * The content-type header value in the HTTP response. This will correspond to a valid 'accept' type in the
         * request.
         * </p>
         * 
         * @param contentType
         *        The content-type header value in the HTTP response. This will correspond to a valid 'accept' type in
         *        the request.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder contentType(String contentType);

        /**
         * <p>
         * The content-disposition header value in the HTTP response.
         * </p>
         * 
         * @param contentDisposition
         *        The content-disposition header value in the HTTP response.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder contentDisposition(String contentDisposition);

        /**
         * <p>
         * The binary blob response to <a>GetExport</a>, which contains the export.
         * </p>
         * 
         * @param body
         *        The binary blob response to <a>GetExport</a>, which contains the export.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder body(SdkBytes body);
    }

    static final class BuilderImpl extends ApiGatewayResponse.BuilderImpl implements Builder {
        private String contentType;

        private String contentDisposition;

        private SdkBytes body;

        private BuilderImpl() {
        }

        private BuilderImpl(GetExportResponse model) {
            super(model);
            contentType(model.contentType);
            contentDisposition(model.contentDisposition);
            body(model.body);
        }

        public final String getContentType() {
            return contentType;
        }

        @Override
        public final Builder contentType(String contentType) {
            this.contentType = contentType;
            return this;
        }

        public final void setContentType(String contentType) {
            this.contentType = contentType;
        }

        public final String getContentDisposition() {
            return contentDisposition;
        }

        @Override
        public final Builder contentDisposition(String contentDisposition) {
            this.contentDisposition = contentDisposition;
            return this;
        }

        public final void setContentDisposition(String contentDisposition) {
            this.contentDisposition = contentDisposition;
        }

        public final ByteBuffer getBody() {
            return body == null ? null : body.asByteBuffer();
        }

        @Override
        public final Builder body(SdkBytes body) {
            this.body = StandardMemberCopier.copy(body);
            return this;
        }

        public final void setBody(ByteBuffer body) {
            body(body == null ? null : SdkBytes.fromByteBuffer(body));
        }

        @Override
        public GetExportResponse build() {
            return new GetExportResponse(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
