/*
 * Copyright 2014-2019 Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.apigateway.model;

import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * The DELETE request to delete a usage plan of a given plan Id.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class DeleteUsagePlanRequest extends ApiGatewayRequest implements
        ToCopyableBuilder<DeleteUsagePlanRequest.Builder, DeleteUsagePlanRequest> {
    private static final SdkField<String> USAGE_PLAN_ID_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .getter(getter(DeleteUsagePlanRequest::usagePlanId)).setter(setter(Builder::usagePlanId))
            .traits(LocationTrait.builder().location(MarshallLocation.PATH).locationName("usageplanId").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(USAGE_PLAN_ID_FIELD));

    private final String usagePlanId;

    private DeleteUsagePlanRequest(BuilderImpl builder) {
        super(builder);
        this.usagePlanId = builder.usagePlanId;
    }

    /**
     * <p>
     * [Required] The Id of the to-be-deleted usage plan.
     * </p>
     * 
     * @return [Required] The Id of the to-be-deleted usage plan.
     */
    public String usagePlanId() {
        return usagePlanId;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(usagePlanId());
        return hashCode;
    }

    @Override
    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof DeleteUsagePlanRequest)) {
            return false;
        }
        DeleteUsagePlanRequest other = (DeleteUsagePlanRequest) obj;
        return Objects.equals(usagePlanId(), other.usagePlanId());
    }

    @Override
    public String toString() {
        return ToString.builder("DeleteUsagePlanRequest").add("UsagePlanId", usagePlanId()).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "usagePlanId":
            return Optional.ofNullable(clazz.cast(usagePlanId()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<DeleteUsagePlanRequest, T> g) {
        return obj -> g.apply((DeleteUsagePlanRequest) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends ApiGatewayRequest.Builder, SdkPojo, CopyableBuilder<Builder, DeleteUsagePlanRequest> {
        /**
         * <p>
         * [Required] The Id of the to-be-deleted usage plan.
         * </p>
         * 
         * @param usagePlanId
         *        [Required] The Id of the to-be-deleted usage plan.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder usagePlanId(String usagePlanId);

        @Override
        Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration);

        @Override
        Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer);
    }

    static final class BuilderImpl extends ApiGatewayRequest.BuilderImpl implements Builder {
        private String usagePlanId;

        private BuilderImpl() {
        }

        private BuilderImpl(DeleteUsagePlanRequest model) {
            super(model);
            usagePlanId(model.usagePlanId);
        }

        public final String getUsagePlanId() {
            return usagePlanId;
        }

        @Override
        public final Builder usagePlanId(String usagePlanId) {
            this.usagePlanId = usagePlanId;
            return this;
        }

        public final void setUsagePlanId(String usagePlanId) {
            this.usagePlanId = usagePlanId;
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public DeleteUsagePlanRequest build() {
            return new DeleteUsagePlanRequest(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
