/*
 * Copyright 2014-2019 Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.apigateway.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.MapTrait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructMap;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * Represents the response of the test invoke request in the HTTP method.
 * </p>
 * <div class="seeAlso"> <a href=
 * "https://docs.aws.amazon.com/apigateway/latest/developerguide/how-to-test-method.html#how-to-test-method-console"
 * >Test API using the API Gateway console</a> </div>
 */
@Generated("software.amazon.awssdk:codegen")
public final class TestInvokeMethodResponse extends ApiGatewayResponse implements
        ToCopyableBuilder<TestInvokeMethodResponse.Builder, TestInvokeMethodResponse> {
    private static final SdkField<Integer> STATUS_FIELD = SdkField.<Integer> builder(MarshallingType.INTEGER)
            .getter(getter(TestInvokeMethodResponse::status)).setter(setter(Builder::status))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("status").build()).build();

    private static final SdkField<String> BODY_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .getter(getter(TestInvokeMethodResponse::body)).setter(setter(Builder::body))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("body").build()).build();

    private static final SdkField<Map<String, String>> HEADERS_FIELD = SdkField
            .<Map<String, String>> builder(MarshallingType.MAP)
            .getter(getter(TestInvokeMethodResponse::headers))
            .setter(setter(Builder::headers))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("headers").build(),
                    MapTrait.builder()
                            .keyLocationName("key")
                            .valueLocationName("value")
                            .valueFieldInfo(
                                    SdkField.<String> builder(MarshallingType.STRING)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("value").build()).build()).build()).build();

    private static final SdkField<Map<String, List<String>>> MULTI_VALUE_HEADERS_FIELD = SdkField
            .<Map<String, List<String>>> builder(MarshallingType.MAP)
            .getter(getter(TestInvokeMethodResponse::multiValueHeaders))
            .setter(setter(Builder::multiValueHeaders))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("multiValueHeaders").build(),
                    MapTrait.builder()
                            .keyLocationName("key")
                            .valueLocationName("value")
                            .valueFieldInfo(
                                    SdkField.<List<String>> builder(MarshallingType.LIST)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("value").build(),
                                                    ListTrait
                                                            .builder()
                                                            .memberLocationName(null)
                                                            .memberFieldInfo(
                                                                    SdkField.<String> builder(MarshallingType.STRING)
                                                                            .traits(LocationTrait.builder()
                                                                                    .location(MarshallLocation.PAYLOAD)
                                                                                    .locationName("member").build()).build())
                                                            .build()).build()).build()).build();

    private static final SdkField<String> LOG_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .getter(getter(TestInvokeMethodResponse::log)).setter(setter(Builder::log))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("log").build()).build();

    private static final SdkField<Long> LATENCY_FIELD = SdkField.<Long> builder(MarshallingType.LONG)
            .getter(getter(TestInvokeMethodResponse::latency)).setter(setter(Builder::latency))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("latency").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(STATUS_FIELD, BODY_FIELD,
            HEADERS_FIELD, MULTI_VALUE_HEADERS_FIELD, LOG_FIELD, LATENCY_FIELD));

    private final Integer status;

    private final String body;

    private final Map<String, String> headers;

    private final Map<String, List<String>> multiValueHeaders;

    private final String log;

    private final Long latency;

    private TestInvokeMethodResponse(BuilderImpl builder) {
        super(builder);
        this.status = builder.status;
        this.body = builder.body;
        this.headers = builder.headers;
        this.multiValueHeaders = builder.multiValueHeaders;
        this.log = builder.log;
        this.latency = builder.latency;
    }

    /**
     * <p>
     * The HTTP status code.
     * </p>
     * 
     * @return The HTTP status code.
     */
    public Integer status() {
        return status;
    }

    /**
     * <p>
     * The body of the HTTP response.
     * </p>
     * 
     * @return The body of the HTTP response.
     */
    public String body() {
        return body;
    }

    /**
     * <p>
     * The headers of the HTTP response.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * 
     * @return The headers of the HTTP response.
     */
    public Map<String, String> headers() {
        return headers;
    }

    /**
     * <p>
     * The headers of the HTTP response as a map from string to list of values.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * 
     * @return The headers of the HTTP response as a map from string to list of values.
     */
    public Map<String, List<String>> multiValueHeaders() {
        return multiValueHeaders;
    }

    /**
     * <p>
     * The API Gateway execution log for the test invoke request.
     * </p>
     * 
     * @return The API Gateway execution log for the test invoke request.
     */
    public String log() {
        return log;
    }

    /**
     * <p>
     * The execution latency of the test invoke request.
     * </p>
     * 
     * @return The execution latency of the test invoke request.
     */
    public Long latency() {
        return latency;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(status());
        hashCode = 31 * hashCode + Objects.hashCode(body());
        hashCode = 31 * hashCode + Objects.hashCode(headers());
        hashCode = 31 * hashCode + Objects.hashCode(multiValueHeaders());
        hashCode = 31 * hashCode + Objects.hashCode(log());
        hashCode = 31 * hashCode + Objects.hashCode(latency());
        return hashCode;
    }

    @Override
    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof TestInvokeMethodResponse)) {
            return false;
        }
        TestInvokeMethodResponse other = (TestInvokeMethodResponse) obj;
        return Objects.equals(status(), other.status()) && Objects.equals(body(), other.body())
                && Objects.equals(headers(), other.headers()) && Objects.equals(multiValueHeaders(), other.multiValueHeaders())
                && Objects.equals(log(), other.log()) && Objects.equals(latency(), other.latency());
    }

    @Override
    public String toString() {
        return ToString.builder("TestInvokeMethodResponse").add("Status", status()).add("Body", body()).add("Headers", headers())
                .add("MultiValueHeaders", multiValueHeaders()).add("Log", log()).add("Latency", latency()).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "status":
            return Optional.ofNullable(clazz.cast(status()));
        case "body":
            return Optional.ofNullable(clazz.cast(body()));
        case "headers":
            return Optional.ofNullable(clazz.cast(headers()));
        case "multiValueHeaders":
            return Optional.ofNullable(clazz.cast(multiValueHeaders()));
        case "log":
            return Optional.ofNullable(clazz.cast(log()));
        case "latency":
            return Optional.ofNullable(clazz.cast(latency()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<TestInvokeMethodResponse, T> g) {
        return obj -> g.apply((TestInvokeMethodResponse) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends ApiGatewayResponse.Builder, SdkPojo, CopyableBuilder<Builder, TestInvokeMethodResponse> {
        /**
         * <p>
         * The HTTP status code.
         * </p>
         * 
         * @param status
         *        The HTTP status code.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder status(Integer status);

        /**
         * <p>
         * The body of the HTTP response.
         * </p>
         * 
         * @param body
         *        The body of the HTTP response.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder body(String body);

        /**
         * <p>
         * The headers of the HTTP response.
         * </p>
         * 
         * @param headers
         *        The headers of the HTTP response.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder headers(Map<String, String> headers);

        /**
         * <p>
         * The headers of the HTTP response as a map from string to list of values.
         * </p>
         * 
         * @param multiValueHeaders
         *        The headers of the HTTP response as a map from string to list of values.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder multiValueHeaders(Map<String, ? extends Collection<String>> multiValueHeaders);

        /**
         * <p>
         * The API Gateway execution log for the test invoke request.
         * </p>
         * 
         * @param log
         *        The API Gateway execution log for the test invoke request.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder log(String log);

        /**
         * <p>
         * The execution latency of the test invoke request.
         * </p>
         * 
         * @param latency
         *        The execution latency of the test invoke request.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder latency(Long latency);
    }

    static final class BuilderImpl extends ApiGatewayResponse.BuilderImpl implements Builder {
        private Integer status;

        private String body;

        private Map<String, String> headers = DefaultSdkAutoConstructMap.getInstance();

        private Map<String, List<String>> multiValueHeaders = DefaultSdkAutoConstructMap.getInstance();

        private String log;

        private Long latency;

        private BuilderImpl() {
        }

        private BuilderImpl(TestInvokeMethodResponse model) {
            super(model);
            status(model.status);
            body(model.body);
            headers(model.headers);
            multiValueHeaders(model.multiValueHeaders);
            log(model.log);
            latency(model.latency);
        }

        public final Integer getStatus() {
            return status;
        }

        @Override
        public final Builder status(Integer status) {
            this.status = status;
            return this;
        }

        public final void setStatus(Integer status) {
            this.status = status;
        }

        public final String getBody() {
            return body;
        }

        @Override
        public final Builder body(String body) {
            this.body = body;
            return this;
        }

        public final void setBody(String body) {
            this.body = body;
        }

        public final Map<String, String> getHeaders() {
            return headers;
        }

        @Override
        public final Builder headers(Map<String, String> headers) {
            this.headers = MapOfStringToStringCopier.copy(headers);
            return this;
        }

        public final void setHeaders(Map<String, String> headers) {
            this.headers = MapOfStringToStringCopier.copy(headers);
        }

        public final Map<String, ? extends Collection<String>> getMultiValueHeaders() {
            return multiValueHeaders;
        }

        @Override
        public final Builder multiValueHeaders(Map<String, ? extends Collection<String>> multiValueHeaders) {
            this.multiValueHeaders = MapOfStringToListCopier.copy(multiValueHeaders);
            return this;
        }

        public final void setMultiValueHeaders(Map<String, ? extends Collection<String>> multiValueHeaders) {
            this.multiValueHeaders = MapOfStringToListCopier.copy(multiValueHeaders);
        }

        public final String getLog() {
            return log;
        }

        @Override
        public final Builder log(String log) {
            this.log = log;
            return this;
        }

        public final void setLog(String log) {
            this.log = log;
        }

        public final Long getLatency() {
            return latency;
        }

        @Override
        public final Builder latency(Long latency) {
            this.latency = latency;
            return this;
        }

        public final void setLatency(Long latency) {
            this.latency = latency;
        }

        @Override
        public TestInvokeMethodResponse build() {
            return new TestInvokeMethodResponse(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
