/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.apigateway.model;

import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * Gets the documentation parts of an API. The result may be filtered by the type, name, or path of API entities
 * (targets).
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class GetDocumentationPartsRequest extends ApiGatewayRequest implements
        ToCopyableBuilder<GetDocumentationPartsRequest.Builder, GetDocumentationPartsRequest> {
    private static final SdkField<String> REST_API_ID_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("restApiId").getter(getter(GetDocumentationPartsRequest::restApiId)).setter(setter(Builder::restApiId))
            .traits(LocationTrait.builder().location(MarshallLocation.PATH).locationName("restapi_id").build()).build();

    private static final SdkField<String> TYPE_FIELD = SdkField.<String> builder(MarshallingType.STRING).memberName("type")
            .getter(getter(GetDocumentationPartsRequest::typeAsString)).setter(setter(Builder::type))
            .traits(LocationTrait.builder().location(MarshallLocation.QUERY_PARAM).locationName("type").build()).build();

    private static final SdkField<String> NAME_QUERY_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("nameQuery").getter(getter(GetDocumentationPartsRequest::nameQuery)).setter(setter(Builder::nameQuery))
            .traits(LocationTrait.builder().location(MarshallLocation.QUERY_PARAM).locationName("name").build()).build();

    private static final SdkField<String> PATH_FIELD = SdkField.<String> builder(MarshallingType.STRING).memberName("path")
            .getter(getter(GetDocumentationPartsRequest::path)).setter(setter(Builder::path))
            .traits(LocationTrait.builder().location(MarshallLocation.QUERY_PARAM).locationName("path").build()).build();

    private static final SdkField<String> POSITION_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("position").getter(getter(GetDocumentationPartsRequest::position)).setter(setter(Builder::position))
            .traits(LocationTrait.builder().location(MarshallLocation.QUERY_PARAM).locationName("position").build()).build();

    private static final SdkField<Integer> LIMIT_FIELD = SdkField.<Integer> builder(MarshallingType.INTEGER).memberName("limit")
            .getter(getter(GetDocumentationPartsRequest::limit)).setter(setter(Builder::limit))
            .traits(LocationTrait.builder().location(MarshallLocation.QUERY_PARAM).locationName("limit").build()).build();

    private static final SdkField<String> LOCATION_STATUS_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("locationStatus").getter(getter(GetDocumentationPartsRequest::locationStatusAsString))
            .setter(setter(Builder::locationStatus))
            .traits(LocationTrait.builder().location(MarshallLocation.QUERY_PARAM).locationName("locationStatus").build())
            .build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(REST_API_ID_FIELD, TYPE_FIELD,
            NAME_QUERY_FIELD, PATH_FIELD, POSITION_FIELD, LIMIT_FIELD, LOCATION_STATUS_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = memberNameToFieldInitializer();

    private final String restApiId;

    private final String type;

    private final String nameQuery;

    private final String path;

    private final String position;

    private final Integer limit;

    private final String locationStatus;

    private GetDocumentationPartsRequest(BuilderImpl builder) {
        super(builder);
        this.restApiId = builder.restApiId;
        this.type = builder.type;
        this.nameQuery = builder.nameQuery;
        this.path = builder.path;
        this.position = builder.position;
        this.limit = builder.limit;
        this.locationStatus = builder.locationStatus;
    }

    /**
     * <p>
     * The string identifier of the associated RestApi.
     * </p>
     * 
     * @return The string identifier of the associated RestApi.
     */
    public final String restApiId() {
        return restApiId;
    }

    /**
     * <p>
     * The type of API entities of the to-be-retrieved documentation parts.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #type} will return
     * {@link DocumentationPartType#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #typeAsString}.
     * </p>
     * 
     * @return The type of API entities of the to-be-retrieved documentation parts.
     * @see DocumentationPartType
     */
    public final DocumentationPartType type() {
        return DocumentationPartType.fromValue(type);
    }

    /**
     * <p>
     * The type of API entities of the to-be-retrieved documentation parts.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #type} will return
     * {@link DocumentationPartType#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #typeAsString}.
     * </p>
     * 
     * @return The type of API entities of the to-be-retrieved documentation parts.
     * @see DocumentationPartType
     */
    public final String typeAsString() {
        return type;
    }

    /**
     * <p>
     * The name of API entities of the to-be-retrieved documentation parts.
     * </p>
     * 
     * @return The name of API entities of the to-be-retrieved documentation parts.
     */
    public final String nameQuery() {
        return nameQuery;
    }

    /**
     * <p>
     * The path of API entities of the to-be-retrieved documentation parts.
     * </p>
     * 
     * @return The path of API entities of the to-be-retrieved documentation parts.
     */
    public final String path() {
        return path;
    }

    /**
     * <p>
     * The current pagination position in the paged result set.
     * </p>
     * 
     * @return The current pagination position in the paged result set.
     */
    public final String position() {
        return position;
    }

    /**
     * <p>
     * The maximum number of returned results per page. The default value is 25 and the maximum value is 500.
     * </p>
     * 
     * @return The maximum number of returned results per page. The default value is 25 and the maximum value is 500.
     */
    public final Integer limit() {
        return limit;
    }

    /**
     * <p>
     * The status of the API documentation parts to retrieve. Valid values are <code>DOCUMENTED</code> for retrieving
     * DocumentationPart resources with content and <code>UNDOCUMENTED</code> for DocumentationPart resources without
     * content.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #locationStatus}
     * will return {@link LocationStatusType#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available
     * from {@link #locationStatusAsString}.
     * </p>
     * 
     * @return The status of the API documentation parts to retrieve. Valid values are <code>DOCUMENTED</code> for
     *         retrieving DocumentationPart resources with content and <code>UNDOCUMENTED</code> for DocumentationPart
     *         resources without content.
     * @see LocationStatusType
     */
    public final LocationStatusType locationStatus() {
        return LocationStatusType.fromValue(locationStatus);
    }

    /**
     * <p>
     * The status of the API documentation parts to retrieve. Valid values are <code>DOCUMENTED</code> for retrieving
     * DocumentationPart resources with content and <code>UNDOCUMENTED</code> for DocumentationPart resources without
     * content.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #locationStatus}
     * will return {@link LocationStatusType#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available
     * from {@link #locationStatusAsString}.
     * </p>
     * 
     * @return The status of the API documentation parts to retrieve. Valid values are <code>DOCUMENTED</code> for
     *         retrieving DocumentationPart resources with content and <code>UNDOCUMENTED</code> for DocumentationPart
     *         resources without content.
     * @see LocationStatusType
     */
    public final String locationStatusAsString() {
        return locationStatus;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(restApiId());
        hashCode = 31 * hashCode + Objects.hashCode(typeAsString());
        hashCode = 31 * hashCode + Objects.hashCode(nameQuery());
        hashCode = 31 * hashCode + Objects.hashCode(path());
        hashCode = 31 * hashCode + Objects.hashCode(position());
        hashCode = 31 * hashCode + Objects.hashCode(limit());
        hashCode = 31 * hashCode + Objects.hashCode(locationStatusAsString());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof GetDocumentationPartsRequest)) {
            return false;
        }
        GetDocumentationPartsRequest other = (GetDocumentationPartsRequest) obj;
        return Objects.equals(restApiId(), other.restApiId()) && Objects.equals(typeAsString(), other.typeAsString())
                && Objects.equals(nameQuery(), other.nameQuery()) && Objects.equals(path(), other.path())
                && Objects.equals(position(), other.position()) && Objects.equals(limit(), other.limit())
                && Objects.equals(locationStatusAsString(), other.locationStatusAsString());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("GetDocumentationPartsRequest").add("RestApiId", restApiId()).add("Type", typeAsString())
                .add("NameQuery", nameQuery()).add("Path", path()).add("Position", position()).add("Limit", limit())
                .add("LocationStatus", locationStatusAsString()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "restApiId":
            return Optional.ofNullable(clazz.cast(restApiId()));
        case "type":
            return Optional.ofNullable(clazz.cast(typeAsString()));
        case "nameQuery":
            return Optional.ofNullable(clazz.cast(nameQuery()));
        case "path":
            return Optional.ofNullable(clazz.cast(path()));
        case "position":
            return Optional.ofNullable(clazz.cast(position()));
        case "limit":
            return Optional.ofNullable(clazz.cast(limit()));
        case "locationStatus":
            return Optional.ofNullable(clazz.cast(locationStatusAsString()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        Map<String, SdkField<?>> map = new HashMap<>();
        map.put("restapi_id", REST_API_ID_FIELD);
        map.put("type", TYPE_FIELD);
        map.put("name", NAME_QUERY_FIELD);
        map.put("path", PATH_FIELD);
        map.put("position", POSITION_FIELD);
        map.put("limit", LIMIT_FIELD);
        map.put("locationStatus", LOCATION_STATUS_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<GetDocumentationPartsRequest, T> g) {
        return obj -> g.apply((GetDocumentationPartsRequest) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends ApiGatewayRequest.Builder, SdkPojo, CopyableBuilder<Builder, GetDocumentationPartsRequest> {
        /**
         * <p>
         * The string identifier of the associated RestApi.
         * </p>
         * 
         * @param restApiId
         *        The string identifier of the associated RestApi.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder restApiId(String restApiId);

        /**
         * <p>
         * The type of API entities of the to-be-retrieved documentation parts.
         * </p>
         * 
         * @param type
         *        The type of API entities of the to-be-retrieved documentation parts.
         * @see DocumentationPartType
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see DocumentationPartType
         */
        Builder type(String type);

        /**
         * <p>
         * The type of API entities of the to-be-retrieved documentation parts.
         * </p>
         * 
         * @param type
         *        The type of API entities of the to-be-retrieved documentation parts.
         * @see DocumentationPartType
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see DocumentationPartType
         */
        Builder type(DocumentationPartType type);

        /**
         * <p>
         * The name of API entities of the to-be-retrieved documentation parts.
         * </p>
         * 
         * @param nameQuery
         *        The name of API entities of the to-be-retrieved documentation parts.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder nameQuery(String nameQuery);

        /**
         * <p>
         * The path of API entities of the to-be-retrieved documentation parts.
         * </p>
         * 
         * @param path
         *        The path of API entities of the to-be-retrieved documentation parts.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder path(String path);

        /**
         * <p>
         * The current pagination position in the paged result set.
         * </p>
         * 
         * @param position
         *        The current pagination position in the paged result set.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder position(String position);

        /**
         * <p>
         * The maximum number of returned results per page. The default value is 25 and the maximum value is 500.
         * </p>
         * 
         * @param limit
         *        The maximum number of returned results per page. The default value is 25 and the maximum value is 500.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder limit(Integer limit);

        /**
         * <p>
         * The status of the API documentation parts to retrieve. Valid values are <code>DOCUMENTED</code> for
         * retrieving DocumentationPart resources with content and <code>UNDOCUMENTED</code> for DocumentationPart
         * resources without content.
         * </p>
         * 
         * @param locationStatus
         *        The status of the API documentation parts to retrieve. Valid values are <code>DOCUMENTED</code> for
         *        retrieving DocumentationPart resources with content and <code>UNDOCUMENTED</code> for
         *        DocumentationPart resources without content.
         * @see LocationStatusType
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see LocationStatusType
         */
        Builder locationStatus(String locationStatus);

        /**
         * <p>
         * The status of the API documentation parts to retrieve. Valid values are <code>DOCUMENTED</code> for
         * retrieving DocumentationPart resources with content and <code>UNDOCUMENTED</code> for DocumentationPart
         * resources without content.
         * </p>
         * 
         * @param locationStatus
         *        The status of the API documentation parts to retrieve. Valid values are <code>DOCUMENTED</code> for
         *        retrieving DocumentationPart resources with content and <code>UNDOCUMENTED</code> for
         *        DocumentationPart resources without content.
         * @see LocationStatusType
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see LocationStatusType
         */
        Builder locationStatus(LocationStatusType locationStatus);

        @Override
        Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration);

        @Override
        Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer);
    }

    static final class BuilderImpl extends ApiGatewayRequest.BuilderImpl implements Builder {
        private String restApiId;

        private String type;

        private String nameQuery;

        private String path;

        private String position;

        private Integer limit;

        private String locationStatus;

        private BuilderImpl() {
        }

        private BuilderImpl(GetDocumentationPartsRequest model) {
            super(model);
            restApiId(model.restApiId);
            type(model.type);
            nameQuery(model.nameQuery);
            path(model.path);
            position(model.position);
            limit(model.limit);
            locationStatus(model.locationStatus);
        }

        public final String getRestApiId() {
            return restApiId;
        }

        public final void setRestApiId(String restApiId) {
            this.restApiId = restApiId;
        }

        @Override
        public final Builder restApiId(String restApiId) {
            this.restApiId = restApiId;
            return this;
        }

        public final String getType() {
            return type;
        }

        public final void setType(String type) {
            this.type = type;
        }

        @Override
        public final Builder type(String type) {
            this.type = type;
            return this;
        }

        @Override
        public final Builder type(DocumentationPartType type) {
            this.type(type == null ? null : type.toString());
            return this;
        }

        public final String getNameQuery() {
            return nameQuery;
        }

        public final void setNameQuery(String nameQuery) {
            this.nameQuery = nameQuery;
        }

        @Override
        public final Builder nameQuery(String nameQuery) {
            this.nameQuery = nameQuery;
            return this;
        }

        public final String getPath() {
            return path;
        }

        public final void setPath(String path) {
            this.path = path;
        }

        @Override
        public final Builder path(String path) {
            this.path = path;
            return this;
        }

        public final String getPosition() {
            return position;
        }

        public final void setPosition(String position) {
            this.position = position;
        }

        @Override
        public final Builder position(String position) {
            this.position = position;
            return this;
        }

        public final Integer getLimit() {
            return limit;
        }

        public final void setLimit(Integer limit) {
            this.limit = limit;
        }

        @Override
        public final Builder limit(Integer limit) {
            this.limit = limit;
            return this;
        }

        public final String getLocationStatus() {
            return locationStatus;
        }

        public final void setLocationStatus(String locationStatus) {
            this.locationStatus = locationStatus;
        }

        @Override
        public final Builder locationStatus(String locationStatus) {
            this.locationStatus = locationStatus;
            return this;
        }

        @Override
        public final Builder locationStatus(LocationStatusType locationStatus) {
            this.locationStatus(locationStatus == null ? null : locationStatus.toString());
            return this;
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public GetDocumentationPartsRequest build() {
            return new GetDocumentationPartsRequest(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }
}
