/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.apigateway.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.MapTrait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructMap;
import software.amazon.awssdk.core.util.SdkAutoConstructMap;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * Represents the response of the test invoke request in the HTTP method.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class TestInvokeMethodResponse extends ApiGatewayResponse implements
        ToCopyableBuilder<TestInvokeMethodResponse.Builder, TestInvokeMethodResponse> {
    private static final SdkField<Integer> STATUS_FIELD = SdkField.<Integer> builder(MarshallingType.INTEGER)
            .memberName("status").getter(getter(TestInvokeMethodResponse::status)).setter(setter(Builder::status))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("status").build()).build();

    private static final SdkField<String> BODY_FIELD = SdkField.<String> builder(MarshallingType.STRING).memberName("body")
            .getter(getter(TestInvokeMethodResponse::body)).setter(setter(Builder::body))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("body").build()).build();

    private static final SdkField<Map<String, String>> HEADERS_FIELD = SdkField
            .<Map<String, String>> builder(MarshallingType.MAP)
            .memberName("headers")
            .getter(getter(TestInvokeMethodResponse::headers))
            .setter(setter(Builder::headers))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("headers").build(),
                    MapTrait.builder()
                            .keyLocationName("key")
                            .valueLocationName("value")
                            .valueFieldInfo(
                                    SdkField.<String> builder(MarshallingType.STRING)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("value").build()).build()).build()).build();

    private static final SdkField<Map<String, List<String>>> MULTI_VALUE_HEADERS_FIELD = SdkField
            .<Map<String, List<String>>> builder(MarshallingType.MAP)
            .memberName("multiValueHeaders")
            .getter(getter(TestInvokeMethodResponse::multiValueHeaders))
            .setter(setter(Builder::multiValueHeaders))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("multiValueHeaders").build(),
                    MapTrait.builder()
                            .keyLocationName("key")
                            .valueLocationName("value")
                            .valueFieldInfo(
                                    SdkField.<List<String>> builder(MarshallingType.LIST)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("value").build(),
                                                    ListTrait
                                                            .builder()
                                                            .memberLocationName(null)
                                                            .memberFieldInfo(
                                                                    SdkField.<String> builder(MarshallingType.STRING)
                                                                            .traits(LocationTrait.builder()
                                                                                    .location(MarshallLocation.PAYLOAD)
                                                                                    .locationName("member").build()).build())
                                                            .build()).build()).build()).build();

    private static final SdkField<String> LOG_FIELD = SdkField.<String> builder(MarshallingType.STRING).memberName("log")
            .getter(getter(TestInvokeMethodResponse::log)).setter(setter(Builder::log))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("log").build()).build();

    private static final SdkField<Long> LATENCY_FIELD = SdkField.<Long> builder(MarshallingType.LONG).memberName("latency")
            .getter(getter(TestInvokeMethodResponse::latency)).setter(setter(Builder::latency))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("latency").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(STATUS_FIELD, BODY_FIELD,
            HEADERS_FIELD, MULTI_VALUE_HEADERS_FIELD, LOG_FIELD, LATENCY_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = memberNameToFieldInitializer();

    private final Integer status;

    private final String body;

    private final Map<String, String> headers;

    private final Map<String, List<String>> multiValueHeaders;

    private final String log;

    private final Long latency;

    private TestInvokeMethodResponse(BuilderImpl builder) {
        super(builder);
        this.status = builder.status;
        this.body = builder.body;
        this.headers = builder.headers;
        this.multiValueHeaders = builder.multiValueHeaders;
        this.log = builder.log;
        this.latency = builder.latency;
    }

    /**
     * <p>
     * The HTTP status code.
     * </p>
     * 
     * @return The HTTP status code.
     */
    public final Integer status() {
        return status;
    }

    /**
     * <p>
     * The body of the HTTP response.
     * </p>
     * 
     * @return The body of the HTTP response.
     */
    public final String body() {
        return body;
    }

    /**
     * For responses, this returns true if the service returned a value for the Headers property. This DOES NOT check
     * that the value is non-empty (for which, you should check the {@code isEmpty()} method on the property). This is
     * useful because the SDK will never return a null collection or map, but you may need to differentiate between the
     * service returning nothing (or null) and the service returning an empty collection or map. For requests, this
     * returns true if a value for the property was specified in the request builder, and false if a value was not
     * specified.
     */
    public final boolean hasHeaders() {
        return headers != null && !(headers instanceof SdkAutoConstructMap);
    }

    /**
     * <p>
     * The headers of the HTTP response.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasHeaders} method.
     * </p>
     * 
     * @return The headers of the HTTP response.
     */
    public final Map<String, String> headers() {
        return headers;
    }

    /**
     * For responses, this returns true if the service returned a value for the MultiValueHeaders property. This DOES
     * NOT check that the value is non-empty (for which, you should check the {@code isEmpty()} method on the property).
     * This is useful because the SDK will never return a null collection or map, but you may need to differentiate
     * between the service returning nothing (or null) and the service returning an empty collection or map. For
     * requests, this returns true if a value for the property was specified in the request builder, and false if a
     * value was not specified.
     */
    public final boolean hasMultiValueHeaders() {
        return multiValueHeaders != null && !(multiValueHeaders instanceof SdkAutoConstructMap);
    }

    /**
     * <p>
     * The headers of the HTTP response as a map from string to list of values.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasMultiValueHeaders} method.
     * </p>
     * 
     * @return The headers of the HTTP response as a map from string to list of values.
     */
    public final Map<String, List<String>> multiValueHeaders() {
        return multiValueHeaders;
    }

    /**
     * <p>
     * The API Gateway execution log for the test invoke request.
     * </p>
     * 
     * @return The API Gateway execution log for the test invoke request.
     */
    public final String log() {
        return log;
    }

    /**
     * <p>
     * The execution latency, in ms, of the test invoke request.
     * </p>
     * 
     * @return The execution latency, in ms, of the test invoke request.
     */
    public final Long latency() {
        return latency;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(status());
        hashCode = 31 * hashCode + Objects.hashCode(body());
        hashCode = 31 * hashCode + Objects.hashCode(hasHeaders() ? headers() : null);
        hashCode = 31 * hashCode + Objects.hashCode(hasMultiValueHeaders() ? multiValueHeaders() : null);
        hashCode = 31 * hashCode + Objects.hashCode(log());
        hashCode = 31 * hashCode + Objects.hashCode(latency());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof TestInvokeMethodResponse)) {
            return false;
        }
        TestInvokeMethodResponse other = (TestInvokeMethodResponse) obj;
        return Objects.equals(status(), other.status()) && Objects.equals(body(), other.body())
                && hasHeaders() == other.hasHeaders() && Objects.equals(headers(), other.headers())
                && hasMultiValueHeaders() == other.hasMultiValueHeaders()
                && Objects.equals(multiValueHeaders(), other.multiValueHeaders()) && Objects.equals(log(), other.log())
                && Objects.equals(latency(), other.latency());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("TestInvokeMethodResponse").add("Status", status()).add("Body", body())
                .add("Headers", hasHeaders() ? headers() : null)
                .add("MultiValueHeaders", hasMultiValueHeaders() ? multiValueHeaders() : null).add("Log", log())
                .add("Latency", latency()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "status":
            return Optional.ofNullable(clazz.cast(status()));
        case "body":
            return Optional.ofNullable(clazz.cast(body()));
        case "headers":
            return Optional.ofNullable(clazz.cast(headers()));
        case "multiValueHeaders":
            return Optional.ofNullable(clazz.cast(multiValueHeaders()));
        case "log":
            return Optional.ofNullable(clazz.cast(log()));
        case "latency":
            return Optional.ofNullable(clazz.cast(latency()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        Map<String, SdkField<?>> map = new HashMap<>();
        map.put("status", STATUS_FIELD);
        map.put("body", BODY_FIELD);
        map.put("headers", HEADERS_FIELD);
        map.put("multiValueHeaders", MULTI_VALUE_HEADERS_FIELD);
        map.put("log", LOG_FIELD);
        map.put("latency", LATENCY_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<TestInvokeMethodResponse, T> g) {
        return obj -> g.apply((TestInvokeMethodResponse) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends ApiGatewayResponse.Builder, SdkPojo, CopyableBuilder<Builder, TestInvokeMethodResponse> {
        /**
         * <p>
         * The HTTP status code.
         * </p>
         * 
         * @param status
         *        The HTTP status code.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder status(Integer status);

        /**
         * <p>
         * The body of the HTTP response.
         * </p>
         * 
         * @param body
         *        The body of the HTTP response.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder body(String body);

        /**
         * <p>
         * The headers of the HTTP response.
         * </p>
         * 
         * @param headers
         *        The headers of the HTTP response.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder headers(Map<String, String> headers);

        /**
         * <p>
         * The headers of the HTTP response as a map from string to list of values.
         * </p>
         * 
         * @param multiValueHeaders
         *        The headers of the HTTP response as a map from string to list of values.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder multiValueHeaders(Map<String, ? extends Collection<String>> multiValueHeaders);

        /**
         * <p>
         * The API Gateway execution log for the test invoke request.
         * </p>
         * 
         * @param log
         *        The API Gateway execution log for the test invoke request.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder log(String log);

        /**
         * <p>
         * The execution latency, in ms, of the test invoke request.
         * </p>
         * 
         * @param latency
         *        The execution latency, in ms, of the test invoke request.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder latency(Long latency);
    }

    static final class BuilderImpl extends ApiGatewayResponse.BuilderImpl implements Builder {
        private Integer status;

        private String body;

        private Map<String, String> headers = DefaultSdkAutoConstructMap.getInstance();

        private Map<String, List<String>> multiValueHeaders = DefaultSdkAutoConstructMap.getInstance();

        private String log;

        private Long latency;

        private BuilderImpl() {
        }

        private BuilderImpl(TestInvokeMethodResponse model) {
            super(model);
            status(model.status);
            body(model.body);
            headers(model.headers);
            multiValueHeaders(model.multiValueHeaders);
            log(model.log);
            latency(model.latency);
        }

        public final Integer getStatus() {
            return status;
        }

        public final void setStatus(Integer status) {
            this.status = status;
        }

        @Override
        public final Builder status(Integer status) {
            this.status = status;
            return this;
        }

        public final String getBody() {
            return body;
        }

        public final void setBody(String body) {
            this.body = body;
        }

        @Override
        public final Builder body(String body) {
            this.body = body;
            return this;
        }

        public final Map<String, String> getHeaders() {
            if (headers instanceof SdkAutoConstructMap) {
                return null;
            }
            return headers;
        }

        public final void setHeaders(Map<String, String> headers) {
            this.headers = MapOfStringToStringCopier.copy(headers);
        }

        @Override
        public final Builder headers(Map<String, String> headers) {
            this.headers = MapOfStringToStringCopier.copy(headers);
            return this;
        }

        public final Map<String, ? extends Collection<String>> getMultiValueHeaders() {
            if (multiValueHeaders instanceof SdkAutoConstructMap) {
                return null;
            }
            return multiValueHeaders;
        }

        public final void setMultiValueHeaders(Map<String, ? extends Collection<String>> multiValueHeaders) {
            this.multiValueHeaders = MapOfStringToListCopier.copy(multiValueHeaders);
        }

        @Override
        public final Builder multiValueHeaders(Map<String, ? extends Collection<String>> multiValueHeaders) {
            this.multiValueHeaders = MapOfStringToListCopier.copy(multiValueHeaders);
            return this;
        }

        public final String getLog() {
            return log;
        }

        public final void setLog(String log) {
            this.log = log;
        }

        @Override
        public final Builder log(String log) {
            this.log = log;
            return this;
        }

        public final Long getLatency() {
            return latency;
        }

        public final void setLatency(Long latency) {
            this.latency = latency;
        }

        @Override
        public final Builder latency(Long latency) {
            this.latency = latency;
            return this;
        }

        @Override
        public TestInvokeMethodResponse build() {
            return new TestInvokeMethodResponse(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }
}
