/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.apigateway.model;

import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.MapTrait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructMap;
import software.amazon.awssdk.core.util.SdkAutoConstructMap;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * Represents a put integration response request.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class PutIntegrationResponseRequest extends ApiGatewayRequest implements
        ToCopyableBuilder<PutIntegrationResponseRequest.Builder, PutIntegrationResponseRequest> {
    private static final SdkField<String> REST_API_ID_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("restApiId").getter(getter(PutIntegrationResponseRequest::restApiId)).setter(setter(Builder::restApiId))
            .traits(LocationTrait.builder().location(MarshallLocation.PATH).locationName("restapi_id").build()).build();

    private static final SdkField<String> RESOURCE_ID_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("resourceId").getter(getter(PutIntegrationResponseRequest::resourceId))
            .setter(setter(Builder::resourceId))
            .traits(LocationTrait.builder().location(MarshallLocation.PATH).locationName("resource_id").build()).build();

    private static final SdkField<String> HTTP_METHOD_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("httpMethod").getter(getter(PutIntegrationResponseRequest::httpMethod))
            .setter(setter(Builder::httpMethod))
            .traits(LocationTrait.builder().location(MarshallLocation.PATH).locationName("http_method").build()).build();

    private static final SdkField<String> STATUS_CODE_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("statusCode").getter(getter(PutIntegrationResponseRequest::statusCode))
            .setter(setter(Builder::statusCode))
            .traits(LocationTrait.builder().location(MarshallLocation.PATH).locationName("status_code").build()).build();

    private static final SdkField<String> SELECTION_PATTERN_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("selectionPattern").getter(getter(PutIntegrationResponseRequest::selectionPattern))
            .setter(setter(Builder::selectionPattern))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("selectionPattern").build()).build();

    private static final SdkField<Map<String, String>> RESPONSE_PARAMETERS_FIELD = SdkField
            .<Map<String, String>> builder(MarshallingType.MAP)
            .memberName("responseParameters")
            .getter(getter(PutIntegrationResponseRequest::responseParameters))
            .setter(setter(Builder::responseParameters))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("responseParameters").build(),
                    MapTrait.builder()
                            .keyLocationName("key")
                            .valueLocationName("value")
                            .valueFieldInfo(
                                    SdkField.<String> builder(MarshallingType.STRING)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("value").build()).build()).build()).build();

    private static final SdkField<Map<String, String>> RESPONSE_TEMPLATES_FIELD = SdkField
            .<Map<String, String>> builder(MarshallingType.MAP)
            .memberName("responseTemplates")
            .getter(getter(PutIntegrationResponseRequest::responseTemplates))
            .setter(setter(Builder::responseTemplates))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("responseTemplates").build(),
                    MapTrait.builder()
                            .keyLocationName("key")
                            .valueLocationName("value")
                            .valueFieldInfo(
                                    SdkField.<String> builder(MarshallingType.STRING)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("value").build()).build()).build()).build();

    private static final SdkField<String> CONTENT_HANDLING_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("contentHandling").getter(getter(PutIntegrationResponseRequest::contentHandlingAsString))
            .setter(setter(Builder::contentHandling))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("contentHandling").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(REST_API_ID_FIELD,
            RESOURCE_ID_FIELD, HTTP_METHOD_FIELD, STATUS_CODE_FIELD, SELECTION_PATTERN_FIELD, RESPONSE_PARAMETERS_FIELD,
            RESPONSE_TEMPLATES_FIELD, CONTENT_HANDLING_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = memberNameToFieldInitializer();

    private final String restApiId;

    private final String resourceId;

    private final String httpMethod;

    private final String statusCodeValue;

    private final String selectionPattern;

    private final Map<String, String> responseParameters;

    private final Map<String, String> responseTemplates;

    private final String contentHandling;

    private PutIntegrationResponseRequest(BuilderImpl builder) {
        super(builder);
        this.restApiId = builder.restApiId;
        this.resourceId = builder.resourceId;
        this.httpMethod = builder.httpMethod;
        this.statusCodeValue = builder.statusCodeValue;
        this.selectionPattern = builder.selectionPattern;
        this.responseParameters = builder.responseParameters;
        this.responseTemplates = builder.responseTemplates;
        this.contentHandling = builder.contentHandling;
    }

    /**
     * <p>
     * The string identifier of the associated RestApi.
     * </p>
     * 
     * @return The string identifier of the associated RestApi.
     */
    public final String restApiId() {
        return restApiId;
    }

    /**
     * <p>
     * Specifies a put integration response request's resource identifier.
     * </p>
     * 
     * @return Specifies a put integration response request's resource identifier.
     */
    public final String resourceId() {
        return resourceId;
    }

    /**
     * <p>
     * Specifies a put integration response request's HTTP method.
     * </p>
     * 
     * @return Specifies a put integration response request's HTTP method.
     */
    public final String httpMethod() {
        return httpMethod;
    }

    /**
     * <p>
     * Specifies the status code that is used to map the integration response to an existing MethodResponse.
     * </p>
     * 
     * @return Specifies the status code that is used to map the integration response to an existing MethodResponse.
     */
    public final String statusCode() {
        return statusCodeValue;
    }

    /**
     * <p>
     * Specifies the selection pattern of a put integration response.
     * </p>
     * 
     * @return Specifies the selection pattern of a put integration response.
     */
    public final String selectionPattern() {
        return selectionPattern;
    }

    /**
     * For responses, this returns true if the service returned a value for the ResponseParameters property. This DOES
     * NOT check that the value is non-empty (for which, you should check the {@code isEmpty()} method on the property).
     * This is useful because the SDK will never return a null collection or map, but you may need to differentiate
     * between the service returning nothing (or null) and the service returning an empty collection or map. For
     * requests, this returns true if a value for the property was specified in the request builder, and false if a
     * value was not specified.
     */
    public final boolean hasResponseParameters() {
        return responseParameters != null && !(responseParameters instanceof SdkAutoConstructMap);
    }

    /**
     * <p>
     * A key-value map specifying response parameters that are passed to the method response from the back end. The key
     * is a method response header parameter name and the mapped value is an integration response header value, a static
     * value enclosed within a pair of single quotes, or a JSON expression from the integration response body. The
     * mapping key must match the pattern of <code>method.response.header.{name}</code>, where <code>name</code> is a
     * valid and unique header name. The mapped non-static value must match the pattern of
     * <code>integration.response.header.{name}</code> or <code>integration.response.body.{JSON-expression}</code>,
     * where <code>name</code> must be a valid and unique response header name and <code>JSON-expression</code> a valid
     * JSON expression without the <code>$</code> prefix.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasResponseParameters} method.
     * </p>
     * 
     * @return A key-value map specifying response parameters that are passed to the method response from the back end.
     *         The key is a method response header parameter name and the mapped value is an integration response header
     *         value, a static value enclosed within a pair of single quotes, or a JSON expression from the integration
     *         response body. The mapping key must match the pattern of <code>method.response.header.{name}</code>,
     *         where <code>name</code> is a valid and unique header name. The mapped non-static value must match the
     *         pattern of <code>integration.response.header.{name}</code> or
     *         <code>integration.response.body.{JSON-expression}</code>, where <code>name</code> must be a valid and
     *         unique response header name and <code>JSON-expression</code> a valid JSON expression without the
     *         <code>$</code> prefix.
     */
    public final Map<String, String> responseParameters() {
        return responseParameters;
    }

    /**
     * For responses, this returns true if the service returned a value for the ResponseTemplates property. This DOES
     * NOT check that the value is non-empty (for which, you should check the {@code isEmpty()} method on the property).
     * This is useful because the SDK will never return a null collection or map, but you may need to differentiate
     * between the service returning nothing (or null) and the service returning an empty collection or map. For
     * requests, this returns true if a value for the property was specified in the request builder, and false if a
     * value was not specified.
     */
    public final boolean hasResponseTemplates() {
        return responseTemplates != null && !(responseTemplates instanceof SdkAutoConstructMap);
    }

    /**
     * <p>
     * Specifies a put integration response's templates.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasResponseTemplates} method.
     * </p>
     * 
     * @return Specifies a put integration response's templates.
     */
    public final Map<String, String> responseTemplates() {
        return responseTemplates;
    }

    /**
     * <p>
     * Specifies how to handle response payload content type conversions. Supported values are
     * <code>CONVERT_TO_BINARY</code> and <code>CONVERT_TO_TEXT</code>, with the following behaviors:
     * </p>
     * <p>
     * If this property is not defined, the response payload will be passed through from the integration response to the
     * method response without modification.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #contentHandling}
     * will return {@link ContentHandlingStrategy#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is
     * available from {@link #contentHandlingAsString}.
     * </p>
     * 
     * @return Specifies how to handle response payload content type conversions. Supported values are
     *         <code>CONVERT_TO_BINARY</code> and <code>CONVERT_TO_TEXT</code>, with the following behaviors:</p>
     *         <p>
     *         If this property is not defined, the response payload will be passed through from the integration
     *         response to the method response without modification.
     * @see ContentHandlingStrategy
     */
    public final ContentHandlingStrategy contentHandling() {
        return ContentHandlingStrategy.fromValue(contentHandling);
    }

    /**
     * <p>
     * Specifies how to handle response payload content type conversions. Supported values are
     * <code>CONVERT_TO_BINARY</code> and <code>CONVERT_TO_TEXT</code>, with the following behaviors:
     * </p>
     * <p>
     * If this property is not defined, the response payload will be passed through from the integration response to the
     * method response without modification.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #contentHandling}
     * will return {@link ContentHandlingStrategy#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is
     * available from {@link #contentHandlingAsString}.
     * </p>
     * 
     * @return Specifies how to handle response payload content type conversions. Supported values are
     *         <code>CONVERT_TO_BINARY</code> and <code>CONVERT_TO_TEXT</code>, with the following behaviors:</p>
     *         <p>
     *         If this property is not defined, the response payload will be passed through from the integration
     *         response to the method response without modification.
     * @see ContentHandlingStrategy
     */
    public final String contentHandlingAsString() {
        return contentHandling;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(restApiId());
        hashCode = 31 * hashCode + Objects.hashCode(resourceId());
        hashCode = 31 * hashCode + Objects.hashCode(httpMethod());
        hashCode = 31 * hashCode + Objects.hashCode(statusCode());
        hashCode = 31 * hashCode + Objects.hashCode(selectionPattern());
        hashCode = 31 * hashCode + Objects.hashCode(hasResponseParameters() ? responseParameters() : null);
        hashCode = 31 * hashCode + Objects.hashCode(hasResponseTemplates() ? responseTemplates() : null);
        hashCode = 31 * hashCode + Objects.hashCode(contentHandlingAsString());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof PutIntegrationResponseRequest)) {
            return false;
        }
        PutIntegrationResponseRequest other = (PutIntegrationResponseRequest) obj;
        return Objects.equals(restApiId(), other.restApiId()) && Objects.equals(resourceId(), other.resourceId())
                && Objects.equals(httpMethod(), other.httpMethod()) && Objects.equals(statusCode(), other.statusCode())
                && Objects.equals(selectionPattern(), other.selectionPattern())
                && hasResponseParameters() == other.hasResponseParameters()
                && Objects.equals(responseParameters(), other.responseParameters())
                && hasResponseTemplates() == other.hasResponseTemplates()
                && Objects.equals(responseTemplates(), other.responseTemplates())
                && Objects.equals(contentHandlingAsString(), other.contentHandlingAsString());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("PutIntegrationResponseRequest").add("RestApiId", restApiId()).add("ResourceId", resourceId())
                .add("HttpMethod", httpMethod()).add("StatusCode", statusCode()).add("SelectionPattern", selectionPattern())
                .add("ResponseParameters", hasResponseParameters() ? responseParameters() : null)
                .add("ResponseTemplates", hasResponseTemplates() ? responseTemplates() : null)
                .add("ContentHandling", contentHandlingAsString()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "restApiId":
            return Optional.ofNullable(clazz.cast(restApiId()));
        case "resourceId":
            return Optional.ofNullable(clazz.cast(resourceId()));
        case "httpMethod":
            return Optional.ofNullable(clazz.cast(httpMethod()));
        case "statusCode":
            return Optional.ofNullable(clazz.cast(statusCode()));
        case "selectionPattern":
            return Optional.ofNullable(clazz.cast(selectionPattern()));
        case "responseParameters":
            return Optional.ofNullable(clazz.cast(responseParameters()));
        case "responseTemplates":
            return Optional.ofNullable(clazz.cast(responseTemplates()));
        case "contentHandling":
            return Optional.ofNullable(clazz.cast(contentHandlingAsString()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        Map<String, SdkField<?>> map = new HashMap<>();
        map.put("restapi_id", REST_API_ID_FIELD);
        map.put("resource_id", RESOURCE_ID_FIELD);
        map.put("http_method", HTTP_METHOD_FIELD);
        map.put("status_code", STATUS_CODE_FIELD);
        map.put("selectionPattern", SELECTION_PATTERN_FIELD);
        map.put("responseParameters", RESPONSE_PARAMETERS_FIELD);
        map.put("responseTemplates", RESPONSE_TEMPLATES_FIELD);
        map.put("contentHandling", CONTENT_HANDLING_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<PutIntegrationResponseRequest, T> g) {
        return obj -> g.apply((PutIntegrationResponseRequest) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends ApiGatewayRequest.Builder, SdkPojo, CopyableBuilder<Builder, PutIntegrationResponseRequest> {
        /**
         * <p>
         * The string identifier of the associated RestApi.
         * </p>
         * 
         * @param restApiId
         *        The string identifier of the associated RestApi.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder restApiId(String restApiId);

        /**
         * <p>
         * Specifies a put integration response request's resource identifier.
         * </p>
         * 
         * @param resourceId
         *        Specifies a put integration response request's resource identifier.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder resourceId(String resourceId);

        /**
         * <p>
         * Specifies a put integration response request's HTTP method.
         * </p>
         * 
         * @param httpMethod
         *        Specifies a put integration response request's HTTP method.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder httpMethod(String httpMethod);

        /**
         * <p>
         * Specifies the status code that is used to map the integration response to an existing MethodResponse.
         * </p>
         * 
         * @param statusCodeValue
         *        Specifies the status code that is used to map the integration response to an existing MethodResponse.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder statusCode(String statusCodeValue);

        /**
         * <p>
         * Specifies the selection pattern of a put integration response.
         * </p>
         * 
         * @param selectionPattern
         *        Specifies the selection pattern of a put integration response.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder selectionPattern(String selectionPattern);

        /**
         * <p>
         * A key-value map specifying response parameters that are passed to the method response from the back end. The
         * key is a method response header parameter name and the mapped value is an integration response header value,
         * a static value enclosed within a pair of single quotes, or a JSON expression from the integration response
         * body. The mapping key must match the pattern of <code>method.response.header.{name}</code>, where
         * <code>name</code> is a valid and unique header name. The mapped non-static value must match the pattern of
         * <code>integration.response.header.{name}</code> or <code>integration.response.body.{JSON-expression}</code>,
         * where <code>name</code> must be a valid and unique response header name and <code>JSON-expression</code> a
         * valid JSON expression without the <code>$</code> prefix.
         * </p>
         * 
         * @param responseParameters
         *        A key-value map specifying response parameters that are passed to the method response from the back
         *        end. The key is a method response header parameter name and the mapped value is an integration
         *        response header value, a static value enclosed within a pair of single quotes, or a JSON expression
         *        from the integration response body. The mapping key must match the pattern of
         *        <code>method.response.header.{name}</code>, where <code>name</code> is a valid and unique header name.
         *        The mapped non-static value must match the pattern of <code>integration.response.header.{name}</code>
         *        or <code>integration.response.body.{JSON-expression}</code>, where <code>name</code> must be a valid
         *        and unique response header name and <code>JSON-expression</code> a valid JSON expression without the
         *        <code>$</code> prefix.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder responseParameters(Map<String, String> responseParameters);

        /**
         * <p>
         * Specifies a put integration response's templates.
         * </p>
         * 
         * @param responseTemplates
         *        Specifies a put integration response's templates.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder responseTemplates(Map<String, String> responseTemplates);

        /**
         * <p>
         * Specifies how to handle response payload content type conversions. Supported values are
         * <code>CONVERT_TO_BINARY</code> and <code>CONVERT_TO_TEXT</code>, with the following behaviors:
         * </p>
         * <p>
         * If this property is not defined, the response payload will be passed through from the integration response to
         * the method response without modification.
         * </p>
         * 
         * @param contentHandling
         *        Specifies how to handle response payload content type conversions. Supported values are
         *        <code>CONVERT_TO_BINARY</code> and <code>CONVERT_TO_TEXT</code>, with the following behaviors:</p>
         *        <p>
         *        If this property is not defined, the response payload will be passed through from the integration
         *        response to the method response without modification.
         * @see ContentHandlingStrategy
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see ContentHandlingStrategy
         */
        Builder contentHandling(String contentHandling);

        /**
         * <p>
         * Specifies how to handle response payload content type conversions. Supported values are
         * <code>CONVERT_TO_BINARY</code> and <code>CONVERT_TO_TEXT</code>, with the following behaviors:
         * </p>
         * <p>
         * If this property is not defined, the response payload will be passed through from the integration response to
         * the method response without modification.
         * </p>
         * 
         * @param contentHandling
         *        Specifies how to handle response payload content type conversions. Supported values are
         *        <code>CONVERT_TO_BINARY</code> and <code>CONVERT_TO_TEXT</code>, with the following behaviors:</p>
         *        <p>
         *        If this property is not defined, the response payload will be passed through from the integration
         *        response to the method response without modification.
         * @see ContentHandlingStrategy
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see ContentHandlingStrategy
         */
        Builder contentHandling(ContentHandlingStrategy contentHandling);

        @Override
        Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration);

        @Override
        Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer);
    }

    static final class BuilderImpl extends ApiGatewayRequest.BuilderImpl implements Builder {
        private String restApiId;

        private String resourceId;

        private String httpMethod;

        private String statusCodeValue;

        private String selectionPattern;

        private Map<String, String> responseParameters = DefaultSdkAutoConstructMap.getInstance();

        private Map<String, String> responseTemplates = DefaultSdkAutoConstructMap.getInstance();

        private String contentHandling;

        private BuilderImpl() {
        }

        private BuilderImpl(PutIntegrationResponseRequest model) {
            super(model);
            restApiId(model.restApiId);
            resourceId(model.resourceId);
            httpMethod(model.httpMethod);
            statusCode(model.statusCodeValue);
            selectionPattern(model.selectionPattern);
            responseParameters(model.responseParameters);
            responseTemplates(model.responseTemplates);
            contentHandling(model.contentHandling);
        }

        public final String getRestApiId() {
            return restApiId;
        }

        public final void setRestApiId(String restApiId) {
            this.restApiId = restApiId;
        }

        @Override
        public final Builder restApiId(String restApiId) {
            this.restApiId = restApiId;
            return this;
        }

        public final String getResourceId() {
            return resourceId;
        }

        public final void setResourceId(String resourceId) {
            this.resourceId = resourceId;
        }

        @Override
        public final Builder resourceId(String resourceId) {
            this.resourceId = resourceId;
            return this;
        }

        public final String getHttpMethod() {
            return httpMethod;
        }

        public final void setHttpMethod(String httpMethod) {
            this.httpMethod = httpMethod;
        }

        @Override
        public final Builder httpMethod(String httpMethod) {
            this.httpMethod = httpMethod;
            return this;
        }

        public final String getStatusCode() {
            return statusCodeValue;
        }

        public final void setStatusCode(String statusCodeValue) {
            this.statusCodeValue = statusCodeValue;
        }

        @Override
        public final Builder statusCode(String statusCodeValue) {
            this.statusCodeValue = statusCodeValue;
            return this;
        }

        public final String getSelectionPattern() {
            return selectionPattern;
        }

        public final void setSelectionPattern(String selectionPattern) {
            this.selectionPattern = selectionPattern;
        }

        @Override
        public final Builder selectionPattern(String selectionPattern) {
            this.selectionPattern = selectionPattern;
            return this;
        }

        public final Map<String, String> getResponseParameters() {
            if (responseParameters instanceof SdkAutoConstructMap) {
                return null;
            }
            return responseParameters;
        }

        public final void setResponseParameters(Map<String, String> responseParameters) {
            this.responseParameters = MapOfStringToStringCopier.copy(responseParameters);
        }

        @Override
        public final Builder responseParameters(Map<String, String> responseParameters) {
            this.responseParameters = MapOfStringToStringCopier.copy(responseParameters);
            return this;
        }

        public final Map<String, String> getResponseTemplates() {
            if (responseTemplates instanceof SdkAutoConstructMap) {
                return null;
            }
            return responseTemplates;
        }

        public final void setResponseTemplates(Map<String, String> responseTemplates) {
            this.responseTemplates = MapOfStringToStringCopier.copy(responseTemplates);
        }

        @Override
        public final Builder responseTemplates(Map<String, String> responseTemplates) {
            this.responseTemplates = MapOfStringToStringCopier.copy(responseTemplates);
            return this;
        }

        public final String getContentHandling() {
            return contentHandling;
        }

        public final void setContentHandling(String contentHandling) {
            this.contentHandling = contentHandling;
        }

        @Override
        public final Builder contentHandling(String contentHandling) {
            this.contentHandling = contentHandling;
            return this;
        }

        @Override
        public final Builder contentHandling(ContentHandlingStrategy contentHandling) {
            this.contentHandling(contentHandling == null ? null : contentHandling.toString());
            return this;
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public PutIntegrationResponseRequest build() {
            return new PutIntegrationResponseRequest(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }
}
