/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.apigateway.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * Requests API Gateway to get information about a Deployment resource.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class GetDeploymentRequest extends ApiGatewayRequest implements
        ToCopyableBuilder<GetDeploymentRequest.Builder, GetDeploymentRequest> {
    private static final SdkField<String> REST_API_ID_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("restApiId").getter(getter(GetDeploymentRequest::restApiId)).setter(setter(Builder::restApiId))
            .traits(LocationTrait.builder().location(MarshallLocation.PATH).locationName("restapi_id").build()).build();

    private static final SdkField<String> DEPLOYMENT_ID_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("deploymentId").getter(getter(GetDeploymentRequest::deploymentId)).setter(setter(Builder::deploymentId))
            .traits(LocationTrait.builder().location(MarshallLocation.PATH).locationName("deployment_id").build()).build();

    private static final SdkField<List<String>> EMBED_FIELD = SdkField
            .<List<String>> builder(MarshallingType.LIST)
            .memberName("embed")
            .getter(getter(GetDeploymentRequest::embed))
            .setter(setter(Builder::embed))
            .traits(LocationTrait.builder().location(MarshallLocation.QUERY_PARAM).locationName("embed").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<String> builder(MarshallingType.STRING)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(REST_API_ID_FIELD,
            DEPLOYMENT_ID_FIELD, EMBED_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = memberNameToFieldInitializer();

    private final String restApiId;

    private final String deploymentId;

    private final List<String> embed;

    private GetDeploymentRequest(BuilderImpl builder) {
        super(builder);
        this.restApiId = builder.restApiId;
        this.deploymentId = builder.deploymentId;
        this.embed = builder.embed;
    }

    /**
     * <p>
     * The string identifier of the associated RestApi.
     * </p>
     * 
     * @return The string identifier of the associated RestApi.
     */
    public final String restApiId() {
        return restApiId;
    }

    /**
     * <p>
     * The identifier of the Deployment resource to get information about.
     * </p>
     * 
     * @return The identifier of the Deployment resource to get information about.
     */
    public final String deploymentId() {
        return deploymentId;
    }

    /**
     * For responses, this returns true if the service returned a value for the Embed property. This DOES NOT check that
     * the value is non-empty (for which, you should check the {@code isEmpty()} method on the property). This is useful
     * because the SDK will never return a null collection or map, but you may need to differentiate between the service
     * returning nothing (or null) and the service returning an empty collection or map. For requests, this returns true
     * if a value for the property was specified in the request builder, and false if a value was not specified.
     */
    public final boolean hasEmbed() {
        return embed != null && !(embed instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * A query parameter to retrieve the specified embedded resources of the returned Deployment resource in the
     * response. In a REST API call, this <code>embed</code> parameter value is a list of comma-separated strings, as in
     * <code>GET /restapis/{restapi_id}/deployments/{deployment_id}?embed=var1,var2</code>. The SDK and other
     * platform-dependent libraries might use a different format for the list. Currently, this request supports only
     * retrieval of the embedded API summary this way. Hence, the parameter value must be a single-valued list
     * containing only the <code>"apisummary"</code> string. For example,
     * <code>GET /restapis/{restapi_id}/deployments/{deployment_id}?embed=apisummary</code>.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasEmbed} method.
     * </p>
     * 
     * @return A query parameter to retrieve the specified embedded resources of the returned Deployment resource in the
     *         response. In a REST API call, this <code>embed</code> parameter value is a list of comma-separated
     *         strings, as in <code>GET /restapis/{restapi_id}/deployments/{deployment_id}?embed=var1,var2</code>. The
     *         SDK and other platform-dependent libraries might use a different format for the list. Currently, this
     *         request supports only retrieval of the embedded API summary this way. Hence, the parameter value must be
     *         a single-valued list containing only the <code>"apisummary"</code> string. For example,
     *         <code>GET /restapis/{restapi_id}/deployments/{deployment_id}?embed=apisummary</code>.
     */
    public final List<String> embed() {
        return embed;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(restApiId());
        hashCode = 31 * hashCode + Objects.hashCode(deploymentId());
        hashCode = 31 * hashCode + Objects.hashCode(hasEmbed() ? embed() : null);
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof GetDeploymentRequest)) {
            return false;
        }
        GetDeploymentRequest other = (GetDeploymentRequest) obj;
        return Objects.equals(restApiId(), other.restApiId()) && Objects.equals(deploymentId(), other.deploymentId())
                && hasEmbed() == other.hasEmbed() && Objects.equals(embed(), other.embed());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("GetDeploymentRequest").add("RestApiId", restApiId()).add("DeploymentId", deploymentId())
                .add("Embed", hasEmbed() ? embed() : null).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "restApiId":
            return Optional.ofNullable(clazz.cast(restApiId()));
        case "deploymentId":
            return Optional.ofNullable(clazz.cast(deploymentId()));
        case "embed":
            return Optional.ofNullable(clazz.cast(embed()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        Map<String, SdkField<?>> map = new HashMap<>();
        map.put("restapi_id", REST_API_ID_FIELD);
        map.put("deployment_id", DEPLOYMENT_ID_FIELD);
        map.put("embed", EMBED_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<GetDeploymentRequest, T> g) {
        return obj -> g.apply((GetDeploymentRequest) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends ApiGatewayRequest.Builder, SdkPojo, CopyableBuilder<Builder, GetDeploymentRequest> {
        /**
         * <p>
         * The string identifier of the associated RestApi.
         * </p>
         * 
         * @param restApiId
         *        The string identifier of the associated RestApi.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder restApiId(String restApiId);

        /**
         * <p>
         * The identifier of the Deployment resource to get information about.
         * </p>
         * 
         * @param deploymentId
         *        The identifier of the Deployment resource to get information about.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder deploymentId(String deploymentId);

        /**
         * <p>
         * A query parameter to retrieve the specified embedded resources of the returned Deployment resource in the
         * response. In a REST API call, this <code>embed</code> parameter value is a list of comma-separated strings,
         * as in <code>GET /restapis/{restapi_id}/deployments/{deployment_id}?embed=var1,var2</code>. The SDK and other
         * platform-dependent libraries might use a different format for the list. Currently, this request supports only
         * retrieval of the embedded API summary this way. Hence, the parameter value must be a single-valued list
         * containing only the <code>"apisummary"</code> string. For example,
         * <code>GET /restapis/{restapi_id}/deployments/{deployment_id}?embed=apisummary</code>.
         * </p>
         * 
         * @param embed
         *        A query parameter to retrieve the specified embedded resources of the returned Deployment resource in
         *        the response. In a REST API call, this <code>embed</code> parameter value is a list of comma-separated
         *        strings, as in <code>GET /restapis/{restapi_id}/deployments/{deployment_id}?embed=var1,var2</code>.
         *        The SDK and other platform-dependent libraries might use a different format for the list. Currently,
         *        this request supports only retrieval of the embedded API summary this way. Hence, the parameter value
         *        must be a single-valued list containing only the <code>"apisummary"</code> string. For example,
         *        <code>GET /restapis/{restapi_id}/deployments/{deployment_id}?embed=apisummary</code>.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder embed(Collection<String> embed);

        /**
         * <p>
         * A query parameter to retrieve the specified embedded resources of the returned Deployment resource in the
         * response. In a REST API call, this <code>embed</code> parameter value is a list of comma-separated strings,
         * as in <code>GET /restapis/{restapi_id}/deployments/{deployment_id}?embed=var1,var2</code>. The SDK and other
         * platform-dependent libraries might use a different format for the list. Currently, this request supports only
         * retrieval of the embedded API summary this way. Hence, the parameter value must be a single-valued list
         * containing only the <code>"apisummary"</code> string. For example,
         * <code>GET /restapis/{restapi_id}/deployments/{deployment_id}?embed=apisummary</code>.
         * </p>
         * 
         * @param embed
         *        A query parameter to retrieve the specified embedded resources of the returned Deployment resource in
         *        the response. In a REST API call, this <code>embed</code> parameter value is a list of comma-separated
         *        strings, as in <code>GET /restapis/{restapi_id}/deployments/{deployment_id}?embed=var1,var2</code>.
         *        The SDK and other platform-dependent libraries might use a different format for the list. Currently,
         *        this request supports only retrieval of the embedded API summary this way. Hence, the parameter value
         *        must be a single-valued list containing only the <code>"apisummary"</code> string. For example,
         *        <code>GET /restapis/{restapi_id}/deployments/{deployment_id}?embed=apisummary</code>.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder embed(String... embed);

        @Override
        Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration);

        @Override
        Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer);
    }

    static final class BuilderImpl extends ApiGatewayRequest.BuilderImpl implements Builder {
        private String restApiId;

        private String deploymentId;

        private List<String> embed = DefaultSdkAutoConstructList.getInstance();

        private BuilderImpl() {
        }

        private BuilderImpl(GetDeploymentRequest model) {
            super(model);
            restApiId(model.restApiId);
            deploymentId(model.deploymentId);
            embed(model.embed);
        }

        public final String getRestApiId() {
            return restApiId;
        }

        public final void setRestApiId(String restApiId) {
            this.restApiId = restApiId;
        }

        @Override
        public final Builder restApiId(String restApiId) {
            this.restApiId = restApiId;
            return this;
        }

        public final String getDeploymentId() {
            return deploymentId;
        }

        public final void setDeploymentId(String deploymentId) {
            this.deploymentId = deploymentId;
        }

        @Override
        public final Builder deploymentId(String deploymentId) {
            this.deploymentId = deploymentId;
            return this;
        }

        public final Collection<String> getEmbed() {
            if (embed instanceof SdkAutoConstructList) {
                return null;
            }
            return embed;
        }

        public final void setEmbed(Collection<String> embed) {
            this.embed = ListOfStringCopier.copy(embed);
        }

        @Override
        public final Builder embed(Collection<String> embed) {
            this.embed = ListOfStringCopier.copy(embed);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder embed(String... embed) {
            embed(Arrays.asList(embed));
            return this;
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public GetDeploymentRequest build() {
            return new GetDeploymentRequest(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }
}
