/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.apigateway.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.MapTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructMap;
import software.amazon.awssdk.core.util.SdkAutoConstructMap;
import software.amazon.awssdk.services.apigateway.model.ApiGatewayRequest;
import software.amazon.awssdk.services.apigateway.model.MapOfStringToListCopier;
import software.amazon.awssdk.services.apigateway.model.MapOfStringToStringCopier;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class TestInvokeMethodRequest
extends ApiGatewayRequest
implements ToCopyableBuilder<Builder, TestInvokeMethodRequest> {
    private static final SdkField<String> REST_API_ID_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("restApiId").getter(TestInvokeMethodRequest.getter(TestInvokeMethodRequest::restApiId)).setter(TestInvokeMethodRequest.setter(Builder::restApiId)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PATH).locationName("restapi_id").build()}).build();
    private static final SdkField<String> RESOURCE_ID_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("resourceId").getter(TestInvokeMethodRequest.getter(TestInvokeMethodRequest::resourceId)).setter(TestInvokeMethodRequest.setter(Builder::resourceId)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PATH).locationName("resource_id").build()}).build();
    private static final SdkField<String> HTTP_METHOD_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("httpMethod").getter(TestInvokeMethodRequest.getter(TestInvokeMethodRequest::httpMethod)).setter(TestInvokeMethodRequest.setter(Builder::httpMethod)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PATH).locationName("http_method").build()}).build();
    private static final SdkField<String> PATH_WITH_QUERY_STRING_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("pathWithQueryString").getter(TestInvokeMethodRequest.getter(TestInvokeMethodRequest::pathWithQueryString)).setter(TestInvokeMethodRequest.setter(Builder::pathWithQueryString)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("pathWithQueryString").build()}).build();
    private static final SdkField<String> BODY_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("body").getter(TestInvokeMethodRequest.getter(TestInvokeMethodRequest::body)).setter(TestInvokeMethodRequest.setter(Builder::body)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("body").build()}).build();
    private static final SdkField<Map<String, String>> HEADERS_FIELD = SdkField.builder((MarshallingType)MarshallingType.MAP).memberName("headers").getter(TestInvokeMethodRequest.getter(TestInvokeMethodRequest::headers)).setter(TestInvokeMethodRequest.setter(Builder::headers)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("headers").build(), MapTrait.builder().keyLocationName("key").valueLocationName("value").valueFieldInfo(SdkField.builder((MarshallingType)MarshallingType.STRING).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("value").build()}).build()).build()}).build();
    private static final SdkField<Map<String, List<String>>> MULTI_VALUE_HEADERS_FIELD = SdkField.builder((MarshallingType)MarshallingType.MAP).memberName("multiValueHeaders").getter(TestInvokeMethodRequest.getter(TestInvokeMethodRequest::multiValueHeaders)).setter(TestInvokeMethodRequest.setter(Builder::multiValueHeaders)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("multiValueHeaders").build(), MapTrait.builder().keyLocationName("key").valueLocationName("value").valueFieldInfo(SdkField.builder((MarshallingType)MarshallingType.LIST).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("value").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.STRING).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build()).build()}).build();
    private static final SdkField<String> CLIENT_CERTIFICATE_ID_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("clientCertificateId").getter(TestInvokeMethodRequest.getter(TestInvokeMethodRequest::clientCertificateId)).setter(TestInvokeMethodRequest.setter(Builder::clientCertificateId)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("clientCertificateId").build()}).build();
    private static final SdkField<Map<String, String>> STAGE_VARIABLES_FIELD = SdkField.builder((MarshallingType)MarshallingType.MAP).memberName("stageVariables").getter(TestInvokeMethodRequest.getter(TestInvokeMethodRequest::stageVariables)).setter(TestInvokeMethodRequest.setter(Builder::stageVariables)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("stageVariables").build(), MapTrait.builder().keyLocationName("key").valueLocationName("value").valueFieldInfo(SdkField.builder((MarshallingType)MarshallingType.STRING).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("value").build()}).build()).build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(REST_API_ID_FIELD, RESOURCE_ID_FIELD, HTTP_METHOD_FIELD, PATH_WITH_QUERY_STRING_FIELD, BODY_FIELD, HEADERS_FIELD, MULTI_VALUE_HEADERS_FIELD, CLIENT_CERTIFICATE_ID_FIELD, STAGE_VARIABLES_FIELD));
    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = TestInvokeMethodRequest.memberNameToFieldInitializer();
    private final String restApiId;
    private final String resourceId;
    private final String httpMethod;
    private final String pathWithQueryString;
    private final String body;
    private final Map<String, String> headers;
    private final Map<String, List<String>> multiValueHeaders;
    private final String clientCertificateId;
    private final Map<String, String> stageVariables;

    private TestInvokeMethodRequest(BuilderImpl builder) {
        super(builder);
        this.restApiId = builder.restApiId;
        this.resourceId = builder.resourceId;
        this.httpMethod = builder.httpMethod;
        this.pathWithQueryString = builder.pathWithQueryString;
        this.body = builder.body;
        this.headers = builder.headers;
        this.multiValueHeaders = builder.multiValueHeaders;
        this.clientCertificateId = builder.clientCertificateId;
        this.stageVariables = builder.stageVariables;
    }

    public final String restApiId() {
        return this.restApiId;
    }

    public final String resourceId() {
        return this.resourceId;
    }

    public final String httpMethod() {
        return this.httpMethod;
    }

    public final String pathWithQueryString() {
        return this.pathWithQueryString;
    }

    public final String body() {
        return this.body;
    }

    public final boolean hasHeaders() {
        return this.headers != null && !(this.headers instanceof SdkAutoConstructMap);
    }

    public final Map<String, String> headers() {
        return this.headers;
    }

    public final boolean hasMultiValueHeaders() {
        return this.multiValueHeaders != null && !(this.multiValueHeaders instanceof SdkAutoConstructMap);
    }

    public final Map<String, List<String>> multiValueHeaders() {
        return this.multiValueHeaders;
    }

    public final String clientCertificateId() {
        return this.clientCertificateId;
    }

    public final boolean hasStageVariables() {
        return this.stageVariables != null && !(this.stageVariables instanceof SdkAutoConstructMap);
    }

    public final Map<String, String> stageVariables() {
        return this.stageVariables;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(this.restApiId());
        hashCode = 31 * hashCode + Objects.hashCode(this.resourceId());
        hashCode = 31 * hashCode + Objects.hashCode(this.httpMethod());
        hashCode = 31 * hashCode + Objects.hashCode(this.pathWithQueryString());
        hashCode = 31 * hashCode + Objects.hashCode(this.body());
        hashCode = 31 * hashCode + Objects.hashCode(this.hasHeaders() ? this.headers() : null);
        hashCode = 31 * hashCode + Objects.hashCode(this.hasMultiValueHeaders() ? this.multiValueHeaders() : null);
        hashCode = 31 * hashCode + Objects.hashCode(this.clientCertificateId());
        hashCode = 31 * hashCode + Objects.hashCode(this.hasStageVariables() ? this.stageVariables() : null);
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return super.equals(obj) && this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof TestInvokeMethodRequest)) {
            return false;
        }
        TestInvokeMethodRequest other = (TestInvokeMethodRequest)((Object)obj);
        return Objects.equals(this.restApiId(), other.restApiId()) && Objects.equals(this.resourceId(), other.resourceId()) && Objects.equals(this.httpMethod(), other.httpMethod()) && Objects.equals(this.pathWithQueryString(), other.pathWithQueryString()) && Objects.equals(this.body(), other.body()) && this.hasHeaders() == other.hasHeaders() && Objects.equals(this.headers(), other.headers()) && this.hasMultiValueHeaders() == other.hasMultiValueHeaders() && Objects.equals(this.multiValueHeaders(), other.multiValueHeaders()) && Objects.equals(this.clientCertificateId(), other.clientCertificateId()) && this.hasStageVariables() == other.hasStageVariables() && Objects.equals(this.stageVariables(), other.stageVariables());
    }

    public final String toString() {
        return ToString.builder((String)"TestInvokeMethodRequest").add("RestApiId", (Object)this.restApiId()).add("ResourceId", (Object)this.resourceId()).add("HttpMethod", (Object)this.httpMethod()).add("PathWithQueryString", (Object)this.pathWithQueryString()).add("Body", (Object)this.body()).add("Headers", this.hasHeaders() ? this.headers() : null).add("MultiValueHeaders", this.hasMultiValueHeaders() ? this.multiValueHeaders() : null).add("ClientCertificateId", (Object)this.clientCertificateId()).add("StageVariables", this.hasStageVariables() ? this.stageVariables() : null).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "restApiId": {
                return Optional.ofNullable(clazz.cast(this.restApiId()));
            }
            case "resourceId": {
                return Optional.ofNullable(clazz.cast(this.resourceId()));
            }
            case "httpMethod": {
                return Optional.ofNullable(clazz.cast(this.httpMethod()));
            }
            case "pathWithQueryString": {
                return Optional.ofNullable(clazz.cast(this.pathWithQueryString()));
            }
            case "body": {
                return Optional.ofNullable(clazz.cast(this.body()));
            }
            case "headers": {
                return Optional.ofNullable(clazz.cast(this.headers()));
            }
            case "multiValueHeaders": {
                return Optional.ofNullable(clazz.cast(this.multiValueHeaders()));
            }
            case "clientCertificateId": {
                return Optional.ofNullable(clazz.cast(this.clientCertificateId()));
            }
            case "stageVariables": {
                return Optional.ofNullable(clazz.cast(this.stageVariables()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("restapi_id", REST_API_ID_FIELD);
        map.put("resource_id", RESOURCE_ID_FIELD);
        map.put("http_method", HTTP_METHOD_FIELD);
        map.put("pathWithQueryString", PATH_WITH_QUERY_STRING_FIELD);
        map.put("body", BODY_FIELD);
        map.put("headers", HEADERS_FIELD);
        map.put("multiValueHeaders", MULTI_VALUE_HEADERS_FIELD);
        map.put("clientCertificateId", CLIENT_CERTIFICATE_ID_FIELD);
        map.put("stageVariables", STAGE_VARIABLES_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<TestInvokeMethodRequest, T> g) {
        return obj -> g.apply((TestInvokeMethodRequest)((Object)((Object)obj)));
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    extends ApiGatewayRequest.BuilderImpl
    implements Builder {
        private String restApiId;
        private String resourceId;
        private String httpMethod;
        private String pathWithQueryString;
        private String body;
        private Map<String, String> headers = DefaultSdkAutoConstructMap.getInstance();
        private Map<String, List<String>> multiValueHeaders = DefaultSdkAutoConstructMap.getInstance();
        private String clientCertificateId;
        private Map<String, String> stageVariables = DefaultSdkAutoConstructMap.getInstance();

        private BuilderImpl() {
        }

        private BuilderImpl(TestInvokeMethodRequest model) {
            super(model);
            this.restApiId(model.restApiId);
            this.resourceId(model.resourceId);
            this.httpMethod(model.httpMethod);
            this.pathWithQueryString(model.pathWithQueryString);
            this.body(model.body);
            this.headers(model.headers);
            this.multiValueHeaders(model.multiValueHeaders);
            this.clientCertificateId(model.clientCertificateId);
            this.stageVariables(model.stageVariables);
        }

        public final String getRestApiId() {
            return this.restApiId;
        }

        public final void setRestApiId(String restApiId) {
            this.restApiId = restApiId;
        }

        @Override
        public final Builder restApiId(String restApiId) {
            this.restApiId = restApiId;
            return this;
        }

        public final String getResourceId() {
            return this.resourceId;
        }

        public final void setResourceId(String resourceId) {
            this.resourceId = resourceId;
        }

        @Override
        public final Builder resourceId(String resourceId) {
            this.resourceId = resourceId;
            return this;
        }

        public final String getHttpMethod() {
            return this.httpMethod;
        }

        public final void setHttpMethod(String httpMethod) {
            this.httpMethod = httpMethod;
        }

        @Override
        public final Builder httpMethod(String httpMethod) {
            this.httpMethod = httpMethod;
            return this;
        }

        public final String getPathWithQueryString() {
            return this.pathWithQueryString;
        }

        public final void setPathWithQueryString(String pathWithQueryString) {
            this.pathWithQueryString = pathWithQueryString;
        }

        @Override
        public final Builder pathWithQueryString(String pathWithQueryString) {
            this.pathWithQueryString = pathWithQueryString;
            return this;
        }

        public final String getBody() {
            return this.body;
        }

        public final void setBody(String body) {
            this.body = body;
        }

        @Override
        public final Builder body(String body) {
            this.body = body;
            return this;
        }

        public final Map<String, String> getHeaders() {
            if (this.headers instanceof SdkAutoConstructMap) {
                return null;
            }
            return this.headers;
        }

        public final void setHeaders(Map<String, String> headers) {
            this.headers = MapOfStringToStringCopier.copy(headers);
        }

        @Override
        public final Builder headers(Map<String, String> headers) {
            this.headers = MapOfStringToStringCopier.copy(headers);
            return this;
        }

        public final Map<String, ? extends Collection<String>> getMultiValueHeaders() {
            if (this.multiValueHeaders instanceof SdkAutoConstructMap) {
                return null;
            }
            return this.multiValueHeaders;
        }

        public final void setMultiValueHeaders(Map<String, ? extends Collection<String>> multiValueHeaders) {
            this.multiValueHeaders = MapOfStringToListCopier.copy(multiValueHeaders);
        }

        @Override
        public final Builder multiValueHeaders(Map<String, ? extends Collection<String>> multiValueHeaders) {
            this.multiValueHeaders = MapOfStringToListCopier.copy(multiValueHeaders);
            return this;
        }

        public final String getClientCertificateId() {
            return this.clientCertificateId;
        }

        public final void setClientCertificateId(String clientCertificateId) {
            this.clientCertificateId = clientCertificateId;
        }

        @Override
        public final Builder clientCertificateId(String clientCertificateId) {
            this.clientCertificateId = clientCertificateId;
            return this;
        }

        public final Map<String, String> getStageVariables() {
            if (this.stageVariables instanceof SdkAutoConstructMap) {
                return null;
            }
            return this.stageVariables;
        }

        public final void setStageVariables(Map<String, String> stageVariables) {
            this.stageVariables = MapOfStringToStringCopier.copy(stageVariables);
        }

        @Override
        public final Builder stageVariables(Map<String, String> stageVariables) {
            this.stageVariables = MapOfStringToStringCopier.copy(stageVariables);
            return this;
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public TestInvokeMethodRequest build() {
            return new TestInvokeMethodRequest(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }

    @Mutable
    @NotThreadSafe
    public static interface Builder
    extends ApiGatewayRequest.Builder,
    SdkPojo,
    CopyableBuilder<Builder, TestInvokeMethodRequest> {
        public Builder restApiId(String var1);

        public Builder resourceId(String var1);

        public Builder httpMethod(String var1);

        public Builder pathWithQueryString(String var1);

        public Builder body(String var1);

        public Builder headers(Map<String, String> var1);

        public Builder multiValueHeaders(Map<String, ? extends Collection<String>> var1);

        public Builder clientCertificateId(String var1);

        public Builder stageVariables(Map<String, String> var1);

        public Builder overrideConfiguration(AwsRequestOverrideConfiguration var1);

        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> var1);
    }
}

