/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.apigateway.model;

import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * A set of validation rules for incoming Method requests.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class CreateRequestValidatorResponse extends ApiGatewayResponse implements
        ToCopyableBuilder<CreateRequestValidatorResponse.Builder, CreateRequestValidatorResponse> {
    private static final SdkField<String> ID_FIELD = SdkField.<String> builder(MarshallingType.STRING).memberName("id")
            .getter(getter(CreateRequestValidatorResponse::id)).setter(setter(Builder::id))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("id").build()).build();

    private static final SdkField<String> NAME_FIELD = SdkField.<String> builder(MarshallingType.STRING).memberName("name")
            .getter(getter(CreateRequestValidatorResponse::name)).setter(setter(Builder::name))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("name").build()).build();

    private static final SdkField<Boolean> VALIDATE_REQUEST_BODY_FIELD = SdkField.<Boolean> builder(MarshallingType.BOOLEAN)
            .memberName("validateRequestBody").getter(getter(CreateRequestValidatorResponse::validateRequestBody))
            .setter(setter(Builder::validateRequestBody))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("validateRequestBody").build())
            .build();

    private static final SdkField<Boolean> VALIDATE_REQUEST_PARAMETERS_FIELD = SdkField
            .<Boolean> builder(MarshallingType.BOOLEAN).memberName("validateRequestParameters")
            .getter(getter(CreateRequestValidatorResponse::validateRequestParameters))
            .setter(setter(Builder::validateRequestParameters))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("validateRequestParameters").build())
            .build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(ID_FIELD, NAME_FIELD,
            VALIDATE_REQUEST_BODY_FIELD, VALIDATE_REQUEST_PARAMETERS_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = memberNameToFieldInitializer();

    private final String id;

    private final String name;

    private final Boolean validateRequestBody;

    private final Boolean validateRequestParameters;

    private CreateRequestValidatorResponse(BuilderImpl builder) {
        super(builder);
        this.id = builder.id;
        this.name = builder.name;
        this.validateRequestBody = builder.validateRequestBody;
        this.validateRequestParameters = builder.validateRequestParameters;
    }

    /**
     * <p>
     * The identifier of this RequestValidator.
     * </p>
     * 
     * @return The identifier of this RequestValidator.
     */
    public final String id() {
        return id;
    }

    /**
     * <p>
     * The name of this RequestValidator
     * </p>
     * 
     * @return The name of this RequestValidator
     */
    public final String name() {
        return name;
    }

    /**
     * <p>
     * A Boolean flag to indicate whether to validate a request body according to the configured Model schema.
     * </p>
     * 
     * @return A Boolean flag to indicate whether to validate a request body according to the configured Model schema.
     */
    public final Boolean validateRequestBody() {
        return validateRequestBody;
    }

    /**
     * <p>
     * A Boolean flag to indicate whether to validate request parameters (<code>true</code>) or not (<code>false</code>
     * ).
     * </p>
     * 
     * @return A Boolean flag to indicate whether to validate request parameters (<code>true</code>) or not (
     *         <code>false</code>).
     */
    public final Boolean validateRequestParameters() {
        return validateRequestParameters;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(id());
        hashCode = 31 * hashCode + Objects.hashCode(name());
        hashCode = 31 * hashCode + Objects.hashCode(validateRequestBody());
        hashCode = 31 * hashCode + Objects.hashCode(validateRequestParameters());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof CreateRequestValidatorResponse)) {
            return false;
        }
        CreateRequestValidatorResponse other = (CreateRequestValidatorResponse) obj;
        return Objects.equals(id(), other.id()) && Objects.equals(name(), other.name())
                && Objects.equals(validateRequestBody(), other.validateRequestBody())
                && Objects.equals(validateRequestParameters(), other.validateRequestParameters());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("CreateRequestValidatorResponse").add("Id", id()).add("Name", name())
                .add("ValidateRequestBody", validateRequestBody()).add("ValidateRequestParameters", validateRequestParameters())
                .build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "id":
            return Optional.ofNullable(clazz.cast(id()));
        case "name":
            return Optional.ofNullable(clazz.cast(name()));
        case "validateRequestBody":
            return Optional.ofNullable(clazz.cast(validateRequestBody()));
        case "validateRequestParameters":
            return Optional.ofNullable(clazz.cast(validateRequestParameters()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        Map<String, SdkField<?>> map = new HashMap<>();
        map.put("id", ID_FIELD);
        map.put("name", NAME_FIELD);
        map.put("validateRequestBody", VALIDATE_REQUEST_BODY_FIELD);
        map.put("validateRequestParameters", VALIDATE_REQUEST_PARAMETERS_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<CreateRequestValidatorResponse, T> g) {
        return obj -> g.apply((CreateRequestValidatorResponse) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    @Mutable
    @NotThreadSafe
    public interface Builder extends ApiGatewayResponse.Builder, SdkPojo,
            CopyableBuilder<Builder, CreateRequestValidatorResponse> {
        /**
         * <p>
         * The identifier of this RequestValidator.
         * </p>
         * 
         * @param id
         *        The identifier of this RequestValidator.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder id(String id);

        /**
         * <p>
         * The name of this RequestValidator
         * </p>
         * 
         * @param name
         *        The name of this RequestValidator
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder name(String name);

        /**
         * <p>
         * A Boolean flag to indicate whether to validate a request body according to the configured Model schema.
         * </p>
         * 
         * @param validateRequestBody
         *        A Boolean flag to indicate whether to validate a request body according to the configured Model
         *        schema.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder validateRequestBody(Boolean validateRequestBody);

        /**
         * <p>
         * A Boolean flag to indicate whether to validate request parameters (<code>true</code>) or not (
         * <code>false</code>).
         * </p>
         * 
         * @param validateRequestParameters
         *        A Boolean flag to indicate whether to validate request parameters (<code>true</code>) or not (
         *        <code>false</code>).
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder validateRequestParameters(Boolean validateRequestParameters);
    }

    static final class BuilderImpl extends ApiGatewayResponse.BuilderImpl implements Builder {
        private String id;

        private String name;

        private Boolean validateRequestBody;

        private Boolean validateRequestParameters;

        private BuilderImpl() {
        }

        private BuilderImpl(CreateRequestValidatorResponse model) {
            super(model);
            id(model.id);
            name(model.name);
            validateRequestBody(model.validateRequestBody);
            validateRequestParameters(model.validateRequestParameters);
        }

        public final String getId() {
            return id;
        }

        public final void setId(String id) {
            this.id = id;
        }

        @Override
        public final Builder id(String id) {
            this.id = id;
            return this;
        }

        public final String getName() {
            return name;
        }

        public final void setName(String name) {
            this.name = name;
        }

        @Override
        public final Builder name(String name) {
            this.name = name;
            return this;
        }

        public final Boolean getValidateRequestBody() {
            return validateRequestBody;
        }

        public final void setValidateRequestBody(Boolean validateRequestBody) {
            this.validateRequestBody = validateRequestBody;
        }

        @Override
        public final Builder validateRequestBody(Boolean validateRequestBody) {
            this.validateRequestBody = validateRequestBody;
            return this;
        }

        public final Boolean getValidateRequestParameters() {
            return validateRequestParameters;
        }

        public final void setValidateRequestParameters(Boolean validateRequestParameters) {
            this.validateRequestParameters = validateRequestParameters;
        }

        @Override
        public final Builder validateRequestParameters(Boolean validateRequestParameters) {
            this.validateRequestParameters = validateRequestParameters;
            return this;
        }

        @Override
        public CreateRequestValidatorResponse build() {
            return new CreateRequestValidatorResponse(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }
}
