/*
 * Copyright 2014-2019 Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.apigateway.model;

import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.awscore.exception.AwsErrorDetails;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * The request exceeded the rate limit. Retry after the specified time period.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class LimitExceededException extends ApiGatewayException implements
        ToCopyableBuilder<LimitExceededException.Builder, LimitExceededException> {
    private static final SdkField<String> RETRY_AFTER_SECONDS_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .getter(getter(LimitExceededException::retryAfterSeconds)).setter(setter(Builder::retryAfterSeconds))
            .traits(LocationTrait.builder().location(MarshallLocation.HEADER).locationName("Retry-After").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(RETRY_AFTER_SECONDS_FIELD));

    private static final long serialVersionUID = 1L;

    private final String retryAfterSeconds;

    private LimitExceededException(BuilderImpl builder) {
        super(builder);
        this.retryAfterSeconds = builder.retryAfterSeconds;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    /**
     * Returns the value of the RetryAfterSeconds property for this object.
     * 
     * @return The value of the RetryAfterSeconds property for this object.
     */
    public String retryAfterSeconds() {
        return retryAfterSeconds;
    }

    @Override
    public List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<LimitExceededException, T> g) {
        return obj -> g.apply((LimitExceededException) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SdkPojo, CopyableBuilder<Builder, LimitExceededException>, ApiGatewayException.Builder {
        /**
         * Sets the value of the RetryAfterSeconds property for this object.
         *
         * @param retryAfterSeconds
         *        The new value for the RetryAfterSeconds property for this object.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder retryAfterSeconds(String retryAfterSeconds);

        @Override
        Builder awsErrorDetails(AwsErrorDetails awsErrorDetails);

        @Override
        Builder message(String message);

        @Override
        Builder requestId(String requestId);

        @Override
        Builder statusCode(int statusCode);

        @Override
        Builder cause(Throwable cause);
    }

    static final class BuilderImpl extends ApiGatewayException.BuilderImpl implements Builder {
        private String retryAfterSeconds;

        private BuilderImpl() {
        }

        private BuilderImpl(LimitExceededException model) {
            super(model);
            retryAfterSeconds(model.retryAfterSeconds);
        }

        public final String getRetryAfterSeconds() {
            return retryAfterSeconds;
        }

        @Override
        public final Builder retryAfterSeconds(String retryAfterSeconds) {
            this.retryAfterSeconds = retryAfterSeconds;
            return this;
        }

        public final void setRetryAfterSeconds(String retryAfterSeconds) {
            this.retryAfterSeconds = retryAfterSeconds;
        }

        @Override
        public BuilderImpl awsErrorDetails(AwsErrorDetails awsErrorDetails) {
            this.awsErrorDetails = awsErrorDetails;
            return this;
        }

        @Override
        public BuilderImpl message(String message) {
            this.message = message;
            return this;
        }

        @Override
        public BuilderImpl requestId(String requestId) {
            this.requestId = requestId;
            return this;
        }

        @Override
        public BuilderImpl statusCode(int statusCode) {
            this.statusCode = statusCode;
            return this;
        }

        @Override
        public BuilderImpl cause(Throwable cause) {
            this.cause = cause;
            return this;
        }

        @Override
        public LimitExceededException build() {
            return new LimitExceededException(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
