/*
 * Copyright 2014-2019 Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.apigateway.model;

import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * A request to delete the <a>ClientCertificate</a> resource.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class DeleteClientCertificateRequest extends ApiGatewayRequest implements
        ToCopyableBuilder<DeleteClientCertificateRequest.Builder, DeleteClientCertificateRequest> {
    private static final SdkField<String> CLIENT_CERTIFICATE_ID_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .getter(getter(DeleteClientCertificateRequest::clientCertificateId)).setter(setter(Builder::clientCertificateId))
            .traits(LocationTrait.builder().location(MarshallLocation.PATH).locationName("clientcertificate_id").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(CLIENT_CERTIFICATE_ID_FIELD));

    private final String clientCertificateId;

    private DeleteClientCertificateRequest(BuilderImpl builder) {
        super(builder);
        this.clientCertificateId = builder.clientCertificateId;
    }

    /**
     * <p>
     * [Required] The identifier of the <a>ClientCertificate</a> resource to be deleted.
     * </p>
     * 
     * @return [Required] The identifier of the <a>ClientCertificate</a> resource to be deleted.
     */
    public String clientCertificateId() {
        return clientCertificateId;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(clientCertificateId());
        return hashCode;
    }

    @Override
    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof DeleteClientCertificateRequest)) {
            return false;
        }
        DeleteClientCertificateRequest other = (DeleteClientCertificateRequest) obj;
        return Objects.equals(clientCertificateId(), other.clientCertificateId());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public String toString() {
        return ToString.builder("DeleteClientCertificateRequest").add("ClientCertificateId", clientCertificateId()).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "clientCertificateId":
            return Optional.ofNullable(clazz.cast(clientCertificateId()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<DeleteClientCertificateRequest, T> g) {
        return obj -> g.apply((DeleteClientCertificateRequest) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends ApiGatewayRequest.Builder, SdkPojo, CopyableBuilder<Builder, DeleteClientCertificateRequest> {
        /**
         * <p>
         * [Required] The identifier of the <a>ClientCertificate</a> resource to be deleted.
         * </p>
         * 
         * @param clientCertificateId
         *        [Required] The identifier of the <a>ClientCertificate</a> resource to be deleted.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder clientCertificateId(String clientCertificateId);

        @Override
        Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration);

        @Override
        Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer);
    }

    static final class BuilderImpl extends ApiGatewayRequest.BuilderImpl implements Builder {
        private String clientCertificateId;

        private BuilderImpl() {
        }

        private BuilderImpl(DeleteClientCertificateRequest model) {
            super(model);
            clientCertificateId(model.clientCertificateId);
        }

        public final String getClientCertificateId() {
            return clientCertificateId;
        }

        @Override
        public final Builder clientCertificateId(String clientCertificateId) {
            this.clientCertificateId = clientCertificateId;
            return this;
        }

        public final void setClientCertificateId(String clientCertificateId) {
            this.clientCertificateId = clientCertificateId;
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public DeleteClientCertificateRequest build() {
            return new DeleteClientCertificateRequest(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
