/*
 * Copyright 2014-2019 Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.apigateway.model;

import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * Deletes an existing documentation part of an API.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class DeleteDocumentationPartRequest extends ApiGatewayRequest implements
        ToCopyableBuilder<DeleteDocumentationPartRequest.Builder, DeleteDocumentationPartRequest> {
    private static final SdkField<String> REST_API_ID_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .getter(getter(DeleteDocumentationPartRequest::restApiId)).setter(setter(Builder::restApiId))
            .traits(LocationTrait.builder().location(MarshallLocation.PATH).locationName("restapi_id").build()).build();

    private static final SdkField<String> DOCUMENTATION_PART_ID_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .getter(getter(DeleteDocumentationPartRequest::documentationPartId)).setter(setter(Builder::documentationPartId))
            .traits(LocationTrait.builder().location(MarshallLocation.PATH).locationName("part_id").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(REST_API_ID_FIELD,
            DOCUMENTATION_PART_ID_FIELD));

    private final String restApiId;

    private final String documentationPartId;

    private DeleteDocumentationPartRequest(BuilderImpl builder) {
        super(builder);
        this.restApiId = builder.restApiId;
        this.documentationPartId = builder.documentationPartId;
    }

    /**
     * <p>
     * [Required] The string identifier of the associated <a>RestApi</a>.
     * </p>
     * 
     * @return [Required] The string identifier of the associated <a>RestApi</a>.
     */
    public String restApiId() {
        return restApiId;
    }

    /**
     * <p>
     * [Required] The identifier of the to-be-deleted documentation part.
     * </p>
     * 
     * @return [Required] The identifier of the to-be-deleted documentation part.
     */
    public String documentationPartId() {
        return documentationPartId;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(restApiId());
        hashCode = 31 * hashCode + Objects.hashCode(documentationPartId());
        return hashCode;
    }

    @Override
    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof DeleteDocumentationPartRequest)) {
            return false;
        }
        DeleteDocumentationPartRequest other = (DeleteDocumentationPartRequest) obj;
        return Objects.equals(restApiId(), other.restApiId())
                && Objects.equals(documentationPartId(), other.documentationPartId());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public String toString() {
        return ToString.builder("DeleteDocumentationPartRequest").add("RestApiId", restApiId())
                .add("DocumentationPartId", documentationPartId()).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "restApiId":
            return Optional.ofNullable(clazz.cast(restApiId()));
        case "documentationPartId":
            return Optional.ofNullable(clazz.cast(documentationPartId()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<DeleteDocumentationPartRequest, T> g) {
        return obj -> g.apply((DeleteDocumentationPartRequest) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends ApiGatewayRequest.Builder, SdkPojo, CopyableBuilder<Builder, DeleteDocumentationPartRequest> {
        /**
         * <p>
         * [Required] The string identifier of the associated <a>RestApi</a>.
         * </p>
         * 
         * @param restApiId
         *        [Required] The string identifier of the associated <a>RestApi</a>.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder restApiId(String restApiId);

        /**
         * <p>
         * [Required] The identifier of the to-be-deleted documentation part.
         * </p>
         * 
         * @param documentationPartId
         *        [Required] The identifier of the to-be-deleted documentation part.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder documentationPartId(String documentationPartId);

        @Override
        Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration);

        @Override
        Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer);
    }

    static final class BuilderImpl extends ApiGatewayRequest.BuilderImpl implements Builder {
        private String restApiId;

        private String documentationPartId;

        private BuilderImpl() {
        }

        private BuilderImpl(DeleteDocumentationPartRequest model) {
            super(model);
            restApiId(model.restApiId);
            documentationPartId(model.documentationPartId);
        }

        public final String getRestApiId() {
            return restApiId;
        }

        @Override
        public final Builder restApiId(String restApiId) {
            this.restApiId = restApiId;
            return this;
        }

        public final void setRestApiId(String restApiId) {
            this.restApiId = restApiId;
        }

        public final String getDocumentationPartId() {
            return documentationPartId;
        }

        @Override
        public final Builder documentationPartId(String documentationPartId) {
            this.documentationPartId = documentationPartId;
            return this;
        }

        public final void setDocumentationPartId(String documentationPartId) {
            this.documentationPartId = documentationPartId;
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public DeleteDocumentationPartRequest build() {
            return new DeleteDocumentationPartRequest(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
