/*
 * Copyright 2014-2019 Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.apigateway.model;

import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * Requests API Gateway to create a <a>Resource</a> resource.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class CreateResourceRequest extends ApiGatewayRequest implements
        ToCopyableBuilder<CreateResourceRequest.Builder, CreateResourceRequest> {
    private static final SdkField<String> REST_API_ID_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .getter(getter(CreateResourceRequest::restApiId)).setter(setter(Builder::restApiId))
            .traits(LocationTrait.builder().location(MarshallLocation.PATH).locationName("restapi_id").build()).build();

    private static final SdkField<String> PARENT_ID_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .getter(getter(CreateResourceRequest::parentId)).setter(setter(Builder::parentId))
            .traits(LocationTrait.builder().location(MarshallLocation.PATH).locationName("parent_id").build()).build();

    private static final SdkField<String> PATH_PART_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .getter(getter(CreateResourceRequest::pathPart)).setter(setter(Builder::pathPart))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("pathPart").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(REST_API_ID_FIELD,
            PARENT_ID_FIELD, PATH_PART_FIELD));

    private final String restApiId;

    private final String parentId;

    private final String pathPart;

    private CreateResourceRequest(BuilderImpl builder) {
        super(builder);
        this.restApiId = builder.restApiId;
        this.parentId = builder.parentId;
        this.pathPart = builder.pathPart;
    }

    /**
     * <p>
     * [Required] The string identifier of the associated <a>RestApi</a>.
     * </p>
     * 
     * @return [Required] The string identifier of the associated <a>RestApi</a>.
     */
    public String restApiId() {
        return restApiId;
    }

    /**
     * <p>
     * [Required] The parent resource's identifier.
     * </p>
     * 
     * @return [Required] The parent resource's identifier.
     */
    public String parentId() {
        return parentId;
    }

    /**
     * <p>
     * The last path segment for this resource.
     * </p>
     * 
     * @return The last path segment for this resource.
     */
    public String pathPart() {
        return pathPart;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(restApiId());
        hashCode = 31 * hashCode + Objects.hashCode(parentId());
        hashCode = 31 * hashCode + Objects.hashCode(pathPart());
        return hashCode;
    }

    @Override
    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof CreateResourceRequest)) {
            return false;
        }
        CreateResourceRequest other = (CreateResourceRequest) obj;
        return Objects.equals(restApiId(), other.restApiId()) && Objects.equals(parentId(), other.parentId())
                && Objects.equals(pathPart(), other.pathPart());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public String toString() {
        return ToString.builder("CreateResourceRequest").add("RestApiId", restApiId()).add("ParentId", parentId())
                .add("PathPart", pathPart()).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "restApiId":
            return Optional.ofNullable(clazz.cast(restApiId()));
        case "parentId":
            return Optional.ofNullable(clazz.cast(parentId()));
        case "pathPart":
            return Optional.ofNullable(clazz.cast(pathPart()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<CreateResourceRequest, T> g) {
        return obj -> g.apply((CreateResourceRequest) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends ApiGatewayRequest.Builder, SdkPojo, CopyableBuilder<Builder, CreateResourceRequest> {
        /**
         * <p>
         * [Required] The string identifier of the associated <a>RestApi</a>.
         * </p>
         * 
         * @param restApiId
         *        [Required] The string identifier of the associated <a>RestApi</a>.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder restApiId(String restApiId);

        /**
         * <p>
         * [Required] The parent resource's identifier.
         * </p>
         * 
         * @param parentId
         *        [Required] The parent resource's identifier.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder parentId(String parentId);

        /**
         * <p>
         * The last path segment for this resource.
         * </p>
         * 
         * @param pathPart
         *        The last path segment for this resource.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder pathPart(String pathPart);

        @Override
        Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration);

        @Override
        Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer);
    }

    static final class BuilderImpl extends ApiGatewayRequest.BuilderImpl implements Builder {
        private String restApiId;

        private String parentId;

        private String pathPart;

        private BuilderImpl() {
        }

        private BuilderImpl(CreateResourceRequest model) {
            super(model);
            restApiId(model.restApiId);
            parentId(model.parentId);
            pathPart(model.pathPart);
        }

        public final String getRestApiId() {
            return restApiId;
        }

        @Override
        public final Builder restApiId(String restApiId) {
            this.restApiId = restApiId;
            return this;
        }

        public final void setRestApiId(String restApiId) {
            this.restApiId = restApiId;
        }

        public final String getParentId() {
            return parentId;
        }

        @Override
        public final Builder parentId(String parentId) {
            this.parentId = parentId;
            return this;
        }

        public final void setParentId(String parentId) {
            this.parentId = parentId;
        }

        public final String getPathPart() {
            return pathPart;
        }

        @Override
        public final Builder pathPart(String pathPart) {
            this.pathPart = pathPart;
            return this;
        }

        public final void setPathPart(String pathPart) {
            this.pathPart = pathPart;
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public CreateResourceRequest build() {
            return new CreateResourceRequest(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
