/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.apigateway.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.services.apigateway.model.ApiGatewayResponse;
import software.amazon.awssdk.services.apigateway.model.ListOfSdkConfigurationPropertyCopier;
import software.amazon.awssdk.services.apigateway.model.SdkConfigurationProperty;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class GetSdkTypeResponse
extends ApiGatewayResponse
implements ToCopyableBuilder<Builder, GetSdkTypeResponse> {
    private static final SdkField<String> ID_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).getter(GetSdkTypeResponse.getter(GetSdkTypeResponse::id)).setter(GetSdkTypeResponse.setter(Builder::id)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("id").build()}).build();
    private static final SdkField<String> FRIENDLY_NAME_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).getter(GetSdkTypeResponse.getter(GetSdkTypeResponse::friendlyName)).setter(GetSdkTypeResponse.setter(Builder::friendlyName)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("friendlyName").build()}).build();
    private static final SdkField<String> DESCRIPTION_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).getter(GetSdkTypeResponse.getter(GetSdkTypeResponse::description)).setter(GetSdkTypeResponse.setter(Builder::description)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("description").build()}).build();
    private static final SdkField<List<SdkConfigurationProperty>> CONFIGURATION_PROPERTIES_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).getter(GetSdkTypeResponse.getter(GetSdkTypeResponse::configurationProperties)).setter(GetSdkTypeResponse.setter(Builder::configurationProperties)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("configurationProperties").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).constructor(SdkConfigurationProperty::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(ID_FIELD, FRIENDLY_NAME_FIELD, DESCRIPTION_FIELD, CONFIGURATION_PROPERTIES_FIELD));
    private final String id;
    private final String friendlyName;
    private final String description;
    private final List<SdkConfigurationProperty> configurationProperties;

    private GetSdkTypeResponse(BuilderImpl builder) {
        super(builder);
        this.id = builder.id;
        this.friendlyName = builder.friendlyName;
        this.description = builder.description;
        this.configurationProperties = builder.configurationProperties;
    }

    public String id() {
        return this.id;
    }

    public String friendlyName() {
        return this.friendlyName;
    }

    public String description() {
        return this.description;
    }

    public List<SdkConfigurationProperty> configurationProperties() {
        return this.configurationProperties;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.id());
        hashCode = 31 * hashCode + Objects.hashCode(this.friendlyName());
        hashCode = 31 * hashCode + Objects.hashCode(this.description());
        hashCode = 31 * hashCode + Objects.hashCode(this.configurationProperties());
        return hashCode;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof GetSdkTypeResponse)) {
            return false;
        }
        GetSdkTypeResponse other = (GetSdkTypeResponse)((Object)obj);
        return Objects.equals(this.id(), other.id()) && Objects.equals(this.friendlyName(), other.friendlyName()) && Objects.equals(this.description(), other.description()) && Objects.equals(this.configurationProperties(), other.configurationProperties());
    }

    public String toString() {
        return ToString.builder((String)"GetSdkTypeResponse").add("Id", (Object)this.id()).add("FriendlyName", (Object)this.friendlyName()).add("Description", (Object)this.description()).add("ConfigurationProperties", this.configurationProperties()).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "id": {
                return Optional.ofNullable(clazz.cast(this.id()));
            }
            case "friendlyName": {
                return Optional.ofNullable(clazz.cast(this.friendlyName()));
            }
            case "description": {
                return Optional.ofNullable(clazz.cast(this.description()));
            }
            case "configurationProperties": {
                return Optional.ofNullable(clazz.cast(this.configurationProperties()));
            }
        }
        return Optional.empty();
    }

    public List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<GetSdkTypeResponse, T> g) {
        return obj -> g.apply((GetSdkTypeResponse)((Object)((Object)obj)));
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    extends ApiGatewayResponse.BuilderImpl
    implements Builder {
        private String id;
        private String friendlyName;
        private String description;
        private List<SdkConfigurationProperty> configurationProperties = DefaultSdkAutoConstructList.getInstance();

        private BuilderImpl() {
        }

        private BuilderImpl(GetSdkTypeResponse model) {
            super(model);
            this.id(model.id);
            this.friendlyName(model.friendlyName);
            this.description(model.description);
            this.configurationProperties(model.configurationProperties);
        }

        public final String getId() {
            return this.id;
        }

        @Override
        public final Builder id(String id) {
            this.id = id;
            return this;
        }

        public final void setId(String id) {
            this.id = id;
        }

        public final String getFriendlyName() {
            return this.friendlyName;
        }

        @Override
        public final Builder friendlyName(String friendlyName) {
            this.friendlyName = friendlyName;
            return this;
        }

        public final void setFriendlyName(String friendlyName) {
            this.friendlyName = friendlyName;
        }

        public final String getDescription() {
            return this.description;
        }

        @Override
        public final Builder description(String description) {
            this.description = description;
            return this;
        }

        public final void setDescription(String description) {
            this.description = description;
        }

        public final Collection<SdkConfigurationProperty.Builder> getConfigurationProperties() {
            return this.configurationProperties != null ? (Collection)this.configurationProperties.stream().map(SdkConfigurationProperty::toBuilder).collect(Collectors.toList()) : null;
        }

        @Override
        public final Builder configurationProperties(Collection<SdkConfigurationProperty> configurationProperties) {
            this.configurationProperties = ListOfSdkConfigurationPropertyCopier.copy(configurationProperties);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder configurationProperties(SdkConfigurationProperty ... configurationProperties) {
            this.configurationProperties(Arrays.asList(configurationProperties));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder configurationProperties(Consumer<SdkConfigurationProperty.Builder> ... configurationProperties) {
            this.configurationProperties(Stream.of(configurationProperties).map(c -> (SdkConfigurationProperty)((SdkConfigurationProperty.Builder)SdkConfigurationProperty.builder().applyMutation((Consumer)c)).build()).collect(Collectors.toList()));
            return this;
        }

        public final void setConfigurationProperties(Collection<SdkConfigurationProperty.BuilderImpl> configurationProperties) {
            this.configurationProperties = ListOfSdkConfigurationPropertyCopier.copyFromBuilder(configurationProperties);
        }

        @Override
        public GetSdkTypeResponse build() {
            return new GetSdkTypeResponse(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }

    public static interface Builder
    extends ApiGatewayResponse.Builder,
    SdkPojo,
    CopyableBuilder<Builder, GetSdkTypeResponse> {
        public Builder id(String var1);

        public Builder friendlyName(String var1);

        public Builder description(String var1);

        public Builder configurationProperties(Collection<SdkConfigurationProperty> var1);

        public Builder configurationProperties(SdkConfigurationProperty ... var1);

        public Builder configurationProperties(Consumer<SdkConfigurationProperty.Builder> ... var1);
    }
}

