/*
 * Copyright 2014-2019 Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.apigateway.model;

import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * Represents the data structure of a method's request or response payload.
 * </p>
 * <div class="remarks">
 * <p>
 * A request model defines the data structure of the client-supplied request payload. A response model defines the data
 * structure of the response payload returned by the back end. Although not required, models are useful for mapping
 * payloads between the front end and back end.
 * </p>
 * <p>
 * A model is used for generating an API's SDK, validating the input request body, and creating a skeletal mapping
 * template.
 * </p>
 * </div> <div class="seeAlso"> <a>Method</a>, <a>MethodResponse</a>, <a
 * href="https://docs.aws.amazon.com/apigateway/latest/developerguide/models-mappings.html">Models and Mappings</a>
 * </div>
 */
@Generated("software.amazon.awssdk:codegen")
public final class GetModelResponse extends ApiGatewayResponse implements
        ToCopyableBuilder<GetModelResponse.Builder, GetModelResponse> {
    private static final SdkField<String> ID_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .getter(getter(GetModelResponse::id)).setter(setter(Builder::id))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("id").build()).build();

    private static final SdkField<String> NAME_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .getter(getter(GetModelResponse::name)).setter(setter(Builder::name))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("name").build()).build();

    private static final SdkField<String> DESCRIPTION_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .getter(getter(GetModelResponse::description)).setter(setter(Builder::description))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("description").build()).build();

    private static final SdkField<String> SCHEMA_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .getter(getter(GetModelResponse::schema)).setter(setter(Builder::schema))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("schema").build()).build();

    private static final SdkField<String> CONTENT_TYPE_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .getter(getter(GetModelResponse::contentType)).setter(setter(Builder::contentType))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("contentType").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(ID_FIELD, NAME_FIELD,
            DESCRIPTION_FIELD, SCHEMA_FIELD, CONTENT_TYPE_FIELD));

    private final String id;

    private final String name;

    private final String description;

    private final String schema;

    private final String contentType;

    private GetModelResponse(BuilderImpl builder) {
        super(builder);
        this.id = builder.id;
        this.name = builder.name;
        this.description = builder.description;
        this.schema = builder.schema;
        this.contentType = builder.contentType;
    }

    /**
     * <p>
     * The identifier for the model resource.
     * </p>
     * 
     * @return The identifier for the model resource.
     */
    public String id() {
        return id;
    }

    /**
     * <p>
     * The name of the model. Must be an alphanumeric string.
     * </p>
     * 
     * @return The name of the model. Must be an alphanumeric string.
     */
    public String name() {
        return name;
    }

    /**
     * <p>
     * The description of the model.
     * </p>
     * 
     * @return The description of the model.
     */
    public String description() {
        return description;
    }

    /**
     * <p>
     * The schema for the model. For <code>application/json</code> models, this should be <a
     * href="https://tools.ietf.org/html/draft-zyp-json-schema-04" target="_blank">JSON schema draft 4</a> model. Do not
     * include "\*&#47;" characters in the description of any properties because such "\*&#47;" characters may be
     * interpreted as the closing marker for comments in some languages, such as Java or JavaScript, causing the
     * installation of your API's SDK generated by API Gateway to fail.
     * </p>
     * 
     * @return The schema for the model. For <code>application/json</code> models, this should be <a
     *         href="https://tools.ietf.org/html/draft-zyp-json-schema-04" target="_blank">JSON schema draft 4</a>
     *         model. Do not include "\*&#47;" characters in the description of any properties because such "\*&#47;"
     *         characters may be interpreted as the closing marker for comments in some languages, such as Java or
     *         JavaScript, causing the installation of your API's SDK generated by API Gateway to fail.
     */
    public String schema() {
        return schema;
    }

    /**
     * <p>
     * The content-type for the model.
     * </p>
     * 
     * @return The content-type for the model.
     */
    public String contentType() {
        return contentType;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(id());
        hashCode = 31 * hashCode + Objects.hashCode(name());
        hashCode = 31 * hashCode + Objects.hashCode(description());
        hashCode = 31 * hashCode + Objects.hashCode(schema());
        hashCode = 31 * hashCode + Objects.hashCode(contentType());
        return hashCode;
    }

    @Override
    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof GetModelResponse)) {
            return false;
        }
        GetModelResponse other = (GetModelResponse) obj;
        return Objects.equals(id(), other.id()) && Objects.equals(name(), other.name())
                && Objects.equals(description(), other.description()) && Objects.equals(schema(), other.schema())
                && Objects.equals(contentType(), other.contentType());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public String toString() {
        return ToString.builder("GetModelResponse").add("Id", id()).add("Name", name()).add("Description", description())
                .add("Schema", schema()).add("ContentType", contentType()).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "id":
            return Optional.ofNullable(clazz.cast(id()));
        case "name":
            return Optional.ofNullable(clazz.cast(name()));
        case "description":
            return Optional.ofNullable(clazz.cast(description()));
        case "schema":
            return Optional.ofNullable(clazz.cast(schema()));
        case "contentType":
            return Optional.ofNullable(clazz.cast(contentType()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<GetModelResponse, T> g) {
        return obj -> g.apply((GetModelResponse) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends ApiGatewayResponse.Builder, SdkPojo, CopyableBuilder<Builder, GetModelResponse> {
        /**
         * <p>
         * The identifier for the model resource.
         * </p>
         * 
         * @param id
         *        The identifier for the model resource.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder id(String id);

        /**
         * <p>
         * The name of the model. Must be an alphanumeric string.
         * </p>
         * 
         * @param name
         *        The name of the model. Must be an alphanumeric string.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder name(String name);

        /**
         * <p>
         * The description of the model.
         * </p>
         * 
         * @param description
         *        The description of the model.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder description(String description);

        /**
         * <p>
         * The schema for the model. For <code>application/json</code> models, this should be <a
         * href="https://tools.ietf.org/html/draft-zyp-json-schema-04" target="_blank">JSON schema draft 4</a> model. Do
         * not include "\*&#47;" characters in the description of any properties because such "\*&#47;" characters may
         * be interpreted as the closing marker for comments in some languages, such as Java or JavaScript, causing the
         * installation of your API's SDK generated by API Gateway to fail.
         * </p>
         * 
         * @param schema
         *        The schema for the model. For <code>application/json</code> models, this should be <a
         *        href="https://tools.ietf.org/html/draft-zyp-json-schema-04" target="_blank">JSON schema draft 4</a>
         *        model. Do not include "\*&#47;" characters in the description of any properties because such "\*&#47;"
         *        characters may be interpreted as the closing marker for comments in some languages, such as Java or
         *        JavaScript, causing the installation of your API's SDK generated by API Gateway to fail.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder schema(String schema);

        /**
         * <p>
         * The content-type for the model.
         * </p>
         * 
         * @param contentType
         *        The content-type for the model.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder contentType(String contentType);
    }

    static final class BuilderImpl extends ApiGatewayResponse.BuilderImpl implements Builder {
        private String id;

        private String name;

        private String description;

        private String schema;

        private String contentType;

        private BuilderImpl() {
        }

        private BuilderImpl(GetModelResponse model) {
            super(model);
            id(model.id);
            name(model.name);
            description(model.description);
            schema(model.schema);
            contentType(model.contentType);
        }

        public final String getId() {
            return id;
        }

        @Override
        public final Builder id(String id) {
            this.id = id;
            return this;
        }

        public final void setId(String id) {
            this.id = id;
        }

        public final String getName() {
            return name;
        }

        @Override
        public final Builder name(String name) {
            this.name = name;
            return this;
        }

        public final void setName(String name) {
            this.name = name;
        }

        public final String getDescription() {
            return description;
        }

        @Override
        public final Builder description(String description) {
            this.description = description;
            return this;
        }

        public final void setDescription(String description) {
            this.description = description;
        }

        public final String getSchema() {
            return schema;
        }

        @Override
        public final Builder schema(String schema) {
            this.schema = schema;
            return this;
        }

        public final void setSchema(String schema) {
            this.schema = schema;
        }

        public final String getContentType() {
            return contentType;
        }

        @Override
        public final Builder contentType(String contentType) {
            this.contentType = contentType;
            return this;
        }

        public final void setContentType(String contentType) {
            this.contentType = contentType;
        }

        @Override
        public GetModelResponse build() {
            return new GetModelResponse(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
