/*
 * Copyright 2014-2019 Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.apigateway.model;

import java.time.Instant;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.MapTrait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructMap;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * Represents a REST API.
 * </p>
 * <div class="seeAlso"> <a
 * href="https://docs.aws.amazon.com/apigateway/latest/developerguide/how-to-create-api.html">Create an API</a> </div>
 */
@Generated("software.amazon.awssdk:codegen")
public final class CreateRestApiResponse extends ApiGatewayResponse implements
        ToCopyableBuilder<CreateRestApiResponse.Builder, CreateRestApiResponse> {
    private static final SdkField<String> ID_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .getter(getter(CreateRestApiResponse::id)).setter(setter(Builder::id))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("id").build()).build();

    private static final SdkField<String> NAME_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .getter(getter(CreateRestApiResponse::name)).setter(setter(Builder::name))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("name").build()).build();

    private static final SdkField<String> DESCRIPTION_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .getter(getter(CreateRestApiResponse::description)).setter(setter(Builder::description))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("description").build()).build();

    private static final SdkField<Instant> CREATED_DATE_FIELD = SdkField.<Instant> builder(MarshallingType.INSTANT)
            .getter(getter(CreateRestApiResponse::createdDate)).setter(setter(Builder::createdDate))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("createdDate").build()).build();

    private static final SdkField<String> VERSION_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .getter(getter(CreateRestApiResponse::version)).setter(setter(Builder::version))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("version").build()).build();

    private static final SdkField<List<String>> WARNINGS_FIELD = SdkField
            .<List<String>> builder(MarshallingType.LIST)
            .getter(getter(CreateRestApiResponse::warnings))
            .setter(setter(Builder::warnings))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("warnings").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<String> builder(MarshallingType.STRING)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final SdkField<List<String>> BINARY_MEDIA_TYPES_FIELD = SdkField
            .<List<String>> builder(MarshallingType.LIST)
            .getter(getter(CreateRestApiResponse::binaryMediaTypes))
            .setter(setter(Builder::binaryMediaTypes))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("binaryMediaTypes").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<String> builder(MarshallingType.STRING)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final SdkField<Integer> MINIMUM_COMPRESSION_SIZE_FIELD = SdkField.<Integer> builder(MarshallingType.INTEGER)
            .getter(getter(CreateRestApiResponse::minimumCompressionSize)).setter(setter(Builder::minimumCompressionSize))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("minimumCompressionSize").build())
            .build();

    private static final SdkField<String> API_KEY_SOURCE_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .getter(getter(CreateRestApiResponse::apiKeySourceAsString)).setter(setter(Builder::apiKeySource))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("apiKeySource").build()).build();

    private static final SdkField<EndpointConfiguration> ENDPOINT_CONFIGURATION_FIELD = SdkField
            .<EndpointConfiguration> builder(MarshallingType.SDK_POJO)
            .getter(getter(CreateRestApiResponse::endpointConfiguration)).setter(setter(Builder::endpointConfiguration))
            .constructor(EndpointConfiguration::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("endpointConfiguration").build())
            .build();

    private static final SdkField<String> POLICY_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .getter(getter(CreateRestApiResponse::policy)).setter(setter(Builder::policy))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("policy").build()).build();

    private static final SdkField<Map<String, String>> TAGS_FIELD = SdkField
            .<Map<String, String>> builder(MarshallingType.MAP)
            .getter(getter(CreateRestApiResponse::tags))
            .setter(setter(Builder::tags))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("tags").build(),
                    MapTrait.builder()
                            .keyLocationName("key")
                            .valueLocationName("value")
                            .valueFieldInfo(
                                    SdkField.<String> builder(MarshallingType.STRING)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("value").build()).build()).build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(ID_FIELD, NAME_FIELD,
            DESCRIPTION_FIELD, CREATED_DATE_FIELD, VERSION_FIELD, WARNINGS_FIELD, BINARY_MEDIA_TYPES_FIELD,
            MINIMUM_COMPRESSION_SIZE_FIELD, API_KEY_SOURCE_FIELD, ENDPOINT_CONFIGURATION_FIELD, POLICY_FIELD, TAGS_FIELD));

    private final String id;

    private final String name;

    private final String description;

    private final Instant createdDate;

    private final String version;

    private final List<String> warnings;

    private final List<String> binaryMediaTypes;

    private final Integer minimumCompressionSize;

    private final String apiKeySource;

    private final EndpointConfiguration endpointConfiguration;

    private final String policy;

    private final Map<String, String> tags;

    private CreateRestApiResponse(BuilderImpl builder) {
        super(builder);
        this.id = builder.id;
        this.name = builder.name;
        this.description = builder.description;
        this.createdDate = builder.createdDate;
        this.version = builder.version;
        this.warnings = builder.warnings;
        this.binaryMediaTypes = builder.binaryMediaTypes;
        this.minimumCompressionSize = builder.minimumCompressionSize;
        this.apiKeySource = builder.apiKeySource;
        this.endpointConfiguration = builder.endpointConfiguration;
        this.policy = builder.policy;
        this.tags = builder.tags;
    }

    /**
     * <p>
     * The API's identifier. This identifier is unique across all of your APIs in API Gateway.
     * </p>
     * 
     * @return The API's identifier. This identifier is unique across all of your APIs in API Gateway.
     */
    public String id() {
        return id;
    }

    /**
     * <p>
     * The API's name.
     * </p>
     * 
     * @return The API's name.
     */
    public String name() {
        return name;
    }

    /**
     * <p>
     * The API's description.
     * </p>
     * 
     * @return The API's description.
     */
    public String description() {
        return description;
    }

    /**
     * <p>
     * The timestamp when the API was created.
     * </p>
     * 
     * @return The timestamp when the API was created.
     */
    public Instant createdDate() {
        return createdDate;
    }

    /**
     * <p>
     * A version identifier for the API.
     * </p>
     * 
     * @return A version identifier for the API.
     */
    public String version() {
        return version;
    }

    /**
     * <p>
     * The warning messages reported when <code>failonwarnings</code> is turned on during API import.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * 
     * @return The warning messages reported when <code>failonwarnings</code> is turned on during API import.
     */
    public List<String> warnings() {
        return warnings;
    }

    /**
     * <p>
     * The list of binary media types supported by the <a>RestApi</a>. By default, the <a>RestApi</a> supports only
     * UTF-8-encoded text payloads.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * 
     * @return The list of binary media types supported by the <a>RestApi</a>. By default, the <a>RestApi</a> supports
     *         only UTF-8-encoded text payloads.
     */
    public List<String> binaryMediaTypes() {
        return binaryMediaTypes;
    }

    /**
     * <p>
     * A nullable integer that is used to enable compression (with non-negative between 0 and 10485760 (10M) bytes,
     * inclusive) or disable compression (with a null value) on an API. When compression is enabled, compression or
     * decompression is not applied on the payload if the payload size is smaller than this value. Setting it to zero
     * allows compression for any payload size.
     * </p>
     * 
     * @return A nullable integer that is used to enable compression (with non-negative between 0 and 10485760 (10M)
     *         bytes, inclusive) or disable compression (with a null value) on an API. When compression is enabled,
     *         compression or decompression is not applied on the payload if the payload size is smaller than this
     *         value. Setting it to zero allows compression for any payload size.
     */
    public Integer minimumCompressionSize() {
        return minimumCompressionSize;
    }

    /**
     * <p>
     * The source of the API key for metering requests according to a usage plan. Valid values are:
     * <ul>
     * <li><code>HEADER</code> to read the API key from the <code>X-API-Key</code> header of a request.</li>
     * <li><code>AUTHORIZER</code> to read the API key from the <code>UsageIdentifierKey</code> from a custom
     * authorizer.</li>
     * </ul>
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #apiKeySource} will
     * return {@link ApiKeySourceType#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #apiKeySourceAsString}.
     * </p>
     * 
     * @return The source of the API key for metering requests according to a usage plan. Valid values are:
     *         <ul>
     *         <li><code>HEADER</code> to read the API key from the <code>X-API-Key</code> header of a request.</li>
     *         <li><code>AUTHORIZER</code> to read the API key from the <code>UsageIdentifierKey</code> from a custom
     *         authorizer.</li>
     *         </ul>
     * @see ApiKeySourceType
     */
    public ApiKeySourceType apiKeySource() {
        return ApiKeySourceType.fromValue(apiKeySource);
    }

    /**
     * <p>
     * The source of the API key for metering requests according to a usage plan. Valid values are:
     * <ul>
     * <li><code>HEADER</code> to read the API key from the <code>X-API-Key</code> header of a request.</li>
     * <li><code>AUTHORIZER</code> to read the API key from the <code>UsageIdentifierKey</code> from a custom
     * authorizer.</li>
     * </ul>
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #apiKeySource} will
     * return {@link ApiKeySourceType#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #apiKeySourceAsString}.
     * </p>
     * 
     * @return The source of the API key for metering requests according to a usage plan. Valid values are:
     *         <ul>
     *         <li><code>HEADER</code> to read the API key from the <code>X-API-Key</code> header of a request.</li>
     *         <li><code>AUTHORIZER</code> to read the API key from the <code>UsageIdentifierKey</code> from a custom
     *         authorizer.</li>
     *         </ul>
     * @see ApiKeySourceType
     */
    public String apiKeySourceAsString() {
        return apiKeySource;
    }

    /**
     * <p>
     * The endpoint configuration of this <a>RestApi</a> showing the endpoint types of the API.
     * </p>
     * 
     * @return The endpoint configuration of this <a>RestApi</a> showing the endpoint types of the API.
     */
    public EndpointConfiguration endpointConfiguration() {
        return endpointConfiguration;
    }

    /**
     * A stringified JSON policy document that applies to this RestApi regardless of the caller and <a>Method</a>
     * configuration.
     * 
     * @return A stringified JSON policy document that applies to this RestApi regardless of the caller and
     *         <a>Method</a> configuration.
     */
    public String policy() {
        return policy;
    }

    /**
     * <p>
     * The collection of tags. Each tag element is associated with a given resource.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * 
     * @return The collection of tags. Each tag element is associated with a given resource.
     */
    public Map<String, String> tags() {
        return tags;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(id());
        hashCode = 31 * hashCode + Objects.hashCode(name());
        hashCode = 31 * hashCode + Objects.hashCode(description());
        hashCode = 31 * hashCode + Objects.hashCode(createdDate());
        hashCode = 31 * hashCode + Objects.hashCode(version());
        hashCode = 31 * hashCode + Objects.hashCode(warnings());
        hashCode = 31 * hashCode + Objects.hashCode(binaryMediaTypes());
        hashCode = 31 * hashCode + Objects.hashCode(minimumCompressionSize());
        hashCode = 31 * hashCode + Objects.hashCode(apiKeySourceAsString());
        hashCode = 31 * hashCode + Objects.hashCode(endpointConfiguration());
        hashCode = 31 * hashCode + Objects.hashCode(policy());
        hashCode = 31 * hashCode + Objects.hashCode(tags());
        return hashCode;
    }

    @Override
    public boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof CreateRestApiResponse)) {
            return false;
        }
        CreateRestApiResponse other = (CreateRestApiResponse) obj;
        return Objects.equals(id(), other.id()) && Objects.equals(name(), other.name())
                && Objects.equals(description(), other.description()) && Objects.equals(createdDate(), other.createdDate())
                && Objects.equals(version(), other.version()) && Objects.equals(warnings(), other.warnings())
                && Objects.equals(binaryMediaTypes(), other.binaryMediaTypes())
                && Objects.equals(minimumCompressionSize(), other.minimumCompressionSize())
                && Objects.equals(apiKeySourceAsString(), other.apiKeySourceAsString())
                && Objects.equals(endpointConfiguration(), other.endpointConfiguration())
                && Objects.equals(policy(), other.policy()) && Objects.equals(tags(), other.tags());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public String toString() {
        return ToString.builder("CreateRestApiResponse").add("Id", id()).add("Name", name()).add("Description", description())
                .add("CreatedDate", createdDate()).add("Version", version()).add("Warnings", warnings())
                .add("BinaryMediaTypes", binaryMediaTypes()).add("MinimumCompressionSize", minimumCompressionSize())
                .add("ApiKeySource", apiKeySourceAsString()).add("EndpointConfiguration", endpointConfiguration())
                .add("Policy", policy()).add("Tags", tags()).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "id":
            return Optional.ofNullable(clazz.cast(id()));
        case "name":
            return Optional.ofNullable(clazz.cast(name()));
        case "description":
            return Optional.ofNullable(clazz.cast(description()));
        case "createdDate":
            return Optional.ofNullable(clazz.cast(createdDate()));
        case "version":
            return Optional.ofNullable(clazz.cast(version()));
        case "warnings":
            return Optional.ofNullable(clazz.cast(warnings()));
        case "binaryMediaTypes":
            return Optional.ofNullable(clazz.cast(binaryMediaTypes()));
        case "minimumCompressionSize":
            return Optional.ofNullable(clazz.cast(minimumCompressionSize()));
        case "apiKeySource":
            return Optional.ofNullable(clazz.cast(apiKeySourceAsString()));
        case "endpointConfiguration":
            return Optional.ofNullable(clazz.cast(endpointConfiguration()));
        case "policy":
            return Optional.ofNullable(clazz.cast(policy()));
        case "tags":
            return Optional.ofNullable(clazz.cast(tags()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<CreateRestApiResponse, T> g) {
        return obj -> g.apply((CreateRestApiResponse) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends ApiGatewayResponse.Builder, SdkPojo, CopyableBuilder<Builder, CreateRestApiResponse> {
        /**
         * <p>
         * The API's identifier. This identifier is unique across all of your APIs in API Gateway.
         * </p>
         * 
         * @param id
         *        The API's identifier. This identifier is unique across all of your APIs in API Gateway.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder id(String id);

        /**
         * <p>
         * The API's name.
         * </p>
         * 
         * @param name
         *        The API's name.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder name(String name);

        /**
         * <p>
         * The API's description.
         * </p>
         * 
         * @param description
         *        The API's description.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder description(String description);

        /**
         * <p>
         * The timestamp when the API was created.
         * </p>
         * 
         * @param createdDate
         *        The timestamp when the API was created.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder createdDate(Instant createdDate);

        /**
         * <p>
         * A version identifier for the API.
         * </p>
         * 
         * @param version
         *        A version identifier for the API.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder version(String version);

        /**
         * <p>
         * The warning messages reported when <code>failonwarnings</code> is turned on during API import.
         * </p>
         * 
         * @param warnings
         *        The warning messages reported when <code>failonwarnings</code> is turned on during API import.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder warnings(Collection<String> warnings);

        /**
         * <p>
         * The warning messages reported when <code>failonwarnings</code> is turned on during API import.
         * </p>
         * 
         * @param warnings
         *        The warning messages reported when <code>failonwarnings</code> is turned on during API import.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder warnings(String... warnings);

        /**
         * <p>
         * The list of binary media types supported by the <a>RestApi</a>. By default, the <a>RestApi</a> supports only
         * UTF-8-encoded text payloads.
         * </p>
         * 
         * @param binaryMediaTypes
         *        The list of binary media types supported by the <a>RestApi</a>. By default, the <a>RestApi</a>
         *        supports only UTF-8-encoded text payloads.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder binaryMediaTypes(Collection<String> binaryMediaTypes);

        /**
         * <p>
         * The list of binary media types supported by the <a>RestApi</a>. By default, the <a>RestApi</a> supports only
         * UTF-8-encoded text payloads.
         * </p>
         * 
         * @param binaryMediaTypes
         *        The list of binary media types supported by the <a>RestApi</a>. By default, the <a>RestApi</a>
         *        supports only UTF-8-encoded text payloads.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder binaryMediaTypes(String... binaryMediaTypes);

        /**
         * <p>
         * A nullable integer that is used to enable compression (with non-negative between 0 and 10485760 (10M) bytes,
         * inclusive) or disable compression (with a null value) on an API. When compression is enabled, compression or
         * decompression is not applied on the payload if the payload size is smaller than this value. Setting it to
         * zero allows compression for any payload size.
         * </p>
         * 
         * @param minimumCompressionSize
         *        A nullable integer that is used to enable compression (with non-negative between 0 and 10485760 (10M)
         *        bytes, inclusive) or disable compression (with a null value) on an API. When compression is enabled,
         *        compression or decompression is not applied on the payload if the payload size is smaller than this
         *        value. Setting it to zero allows compression for any payload size.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder minimumCompressionSize(Integer minimumCompressionSize);

        /**
         * <p>
         * The source of the API key for metering requests according to a usage plan. Valid values are:
         * <ul>
         * <li><code>HEADER</code> to read the API key from the <code>X-API-Key</code> header of a request.</li>
         * <li><code>AUTHORIZER</code> to read the API key from the <code>UsageIdentifierKey</code> from a custom
         * authorizer.</li>
         * </ul>
         * </p>
         * 
         * @param apiKeySource
         *        The source of the API key for metering requests according to a usage plan. Valid values are:
         *        <ul>
         *        <li><code>HEADER</code> to read the API key from the <code>X-API-Key</code> header of a request.</li>
         *        <li><code>AUTHORIZER</code> to read the API key from the <code>UsageIdentifierKey</code> from a custom
         *        authorizer.</li>
         *        </ul>
         * @see ApiKeySourceType
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see ApiKeySourceType
         */
        Builder apiKeySource(String apiKeySource);

        /**
         * <p>
         * The source of the API key for metering requests according to a usage plan. Valid values are:
         * <ul>
         * <li><code>HEADER</code> to read the API key from the <code>X-API-Key</code> header of a request.</li>
         * <li><code>AUTHORIZER</code> to read the API key from the <code>UsageIdentifierKey</code> from a custom
         * authorizer.</li>
         * </ul>
         * </p>
         * 
         * @param apiKeySource
         *        The source of the API key for metering requests according to a usage plan. Valid values are:
         *        <ul>
         *        <li><code>HEADER</code> to read the API key from the <code>X-API-Key</code> header of a request.</li>
         *        <li><code>AUTHORIZER</code> to read the API key from the <code>UsageIdentifierKey</code> from a custom
         *        authorizer.</li>
         *        </ul>
         * @see ApiKeySourceType
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see ApiKeySourceType
         */
        Builder apiKeySource(ApiKeySourceType apiKeySource);

        /**
         * <p>
         * The endpoint configuration of this <a>RestApi</a> showing the endpoint types of the API.
         * </p>
         * 
         * @param endpointConfiguration
         *        The endpoint configuration of this <a>RestApi</a> showing the endpoint types of the API.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder endpointConfiguration(EndpointConfiguration endpointConfiguration);

        /**
         * <p>
         * The endpoint configuration of this <a>RestApi</a> showing the endpoint types of the API.
         * </p>
         * This is a convenience that creates an instance of the {@link EndpointConfiguration.Builder} avoiding the need
         * to create one manually via {@link EndpointConfiguration#builder()}.
         *
         * When the {@link Consumer} completes, {@link EndpointConfiguration.Builder#build()} is called immediately and
         * its result is passed to {@link #endpointConfiguration(EndpointConfiguration)}.
         * 
         * @param endpointConfiguration
         *        a consumer that will call methods on {@link EndpointConfiguration.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #endpointConfiguration(EndpointConfiguration)
         */
        default Builder endpointConfiguration(Consumer<EndpointConfiguration.Builder> endpointConfiguration) {
            return endpointConfiguration(EndpointConfiguration.builder().applyMutation(endpointConfiguration).build());
        }

        /**
         * A stringified JSON policy document that applies to this RestApi regardless of the caller and <a>Method</a>
         * configuration.
         * 
         * @param policy
         *        A stringified JSON policy document that applies to this RestApi regardless of the caller and
         *        <a>Method</a> configuration.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder policy(String policy);

        /**
         * <p>
         * The collection of tags. Each tag element is associated with a given resource.
         * </p>
         * 
         * @param tags
         *        The collection of tags. Each tag element is associated with a given resource.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder tags(Map<String, String> tags);
    }

    static final class BuilderImpl extends ApiGatewayResponse.BuilderImpl implements Builder {
        private String id;

        private String name;

        private String description;

        private Instant createdDate;

        private String version;

        private List<String> warnings = DefaultSdkAutoConstructList.getInstance();

        private List<String> binaryMediaTypes = DefaultSdkAutoConstructList.getInstance();

        private Integer minimumCompressionSize;

        private String apiKeySource;

        private EndpointConfiguration endpointConfiguration;

        private String policy;

        private Map<String, String> tags = DefaultSdkAutoConstructMap.getInstance();

        private BuilderImpl() {
        }

        private BuilderImpl(CreateRestApiResponse model) {
            super(model);
            id(model.id);
            name(model.name);
            description(model.description);
            createdDate(model.createdDate);
            version(model.version);
            warnings(model.warnings);
            binaryMediaTypes(model.binaryMediaTypes);
            minimumCompressionSize(model.minimumCompressionSize);
            apiKeySource(model.apiKeySource);
            endpointConfiguration(model.endpointConfiguration);
            policy(model.policy);
            tags(model.tags);
        }

        public final String getId() {
            return id;
        }

        @Override
        public final Builder id(String id) {
            this.id = id;
            return this;
        }

        public final void setId(String id) {
            this.id = id;
        }

        public final String getName() {
            return name;
        }

        @Override
        public final Builder name(String name) {
            this.name = name;
            return this;
        }

        public final void setName(String name) {
            this.name = name;
        }

        public final String getDescription() {
            return description;
        }

        @Override
        public final Builder description(String description) {
            this.description = description;
            return this;
        }

        public final void setDescription(String description) {
            this.description = description;
        }

        public final Instant getCreatedDate() {
            return createdDate;
        }

        @Override
        public final Builder createdDate(Instant createdDate) {
            this.createdDate = createdDate;
            return this;
        }

        public final void setCreatedDate(Instant createdDate) {
            this.createdDate = createdDate;
        }

        public final String getVersion() {
            return version;
        }

        @Override
        public final Builder version(String version) {
            this.version = version;
            return this;
        }

        public final void setVersion(String version) {
            this.version = version;
        }

        public final Collection<String> getWarnings() {
            return warnings;
        }

        @Override
        public final Builder warnings(Collection<String> warnings) {
            this.warnings = ListOfStringCopier.copy(warnings);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder warnings(String... warnings) {
            warnings(Arrays.asList(warnings));
            return this;
        }

        public final void setWarnings(Collection<String> warnings) {
            this.warnings = ListOfStringCopier.copy(warnings);
        }

        public final Collection<String> getBinaryMediaTypes() {
            return binaryMediaTypes;
        }

        @Override
        public final Builder binaryMediaTypes(Collection<String> binaryMediaTypes) {
            this.binaryMediaTypes = ListOfStringCopier.copy(binaryMediaTypes);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder binaryMediaTypes(String... binaryMediaTypes) {
            binaryMediaTypes(Arrays.asList(binaryMediaTypes));
            return this;
        }

        public final void setBinaryMediaTypes(Collection<String> binaryMediaTypes) {
            this.binaryMediaTypes = ListOfStringCopier.copy(binaryMediaTypes);
        }

        public final Integer getMinimumCompressionSize() {
            return minimumCompressionSize;
        }

        @Override
        public final Builder minimumCompressionSize(Integer minimumCompressionSize) {
            this.minimumCompressionSize = minimumCompressionSize;
            return this;
        }

        public final void setMinimumCompressionSize(Integer minimumCompressionSize) {
            this.minimumCompressionSize = minimumCompressionSize;
        }

        public final String getApiKeySourceAsString() {
            return apiKeySource;
        }

        @Override
        public final Builder apiKeySource(String apiKeySource) {
            this.apiKeySource = apiKeySource;
            return this;
        }

        @Override
        public final Builder apiKeySource(ApiKeySourceType apiKeySource) {
            this.apiKeySource(apiKeySource == null ? null : apiKeySource.toString());
            return this;
        }

        public final void setApiKeySource(String apiKeySource) {
            this.apiKeySource = apiKeySource;
        }

        public final EndpointConfiguration.Builder getEndpointConfiguration() {
            return endpointConfiguration != null ? endpointConfiguration.toBuilder() : null;
        }

        @Override
        public final Builder endpointConfiguration(EndpointConfiguration endpointConfiguration) {
            this.endpointConfiguration = endpointConfiguration;
            return this;
        }

        public final void setEndpointConfiguration(EndpointConfiguration.BuilderImpl endpointConfiguration) {
            this.endpointConfiguration = endpointConfiguration != null ? endpointConfiguration.build() : null;
        }

        public final String getPolicy() {
            return policy;
        }

        @Override
        public final Builder policy(String policy) {
            this.policy = policy;
            return this;
        }

        public final void setPolicy(String policy) {
            this.policy = policy;
        }

        public final Map<String, String> getTags() {
            return tags;
        }

        @Override
        public final Builder tags(Map<String, String> tags) {
            this.tags = MapOfStringToStringCopier.copy(tags);
            return this;
        }

        public final void setTags(Map<String, String> tags) {
            this.tags = MapOfStringToStringCopier.copy(tags);
        }

        @Override
        public CreateRestApiResponse build() {
            return new CreateRestApiResponse(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
