/*
 * Copyright 2014-2019 Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.apigateway.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.MapTrait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructMap;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * Make a request to simulate the execution of an <a>Authorizer</a>.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class TestInvokeAuthorizerRequest extends ApiGatewayRequest implements
        ToCopyableBuilder<TestInvokeAuthorizerRequest.Builder, TestInvokeAuthorizerRequest> {
    private static final SdkField<String> REST_API_ID_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .getter(getter(TestInvokeAuthorizerRequest::restApiId)).setter(setter(Builder::restApiId))
            .traits(LocationTrait.builder().location(MarshallLocation.PATH).locationName("restapi_id").build()).build();

    private static final SdkField<String> AUTHORIZER_ID_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .getter(getter(TestInvokeAuthorizerRequest::authorizerId)).setter(setter(Builder::authorizerId))
            .traits(LocationTrait.builder().location(MarshallLocation.PATH).locationName("authorizer_id").build()).build();

    private static final SdkField<Map<String, String>> HEADERS_FIELD = SdkField
            .<Map<String, String>> builder(MarshallingType.MAP)
            .getter(getter(TestInvokeAuthorizerRequest::headers))
            .setter(setter(Builder::headers))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("headers").build(),
                    MapTrait.builder()
                            .keyLocationName("key")
                            .valueLocationName("value")
                            .valueFieldInfo(
                                    SdkField.<String> builder(MarshallingType.STRING)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("value").build()).build()).build()).build();

    private static final SdkField<Map<String, List<String>>> MULTI_VALUE_HEADERS_FIELD = SdkField
            .<Map<String, List<String>>> builder(MarshallingType.MAP)
            .getter(getter(TestInvokeAuthorizerRequest::multiValueHeaders))
            .setter(setter(Builder::multiValueHeaders))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("multiValueHeaders").build(),
                    MapTrait.builder()
                            .keyLocationName("key")
                            .valueLocationName("value")
                            .valueFieldInfo(
                                    SdkField.<List<String>> builder(MarshallingType.LIST)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("value").build(),
                                                    ListTrait
                                                            .builder()
                                                            .memberLocationName(null)
                                                            .memberFieldInfo(
                                                                    SdkField.<String> builder(MarshallingType.STRING)
                                                                            .traits(LocationTrait.builder()
                                                                                    .location(MarshallLocation.PAYLOAD)
                                                                                    .locationName("member").build()).build())
                                                            .build()).build()).build()).build();

    private static final SdkField<String> PATH_WITH_QUERY_STRING_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .getter(getter(TestInvokeAuthorizerRequest::pathWithQueryString)).setter(setter(Builder::pathWithQueryString))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("pathWithQueryString").build())
            .build();

    private static final SdkField<String> BODY_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .getter(getter(TestInvokeAuthorizerRequest::body)).setter(setter(Builder::body))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("body").build()).build();

    private static final SdkField<Map<String, String>> STAGE_VARIABLES_FIELD = SdkField
            .<Map<String, String>> builder(MarshallingType.MAP)
            .getter(getter(TestInvokeAuthorizerRequest::stageVariables))
            .setter(setter(Builder::stageVariables))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("stageVariables").build(),
                    MapTrait.builder()
                            .keyLocationName("key")
                            .valueLocationName("value")
                            .valueFieldInfo(
                                    SdkField.<String> builder(MarshallingType.STRING)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("value").build()).build()).build()).build();

    private static final SdkField<Map<String, String>> ADDITIONAL_CONTEXT_FIELD = SdkField
            .<Map<String, String>> builder(MarshallingType.MAP)
            .getter(getter(TestInvokeAuthorizerRequest::additionalContext))
            .setter(setter(Builder::additionalContext))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("additionalContext").build(),
                    MapTrait.builder()
                            .keyLocationName("key")
                            .valueLocationName("value")
                            .valueFieldInfo(
                                    SdkField.<String> builder(MarshallingType.STRING)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("value").build()).build()).build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(REST_API_ID_FIELD,
            AUTHORIZER_ID_FIELD, HEADERS_FIELD, MULTI_VALUE_HEADERS_FIELD, PATH_WITH_QUERY_STRING_FIELD, BODY_FIELD,
            STAGE_VARIABLES_FIELD, ADDITIONAL_CONTEXT_FIELD));

    private final String restApiId;

    private final String authorizerId;

    private final Map<String, String> headers;

    private final Map<String, List<String>> multiValueHeaders;

    private final String pathWithQueryString;

    private final String body;

    private final Map<String, String> stageVariables;

    private final Map<String, String> additionalContext;

    private TestInvokeAuthorizerRequest(BuilderImpl builder) {
        super(builder);
        this.restApiId = builder.restApiId;
        this.authorizerId = builder.authorizerId;
        this.headers = builder.headers;
        this.multiValueHeaders = builder.multiValueHeaders;
        this.pathWithQueryString = builder.pathWithQueryString;
        this.body = builder.body;
        this.stageVariables = builder.stageVariables;
        this.additionalContext = builder.additionalContext;
    }

    /**
     * <p>
     * [Required] The string identifier of the associated <a>RestApi</a>.
     * </p>
     * 
     * @return [Required] The string identifier of the associated <a>RestApi</a>.
     */
    public String restApiId() {
        return restApiId;
    }

    /**
     * <p>
     * [Required] Specifies a test invoke authorizer request's <a>Authorizer</a> ID.
     * </p>
     * 
     * @return [Required] Specifies a test invoke authorizer request's <a>Authorizer</a> ID.
     */
    public String authorizerId() {
        return authorizerId;
    }

    /**
     * <p>
     * [Required] A key-value map of headers to simulate an incoming invocation request. This is where the incoming
     * authorization token, or identity source, should be specified.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * 
     * @return [Required] A key-value map of headers to simulate an incoming invocation request. This is where the
     *         incoming authorization token, or identity source, should be specified.
     */
    public Map<String, String> headers() {
        return headers;
    }

    /**
     * <p>
     * [Optional] The headers as a map from string to list of values to simulate an incoming invocation request. This is
     * where the incoming authorization token, or identity source, may be specified.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * 
     * @return [Optional] The headers as a map from string to list of values to simulate an incoming invocation request.
     *         This is where the incoming authorization token, or identity source, may be specified.
     */
    public Map<String, List<String>> multiValueHeaders() {
        return multiValueHeaders;
    }

    /**
     * <p>
     * [Optional] The URI path, including query string, of the simulated invocation request. Use this to specify path
     * parameters and query string parameters.
     * </p>
     * 
     * @return [Optional] The URI path, including query string, of the simulated invocation request. Use this to specify
     *         path parameters and query string parameters.
     */
    public String pathWithQueryString() {
        return pathWithQueryString;
    }

    /**
     * <p>
     * [Optional] The simulated request body of an incoming invocation request.
     * </p>
     * 
     * @return [Optional] The simulated request body of an incoming invocation request.
     */
    public String body() {
        return body;
    }

    /**
     * <p>
     * A key-value map of stage variables to simulate an invocation on a deployed <a>Stage</a>.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * 
     * @return A key-value map of stage variables to simulate an invocation on a deployed <a>Stage</a>.
     */
    public Map<String, String> stageVariables() {
        return stageVariables;
    }

    /**
     * <p>
     * [Optional] A key-value map of additional context variables.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * 
     * @return [Optional] A key-value map of additional context variables.
     */
    public Map<String, String> additionalContext() {
        return additionalContext;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(restApiId());
        hashCode = 31 * hashCode + Objects.hashCode(authorizerId());
        hashCode = 31 * hashCode + Objects.hashCode(headers());
        hashCode = 31 * hashCode + Objects.hashCode(multiValueHeaders());
        hashCode = 31 * hashCode + Objects.hashCode(pathWithQueryString());
        hashCode = 31 * hashCode + Objects.hashCode(body());
        hashCode = 31 * hashCode + Objects.hashCode(stageVariables());
        hashCode = 31 * hashCode + Objects.hashCode(additionalContext());
        return hashCode;
    }

    @Override
    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof TestInvokeAuthorizerRequest)) {
            return false;
        }
        TestInvokeAuthorizerRequest other = (TestInvokeAuthorizerRequest) obj;
        return Objects.equals(restApiId(), other.restApiId()) && Objects.equals(authorizerId(), other.authorizerId())
                && Objects.equals(headers(), other.headers()) && Objects.equals(multiValueHeaders(), other.multiValueHeaders())
                && Objects.equals(pathWithQueryString(), other.pathWithQueryString()) && Objects.equals(body(), other.body())
                && Objects.equals(stageVariables(), other.stageVariables())
                && Objects.equals(additionalContext(), other.additionalContext());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public String toString() {
        return ToString.builder("TestInvokeAuthorizerRequest").add("RestApiId", restApiId()).add("AuthorizerId", authorizerId())
                .add("Headers", headers()).add("MultiValueHeaders", multiValueHeaders())
                .add("PathWithQueryString", pathWithQueryString()).add("Body", body()).add("StageVariables", stageVariables())
                .add("AdditionalContext", additionalContext()).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "restApiId":
            return Optional.ofNullable(clazz.cast(restApiId()));
        case "authorizerId":
            return Optional.ofNullable(clazz.cast(authorizerId()));
        case "headers":
            return Optional.ofNullable(clazz.cast(headers()));
        case "multiValueHeaders":
            return Optional.ofNullable(clazz.cast(multiValueHeaders()));
        case "pathWithQueryString":
            return Optional.ofNullable(clazz.cast(pathWithQueryString()));
        case "body":
            return Optional.ofNullable(clazz.cast(body()));
        case "stageVariables":
            return Optional.ofNullable(clazz.cast(stageVariables()));
        case "additionalContext":
            return Optional.ofNullable(clazz.cast(additionalContext()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<TestInvokeAuthorizerRequest, T> g) {
        return obj -> g.apply((TestInvokeAuthorizerRequest) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends ApiGatewayRequest.Builder, SdkPojo, CopyableBuilder<Builder, TestInvokeAuthorizerRequest> {
        /**
         * <p>
         * [Required] The string identifier of the associated <a>RestApi</a>.
         * </p>
         * 
         * @param restApiId
         *        [Required] The string identifier of the associated <a>RestApi</a>.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder restApiId(String restApiId);

        /**
         * <p>
         * [Required] Specifies a test invoke authorizer request's <a>Authorizer</a> ID.
         * </p>
         * 
         * @param authorizerId
         *        [Required] Specifies a test invoke authorizer request's <a>Authorizer</a> ID.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder authorizerId(String authorizerId);

        /**
         * <p>
         * [Required] A key-value map of headers to simulate an incoming invocation request. This is where the incoming
         * authorization token, or identity source, should be specified.
         * </p>
         * 
         * @param headers
         *        [Required] A key-value map of headers to simulate an incoming invocation request. This is where the
         *        incoming authorization token, or identity source, should be specified.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder headers(Map<String, String> headers);

        /**
         * <p>
         * [Optional] The headers as a map from string to list of values to simulate an incoming invocation request.
         * This is where the incoming authorization token, or identity source, may be specified.
         * </p>
         * 
         * @param multiValueHeaders
         *        [Optional] The headers as a map from string to list of values to simulate an incoming invocation
         *        request. This is where the incoming authorization token, or identity source, may be specified.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder multiValueHeaders(Map<String, ? extends Collection<String>> multiValueHeaders);

        /**
         * <p>
         * [Optional] The URI path, including query string, of the simulated invocation request. Use this to specify
         * path parameters and query string parameters.
         * </p>
         * 
         * @param pathWithQueryString
         *        [Optional] The URI path, including query string, of the simulated invocation request. Use this to
         *        specify path parameters and query string parameters.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder pathWithQueryString(String pathWithQueryString);

        /**
         * <p>
         * [Optional] The simulated request body of an incoming invocation request.
         * </p>
         * 
         * @param body
         *        [Optional] The simulated request body of an incoming invocation request.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder body(String body);

        /**
         * <p>
         * A key-value map of stage variables to simulate an invocation on a deployed <a>Stage</a>.
         * </p>
         * 
         * @param stageVariables
         *        A key-value map of stage variables to simulate an invocation on a deployed <a>Stage</a>.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder stageVariables(Map<String, String> stageVariables);

        /**
         * <p>
         * [Optional] A key-value map of additional context variables.
         * </p>
         * 
         * @param additionalContext
         *        [Optional] A key-value map of additional context variables.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder additionalContext(Map<String, String> additionalContext);

        @Override
        Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration);

        @Override
        Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer);
    }

    static final class BuilderImpl extends ApiGatewayRequest.BuilderImpl implements Builder {
        private String restApiId;

        private String authorizerId;

        private Map<String, String> headers = DefaultSdkAutoConstructMap.getInstance();

        private Map<String, List<String>> multiValueHeaders = DefaultSdkAutoConstructMap.getInstance();

        private String pathWithQueryString;

        private String body;

        private Map<String, String> stageVariables = DefaultSdkAutoConstructMap.getInstance();

        private Map<String, String> additionalContext = DefaultSdkAutoConstructMap.getInstance();

        private BuilderImpl() {
        }

        private BuilderImpl(TestInvokeAuthorizerRequest model) {
            super(model);
            restApiId(model.restApiId);
            authorizerId(model.authorizerId);
            headers(model.headers);
            multiValueHeaders(model.multiValueHeaders);
            pathWithQueryString(model.pathWithQueryString);
            body(model.body);
            stageVariables(model.stageVariables);
            additionalContext(model.additionalContext);
        }

        public final String getRestApiId() {
            return restApiId;
        }

        @Override
        public final Builder restApiId(String restApiId) {
            this.restApiId = restApiId;
            return this;
        }

        public final void setRestApiId(String restApiId) {
            this.restApiId = restApiId;
        }

        public final String getAuthorizerId() {
            return authorizerId;
        }

        @Override
        public final Builder authorizerId(String authorizerId) {
            this.authorizerId = authorizerId;
            return this;
        }

        public final void setAuthorizerId(String authorizerId) {
            this.authorizerId = authorizerId;
        }

        public final Map<String, String> getHeaders() {
            return headers;
        }

        @Override
        public final Builder headers(Map<String, String> headers) {
            this.headers = MapOfStringToStringCopier.copy(headers);
            return this;
        }

        public final void setHeaders(Map<String, String> headers) {
            this.headers = MapOfStringToStringCopier.copy(headers);
        }

        public final Map<String, ? extends Collection<String>> getMultiValueHeaders() {
            return multiValueHeaders;
        }

        @Override
        public final Builder multiValueHeaders(Map<String, ? extends Collection<String>> multiValueHeaders) {
            this.multiValueHeaders = MapOfStringToListCopier.copy(multiValueHeaders);
            return this;
        }

        public final void setMultiValueHeaders(Map<String, ? extends Collection<String>> multiValueHeaders) {
            this.multiValueHeaders = MapOfStringToListCopier.copy(multiValueHeaders);
        }

        public final String getPathWithQueryString() {
            return pathWithQueryString;
        }

        @Override
        public final Builder pathWithQueryString(String pathWithQueryString) {
            this.pathWithQueryString = pathWithQueryString;
            return this;
        }

        public final void setPathWithQueryString(String pathWithQueryString) {
            this.pathWithQueryString = pathWithQueryString;
        }

        public final String getBody() {
            return body;
        }

        @Override
        public final Builder body(String body) {
            this.body = body;
            return this;
        }

        public final void setBody(String body) {
            this.body = body;
        }

        public final Map<String, String> getStageVariables() {
            return stageVariables;
        }

        @Override
        public final Builder stageVariables(Map<String, String> stageVariables) {
            this.stageVariables = MapOfStringToStringCopier.copy(stageVariables);
            return this;
        }

        public final void setStageVariables(Map<String, String> stageVariables) {
            this.stageVariables = MapOfStringToStringCopier.copy(stageVariables);
        }

        public final Map<String, String> getAdditionalContext() {
            return additionalContext;
        }

        @Override
        public final Builder additionalContext(Map<String, String> additionalContext) {
            this.additionalContext = MapOfStringToStringCopier.copy(additionalContext);
            return this;
        }

        public final void setAdditionalContext(Map<String, String> additionalContext) {
            this.additionalContext = MapOfStringToStringCopier.copy(additionalContext);
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public TestInvokeAuthorizerRequest build() {
            return new TestInvokeAuthorizerRequest(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
