/*
 * Copyright 2014-2019 Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.apigateway.model;

import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.MapTrait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructMap;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * Request a new generated client SDK for a <a>RestApi</a> and <a>Stage</a>.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class GetSdkRequest extends ApiGatewayRequest implements ToCopyableBuilder<GetSdkRequest.Builder, GetSdkRequest> {
    private static final SdkField<String> REST_API_ID_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .getter(getter(GetSdkRequest::restApiId)).setter(setter(Builder::restApiId))
            .traits(LocationTrait.builder().location(MarshallLocation.PATH).locationName("restapi_id").build()).build();

    private static final SdkField<String> STAGE_NAME_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .getter(getter(GetSdkRequest::stageName)).setter(setter(Builder::stageName))
            .traits(LocationTrait.builder().location(MarshallLocation.PATH).locationName("stage_name").build()).build();

    private static final SdkField<String> SDK_TYPE_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .getter(getter(GetSdkRequest::sdkType)).setter(setter(Builder::sdkType))
            .traits(LocationTrait.builder().location(MarshallLocation.PATH).locationName("sdk_type").build()).build();

    private static final SdkField<Map<String, String>> PARAMETERS_FIELD = SdkField
            .<Map<String, String>> builder(MarshallingType.MAP)
            .getter(getter(GetSdkRequest::parameters))
            .setter(setter(Builder::parameters))
            .traits(LocationTrait.builder().location(MarshallLocation.QUERY_PARAM).locationName("parameters").build(),
                    MapTrait.builder()
                            .keyLocationName("key")
                            .valueLocationName("value")
                            .valueFieldInfo(
                                    SdkField.<String> builder(MarshallingType.STRING)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("value").build()).build()).build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(REST_API_ID_FIELD,
            STAGE_NAME_FIELD, SDK_TYPE_FIELD, PARAMETERS_FIELD));

    private final String restApiId;

    private final String stageName;

    private final String sdkType;

    private final Map<String, String> parameters;

    private GetSdkRequest(BuilderImpl builder) {
        super(builder);
        this.restApiId = builder.restApiId;
        this.stageName = builder.stageName;
        this.sdkType = builder.sdkType;
        this.parameters = builder.parameters;
    }

    /**
     * <p>
     * [Required] The string identifier of the associated <a>RestApi</a>.
     * </p>
     * 
     * @return [Required] The string identifier of the associated <a>RestApi</a>.
     */
    public String restApiId() {
        return restApiId;
    }

    /**
     * <p>
     * [Required] The name of the <a>Stage</a> that the SDK will use.
     * </p>
     * 
     * @return [Required] The name of the <a>Stage</a> that the SDK will use.
     */
    public String stageName() {
        return stageName;
    }

    /**
     * <p>
     * [Required] The language for the generated SDK. Currently <code>java</code>, <code>javascript</code>,
     * <code>android</code>, <code>objectivec</code> (for iOS), <code>swift</code> (for iOS), and <code>ruby</code> are
     * supported.
     * </p>
     * 
     * @return [Required] The language for the generated SDK. Currently <code>java</code>, <code>javascript</code>,
     *         <code>android</code>, <code>objectivec</code> (for iOS), <code>swift</code> (for iOS), and
     *         <code>ruby</code> are supported.
     */
    public String sdkType() {
        return sdkType;
    }

    /**
     * <p>
     * A string-to-string key-value map of query parameters <code>sdkType</code>-dependent properties of the SDK. For
     * <code>sdkType</code> of <code>objectivec</code> or <code>swift</code>, a parameter named <code>classPrefix</code>
     * is required. For <code>sdkType</code> of <code>android</code>, parameters named <code>groupId</code>,
     * <code>artifactId</code>, <code>artifactVersion</code>, and <code>invokerPackage</code> are required. For
     * <code>sdkType</code> of <code>java</code>, parameters named <code>serviceName</code> and
     * <code>javaPackageName</code> are required.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * 
     * @return A string-to-string key-value map of query parameters <code>sdkType</code>-dependent properties of the
     *         SDK. For <code>sdkType</code> of <code>objectivec</code> or <code>swift</code>, a parameter named
     *         <code>classPrefix</code> is required. For <code>sdkType</code> of <code>android</code>, parameters named
     *         <code>groupId</code>, <code>artifactId</code>, <code>artifactVersion</code>, and
     *         <code>invokerPackage</code> are required. For <code>sdkType</code> of <code>java</code>, parameters named
     *         <code>serviceName</code> and <code>javaPackageName</code> are required.
     */
    public Map<String, String> parameters() {
        return parameters;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(restApiId());
        hashCode = 31 * hashCode + Objects.hashCode(stageName());
        hashCode = 31 * hashCode + Objects.hashCode(sdkType());
        hashCode = 31 * hashCode + Objects.hashCode(parameters());
        return hashCode;
    }

    @Override
    public boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof GetSdkRequest)) {
            return false;
        }
        GetSdkRequest other = (GetSdkRequest) obj;
        return Objects.equals(restApiId(), other.restApiId()) && Objects.equals(stageName(), other.stageName())
                && Objects.equals(sdkType(), other.sdkType()) && Objects.equals(parameters(), other.parameters());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public String toString() {
        return ToString.builder("GetSdkRequest").add("RestApiId", restApiId()).add("StageName", stageName())
                .add("SdkType", sdkType()).add("Parameters", parameters()).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "restApiId":
            return Optional.ofNullable(clazz.cast(restApiId()));
        case "stageName":
            return Optional.ofNullable(clazz.cast(stageName()));
        case "sdkType":
            return Optional.ofNullable(clazz.cast(sdkType()));
        case "parameters":
            return Optional.ofNullable(clazz.cast(parameters()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<GetSdkRequest, T> g) {
        return obj -> g.apply((GetSdkRequest) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends ApiGatewayRequest.Builder, SdkPojo, CopyableBuilder<Builder, GetSdkRequest> {
        /**
         * <p>
         * [Required] The string identifier of the associated <a>RestApi</a>.
         * </p>
         * 
         * @param restApiId
         *        [Required] The string identifier of the associated <a>RestApi</a>.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder restApiId(String restApiId);

        /**
         * <p>
         * [Required] The name of the <a>Stage</a> that the SDK will use.
         * </p>
         * 
         * @param stageName
         *        [Required] The name of the <a>Stage</a> that the SDK will use.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder stageName(String stageName);

        /**
         * <p>
         * [Required] The language for the generated SDK. Currently <code>java</code>, <code>javascript</code>,
         * <code>android</code>, <code>objectivec</code> (for iOS), <code>swift</code> (for iOS), and <code>ruby</code>
         * are supported.
         * </p>
         * 
         * @param sdkType
         *        [Required] The language for the generated SDK. Currently <code>java</code>, <code>javascript</code>,
         *        <code>android</code>, <code>objectivec</code> (for iOS), <code>swift</code> (for iOS), and
         *        <code>ruby</code> are supported.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder sdkType(String sdkType);

        /**
         * <p>
         * A string-to-string key-value map of query parameters <code>sdkType</code>-dependent properties of the SDK.
         * For <code>sdkType</code> of <code>objectivec</code> or <code>swift</code>, a parameter named
         * <code>classPrefix</code> is required. For <code>sdkType</code> of <code>android</code>, parameters named
         * <code>groupId</code>, <code>artifactId</code>, <code>artifactVersion</code>, and <code>invokerPackage</code>
         * are required. For <code>sdkType</code> of <code>java</code>, parameters named <code>serviceName</code> and
         * <code>javaPackageName</code> are required.
         * </p>
         * 
         * @param parameters
         *        A string-to-string key-value map of query parameters <code>sdkType</code>-dependent properties of the
         *        SDK. For <code>sdkType</code> of <code>objectivec</code> or <code>swift</code>, a parameter named
         *        <code>classPrefix</code> is required. For <code>sdkType</code> of <code>android</code>, parameters
         *        named <code>groupId</code>, <code>artifactId</code>, <code>artifactVersion</code>, and
         *        <code>invokerPackage</code> are required. For <code>sdkType</code> of <code>java</code>, parameters
         *        named <code>serviceName</code> and <code>javaPackageName</code> are required.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder parameters(Map<String, String> parameters);

        @Override
        Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration);

        @Override
        Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer);
    }

    static final class BuilderImpl extends ApiGatewayRequest.BuilderImpl implements Builder {
        private String restApiId;

        private String stageName;

        private String sdkType;

        private Map<String, String> parameters = DefaultSdkAutoConstructMap.getInstance();

        private BuilderImpl() {
        }

        private BuilderImpl(GetSdkRequest model) {
            super(model);
            restApiId(model.restApiId);
            stageName(model.stageName);
            sdkType(model.sdkType);
            parameters(model.parameters);
        }

        public final String getRestApiId() {
            return restApiId;
        }

        @Override
        public final Builder restApiId(String restApiId) {
            this.restApiId = restApiId;
            return this;
        }

        public final void setRestApiId(String restApiId) {
            this.restApiId = restApiId;
        }

        public final String getStageName() {
            return stageName;
        }

        @Override
        public final Builder stageName(String stageName) {
            this.stageName = stageName;
            return this;
        }

        public final void setStageName(String stageName) {
            this.stageName = stageName;
        }

        public final String getSdkType() {
            return sdkType;
        }

        @Override
        public final Builder sdkType(String sdkType) {
            this.sdkType = sdkType;
            return this;
        }

        public final void setSdkType(String sdkType) {
            this.sdkType = sdkType;
        }

        public final Map<String, String> getParameters() {
            return parameters;
        }

        @Override
        public final Builder parameters(Map<String, String> parameters) {
            this.parameters = MapOfStringToStringCopier.copy(parameters);
            return this;
        }

        public final void setParameters(Map<String, String> parameters) {
            this.parameters = MapOfStringToStringCopier.copy(parameters);
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public GetSdkRequest build() {
            return new GetSdkRequest(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
