/*
 * Copyright 2014-2019 Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.apigateway.model;

import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.MapTrait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructMap;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * Represents a put integration response request.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class PutIntegrationResponseRequest extends ApiGatewayRequest implements
        ToCopyableBuilder<PutIntegrationResponseRequest.Builder, PutIntegrationResponseRequest> {
    private static final SdkField<String> REST_API_ID_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .getter(getter(PutIntegrationResponseRequest::restApiId)).setter(setter(Builder::restApiId))
            .traits(LocationTrait.builder().location(MarshallLocation.PATH).locationName("restapi_id").build()).build();

    private static final SdkField<String> RESOURCE_ID_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .getter(getter(PutIntegrationResponseRequest::resourceId)).setter(setter(Builder::resourceId))
            .traits(LocationTrait.builder().location(MarshallLocation.PATH).locationName("resource_id").build()).build();

    private static final SdkField<String> HTTP_METHOD_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .getter(getter(PutIntegrationResponseRequest::httpMethod)).setter(setter(Builder::httpMethod))
            .traits(LocationTrait.builder().location(MarshallLocation.PATH).locationName("http_method").build()).build();

    private static final SdkField<String> STATUS_CODE_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .getter(getter(PutIntegrationResponseRequest::statusCode)).setter(setter(Builder::statusCode))
            .traits(LocationTrait.builder().location(MarshallLocation.PATH).locationName("status_code").build()).build();

    private static final SdkField<String> SELECTION_PATTERN_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .getter(getter(PutIntegrationResponseRequest::selectionPattern)).setter(setter(Builder::selectionPattern))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("selectionPattern").build()).build();

    private static final SdkField<Map<String, String>> RESPONSE_PARAMETERS_FIELD = SdkField
            .<Map<String, String>> builder(MarshallingType.MAP)
            .getter(getter(PutIntegrationResponseRequest::responseParameters))
            .setter(setter(Builder::responseParameters))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("responseParameters").build(),
                    MapTrait.builder()
                            .keyLocationName("key")
                            .valueLocationName("value")
                            .valueFieldInfo(
                                    SdkField.<String> builder(MarshallingType.STRING)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("value").build()).build()).build()).build();

    private static final SdkField<Map<String, String>> RESPONSE_TEMPLATES_FIELD = SdkField
            .<Map<String, String>> builder(MarshallingType.MAP)
            .getter(getter(PutIntegrationResponseRequest::responseTemplates))
            .setter(setter(Builder::responseTemplates))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("responseTemplates").build(),
                    MapTrait.builder()
                            .keyLocationName("key")
                            .valueLocationName("value")
                            .valueFieldInfo(
                                    SdkField.<String> builder(MarshallingType.STRING)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("value").build()).build()).build()).build();

    private static final SdkField<String> CONTENT_HANDLING_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .getter(getter(PutIntegrationResponseRequest::contentHandlingAsString)).setter(setter(Builder::contentHandling))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("contentHandling").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(REST_API_ID_FIELD,
            RESOURCE_ID_FIELD, HTTP_METHOD_FIELD, STATUS_CODE_FIELD, SELECTION_PATTERN_FIELD, RESPONSE_PARAMETERS_FIELD,
            RESPONSE_TEMPLATES_FIELD, CONTENT_HANDLING_FIELD));

    private final String restApiId;

    private final String resourceId;

    private final String httpMethod;

    private final String statusCodeValue;

    private final String selectionPattern;

    private final Map<String, String> responseParameters;

    private final Map<String, String> responseTemplates;

    private final String contentHandling;

    private PutIntegrationResponseRequest(BuilderImpl builder) {
        super(builder);
        this.restApiId = builder.restApiId;
        this.resourceId = builder.resourceId;
        this.httpMethod = builder.httpMethod;
        this.statusCodeValue = builder.statusCodeValue;
        this.selectionPattern = builder.selectionPattern;
        this.responseParameters = builder.responseParameters;
        this.responseTemplates = builder.responseTemplates;
        this.contentHandling = builder.contentHandling;
    }

    /**
     * <p>
     * [Required] The string identifier of the associated <a>RestApi</a>.
     * </p>
     * 
     * @return [Required] The string identifier of the associated <a>RestApi</a>.
     */
    public String restApiId() {
        return restApiId;
    }

    /**
     * <p>
     * [Required] Specifies a put integration response request's resource identifier.
     * </p>
     * 
     * @return [Required] Specifies a put integration response request's resource identifier.
     */
    public String resourceId() {
        return resourceId;
    }

    /**
     * <p>
     * [Required] Specifies a put integration response request's HTTP method.
     * </p>
     * 
     * @return [Required] Specifies a put integration response request's HTTP method.
     */
    public String httpMethod() {
        return httpMethod;
    }

    /**
     * <p>
     * [Required] Specifies the status code that is used to map the integration response to an existing
     * <a>MethodResponse</a>.
     * </p>
     * 
     * @return [Required] Specifies the status code that is used to map the integration response to an existing
     *         <a>MethodResponse</a>.
     */
    public String statusCode() {
        return statusCodeValue;
    }

    /**
     * <p>
     * Specifies the selection pattern of a put integration response.
     * </p>
     * 
     * @return Specifies the selection pattern of a put integration response.
     */
    public String selectionPattern() {
        return selectionPattern;
    }

    /**
     * <p>
     * A key-value map specifying response parameters that are passed to the method response from the back end. The key
     * is a method response header parameter name and the mapped value is an integration response header value, a static
     * value enclosed within a pair of single quotes, or a JSON expression from the integration response body. The
     * mapping key must match the pattern of <code>method.response.header.{name}</code>, where <code>name</code> is a
     * valid and unique header name. The mapped non-static value must match the pattern of
     * <code>integration.response.header.{name}</code> or <code>integration.response.body.{JSON-expression}</code>,
     * where <code>name</code> must be a valid and unique response header name and <code>JSON-expression</code> a valid
     * JSON expression without the <code>$</code> prefix.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * 
     * @return A key-value map specifying response parameters that are passed to the method response from the back end.
     *         The key is a method response header parameter name and the mapped value is an integration response header
     *         value, a static value enclosed within a pair of single quotes, or a JSON expression from the integration
     *         response body. The mapping key must match the pattern of <code>method.response.header.{name}</code>,
     *         where <code>name</code> is a valid and unique header name. The mapped non-static value must match the
     *         pattern of <code>integration.response.header.{name}</code> or
     *         <code>integration.response.body.{JSON-expression}</code>, where <code>name</code> must be a valid and
     *         unique response header name and <code>JSON-expression</code> a valid JSON expression without the
     *         <code>$</code> prefix.
     */
    public Map<String, String> responseParameters() {
        return responseParameters;
    }

    /**
     * <p>
     * Specifies a put integration response's templates.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * 
     * @return Specifies a put integration response's templates.
     */
    public Map<String, String> responseTemplates() {
        return responseTemplates;
    }

    /**
     * <p>
     * Specifies how to handle response payload content type conversions. Supported values are
     * <code>CONVERT_TO_BINARY</code> and <code>CONVERT_TO_TEXT</code>, with the following behaviors:
     * </p>
     * <ul>
     * <li>
     * <p>
     * <code>CONVERT_TO_BINARY</code>: Converts a response payload from a Base64-encoded string to the corresponding
     * binary blob.
     * </p>
     * </li>
     * <li>
     * <p>
     * <code>CONVERT_TO_TEXT</code>: Converts a response payload from a binary blob to a Base64-encoded string.
     * </p>
     * </li>
     * </ul>
     * <p>
     * If this property is not defined, the response payload will be passed through from the integration response to the
     * method response without modification.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #contentHandling}
     * will return {@link ContentHandlingStrategy#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is
     * available from {@link #contentHandlingAsString}.
     * </p>
     * 
     * @return Specifies how to handle response payload content type conversions. Supported values are
     *         <code>CONVERT_TO_BINARY</code> and <code>CONVERT_TO_TEXT</code>, with the following behaviors:</p>
     *         <ul>
     *         <li>
     *         <p>
     *         <code>CONVERT_TO_BINARY</code>: Converts a response payload from a Base64-encoded string to the
     *         corresponding binary blob.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         <code>CONVERT_TO_TEXT</code>: Converts a response payload from a binary blob to a Base64-encoded string.
     *         </p>
     *         </li>
     *         </ul>
     *         <p>
     *         If this property is not defined, the response payload will be passed through from the integration
     *         response to the method response without modification.
     * @see ContentHandlingStrategy
     */
    public ContentHandlingStrategy contentHandling() {
        return ContentHandlingStrategy.fromValue(contentHandling);
    }

    /**
     * <p>
     * Specifies how to handle response payload content type conversions. Supported values are
     * <code>CONVERT_TO_BINARY</code> and <code>CONVERT_TO_TEXT</code>, with the following behaviors:
     * </p>
     * <ul>
     * <li>
     * <p>
     * <code>CONVERT_TO_BINARY</code>: Converts a response payload from a Base64-encoded string to the corresponding
     * binary blob.
     * </p>
     * </li>
     * <li>
     * <p>
     * <code>CONVERT_TO_TEXT</code>: Converts a response payload from a binary blob to a Base64-encoded string.
     * </p>
     * </li>
     * </ul>
     * <p>
     * If this property is not defined, the response payload will be passed through from the integration response to the
     * method response without modification.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #contentHandling}
     * will return {@link ContentHandlingStrategy#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is
     * available from {@link #contentHandlingAsString}.
     * </p>
     * 
     * @return Specifies how to handle response payload content type conversions. Supported values are
     *         <code>CONVERT_TO_BINARY</code> and <code>CONVERT_TO_TEXT</code>, with the following behaviors:</p>
     *         <ul>
     *         <li>
     *         <p>
     *         <code>CONVERT_TO_BINARY</code>: Converts a response payload from a Base64-encoded string to the
     *         corresponding binary blob.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         <code>CONVERT_TO_TEXT</code>: Converts a response payload from a binary blob to a Base64-encoded string.
     *         </p>
     *         </li>
     *         </ul>
     *         <p>
     *         If this property is not defined, the response payload will be passed through from the integration
     *         response to the method response without modification.
     * @see ContentHandlingStrategy
     */
    public String contentHandlingAsString() {
        return contentHandling;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(restApiId());
        hashCode = 31 * hashCode + Objects.hashCode(resourceId());
        hashCode = 31 * hashCode + Objects.hashCode(httpMethod());
        hashCode = 31 * hashCode + Objects.hashCode(statusCode());
        hashCode = 31 * hashCode + Objects.hashCode(selectionPattern());
        hashCode = 31 * hashCode + Objects.hashCode(responseParameters());
        hashCode = 31 * hashCode + Objects.hashCode(responseTemplates());
        hashCode = 31 * hashCode + Objects.hashCode(contentHandlingAsString());
        return hashCode;
    }

    @Override
    public boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof PutIntegrationResponseRequest)) {
            return false;
        }
        PutIntegrationResponseRequest other = (PutIntegrationResponseRequest) obj;
        return Objects.equals(restApiId(), other.restApiId()) && Objects.equals(resourceId(), other.resourceId())
                && Objects.equals(httpMethod(), other.httpMethod()) && Objects.equals(statusCode(), other.statusCode())
                && Objects.equals(selectionPattern(), other.selectionPattern())
                && Objects.equals(responseParameters(), other.responseParameters())
                && Objects.equals(responseTemplates(), other.responseTemplates())
                && Objects.equals(contentHandlingAsString(), other.contentHandlingAsString());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public String toString() {
        return ToString.builder("PutIntegrationResponseRequest").add("RestApiId", restApiId()).add("ResourceId", resourceId())
                .add("HttpMethod", httpMethod()).add("StatusCode", statusCode()).add("SelectionPattern", selectionPattern())
                .add("ResponseParameters", responseParameters()).add("ResponseTemplates", responseTemplates())
                .add("ContentHandling", contentHandlingAsString()).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "restApiId":
            return Optional.ofNullable(clazz.cast(restApiId()));
        case "resourceId":
            return Optional.ofNullable(clazz.cast(resourceId()));
        case "httpMethod":
            return Optional.ofNullable(clazz.cast(httpMethod()));
        case "statusCode":
            return Optional.ofNullable(clazz.cast(statusCode()));
        case "selectionPattern":
            return Optional.ofNullable(clazz.cast(selectionPattern()));
        case "responseParameters":
            return Optional.ofNullable(clazz.cast(responseParameters()));
        case "responseTemplates":
            return Optional.ofNullable(clazz.cast(responseTemplates()));
        case "contentHandling":
            return Optional.ofNullable(clazz.cast(contentHandlingAsString()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<PutIntegrationResponseRequest, T> g) {
        return obj -> g.apply((PutIntegrationResponseRequest) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends ApiGatewayRequest.Builder, SdkPojo, CopyableBuilder<Builder, PutIntegrationResponseRequest> {
        /**
         * <p>
         * [Required] The string identifier of the associated <a>RestApi</a>.
         * </p>
         * 
         * @param restApiId
         *        [Required] The string identifier of the associated <a>RestApi</a>.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder restApiId(String restApiId);

        /**
         * <p>
         * [Required] Specifies a put integration response request's resource identifier.
         * </p>
         * 
         * @param resourceId
         *        [Required] Specifies a put integration response request's resource identifier.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder resourceId(String resourceId);

        /**
         * <p>
         * [Required] Specifies a put integration response request's HTTP method.
         * </p>
         * 
         * @param httpMethod
         *        [Required] Specifies a put integration response request's HTTP method.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder httpMethod(String httpMethod);

        /**
         * <p>
         * [Required] Specifies the status code that is used to map the integration response to an existing
         * <a>MethodResponse</a>.
         * </p>
         * 
         * @param statusCodeValue
         *        [Required] Specifies the status code that is used to map the integration response to an existing
         *        <a>MethodResponse</a>.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder statusCode(String statusCodeValue);

        /**
         * <p>
         * Specifies the selection pattern of a put integration response.
         * </p>
         * 
         * @param selectionPattern
         *        Specifies the selection pattern of a put integration response.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder selectionPattern(String selectionPattern);

        /**
         * <p>
         * A key-value map specifying response parameters that are passed to the method response from the back end. The
         * key is a method response header parameter name and the mapped value is an integration response header value,
         * a static value enclosed within a pair of single quotes, or a JSON expression from the integration response
         * body. The mapping key must match the pattern of <code>method.response.header.{name}</code>, where
         * <code>name</code> is a valid and unique header name. The mapped non-static value must match the pattern of
         * <code>integration.response.header.{name}</code> or <code>integration.response.body.{JSON-expression}</code>,
         * where <code>name</code> must be a valid and unique response header name and <code>JSON-expression</code> a
         * valid JSON expression without the <code>$</code> prefix.
         * </p>
         * 
         * @param responseParameters
         *        A key-value map specifying response parameters that are passed to the method response from the back
         *        end. The key is a method response header parameter name and the mapped value is an integration
         *        response header value, a static value enclosed within a pair of single quotes, or a JSON expression
         *        from the integration response body. The mapping key must match the pattern of
         *        <code>method.response.header.{name}</code>, where <code>name</code> is a valid and unique header name.
         *        The mapped non-static value must match the pattern of <code>integration.response.header.{name}</code>
         *        or <code>integration.response.body.{JSON-expression}</code>, where <code>name</code> must be a valid
         *        and unique response header name and <code>JSON-expression</code> a valid JSON expression without the
         *        <code>$</code> prefix.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder responseParameters(Map<String, String> responseParameters);

        /**
         * <p>
         * Specifies a put integration response's templates.
         * </p>
         * 
         * @param responseTemplates
         *        Specifies a put integration response's templates.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder responseTemplates(Map<String, String> responseTemplates);

        /**
         * <p>
         * Specifies how to handle response payload content type conversions. Supported values are
         * <code>CONVERT_TO_BINARY</code> and <code>CONVERT_TO_TEXT</code>, with the following behaviors:
         * </p>
         * <ul>
         * <li>
         * <p>
         * <code>CONVERT_TO_BINARY</code>: Converts a response payload from a Base64-encoded string to the corresponding
         * binary blob.
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>CONVERT_TO_TEXT</code>: Converts a response payload from a binary blob to a Base64-encoded string.
         * </p>
         * </li>
         * </ul>
         * <p>
         * If this property is not defined, the response payload will be passed through from the integration response to
         * the method response without modification.
         * </p>
         * 
         * @param contentHandling
         *        Specifies how to handle response payload content type conversions. Supported values are
         *        <code>CONVERT_TO_BINARY</code> and <code>CONVERT_TO_TEXT</code>, with the following behaviors:</p>
         *        <ul>
         *        <li>
         *        <p>
         *        <code>CONVERT_TO_BINARY</code>: Converts a response payload from a Base64-encoded string to the
         *        corresponding binary blob.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <code>CONVERT_TO_TEXT</code>: Converts a response payload from a binary blob to a Base64-encoded
         *        string.
         *        </p>
         *        </li>
         *        </ul>
         *        <p>
         *        If this property is not defined, the response payload will be passed through from the integration
         *        response to the method response without modification.
         * @see ContentHandlingStrategy
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see ContentHandlingStrategy
         */
        Builder contentHandling(String contentHandling);

        /**
         * <p>
         * Specifies how to handle response payload content type conversions. Supported values are
         * <code>CONVERT_TO_BINARY</code> and <code>CONVERT_TO_TEXT</code>, with the following behaviors:
         * </p>
         * <ul>
         * <li>
         * <p>
         * <code>CONVERT_TO_BINARY</code>: Converts a response payload from a Base64-encoded string to the corresponding
         * binary blob.
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>CONVERT_TO_TEXT</code>: Converts a response payload from a binary blob to a Base64-encoded string.
         * </p>
         * </li>
         * </ul>
         * <p>
         * If this property is not defined, the response payload will be passed through from the integration response to
         * the method response without modification.
         * </p>
         * 
         * @param contentHandling
         *        Specifies how to handle response payload content type conversions. Supported values are
         *        <code>CONVERT_TO_BINARY</code> and <code>CONVERT_TO_TEXT</code>, with the following behaviors:</p>
         *        <ul>
         *        <li>
         *        <p>
         *        <code>CONVERT_TO_BINARY</code>: Converts a response payload from a Base64-encoded string to the
         *        corresponding binary blob.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <code>CONVERT_TO_TEXT</code>: Converts a response payload from a binary blob to a Base64-encoded
         *        string.
         *        </p>
         *        </li>
         *        </ul>
         *        <p>
         *        If this property is not defined, the response payload will be passed through from the integration
         *        response to the method response without modification.
         * @see ContentHandlingStrategy
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see ContentHandlingStrategy
         */
        Builder contentHandling(ContentHandlingStrategy contentHandling);

        @Override
        Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration);

        @Override
        Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer);
    }

    static final class BuilderImpl extends ApiGatewayRequest.BuilderImpl implements Builder {
        private String restApiId;

        private String resourceId;

        private String httpMethod;

        private String statusCodeValue;

        private String selectionPattern;

        private Map<String, String> responseParameters = DefaultSdkAutoConstructMap.getInstance();

        private Map<String, String> responseTemplates = DefaultSdkAutoConstructMap.getInstance();

        private String contentHandling;

        private BuilderImpl() {
        }

        private BuilderImpl(PutIntegrationResponseRequest model) {
            super(model);
            restApiId(model.restApiId);
            resourceId(model.resourceId);
            httpMethod(model.httpMethod);
            statusCode(model.statusCodeValue);
            selectionPattern(model.selectionPattern);
            responseParameters(model.responseParameters);
            responseTemplates(model.responseTemplates);
            contentHandling(model.contentHandling);
        }

        public final String getRestApiId() {
            return restApiId;
        }

        @Override
        public final Builder restApiId(String restApiId) {
            this.restApiId = restApiId;
            return this;
        }

        public final void setRestApiId(String restApiId) {
            this.restApiId = restApiId;
        }

        public final String getResourceId() {
            return resourceId;
        }

        @Override
        public final Builder resourceId(String resourceId) {
            this.resourceId = resourceId;
            return this;
        }

        public final void setResourceId(String resourceId) {
            this.resourceId = resourceId;
        }

        public final String getHttpMethod() {
            return httpMethod;
        }

        @Override
        public final Builder httpMethod(String httpMethod) {
            this.httpMethod = httpMethod;
            return this;
        }

        public final void setHttpMethod(String httpMethod) {
            this.httpMethod = httpMethod;
        }

        public final String getStatusCode() {
            return statusCodeValue;
        }

        @Override
        public final Builder statusCode(String statusCodeValue) {
            this.statusCodeValue = statusCodeValue;
            return this;
        }

        public final void setStatusCode(String statusCodeValue) {
            this.statusCodeValue = statusCodeValue;
        }

        public final String getSelectionPattern() {
            return selectionPattern;
        }

        @Override
        public final Builder selectionPattern(String selectionPattern) {
            this.selectionPattern = selectionPattern;
            return this;
        }

        public final void setSelectionPattern(String selectionPattern) {
            this.selectionPattern = selectionPattern;
        }

        public final Map<String, String> getResponseParameters() {
            return responseParameters;
        }

        @Override
        public final Builder responseParameters(Map<String, String> responseParameters) {
            this.responseParameters = MapOfStringToStringCopier.copy(responseParameters);
            return this;
        }

        public final void setResponseParameters(Map<String, String> responseParameters) {
            this.responseParameters = MapOfStringToStringCopier.copy(responseParameters);
        }

        public final Map<String, String> getResponseTemplates() {
            return responseTemplates;
        }

        @Override
        public final Builder responseTemplates(Map<String, String> responseTemplates) {
            this.responseTemplates = MapOfStringToStringCopier.copy(responseTemplates);
            return this;
        }

        public final void setResponseTemplates(Map<String, String> responseTemplates) {
            this.responseTemplates = MapOfStringToStringCopier.copy(responseTemplates);
        }

        public final String getContentHandlingAsString() {
            return contentHandling;
        }

        @Override
        public final Builder contentHandling(String contentHandling) {
            this.contentHandling = contentHandling;
            return this;
        }

        @Override
        public final Builder contentHandling(ContentHandlingStrategy contentHandling) {
            this.contentHandling(contentHandling.toString());
            return this;
        }

        public final void setContentHandling(String contentHandling) {
            this.contentHandling = contentHandling;
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public PutIntegrationResponseRequest build() {
            return new PutIntegrationResponseRequest(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
