/*
 * Copyright 2014-2019 Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.apigatewaymanagementapi;

import java.util.concurrent.CompletableFuture;
import java.util.function.Consumer;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkClient;
import software.amazon.awssdk.services.apigatewaymanagementapi.model.DeleteConnectionRequest;
import software.amazon.awssdk.services.apigatewaymanagementapi.model.DeleteConnectionResponse;
import software.amazon.awssdk.services.apigatewaymanagementapi.model.GetConnectionRequest;
import software.amazon.awssdk.services.apigatewaymanagementapi.model.GetConnectionResponse;
import software.amazon.awssdk.services.apigatewaymanagementapi.model.PostToConnectionRequest;
import software.amazon.awssdk.services.apigatewaymanagementapi.model.PostToConnectionResponse;

/**
 * Service client for accessing AmazonApiGatewayManagementApi asynchronously. This can be created using the static
 * {@link #builder()} method.
 *
 * <p>
 * The Amazon API Gateway Management API allows you to directly manage runtime aspects of your deployed APIs. To use it,
 * you must explicitly set the SDK's endpoint to point to the endpoint of your deployed API. The endpoint will be of the
 * form https://{api-id}.execute-api.{region}.amazonaws.com/{stage}, or will be the endpoint corresponding to your API's
 * custom domain and base path, if applicable.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public interface ApiGatewayManagementApiAsyncClient extends SdkClient {
    String SERVICE_NAME = "execute-api";

    /**
     * Create a {@link ApiGatewayManagementApiAsyncClient} with the region loaded from the
     * {@link software.amazon.awssdk.regions.providers.DefaultAwsRegionProviderChain} and credentials loaded from the
     * {@link software.amazon.awssdk.auth.credentials.DefaultCredentialsProvider}.
     */
    static ApiGatewayManagementApiAsyncClient create() {
        return builder().build();
    }

    /**
     * Create a builder that can be used to configure and create a {@link ApiGatewayManagementApiAsyncClient}.
     */
    static ApiGatewayManagementApiAsyncClientBuilder builder() {
        return new DefaultApiGatewayManagementApiAsyncClientBuilder();
    }

    /**
     * <p>
     * Delete the connection with the provided id.
     * </p>
     *
     * @param deleteConnectionRequest
     * @return A Java Future containing the result of the DeleteConnection operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>GoneException The connection with the provided id no longer exists.</li>
     *         <li>LimitExceededException The client is sending more than the allowed number of requests per unit of
     *         time or the WebSocket client side buffer is full.</li>
     *         <li>ForbiddenException The caller is not authorized to invoke this operation.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>ApiGatewayManagementApiException Base class for all service exceptions. Unknown exceptions will be
     *         thrown as an instance of this type.</li>
     *         </ul>
     * @sample ApiGatewayManagementApiAsyncClient.DeleteConnection
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/apigatewaymanagementapi-2018-11-29/DeleteConnection"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<DeleteConnectionResponse> deleteConnection(DeleteConnectionRequest deleteConnectionRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Delete the connection with the provided id.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link DeleteConnectionRequest.Builder} avoiding the need
     * to create one manually via {@link DeleteConnectionRequest#builder()}
     * </p>
     *
     * @param deleteConnectionRequest
     *        A {@link Consumer} that will call methods on {@link DeleteConnectionRequest.Builder} to create a request.
     * @return A Java Future containing the result of the DeleteConnection operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>GoneException The connection with the provided id no longer exists.</li>
     *         <li>LimitExceededException The client is sending more than the allowed number of requests per unit of
     *         time or the WebSocket client side buffer is full.</li>
     *         <li>ForbiddenException The caller is not authorized to invoke this operation.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>ApiGatewayManagementApiException Base class for all service exceptions. Unknown exceptions will be
     *         thrown as an instance of this type.</li>
     *         </ul>
     * @sample ApiGatewayManagementApiAsyncClient.DeleteConnection
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/apigatewaymanagementapi-2018-11-29/DeleteConnection"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<DeleteConnectionResponse> deleteConnection(
            Consumer<DeleteConnectionRequest.Builder> deleteConnectionRequest) {
        return deleteConnection(DeleteConnectionRequest.builder().applyMutation(deleteConnectionRequest).build());
    }

    /**
     * <p>
     * Get information about the connection with the provided id.
     * </p>
     *
     * @param getConnectionRequest
     * @return A Java Future containing the result of the GetConnection operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>GoneException The connection with the provided id no longer exists.</li>
     *         <li>LimitExceededException The client is sending more than the allowed number of requests per unit of
     *         time or the WebSocket client side buffer is full.</li>
     *         <li>ForbiddenException The caller is not authorized to invoke this operation.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>ApiGatewayManagementApiException Base class for all service exceptions. Unknown exceptions will be
     *         thrown as an instance of this type.</li>
     *         </ul>
     * @sample ApiGatewayManagementApiAsyncClient.GetConnection
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/apigatewaymanagementapi-2018-11-29/GetConnection"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<GetConnectionResponse> getConnection(GetConnectionRequest getConnectionRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Get information about the connection with the provided id.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link GetConnectionRequest.Builder} avoiding the need to
     * create one manually via {@link GetConnectionRequest#builder()}
     * </p>
     *
     * @param getConnectionRequest
     *        A {@link Consumer} that will call methods on {@link GetConnectionRequest.Builder} to create a request.
     * @return A Java Future containing the result of the GetConnection operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>GoneException The connection with the provided id no longer exists.</li>
     *         <li>LimitExceededException The client is sending more than the allowed number of requests per unit of
     *         time or the WebSocket client side buffer is full.</li>
     *         <li>ForbiddenException The caller is not authorized to invoke this operation.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>ApiGatewayManagementApiException Base class for all service exceptions. Unknown exceptions will be
     *         thrown as an instance of this type.</li>
     *         </ul>
     * @sample ApiGatewayManagementApiAsyncClient.GetConnection
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/apigatewaymanagementapi-2018-11-29/GetConnection"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<GetConnectionResponse> getConnection(Consumer<GetConnectionRequest.Builder> getConnectionRequest) {
        return getConnection(GetConnectionRequest.builder().applyMutation(getConnectionRequest).build());
    }

    /**
     * <p>
     * Sends the provided data to the specified connection.
     * </p>
     *
     * @param postToConnectionRequest
     * @return A Java Future containing the result of the PostToConnection operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>GoneException The connection with the provided id no longer exists.</li>
     *         <li>LimitExceededException The client is sending more than the allowed number of requests per unit of
     *         time or the WebSocket client side buffer is full.</li>
     *         <li>PayloadTooLargeException The data has exceeded the maximum size allowed.</li>
     *         <li>ForbiddenException The caller is not authorized to invoke this operation.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>ApiGatewayManagementApiException Base class for all service exceptions. Unknown exceptions will be
     *         thrown as an instance of this type.</li>
     *         </ul>
     * @sample ApiGatewayManagementApiAsyncClient.PostToConnection
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/apigatewaymanagementapi-2018-11-29/PostToConnection"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<PostToConnectionResponse> postToConnection(PostToConnectionRequest postToConnectionRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Sends the provided data to the specified connection.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link PostToConnectionRequest.Builder} avoiding the need
     * to create one manually via {@link PostToConnectionRequest#builder()}
     * </p>
     *
     * @param postToConnectionRequest
     *        A {@link Consumer} that will call methods on {@link PostToConnectionRequest.Builder} to create a request.
     * @return A Java Future containing the result of the PostToConnection operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>GoneException The connection with the provided id no longer exists.</li>
     *         <li>LimitExceededException The client is sending more than the allowed number of requests per unit of
     *         time or the WebSocket client side buffer is full.</li>
     *         <li>PayloadTooLargeException The data has exceeded the maximum size allowed.</li>
     *         <li>ForbiddenException The caller is not authorized to invoke this operation.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>ApiGatewayManagementApiException Base class for all service exceptions. Unknown exceptions will be
     *         thrown as an instance of this type.</li>
     *         </ul>
     * @sample ApiGatewayManagementApiAsyncClient.PostToConnection
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/apigatewaymanagementapi-2018-11-29/PostToConnection"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<PostToConnectionResponse> postToConnection(
            Consumer<PostToConnectionRequest.Builder> postToConnectionRequest) {
        return postToConnection(PostToConnectionRequest.builder().applyMutation(postToConnectionRequest).build());
    }
}
