/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.apigatewaymanagementapi.model;

import java.time.Instant;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.TimestampFormatTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public final class GetConnectionResponse extends ApiGatewayManagementApiResponse implements
        ToCopyableBuilder<GetConnectionResponse.Builder, GetConnectionResponse> {
    private static final SdkField<Instant> CONNECTED_AT_FIELD = SdkField
            .<Instant> builder(MarshallingType.INSTANT)
            .getter(getter(GetConnectionResponse::connectedAt))
            .setter(setter(Builder::connectedAt))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("connectedAt").build(),
                    TimestampFormatTrait.create(TimestampFormatTrait.Format.ISO_8601)).build();

    private static final SdkField<Identity> IDENTITY_FIELD = SdkField.<Identity> builder(MarshallingType.SDK_POJO)
            .getter(getter(GetConnectionResponse::identity)).setter(setter(Builder::identity)).constructor(Identity::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("identity").build()).build();

    private static final SdkField<Instant> LAST_ACTIVE_AT_FIELD = SdkField
            .<Instant> builder(MarshallingType.INSTANT)
            .getter(getter(GetConnectionResponse::lastActiveAt))
            .setter(setter(Builder::lastActiveAt))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("lastActiveAt").build(),
                    TimestampFormatTrait.create(TimestampFormatTrait.Format.ISO_8601)).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(CONNECTED_AT_FIELD,
            IDENTITY_FIELD, LAST_ACTIVE_AT_FIELD));

    private final Instant connectedAt;

    private final Identity identity;

    private final Instant lastActiveAt;

    private GetConnectionResponse(BuilderImpl builder) {
        super(builder);
        this.connectedAt = builder.connectedAt;
        this.identity = builder.identity;
        this.lastActiveAt = builder.lastActiveAt;
    }

    /**
     * <p>
     * The time in ISO 8601 format for when the connection was established.
     * </p>
     * 
     * @return The time in ISO 8601 format for when the connection was established.
     */
    public Instant connectedAt() {
        return connectedAt;
    }

    /**
     * Returns the value of the Identity property for this object.
     * 
     * @return The value of the Identity property for this object.
     */
    public Identity identity() {
        return identity;
    }

    /**
     * <p>
     * The time in ISO 8601 format for when the connection was last active.
     * </p>
     * 
     * @return The time in ISO 8601 format for when the connection was last active.
     */
    public Instant lastActiveAt() {
        return lastActiveAt;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(connectedAt());
        hashCode = 31 * hashCode + Objects.hashCode(identity());
        hashCode = 31 * hashCode + Objects.hashCode(lastActiveAt());
        return hashCode;
    }

    @Override
    public boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof GetConnectionResponse)) {
            return false;
        }
        GetConnectionResponse other = (GetConnectionResponse) obj;
        return Objects.equals(connectedAt(), other.connectedAt()) && Objects.equals(identity(), other.identity())
                && Objects.equals(lastActiveAt(), other.lastActiveAt());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public String toString() {
        return ToString.builder("GetConnectionResponse").add("ConnectedAt", connectedAt()).add("Identity", identity())
                .add("LastActiveAt", lastActiveAt()).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "ConnectedAt":
            return Optional.ofNullable(clazz.cast(connectedAt()));
        case "Identity":
            return Optional.ofNullable(clazz.cast(identity()));
        case "LastActiveAt":
            return Optional.ofNullable(clazz.cast(lastActiveAt()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<GetConnectionResponse, T> g) {
        return obj -> g.apply((GetConnectionResponse) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends ApiGatewayManagementApiResponse.Builder, SdkPojo,
            CopyableBuilder<Builder, GetConnectionResponse> {
        /**
         * <p>
         * The time in ISO 8601 format for when the connection was established.
         * </p>
         * 
         * @param connectedAt
         *        The time in ISO 8601 format for when the connection was established.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder connectedAt(Instant connectedAt);

        /**
         * Sets the value of the Identity property for this object.
         *
         * @param identity
         *        The new value for the Identity property for this object.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder identity(Identity identity);

        /**
         * Sets the value of the Identity property for this object.
         *
         * This is a convenience that creates an instance of the {@link Identity.Builder} avoiding the need to create
         * one manually via {@link Identity#builder()}.
         *
         * When the {@link Consumer} completes, {@link Identity.Builder#build()} is called immediately and its result is
         * passed to {@link #identity(Identity)}.
         * 
         * @param identity
         *        a consumer that will call methods on {@link Identity.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #identity(Identity)
         */
        default Builder identity(Consumer<Identity.Builder> identity) {
            return identity(Identity.builder().applyMutation(identity).build());
        }

        /**
         * <p>
         * The time in ISO 8601 format for when the connection was last active.
         * </p>
         * 
         * @param lastActiveAt
         *        The time in ISO 8601 format for when the connection was last active.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder lastActiveAt(Instant lastActiveAt);
    }

    static final class BuilderImpl extends ApiGatewayManagementApiResponse.BuilderImpl implements Builder {
        private Instant connectedAt;

        private Identity identity;

        private Instant lastActiveAt;

        private BuilderImpl() {
        }

        private BuilderImpl(GetConnectionResponse model) {
            super(model);
            connectedAt(model.connectedAt);
            identity(model.identity);
            lastActiveAt(model.lastActiveAt);
        }

        public final Instant getConnectedAt() {
            return connectedAt;
        }

        @Override
        public final Builder connectedAt(Instant connectedAt) {
            this.connectedAt = connectedAt;
            return this;
        }

        public final void setConnectedAt(Instant connectedAt) {
            this.connectedAt = connectedAt;
        }

        public final Identity.Builder getIdentity() {
            return identity != null ? identity.toBuilder() : null;
        }

        @Override
        public final Builder identity(Identity identity) {
            this.identity = identity;
            return this;
        }

        public final void setIdentity(Identity.BuilderImpl identity) {
            this.identity = identity != null ? identity.build() : null;
        }

        public final Instant getLastActiveAt() {
            return lastActiveAt;
        }

        @Override
        public final Builder lastActiveAt(Instant lastActiveAt) {
            this.lastActiveAt = lastActiveAt;
            return this;
        }

        public final void setLastActiveAt(Instant lastActiveAt) {
            this.lastActiveAt = lastActiveAt;
        }

        @Override
        public GetConnectionResponse build() {
            return new GetConnectionResponse(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
