/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.apigatewaymanagementapi;

import java.util.function.Consumer;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.annotations.SdkPublicApi;
import software.amazon.awssdk.annotations.ThreadSafe;
import software.amazon.awssdk.awscore.exception.AwsServiceException;
import software.amazon.awssdk.core.SdkClient;
import software.amazon.awssdk.core.exception.SdkClientException;
import software.amazon.awssdk.regions.ServiceMetadata;
import software.amazon.awssdk.services.apigatewaymanagementapi.model.ApiGatewayManagementApiException;
import software.amazon.awssdk.services.apigatewaymanagementapi.model.DeleteConnectionRequest;
import software.amazon.awssdk.services.apigatewaymanagementapi.model.DeleteConnectionResponse;
import software.amazon.awssdk.services.apigatewaymanagementapi.model.ForbiddenException;
import software.amazon.awssdk.services.apigatewaymanagementapi.model.GetConnectionRequest;
import software.amazon.awssdk.services.apigatewaymanagementapi.model.GetConnectionResponse;
import software.amazon.awssdk.services.apigatewaymanagementapi.model.GoneException;
import software.amazon.awssdk.services.apigatewaymanagementapi.model.LimitExceededException;
import software.amazon.awssdk.services.apigatewaymanagementapi.model.PayloadTooLargeException;
import software.amazon.awssdk.services.apigatewaymanagementapi.model.PostToConnectionRequest;
import software.amazon.awssdk.services.apigatewaymanagementapi.model.PostToConnectionResponse;

/**
 * Service client for accessing AmazonApiGatewayManagementApi. This can be created using the static {@link #builder()}
 * method.
 *
 * <p>
 * The Amazon API Gateway Management API allows you to directly manage runtime aspects of your deployed APIs. To use it,
 * you must explicitly set the SDK's endpoint to point to the endpoint of your deployed API. The endpoint will be of the
 * form https://{api-id}.execute-api.{region}.amazonaws.com/{stage}, or will be the endpoint corresponding to your API's
 * custom domain and base path, if applicable.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
@SdkPublicApi
@ThreadSafe
public interface ApiGatewayManagementApiClient extends SdkClient {
    String SERVICE_NAME = "execute-api";

    /**
     * Value for looking up the service's metadata from the
     * {@link software.amazon.awssdk.regions.ServiceMetadataProvider}.
     */
    String SERVICE_METADATA_ID = "execute-api";

    /**
     * Create a {@link ApiGatewayManagementApiClient} with the region loaded from the
     * {@link software.amazon.awssdk.regions.providers.DefaultAwsRegionProviderChain} and credentials loaded from the
     * {@link software.amazon.awssdk.auth.credentials.DefaultCredentialsProvider}.
     */
    static ApiGatewayManagementApiClient create() {
        return builder().build();
    }

    /**
     * Create a builder that can be used to configure and create a {@link ApiGatewayManagementApiClient}.
     */
    static ApiGatewayManagementApiClientBuilder builder() {
        return new DefaultApiGatewayManagementApiClientBuilder();
    }

    /**
     * <p>
     * Delete the connection with the provided id.
     * </p>
     *
     * @param deleteConnectionRequest
     * @return Result of the DeleteConnection operation returned by the service.
     * @throws GoneException
     *         The connection with the provided id no longer exists.
     * @throws LimitExceededException
     *         The client is sending more than the allowed number of requests per unit of time or the WebSocket client
     *         side buffer is full.
     * @throws ForbiddenException
     *         The caller is not authorized to invoke this operation.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws ApiGatewayManagementApiException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample ApiGatewayManagementApiClient.DeleteConnection
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/apigatewaymanagementapi-2018-11-29/DeleteConnection"
     *      target="_top">AWS API Documentation</a>
     */
    default DeleteConnectionResponse deleteConnection(DeleteConnectionRequest deleteConnectionRequest) throws GoneException,
            LimitExceededException, ForbiddenException, AwsServiceException, SdkClientException, ApiGatewayManagementApiException {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Delete the connection with the provided id.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link DeleteConnectionRequest.Builder} avoiding the need
     * to create one manually via {@link DeleteConnectionRequest#builder()}
     * </p>
     *
     * @param deleteConnectionRequest
     *        A {@link Consumer} that will call methods on {@link DeleteConnectionRequest.Builder} to create a request.
     * @return Result of the DeleteConnection operation returned by the service.
     * @throws GoneException
     *         The connection with the provided id no longer exists.
     * @throws LimitExceededException
     *         The client is sending more than the allowed number of requests per unit of time or the WebSocket client
     *         side buffer is full.
     * @throws ForbiddenException
     *         The caller is not authorized to invoke this operation.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws ApiGatewayManagementApiException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample ApiGatewayManagementApiClient.DeleteConnection
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/apigatewaymanagementapi-2018-11-29/DeleteConnection"
     *      target="_top">AWS API Documentation</a>
     */
    default DeleteConnectionResponse deleteConnection(Consumer<DeleteConnectionRequest.Builder> deleteConnectionRequest)
            throws GoneException, LimitExceededException, ForbiddenException, AwsServiceException, SdkClientException,
            ApiGatewayManagementApiException {
        return deleteConnection(DeleteConnectionRequest.builder().applyMutation(deleteConnectionRequest).build());
    }

    /**
     * <p>
     * Get information about the connection with the provided id.
     * </p>
     *
     * @param getConnectionRequest
     * @return Result of the GetConnection operation returned by the service.
     * @throws GoneException
     *         The connection with the provided id no longer exists.
     * @throws LimitExceededException
     *         The client is sending more than the allowed number of requests per unit of time or the WebSocket client
     *         side buffer is full.
     * @throws ForbiddenException
     *         The caller is not authorized to invoke this operation.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws ApiGatewayManagementApiException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample ApiGatewayManagementApiClient.GetConnection
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/apigatewaymanagementapi-2018-11-29/GetConnection"
     *      target="_top">AWS API Documentation</a>
     */
    default GetConnectionResponse getConnection(GetConnectionRequest getConnectionRequest) throws GoneException,
            LimitExceededException, ForbiddenException, AwsServiceException, SdkClientException, ApiGatewayManagementApiException {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Get information about the connection with the provided id.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link GetConnectionRequest.Builder} avoiding the need to
     * create one manually via {@link GetConnectionRequest#builder()}
     * </p>
     *
     * @param getConnectionRequest
     *        A {@link Consumer} that will call methods on {@link GetConnectionRequest.Builder} to create a request.
     * @return Result of the GetConnection operation returned by the service.
     * @throws GoneException
     *         The connection with the provided id no longer exists.
     * @throws LimitExceededException
     *         The client is sending more than the allowed number of requests per unit of time or the WebSocket client
     *         side buffer is full.
     * @throws ForbiddenException
     *         The caller is not authorized to invoke this operation.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws ApiGatewayManagementApiException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample ApiGatewayManagementApiClient.GetConnection
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/apigatewaymanagementapi-2018-11-29/GetConnection"
     *      target="_top">AWS API Documentation</a>
     */
    default GetConnectionResponse getConnection(Consumer<GetConnectionRequest.Builder> getConnectionRequest)
            throws GoneException, LimitExceededException, ForbiddenException, AwsServiceException, SdkClientException,
            ApiGatewayManagementApiException {
        return getConnection(GetConnectionRequest.builder().applyMutation(getConnectionRequest).build());
    }

    /**
     * <p>
     * Sends the provided data to the specified connection.
     * </p>
     *
     * @param postToConnectionRequest
     * @return Result of the PostToConnection operation returned by the service.
     * @throws GoneException
     *         The connection with the provided id no longer exists.
     * @throws LimitExceededException
     *         The client is sending more than the allowed number of requests per unit of time or the WebSocket client
     *         side buffer is full.
     * @throws PayloadTooLargeException
     *         The data has exceeded the maximum size allowed.
     * @throws ForbiddenException
     *         The caller is not authorized to invoke this operation.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws ApiGatewayManagementApiException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample ApiGatewayManagementApiClient.PostToConnection
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/apigatewaymanagementapi-2018-11-29/PostToConnection"
     *      target="_top">AWS API Documentation</a>
     */
    default PostToConnectionResponse postToConnection(PostToConnectionRequest postToConnectionRequest) throws GoneException,
            LimitExceededException, PayloadTooLargeException, ForbiddenException, AwsServiceException, SdkClientException,
            ApiGatewayManagementApiException {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Sends the provided data to the specified connection.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link PostToConnectionRequest.Builder} avoiding the need
     * to create one manually via {@link PostToConnectionRequest#builder()}
     * </p>
     *
     * @param postToConnectionRequest
     *        A {@link Consumer} that will call methods on {@link PostToConnectionRequest.Builder} to create a request.
     * @return Result of the PostToConnection operation returned by the service.
     * @throws GoneException
     *         The connection with the provided id no longer exists.
     * @throws LimitExceededException
     *         The client is sending more than the allowed number of requests per unit of time or the WebSocket client
     *         side buffer is full.
     * @throws PayloadTooLargeException
     *         The data has exceeded the maximum size allowed.
     * @throws ForbiddenException
     *         The caller is not authorized to invoke this operation.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws ApiGatewayManagementApiException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample ApiGatewayManagementApiClient.PostToConnection
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/apigatewaymanagementapi-2018-11-29/PostToConnection"
     *      target="_top">AWS API Documentation</a>
     */
    default PostToConnectionResponse postToConnection(Consumer<PostToConnectionRequest.Builder> postToConnectionRequest)
            throws GoneException, LimitExceededException, PayloadTooLargeException, ForbiddenException, AwsServiceException,
            SdkClientException, ApiGatewayManagementApiException {
        return postToConnection(PostToConnectionRequest.builder().applyMutation(postToConnectionRequest).build());
    }

    static ServiceMetadata serviceMetadata() {
        return ServiceMetadata.of(SERVICE_METADATA_ID);
    }
}
