/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.apigatewaymanagementapi.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public final class Identity implements SdkPojo, Serializable, ToCopyableBuilder<Identity.Builder, Identity> {
    private static final SdkField<String> SOURCE_IP_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("SourceIp").getter(getter(Identity::sourceIp)).setter(setter(Builder::sourceIp))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("sourceIp").build()).build();

    private static final SdkField<String> USER_AGENT_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("UserAgent").getter(getter(Identity::userAgent)).setter(setter(Builder::userAgent))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("userAgent").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(SOURCE_IP_FIELD,
            USER_AGENT_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = memberNameToFieldInitializer();

    private static final long serialVersionUID = 1L;

    private final String sourceIp;

    private final String userAgent;

    private Identity(BuilderImpl builder) {
        this.sourceIp = builder.sourceIp;
        this.userAgent = builder.userAgent;
    }

    /**
     * <p>
     * The source IP address of the TCP connection making the request to API Gateway.
     * </p>
     * 
     * @return The source IP address of the TCP connection making the request to API Gateway.
     */
    public final String sourceIp() {
        return sourceIp;
    }

    /**
     * <p>
     * The User Agent of the API caller.
     * </p>
     * 
     * @return The User Agent of the API caller.
     */
    public final String userAgent() {
        return userAgent;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(sourceIp());
        hashCode = 31 * hashCode + Objects.hashCode(userAgent());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof Identity)) {
            return false;
        }
        Identity other = (Identity) obj;
        return Objects.equals(sourceIp(), other.sourceIp()) && Objects.equals(userAgent(), other.userAgent());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("Identity").add("SourceIp", sourceIp()).add("UserAgent", userAgent()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "SourceIp":
            return Optional.ofNullable(clazz.cast(sourceIp()));
        case "UserAgent":
            return Optional.ofNullable(clazz.cast(userAgent()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        Map<String, SdkField<?>> map = new HashMap<>();
        map.put("sourceIp", SOURCE_IP_FIELD);
        map.put("userAgent", USER_AGENT_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<Identity, T> g) {
        return obj -> g.apply((Identity) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    @Mutable
    @NotThreadSafe
    public interface Builder extends SdkPojo, CopyableBuilder<Builder, Identity> {
        /**
         * <p>
         * The source IP address of the TCP connection making the request to API Gateway.
         * </p>
         * 
         * @param sourceIp
         *        The source IP address of the TCP connection making the request to API Gateway.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder sourceIp(String sourceIp);

        /**
         * <p>
         * The User Agent of the API caller.
         * </p>
         * 
         * @param userAgent
         *        The User Agent of the API caller.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder userAgent(String userAgent);
    }

    static final class BuilderImpl implements Builder {
        private String sourceIp;

        private String userAgent;

        private BuilderImpl() {
        }

        private BuilderImpl(Identity model) {
            sourceIp(model.sourceIp);
            userAgent(model.userAgent);
        }

        public final String getSourceIp() {
            return sourceIp;
        }

        public final void setSourceIp(String sourceIp) {
            this.sourceIp = sourceIp;
        }

        @Override
        public final Builder sourceIp(String sourceIp) {
            this.sourceIp = sourceIp;
            return this;
        }

        public final String getUserAgent() {
            return userAgent;
        }

        public final void setUserAgent(String userAgent) {
            this.userAgent = userAgent;
        }

        @Override
        public final Builder userAgent(String userAgent) {
            this.userAgent = userAgent;
            return this;
        }

        @Override
        public Identity build() {
            return new Identity(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }
}
