/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.apigatewayv2.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * Represents a CORS configuration. Supported only for HTTP APIs. See <a
 * href="https://docs.aws.amazon.com/apigateway/latest/developerguide/http-api-cors.html">Configuring CORS</a> for more
 * information.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class Cors implements SdkPojo, Serializable, ToCopyableBuilder<Cors.Builder, Cors> {
    private static final SdkField<Boolean> ALLOW_CREDENTIALS_FIELD = SdkField.<Boolean> builder(MarshallingType.BOOLEAN)
            .getter(getter(Cors::allowCredentials)).setter(setter(Builder::allowCredentials))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("allowCredentials").build()).build();

    private static final SdkField<List<String>> ALLOW_HEADERS_FIELD = SdkField
            .<List<String>> builder(MarshallingType.LIST)
            .getter(getter(Cors::allowHeaders))
            .setter(setter(Builder::allowHeaders))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("allowHeaders").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<String> builder(MarshallingType.STRING)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final SdkField<List<String>> ALLOW_METHODS_FIELD = SdkField
            .<List<String>> builder(MarshallingType.LIST)
            .getter(getter(Cors::allowMethods))
            .setter(setter(Builder::allowMethods))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("allowMethods").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<String> builder(MarshallingType.STRING)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final SdkField<List<String>> ALLOW_ORIGINS_FIELD = SdkField
            .<List<String>> builder(MarshallingType.LIST)
            .getter(getter(Cors::allowOrigins))
            .setter(setter(Builder::allowOrigins))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("allowOrigins").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<String> builder(MarshallingType.STRING)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final SdkField<List<String>> EXPOSE_HEADERS_FIELD = SdkField
            .<List<String>> builder(MarshallingType.LIST)
            .getter(getter(Cors::exposeHeaders))
            .setter(setter(Builder::exposeHeaders))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("exposeHeaders").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<String> builder(MarshallingType.STRING)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final SdkField<Integer> MAX_AGE_FIELD = SdkField.<Integer> builder(MarshallingType.INTEGER)
            .getter(getter(Cors::maxAge)).setter(setter(Builder::maxAge))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("maxAge").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(ALLOW_CREDENTIALS_FIELD,
            ALLOW_HEADERS_FIELD, ALLOW_METHODS_FIELD, ALLOW_ORIGINS_FIELD, EXPOSE_HEADERS_FIELD, MAX_AGE_FIELD));

    private static final long serialVersionUID = 1L;

    private final Boolean allowCredentials;

    private final List<String> allowHeaders;

    private final List<String> allowMethods;

    private final List<String> allowOrigins;

    private final List<String> exposeHeaders;

    private final Integer maxAge;

    private Cors(BuilderImpl builder) {
        this.allowCredentials = builder.allowCredentials;
        this.allowHeaders = builder.allowHeaders;
        this.allowMethods = builder.allowMethods;
        this.allowOrigins = builder.allowOrigins;
        this.exposeHeaders = builder.exposeHeaders;
        this.maxAge = builder.maxAge;
    }

    /**
     * <p>
     * Specifies whether credentials are included in the CORS request. Supported only for HTTP APIs.
     * </p>
     * 
     * @return Specifies whether credentials are included in the CORS request. Supported only for HTTP APIs.
     */
    public Boolean allowCredentials() {
        return allowCredentials;
    }

    /**
     * Returns true if the AllowHeaders property was specified by the sender (it may be empty), or false if the sender
     * did not specify the value (it will be empty). For responses returned by the SDK, the sender is the AWS service.
     */
    public boolean hasAllowHeaders() {
        return allowHeaders != null && !(allowHeaders instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * Represents a collection of allowed headers. Supported only for HTTP APIs.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * You can use {@link #hasAllowHeaders()} to see if a value was sent in this field.
     * </p>
     * 
     * @return Represents a collection of allowed headers. Supported only for HTTP APIs.
     */
    public List<String> allowHeaders() {
        return allowHeaders;
    }

    /**
     * Returns true if the AllowMethods property was specified by the sender (it may be empty), or false if the sender
     * did not specify the value (it will be empty). For responses returned by the SDK, the sender is the AWS service.
     */
    public boolean hasAllowMethods() {
        return allowMethods != null && !(allowMethods instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * Represents a collection of allowed HTTP methods. Supported only for HTTP APIs.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * You can use {@link #hasAllowMethods()} to see if a value was sent in this field.
     * </p>
     * 
     * @return Represents a collection of allowed HTTP methods. Supported only for HTTP APIs.
     */
    public List<String> allowMethods() {
        return allowMethods;
    }

    /**
     * Returns true if the AllowOrigins property was specified by the sender (it may be empty), or false if the sender
     * did not specify the value (it will be empty). For responses returned by the SDK, the sender is the AWS service.
     */
    public boolean hasAllowOrigins() {
        return allowOrigins != null && !(allowOrigins instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * Represents a collection of allowed origins. Supported only for HTTP APIs.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * You can use {@link #hasAllowOrigins()} to see if a value was sent in this field.
     * </p>
     * 
     * @return Represents a collection of allowed origins. Supported only for HTTP APIs.
     */
    public List<String> allowOrigins() {
        return allowOrigins;
    }

    /**
     * Returns true if the ExposeHeaders property was specified by the sender (it may be empty), or false if the sender
     * did not specify the value (it will be empty). For responses returned by the SDK, the sender is the AWS service.
     */
    public boolean hasExposeHeaders() {
        return exposeHeaders != null && !(exposeHeaders instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * Represents a collection of exposed headers. Supported only for HTTP APIs.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * You can use {@link #hasExposeHeaders()} to see if a value was sent in this field.
     * </p>
     * 
     * @return Represents a collection of exposed headers. Supported only for HTTP APIs.
     */
    public List<String> exposeHeaders() {
        return exposeHeaders;
    }

    /**
     * <p>
     * The number of seconds that the browser should cache preflight request results. Supported only for HTTP APIs.
     * </p>
     * 
     * @return The number of seconds that the browser should cache preflight request results. Supported only for HTTP
     *         APIs.
     */
    public Integer maxAge() {
        return maxAge;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(allowCredentials());
        hashCode = 31 * hashCode + Objects.hashCode(allowHeaders());
        hashCode = 31 * hashCode + Objects.hashCode(allowMethods());
        hashCode = 31 * hashCode + Objects.hashCode(allowOrigins());
        hashCode = 31 * hashCode + Objects.hashCode(exposeHeaders());
        hashCode = 31 * hashCode + Objects.hashCode(maxAge());
        return hashCode;
    }

    @Override
    public boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof Cors)) {
            return false;
        }
        Cors other = (Cors) obj;
        return Objects.equals(allowCredentials(), other.allowCredentials())
                && Objects.equals(allowHeaders(), other.allowHeaders()) && Objects.equals(allowMethods(), other.allowMethods())
                && Objects.equals(allowOrigins(), other.allowOrigins()) && Objects.equals(exposeHeaders(), other.exposeHeaders())
                && Objects.equals(maxAge(), other.maxAge());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public String toString() {
        return ToString.builder("Cors").add("AllowCredentials", allowCredentials()).add("AllowHeaders", allowHeaders())
                .add("AllowMethods", allowMethods()).add("AllowOrigins", allowOrigins()).add("ExposeHeaders", exposeHeaders())
                .add("MaxAge", maxAge()).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "AllowCredentials":
            return Optional.ofNullable(clazz.cast(allowCredentials()));
        case "AllowHeaders":
            return Optional.ofNullable(clazz.cast(allowHeaders()));
        case "AllowMethods":
            return Optional.ofNullable(clazz.cast(allowMethods()));
        case "AllowOrigins":
            return Optional.ofNullable(clazz.cast(allowOrigins()));
        case "ExposeHeaders":
            return Optional.ofNullable(clazz.cast(exposeHeaders()));
        case "MaxAge":
            return Optional.ofNullable(clazz.cast(maxAge()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<Cors, T> g) {
        return obj -> g.apply((Cors) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SdkPojo, CopyableBuilder<Builder, Cors> {
        /**
         * <p>
         * Specifies whether credentials are included in the CORS request. Supported only for HTTP APIs.
         * </p>
         * 
         * @param allowCredentials
         *        Specifies whether credentials are included in the CORS request. Supported only for HTTP APIs.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder allowCredentials(Boolean allowCredentials);

        /**
         * <p>
         * Represents a collection of allowed headers. Supported only for HTTP APIs.
         * </p>
         * 
         * @param allowHeaders
         *        Represents a collection of allowed headers. Supported only for HTTP APIs.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder allowHeaders(Collection<String> allowHeaders);

        /**
         * <p>
         * Represents a collection of allowed headers. Supported only for HTTP APIs.
         * </p>
         * 
         * @param allowHeaders
         *        Represents a collection of allowed headers. Supported only for HTTP APIs.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder allowHeaders(String... allowHeaders);

        /**
         * <p>
         * Represents a collection of allowed HTTP methods. Supported only for HTTP APIs.
         * </p>
         * 
         * @param allowMethods
         *        Represents a collection of allowed HTTP methods. Supported only for HTTP APIs.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder allowMethods(Collection<String> allowMethods);

        /**
         * <p>
         * Represents a collection of allowed HTTP methods. Supported only for HTTP APIs.
         * </p>
         * 
         * @param allowMethods
         *        Represents a collection of allowed HTTP methods. Supported only for HTTP APIs.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder allowMethods(String... allowMethods);

        /**
         * <p>
         * Represents a collection of allowed origins. Supported only for HTTP APIs.
         * </p>
         * 
         * @param allowOrigins
         *        Represents a collection of allowed origins. Supported only for HTTP APIs.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder allowOrigins(Collection<String> allowOrigins);

        /**
         * <p>
         * Represents a collection of allowed origins. Supported only for HTTP APIs.
         * </p>
         * 
         * @param allowOrigins
         *        Represents a collection of allowed origins. Supported only for HTTP APIs.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder allowOrigins(String... allowOrigins);

        /**
         * <p>
         * Represents a collection of exposed headers. Supported only for HTTP APIs.
         * </p>
         * 
         * @param exposeHeaders
         *        Represents a collection of exposed headers. Supported only for HTTP APIs.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder exposeHeaders(Collection<String> exposeHeaders);

        /**
         * <p>
         * Represents a collection of exposed headers. Supported only for HTTP APIs.
         * </p>
         * 
         * @param exposeHeaders
         *        Represents a collection of exposed headers. Supported only for HTTP APIs.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder exposeHeaders(String... exposeHeaders);

        /**
         * <p>
         * The number of seconds that the browser should cache preflight request results. Supported only for HTTP APIs.
         * </p>
         * 
         * @param maxAge
         *        The number of seconds that the browser should cache preflight request results. Supported only for HTTP
         *        APIs.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder maxAge(Integer maxAge);
    }

    static final class BuilderImpl implements Builder {
        private Boolean allowCredentials;

        private List<String> allowHeaders = DefaultSdkAutoConstructList.getInstance();

        private List<String> allowMethods = DefaultSdkAutoConstructList.getInstance();

        private List<String> allowOrigins = DefaultSdkAutoConstructList.getInstance();

        private List<String> exposeHeaders = DefaultSdkAutoConstructList.getInstance();

        private Integer maxAge;

        private BuilderImpl() {
        }

        private BuilderImpl(Cors model) {
            allowCredentials(model.allowCredentials);
            allowHeaders(model.allowHeaders);
            allowMethods(model.allowMethods);
            allowOrigins(model.allowOrigins);
            exposeHeaders(model.exposeHeaders);
            maxAge(model.maxAge);
        }

        public final Boolean getAllowCredentials() {
            return allowCredentials;
        }

        @Override
        public final Builder allowCredentials(Boolean allowCredentials) {
            this.allowCredentials = allowCredentials;
            return this;
        }

        public final void setAllowCredentials(Boolean allowCredentials) {
            this.allowCredentials = allowCredentials;
        }

        public final Collection<String> getAllowHeaders() {
            return allowHeaders;
        }

        @Override
        public final Builder allowHeaders(Collection<String> allowHeaders) {
            this.allowHeaders = CorsHeaderListCopier.copy(allowHeaders);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder allowHeaders(String... allowHeaders) {
            allowHeaders(Arrays.asList(allowHeaders));
            return this;
        }

        public final void setAllowHeaders(Collection<String> allowHeaders) {
            this.allowHeaders = CorsHeaderListCopier.copy(allowHeaders);
        }

        public final Collection<String> getAllowMethods() {
            return allowMethods;
        }

        @Override
        public final Builder allowMethods(Collection<String> allowMethods) {
            this.allowMethods = CorsMethodListCopier.copy(allowMethods);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder allowMethods(String... allowMethods) {
            allowMethods(Arrays.asList(allowMethods));
            return this;
        }

        public final void setAllowMethods(Collection<String> allowMethods) {
            this.allowMethods = CorsMethodListCopier.copy(allowMethods);
        }

        public final Collection<String> getAllowOrigins() {
            return allowOrigins;
        }

        @Override
        public final Builder allowOrigins(Collection<String> allowOrigins) {
            this.allowOrigins = CorsOriginListCopier.copy(allowOrigins);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder allowOrigins(String... allowOrigins) {
            allowOrigins(Arrays.asList(allowOrigins));
            return this;
        }

        public final void setAllowOrigins(Collection<String> allowOrigins) {
            this.allowOrigins = CorsOriginListCopier.copy(allowOrigins);
        }

        public final Collection<String> getExposeHeaders() {
            return exposeHeaders;
        }

        @Override
        public final Builder exposeHeaders(Collection<String> exposeHeaders) {
            this.exposeHeaders = CorsHeaderListCopier.copy(exposeHeaders);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder exposeHeaders(String... exposeHeaders) {
            exposeHeaders(Arrays.asList(exposeHeaders));
            return this;
        }

        public final void setExposeHeaders(Collection<String> exposeHeaders) {
            this.exposeHeaders = CorsHeaderListCopier.copy(exposeHeaders);
        }

        public final Integer getMaxAge() {
            return maxAge;
        }

        @Override
        public final Builder maxAge(Integer maxAge) {
            this.maxAge = maxAge;
            return this;
        }

        public final void setMaxAge(Integer maxAge) {
            this.maxAge = maxAge;
        }

        @Override
        public Cors build() {
            return new Cors(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
