/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.apigatewayv2.model;

import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.MapTrait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructMap;
import software.amazon.awssdk.core.util.SdkAutoConstructMap;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public final class GetIntegrationResponseResponse extends ApiGatewayV2Response implements
        ToCopyableBuilder<GetIntegrationResponseResponse.Builder, GetIntegrationResponseResponse> {
    private static final SdkField<String> CONTENT_HANDLING_STRATEGY_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .getter(getter(GetIntegrationResponseResponse::contentHandlingStrategyAsString))
            .setter(setter(Builder::contentHandlingStrategy))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("contentHandlingStrategy").build())
            .build();

    private static final SdkField<String> INTEGRATION_RESPONSE_ID_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .getter(getter(GetIntegrationResponseResponse::integrationResponseId)).setter(setter(Builder::integrationResponseId))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("integrationResponseId").build())
            .build();

    private static final SdkField<String> INTEGRATION_RESPONSE_KEY_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .getter(getter(GetIntegrationResponseResponse::integrationResponseKey))
            .setter(setter(Builder::integrationResponseKey))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("integrationResponseKey").build())
            .build();

    private static final SdkField<Map<String, String>> RESPONSE_PARAMETERS_FIELD = SdkField
            .<Map<String, String>> builder(MarshallingType.MAP)
            .getter(getter(GetIntegrationResponseResponse::responseParameters))
            .setter(setter(Builder::responseParameters))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("responseParameters").build(),
                    MapTrait.builder()
                            .keyLocationName("key")
                            .valueLocationName("value")
                            .valueFieldInfo(
                                    SdkField.<String> builder(MarshallingType.STRING)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("value").build()).build()).build()).build();

    private static final SdkField<Map<String, String>> RESPONSE_TEMPLATES_FIELD = SdkField
            .<Map<String, String>> builder(MarshallingType.MAP)
            .getter(getter(GetIntegrationResponseResponse::responseTemplates))
            .setter(setter(Builder::responseTemplates))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("responseTemplates").build(),
                    MapTrait.builder()
                            .keyLocationName("key")
                            .valueLocationName("value")
                            .valueFieldInfo(
                                    SdkField.<String> builder(MarshallingType.STRING)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("value").build()).build()).build()).build();

    private static final SdkField<String> TEMPLATE_SELECTION_EXPRESSION_FIELD = SdkField
            .<String> builder(MarshallingType.STRING)
            .getter(getter(GetIntegrationResponseResponse::templateSelectionExpression))
            .setter(setter(Builder::templateSelectionExpression))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("templateSelectionExpression")
                    .build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(
            CONTENT_HANDLING_STRATEGY_FIELD, INTEGRATION_RESPONSE_ID_FIELD, INTEGRATION_RESPONSE_KEY_FIELD,
            RESPONSE_PARAMETERS_FIELD, RESPONSE_TEMPLATES_FIELD, TEMPLATE_SELECTION_EXPRESSION_FIELD));

    private final String contentHandlingStrategy;

    private final String integrationResponseId;

    private final String integrationResponseKey;

    private final Map<String, String> responseParameters;

    private final Map<String, String> responseTemplates;

    private final String templateSelectionExpression;

    private GetIntegrationResponseResponse(BuilderImpl builder) {
        super(builder);
        this.contentHandlingStrategy = builder.contentHandlingStrategy;
        this.integrationResponseId = builder.integrationResponseId;
        this.integrationResponseKey = builder.integrationResponseKey;
        this.responseParameters = builder.responseParameters;
        this.responseTemplates = builder.responseTemplates;
        this.templateSelectionExpression = builder.templateSelectionExpression;
    }

    /**
     * <p>
     * Supported only for WebSocket APIs. Specifies how to handle response payload content type conversions. Supported
     * values are CONVERT_TO_BINARY and CONVERT_TO_TEXT, with the following behaviors:
     * </p>
     * <p>
     * CONVERT_TO_BINARY: Converts a response payload from a Base64-encoded string to the corresponding binary blob.
     * </p>
     * <p>
     * CONVERT_TO_TEXT: Converts a response payload from a binary blob to a Base64-encoded string.
     * </p>
     * <p>
     * If this property is not defined, the response payload will be passed through from the integration response to the
     * route response or method response without modification.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version,
     * {@link #contentHandlingStrategy} will return {@link ContentHandlingStrategy#UNKNOWN_TO_SDK_VERSION}. The raw
     * value returned by the service is available from {@link #contentHandlingStrategyAsString}.
     * </p>
     * 
     * @return Supported only for WebSocket APIs. Specifies how to handle response payload content type conversions.
     *         Supported values are CONVERT_TO_BINARY and CONVERT_TO_TEXT, with the following behaviors:</p>
     *         <p>
     *         CONVERT_TO_BINARY: Converts a response payload from a Base64-encoded string to the corresponding binary
     *         blob.
     *         </p>
     *         <p>
     *         CONVERT_TO_TEXT: Converts a response payload from a binary blob to a Base64-encoded string.
     *         </p>
     *         <p>
     *         If this property is not defined, the response payload will be passed through from the integration
     *         response to the route response or method response without modification.
     * @see ContentHandlingStrategy
     */
    public ContentHandlingStrategy contentHandlingStrategy() {
        return ContentHandlingStrategy.fromValue(contentHandlingStrategy);
    }

    /**
     * <p>
     * Supported only for WebSocket APIs. Specifies how to handle response payload content type conversions. Supported
     * values are CONVERT_TO_BINARY and CONVERT_TO_TEXT, with the following behaviors:
     * </p>
     * <p>
     * CONVERT_TO_BINARY: Converts a response payload from a Base64-encoded string to the corresponding binary blob.
     * </p>
     * <p>
     * CONVERT_TO_TEXT: Converts a response payload from a binary blob to a Base64-encoded string.
     * </p>
     * <p>
     * If this property is not defined, the response payload will be passed through from the integration response to the
     * route response or method response without modification.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version,
     * {@link #contentHandlingStrategy} will return {@link ContentHandlingStrategy#UNKNOWN_TO_SDK_VERSION}. The raw
     * value returned by the service is available from {@link #contentHandlingStrategyAsString}.
     * </p>
     * 
     * @return Supported only for WebSocket APIs. Specifies how to handle response payload content type conversions.
     *         Supported values are CONVERT_TO_BINARY and CONVERT_TO_TEXT, with the following behaviors:</p>
     *         <p>
     *         CONVERT_TO_BINARY: Converts a response payload from a Base64-encoded string to the corresponding binary
     *         blob.
     *         </p>
     *         <p>
     *         CONVERT_TO_TEXT: Converts a response payload from a binary blob to a Base64-encoded string.
     *         </p>
     *         <p>
     *         If this property is not defined, the response payload will be passed through from the integration
     *         response to the route response or method response without modification.
     * @see ContentHandlingStrategy
     */
    public String contentHandlingStrategyAsString() {
        return contentHandlingStrategy;
    }

    /**
     * <p>
     * The integration response ID.
     * </p>
     * 
     * @return The integration response ID.
     */
    public String integrationResponseId() {
        return integrationResponseId;
    }

    /**
     * <p>
     * The integration response key.
     * </p>
     * 
     * @return The integration response key.
     */
    public String integrationResponseKey() {
        return integrationResponseKey;
    }

    /**
     * Returns true if the ResponseParameters property was specified by the sender (it may be empty), or false if the
     * sender did not specify the value (it will be empty). For responses returned by the SDK, the sender is the AWS
     * service.
     */
    public boolean hasResponseParameters() {
        return responseParameters != null && !(responseParameters instanceof SdkAutoConstructMap);
    }

    /**
     * <p>
     * A key-value map specifying response parameters that are passed to the method response from the backend. The key
     * is a method response header parameter name and the mapped value is an integration response header value, a static
     * value enclosed within a pair of single quotes, or a JSON expression from the integration response body. The
     * mapping key must match the pattern of method.response.header.{name}, where name is a valid and unique header
     * name. The mapped non-static value must match the pattern of integration.response.header.{name} or
     * integration.response.body.{JSON-expression}, where name is a valid and unique response header name and
     * JSON-expression is a valid JSON expression without the $ prefix.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * You can use {@link #hasResponseParameters()} to see if a value was sent in this field.
     * </p>
     * 
     * @return A key-value map specifying response parameters that are passed to the method response from the backend.
     *         The key is a method response header parameter name and the mapped value is an integration response header
     *         value, a static value enclosed within a pair of single quotes, or a JSON expression from the integration
     *         response body. The mapping key must match the pattern of method.response.header.{name}, where name is a
     *         valid and unique header name. The mapped non-static value must match the pattern of
     *         integration.response.header.{name} or integration.response.body.{JSON-expression}, where name is a valid
     *         and unique response header name and JSON-expression is a valid JSON expression without the $ prefix.
     */
    public Map<String, String> responseParameters() {
        return responseParameters;
    }

    /**
     * Returns true if the ResponseTemplates property was specified by the sender (it may be empty), or false if the
     * sender did not specify the value (it will be empty). For responses returned by the SDK, the sender is the AWS
     * service.
     */
    public boolean hasResponseTemplates() {
        return responseTemplates != null && !(responseTemplates instanceof SdkAutoConstructMap);
    }

    /**
     * <p>
     * The collection of response templates for the integration response as a string-to-string map of key-value pairs.
     * Response templates are represented as a key/value map, with a content-type as the key and a template as the
     * value.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * You can use {@link #hasResponseTemplates()} to see if a value was sent in this field.
     * </p>
     * 
     * @return The collection of response templates for the integration response as a string-to-string map of key-value
     *         pairs. Response templates are represented as a key/value map, with a content-type as the key and a
     *         template as the value.
     */
    public Map<String, String> responseTemplates() {
        return responseTemplates;
    }

    /**
     * <p>
     * The template selection expressions for the integration response.
     * </p>
     * 
     * @return The template selection expressions for the integration response.
     */
    public String templateSelectionExpression() {
        return templateSelectionExpression;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(contentHandlingStrategyAsString());
        hashCode = 31 * hashCode + Objects.hashCode(integrationResponseId());
        hashCode = 31 * hashCode + Objects.hashCode(integrationResponseKey());
        hashCode = 31 * hashCode + Objects.hashCode(responseParameters());
        hashCode = 31 * hashCode + Objects.hashCode(responseTemplates());
        hashCode = 31 * hashCode + Objects.hashCode(templateSelectionExpression());
        return hashCode;
    }

    @Override
    public boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof GetIntegrationResponseResponse)) {
            return false;
        }
        GetIntegrationResponseResponse other = (GetIntegrationResponseResponse) obj;
        return Objects.equals(contentHandlingStrategyAsString(), other.contentHandlingStrategyAsString())
                && Objects.equals(integrationResponseId(), other.integrationResponseId())
                && Objects.equals(integrationResponseKey(), other.integrationResponseKey())
                && Objects.equals(responseParameters(), other.responseParameters())
                && Objects.equals(responseTemplates(), other.responseTemplates())
                && Objects.equals(templateSelectionExpression(), other.templateSelectionExpression());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public String toString() {
        return ToString.builder("GetIntegrationResponseResponse")
                .add("ContentHandlingStrategy", contentHandlingStrategyAsString())
                .add("IntegrationResponseId", integrationResponseId()).add("IntegrationResponseKey", integrationResponseKey())
                .add("ResponseParameters", responseParameters()).add("ResponseTemplates", responseTemplates())
                .add("TemplateSelectionExpression", templateSelectionExpression()).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "ContentHandlingStrategy":
            return Optional.ofNullable(clazz.cast(contentHandlingStrategyAsString()));
        case "IntegrationResponseId":
            return Optional.ofNullable(clazz.cast(integrationResponseId()));
        case "IntegrationResponseKey":
            return Optional.ofNullable(clazz.cast(integrationResponseKey()));
        case "ResponseParameters":
            return Optional.ofNullable(clazz.cast(responseParameters()));
        case "ResponseTemplates":
            return Optional.ofNullable(clazz.cast(responseTemplates()));
        case "TemplateSelectionExpression":
            return Optional.ofNullable(clazz.cast(templateSelectionExpression()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<GetIntegrationResponseResponse, T> g) {
        return obj -> g.apply((GetIntegrationResponseResponse) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends ApiGatewayV2Response.Builder, SdkPojo,
            CopyableBuilder<Builder, GetIntegrationResponseResponse> {
        /**
         * <p>
         * Supported only for WebSocket APIs. Specifies how to handle response payload content type conversions.
         * Supported values are CONVERT_TO_BINARY and CONVERT_TO_TEXT, with the following behaviors:
         * </p>
         * <p>
         * CONVERT_TO_BINARY: Converts a response payload from a Base64-encoded string to the corresponding binary blob.
         * </p>
         * <p>
         * CONVERT_TO_TEXT: Converts a response payload from a binary blob to a Base64-encoded string.
         * </p>
         * <p>
         * If this property is not defined, the response payload will be passed through from the integration response to
         * the route response or method response without modification.
         * </p>
         * 
         * @param contentHandlingStrategy
         *        Supported only for WebSocket APIs. Specifies how to handle response payload content type conversions.
         *        Supported values are CONVERT_TO_BINARY and CONVERT_TO_TEXT, with the following behaviors:</p>
         *        <p>
         *        CONVERT_TO_BINARY: Converts a response payload from a Base64-encoded string to the corresponding
         *        binary blob.
         *        </p>
         *        <p>
         *        CONVERT_TO_TEXT: Converts a response payload from a binary blob to a Base64-encoded string.
         *        </p>
         *        <p>
         *        If this property is not defined, the response payload will be passed through from the integration
         *        response to the route response or method response without modification.
         * @see ContentHandlingStrategy
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see ContentHandlingStrategy
         */
        Builder contentHandlingStrategy(String contentHandlingStrategy);

        /**
         * <p>
         * Supported only for WebSocket APIs. Specifies how to handle response payload content type conversions.
         * Supported values are CONVERT_TO_BINARY and CONVERT_TO_TEXT, with the following behaviors:
         * </p>
         * <p>
         * CONVERT_TO_BINARY: Converts a response payload from a Base64-encoded string to the corresponding binary blob.
         * </p>
         * <p>
         * CONVERT_TO_TEXT: Converts a response payload from a binary blob to a Base64-encoded string.
         * </p>
         * <p>
         * If this property is not defined, the response payload will be passed through from the integration response to
         * the route response or method response without modification.
         * </p>
         * 
         * @param contentHandlingStrategy
         *        Supported only for WebSocket APIs. Specifies how to handle response payload content type conversions.
         *        Supported values are CONVERT_TO_BINARY and CONVERT_TO_TEXT, with the following behaviors:</p>
         *        <p>
         *        CONVERT_TO_BINARY: Converts a response payload from a Base64-encoded string to the corresponding
         *        binary blob.
         *        </p>
         *        <p>
         *        CONVERT_TO_TEXT: Converts a response payload from a binary blob to a Base64-encoded string.
         *        </p>
         *        <p>
         *        If this property is not defined, the response payload will be passed through from the integration
         *        response to the route response or method response without modification.
         * @see ContentHandlingStrategy
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see ContentHandlingStrategy
         */
        Builder contentHandlingStrategy(ContentHandlingStrategy contentHandlingStrategy);

        /**
         * <p>
         * The integration response ID.
         * </p>
         * 
         * @param integrationResponseId
         *        The integration response ID.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder integrationResponseId(String integrationResponseId);

        /**
         * <p>
         * The integration response key.
         * </p>
         * 
         * @param integrationResponseKey
         *        The integration response key.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder integrationResponseKey(String integrationResponseKey);

        /**
         * <p>
         * A key-value map specifying response parameters that are passed to the method response from the backend. The
         * key is a method response header parameter name and the mapped value is an integration response header value,
         * a static value enclosed within a pair of single quotes, or a JSON expression from the integration response
         * body. The mapping key must match the pattern of method.response.header.{name}, where name is a valid and
         * unique header name. The mapped non-static value must match the pattern of integration.response.header.{name}
         * or integration.response.body.{JSON-expression}, where name is a valid and unique response header name and
         * JSON-expression is a valid JSON expression without the $ prefix.
         * </p>
         * 
         * @param responseParameters
         *        A key-value map specifying response parameters that are passed to the method response from the
         *        backend. The key is a method response header parameter name and the mapped value is an integration
         *        response header value, a static value enclosed within a pair of single quotes, or a JSON expression
         *        from the integration response body. The mapping key must match the pattern of
         *        method.response.header.{name}, where name is a valid and unique header name. The mapped non-static
         *        value must match the pattern of integration.response.header.{name} or
         *        integration.response.body.{JSON-expression}, where name is a valid and unique response header name and
         *        JSON-expression is a valid JSON expression without the $ prefix.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder responseParameters(Map<String, String> responseParameters);

        /**
         * <p>
         * The collection of response templates for the integration response as a string-to-string map of key-value
         * pairs. Response templates are represented as a key/value map, with a content-type as the key and a template
         * as the value.
         * </p>
         * 
         * @param responseTemplates
         *        The collection of response templates for the integration response as a string-to-string map of
         *        key-value pairs. Response templates are represented as a key/value map, with a content-type as the key
         *        and a template as the value.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder responseTemplates(Map<String, String> responseTemplates);

        /**
         * <p>
         * The template selection expressions for the integration response.
         * </p>
         * 
         * @param templateSelectionExpression
         *        The template selection expressions for the integration response.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder templateSelectionExpression(String templateSelectionExpression);
    }

    static final class BuilderImpl extends ApiGatewayV2Response.BuilderImpl implements Builder {
        private String contentHandlingStrategy;

        private String integrationResponseId;

        private String integrationResponseKey;

        private Map<String, String> responseParameters = DefaultSdkAutoConstructMap.getInstance();

        private Map<String, String> responseTemplates = DefaultSdkAutoConstructMap.getInstance();

        private String templateSelectionExpression;

        private BuilderImpl() {
        }

        private BuilderImpl(GetIntegrationResponseResponse model) {
            super(model);
            contentHandlingStrategy(model.contentHandlingStrategy);
            integrationResponseId(model.integrationResponseId);
            integrationResponseKey(model.integrationResponseKey);
            responseParameters(model.responseParameters);
            responseTemplates(model.responseTemplates);
            templateSelectionExpression(model.templateSelectionExpression);
        }

        public final String getContentHandlingStrategy() {
            return contentHandlingStrategy;
        }

        @Override
        public final Builder contentHandlingStrategy(String contentHandlingStrategy) {
            this.contentHandlingStrategy = contentHandlingStrategy;
            return this;
        }

        @Override
        public final Builder contentHandlingStrategy(ContentHandlingStrategy contentHandlingStrategy) {
            this.contentHandlingStrategy(contentHandlingStrategy == null ? null : contentHandlingStrategy.toString());
            return this;
        }

        public final void setContentHandlingStrategy(String contentHandlingStrategy) {
            this.contentHandlingStrategy = contentHandlingStrategy;
        }

        public final String getIntegrationResponseId() {
            return integrationResponseId;
        }

        @Override
        public final Builder integrationResponseId(String integrationResponseId) {
            this.integrationResponseId = integrationResponseId;
            return this;
        }

        public final void setIntegrationResponseId(String integrationResponseId) {
            this.integrationResponseId = integrationResponseId;
        }

        public final String getIntegrationResponseKey() {
            return integrationResponseKey;
        }

        @Override
        public final Builder integrationResponseKey(String integrationResponseKey) {
            this.integrationResponseKey = integrationResponseKey;
            return this;
        }

        public final void setIntegrationResponseKey(String integrationResponseKey) {
            this.integrationResponseKey = integrationResponseKey;
        }

        public final Map<String, String> getResponseParameters() {
            return responseParameters;
        }

        @Override
        public final Builder responseParameters(Map<String, String> responseParameters) {
            this.responseParameters = IntegrationParametersCopier.copy(responseParameters);
            return this;
        }

        public final void setResponseParameters(Map<String, String> responseParameters) {
            this.responseParameters = IntegrationParametersCopier.copy(responseParameters);
        }

        public final Map<String, String> getResponseTemplates() {
            return responseTemplates;
        }

        @Override
        public final Builder responseTemplates(Map<String, String> responseTemplates) {
            this.responseTemplates = TemplateMapCopier.copy(responseTemplates);
            return this;
        }

        public final void setResponseTemplates(Map<String, String> responseTemplates) {
            this.responseTemplates = TemplateMapCopier.copy(responseTemplates);
        }

        public final String getTemplateSelectionExpression() {
            return templateSelectionExpression;
        }

        @Override
        public final Builder templateSelectionExpression(String templateSelectionExpression) {
            this.templateSelectionExpression = templateSelectionExpression;
            return this;
        }

        public final void setTemplateSelectionExpression(String templateSelectionExpression) {
            this.templateSelectionExpression = templateSelectionExpression;
        }

        @Override
        public GetIntegrationResponseResponse build() {
            return new GetIntegrationResponseResponse(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
