/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.apigatewayv2.model;

import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.MapTrait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructMap;
import software.amazon.awssdk.core.util.SdkAutoConstructMap;
import software.amazon.awssdk.utils.CollectionUtils;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * Updates a RouteResponse.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class UpdateRouteResponseRequest extends ApiGatewayV2Request implements
        ToCopyableBuilder<UpdateRouteResponseRequest.Builder, UpdateRouteResponseRequest> {
    private static final SdkField<String> API_ID_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .getter(getter(UpdateRouteResponseRequest::apiId)).setter(setter(Builder::apiId))
            .traits(LocationTrait.builder().location(MarshallLocation.PATH).locationName("apiId").build()).build();

    private static final SdkField<String> MODEL_SELECTION_EXPRESSION_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .getter(getter(UpdateRouteResponseRequest::modelSelectionExpression))
            .setter(setter(Builder::modelSelectionExpression))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("modelSelectionExpression").build())
            .build();

    private static final SdkField<Map<String, String>> RESPONSE_MODELS_FIELD = SdkField
            .<Map<String, String>> builder(MarshallingType.MAP)
            .getter(getter(UpdateRouteResponseRequest::responseModels))
            .setter(setter(Builder::responseModels))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("responseModels").build(),
                    MapTrait.builder()
                            .keyLocationName("key")
                            .valueLocationName("value")
                            .valueFieldInfo(
                                    SdkField.<String> builder(MarshallingType.STRING)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("value").build()).build()).build()).build();

    private static final SdkField<Map<String, ParameterConstraints>> RESPONSE_PARAMETERS_FIELD = SdkField
            .<Map<String, ParameterConstraints>> builder(MarshallingType.MAP)
            .getter(getter(UpdateRouteResponseRequest::responseParameters))
            .setter(setter(Builder::responseParameters))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("responseParameters").build(),
                    MapTrait.builder()
                            .keyLocationName("key")
                            .valueLocationName("value")
                            .valueFieldInfo(
                                    SdkField.<ParameterConstraints> builder(MarshallingType.SDK_POJO)
                                            .constructor(ParameterConstraints::builder)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("value").build()).build()).build()).build();

    private static final SdkField<String> ROUTE_ID_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .getter(getter(UpdateRouteResponseRequest::routeId)).setter(setter(Builder::routeId))
            .traits(LocationTrait.builder().location(MarshallLocation.PATH).locationName("routeId").build()).build();

    private static final SdkField<String> ROUTE_RESPONSE_ID_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .getter(getter(UpdateRouteResponseRequest::routeResponseId)).setter(setter(Builder::routeResponseId))
            .traits(LocationTrait.builder().location(MarshallLocation.PATH).locationName("routeResponseId").build()).build();

    private static final SdkField<String> ROUTE_RESPONSE_KEY_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .getter(getter(UpdateRouteResponseRequest::routeResponseKey)).setter(setter(Builder::routeResponseKey))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("routeResponseKey").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(API_ID_FIELD,
            MODEL_SELECTION_EXPRESSION_FIELD, RESPONSE_MODELS_FIELD, RESPONSE_PARAMETERS_FIELD, ROUTE_ID_FIELD,
            ROUTE_RESPONSE_ID_FIELD, ROUTE_RESPONSE_KEY_FIELD));

    private final String apiId;

    private final String modelSelectionExpression;

    private final Map<String, String> responseModels;

    private final Map<String, ParameterConstraints> responseParameters;

    private final String routeId;

    private final String routeResponseId;

    private final String routeResponseKey;

    private UpdateRouteResponseRequest(BuilderImpl builder) {
        super(builder);
        this.apiId = builder.apiId;
        this.modelSelectionExpression = builder.modelSelectionExpression;
        this.responseModels = builder.responseModels;
        this.responseParameters = builder.responseParameters;
        this.routeId = builder.routeId;
        this.routeResponseId = builder.routeResponseId;
        this.routeResponseKey = builder.routeResponseKey;
    }

    /**
     * <p>
     * The API identifier.
     * </p>
     * 
     * @return The API identifier.
     */
    public String apiId() {
        return apiId;
    }

    /**
     * <p>
     * The model selection expression for the route response. Supported only for WebSocket APIs.
     * </p>
     * 
     * @return The model selection expression for the route response. Supported only for WebSocket APIs.
     */
    public String modelSelectionExpression() {
        return modelSelectionExpression;
    }

    /**
     * Returns true if the ResponseModels property was specified by the sender (it may be empty), or false if the sender
     * did not specify the value (it will be empty). For responses returned by the SDK, the sender is the AWS service.
     */
    public boolean hasResponseModels() {
        return responseModels != null && !(responseModels instanceof SdkAutoConstructMap);
    }

    /**
     * <p>
     * The response models for the route response.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * You can use {@link #hasResponseModels()} to see if a value was sent in this field.
     * </p>
     * 
     * @return The response models for the route response.
     */
    public Map<String, String> responseModels() {
        return responseModels;
    }

    /**
     * Returns true if the ResponseParameters property was specified by the sender (it may be empty), or false if the
     * sender did not specify the value (it will be empty). For responses returned by the SDK, the sender is the AWS
     * service.
     */
    public boolean hasResponseParameters() {
        return responseParameters != null && !(responseParameters instanceof SdkAutoConstructMap);
    }

    /**
     * <p>
     * The route response parameters.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * You can use {@link #hasResponseParameters()} to see if a value was sent in this field.
     * </p>
     * 
     * @return The route response parameters.
     */
    public Map<String, ParameterConstraints> responseParameters() {
        return responseParameters;
    }

    /**
     * <p>
     * The route ID.
     * </p>
     * 
     * @return The route ID.
     */
    public String routeId() {
        return routeId;
    }

    /**
     * <p>
     * The route response ID.
     * </p>
     * 
     * @return The route response ID.
     */
    public String routeResponseId() {
        return routeResponseId;
    }

    /**
     * <p>
     * The route response key.
     * </p>
     * 
     * @return The route response key.
     */
    public String routeResponseKey() {
        return routeResponseKey;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(apiId());
        hashCode = 31 * hashCode + Objects.hashCode(modelSelectionExpression());
        hashCode = 31 * hashCode + Objects.hashCode(responseModels());
        hashCode = 31 * hashCode + Objects.hashCode(responseParameters());
        hashCode = 31 * hashCode + Objects.hashCode(routeId());
        hashCode = 31 * hashCode + Objects.hashCode(routeResponseId());
        hashCode = 31 * hashCode + Objects.hashCode(routeResponseKey());
        return hashCode;
    }

    @Override
    public boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof UpdateRouteResponseRequest)) {
            return false;
        }
        UpdateRouteResponseRequest other = (UpdateRouteResponseRequest) obj;
        return Objects.equals(apiId(), other.apiId())
                && Objects.equals(modelSelectionExpression(), other.modelSelectionExpression())
                && Objects.equals(responseModels(), other.responseModels())
                && Objects.equals(responseParameters(), other.responseParameters()) && Objects.equals(routeId(), other.routeId())
                && Objects.equals(routeResponseId(), other.routeResponseId())
                && Objects.equals(routeResponseKey(), other.routeResponseKey());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public String toString() {
        return ToString.builder("UpdateRouteResponseRequest").add("ApiId", apiId())
                .add("ModelSelectionExpression", modelSelectionExpression()).add("ResponseModels", responseModels())
                .add("ResponseParameters", responseParameters()).add("RouteId", routeId())
                .add("RouteResponseId", routeResponseId()).add("RouteResponseKey", routeResponseKey()).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "ApiId":
            return Optional.ofNullable(clazz.cast(apiId()));
        case "ModelSelectionExpression":
            return Optional.ofNullable(clazz.cast(modelSelectionExpression()));
        case "ResponseModels":
            return Optional.ofNullable(clazz.cast(responseModels()));
        case "ResponseParameters":
            return Optional.ofNullable(clazz.cast(responseParameters()));
        case "RouteId":
            return Optional.ofNullable(clazz.cast(routeId()));
        case "RouteResponseId":
            return Optional.ofNullable(clazz.cast(routeResponseId()));
        case "RouteResponseKey":
            return Optional.ofNullable(clazz.cast(routeResponseKey()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<UpdateRouteResponseRequest, T> g) {
        return obj -> g.apply((UpdateRouteResponseRequest) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends ApiGatewayV2Request.Builder, SdkPojo, CopyableBuilder<Builder, UpdateRouteResponseRequest> {
        /**
         * <p>
         * The API identifier.
         * </p>
         * 
         * @param apiId
         *        The API identifier.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder apiId(String apiId);

        /**
         * <p>
         * The model selection expression for the route response. Supported only for WebSocket APIs.
         * </p>
         * 
         * @param modelSelectionExpression
         *        The model selection expression for the route response. Supported only for WebSocket APIs.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder modelSelectionExpression(String modelSelectionExpression);

        /**
         * <p>
         * The response models for the route response.
         * </p>
         * 
         * @param responseModels
         *        The response models for the route response.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder responseModels(Map<String, String> responseModels);

        /**
         * <p>
         * The route response parameters.
         * </p>
         * 
         * @param responseParameters
         *        The route response parameters.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder responseParameters(Map<String, ParameterConstraints> responseParameters);

        /**
         * <p>
         * The route ID.
         * </p>
         * 
         * @param routeId
         *        The route ID.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder routeId(String routeId);

        /**
         * <p>
         * The route response ID.
         * </p>
         * 
         * @param routeResponseId
         *        The route response ID.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder routeResponseId(String routeResponseId);

        /**
         * <p>
         * The route response key.
         * </p>
         * 
         * @param routeResponseKey
         *        The route response key.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder routeResponseKey(String routeResponseKey);

        @Override
        Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration);

        @Override
        Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer);
    }

    static final class BuilderImpl extends ApiGatewayV2Request.BuilderImpl implements Builder {
        private String apiId;

        private String modelSelectionExpression;

        private Map<String, String> responseModels = DefaultSdkAutoConstructMap.getInstance();

        private Map<String, ParameterConstraints> responseParameters = DefaultSdkAutoConstructMap.getInstance();

        private String routeId;

        private String routeResponseId;

        private String routeResponseKey;

        private BuilderImpl() {
        }

        private BuilderImpl(UpdateRouteResponseRequest model) {
            super(model);
            apiId(model.apiId);
            modelSelectionExpression(model.modelSelectionExpression);
            responseModels(model.responseModels);
            responseParameters(model.responseParameters);
            routeId(model.routeId);
            routeResponseId(model.routeResponseId);
            routeResponseKey(model.routeResponseKey);
        }

        public final String getApiId() {
            return apiId;
        }

        @Override
        public final Builder apiId(String apiId) {
            this.apiId = apiId;
            return this;
        }

        public final void setApiId(String apiId) {
            this.apiId = apiId;
        }

        public final String getModelSelectionExpression() {
            return modelSelectionExpression;
        }

        @Override
        public final Builder modelSelectionExpression(String modelSelectionExpression) {
            this.modelSelectionExpression = modelSelectionExpression;
            return this;
        }

        public final void setModelSelectionExpression(String modelSelectionExpression) {
            this.modelSelectionExpression = modelSelectionExpression;
        }

        public final Map<String, String> getResponseModels() {
            return responseModels;
        }

        @Override
        public final Builder responseModels(Map<String, String> responseModels) {
            this.responseModels = RouteModelsCopier.copy(responseModels);
            return this;
        }

        public final void setResponseModels(Map<String, String> responseModels) {
            this.responseModels = RouteModelsCopier.copy(responseModels);
        }

        public final Map<String, ParameterConstraints.Builder> getResponseParameters() {
            return responseParameters != null ? CollectionUtils.mapValues(responseParameters, ParameterConstraints::toBuilder)
                    : null;
        }

        @Override
        public final Builder responseParameters(Map<String, ParameterConstraints> responseParameters) {
            this.responseParameters = RouteParametersCopier.copy(responseParameters);
            return this;
        }

        public final void setResponseParameters(Map<String, ParameterConstraints.BuilderImpl> responseParameters) {
            this.responseParameters = RouteParametersCopier.copyFromBuilder(responseParameters);
        }

        public final String getRouteId() {
            return routeId;
        }

        @Override
        public final Builder routeId(String routeId) {
            this.routeId = routeId;
            return this;
        }

        public final void setRouteId(String routeId) {
            this.routeId = routeId;
        }

        public final String getRouteResponseId() {
            return routeResponseId;
        }

        @Override
        public final Builder routeResponseId(String routeResponseId) {
            this.routeResponseId = routeResponseId;
            return this;
        }

        public final void setRouteResponseId(String routeResponseId) {
            this.routeResponseId = routeResponseId;
        }

        public final String getRouteResponseKey() {
            return routeResponseKey;
        }

        @Override
        public final Builder routeResponseKey(String routeResponseKey) {
            this.routeResponseKey = routeResponseKey;
            return this;
        }

        public final void setRouteResponseKey(String routeResponseKey) {
            this.routeResponseKey = routeResponseKey;
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public UpdateRouteResponseRequest build() {
            return new UpdateRouteResponseRequest(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
