/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.apigatewayv2.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public final class GetStagesResponse extends ApiGatewayV2Response implements
        ToCopyableBuilder<GetStagesResponse.Builder, GetStagesResponse> {
    private static final SdkField<List<Stage>> ITEMS_FIELD = SdkField
            .<List<Stage>> builder(MarshallingType.LIST)
            .getter(getter(GetStagesResponse::items))
            .setter(setter(Builder::items))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("items").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<Stage> builder(MarshallingType.SDK_POJO)
                                            .constructor(Stage::builder)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final SdkField<String> NEXT_TOKEN_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .getter(getter(GetStagesResponse::nextToken)).setter(setter(Builder::nextToken))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("nextToken").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections
            .unmodifiableList(Arrays.asList(ITEMS_FIELD, NEXT_TOKEN_FIELD));

    private final List<Stage> items;

    private final String nextToken;

    private GetStagesResponse(BuilderImpl builder) {
        super(builder);
        this.items = builder.items;
        this.nextToken = builder.nextToken;
    }

    /**
     * Returns true if the Items property was specified by the sender (it may be empty), or false if the sender did not
     * specify the value (it will be empty). For responses returned by the SDK, the sender is the AWS service.
     */
    public boolean hasItems() {
        return items != null && !(items instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * The elements from this collection.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * You can use {@link #hasItems()} to see if a value was sent in this field.
     * </p>
     * 
     * @return The elements from this collection.
     */
    public List<Stage> items() {
        return items;
    }

    /**
     * <p>
     * The next page of elements from this collection. Not valid for the last element of the collection.
     * </p>
     * 
     * @return The next page of elements from this collection. Not valid for the last element of the collection.
     */
    public String nextToken() {
        return nextToken;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(items());
        hashCode = 31 * hashCode + Objects.hashCode(nextToken());
        return hashCode;
    }

    @Override
    public boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof GetStagesResponse)) {
            return false;
        }
        GetStagesResponse other = (GetStagesResponse) obj;
        return Objects.equals(items(), other.items()) && Objects.equals(nextToken(), other.nextToken());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public String toString() {
        return ToString.builder("GetStagesResponse").add("Items", items()).add("NextToken", nextToken()).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "Items":
            return Optional.ofNullable(clazz.cast(items()));
        case "NextToken":
            return Optional.ofNullable(clazz.cast(nextToken()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<GetStagesResponse, T> g) {
        return obj -> g.apply((GetStagesResponse) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends ApiGatewayV2Response.Builder, SdkPojo, CopyableBuilder<Builder, GetStagesResponse> {
        /**
         * <p>
         * The elements from this collection.
         * </p>
         * 
         * @param items
         *        The elements from this collection.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder items(Collection<Stage> items);

        /**
         * <p>
         * The elements from this collection.
         * </p>
         * 
         * @param items
         *        The elements from this collection.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder items(Stage... items);

        /**
         * <p>
         * The elements from this collection.
         * </p>
         * This is a convenience that creates an instance of the {@link List<Stage>.Builder} avoiding the need to create
         * one manually via {@link List<Stage>#builder()}.
         *
         * When the {@link Consumer} completes, {@link List<Stage>.Builder#build()} is called immediately and its result
         * is passed to {@link #items(List<Stage>)}.
         * 
         * @param items
         *        a consumer that will call methods on {@link List<Stage>.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #items(List<Stage>)
         */
        Builder items(Consumer<Stage.Builder>... items);

        /**
         * <p>
         * The next page of elements from this collection. Not valid for the last element of the collection.
         * </p>
         * 
         * @param nextToken
         *        The next page of elements from this collection. Not valid for the last element of the collection.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder nextToken(String nextToken);
    }

    static final class BuilderImpl extends ApiGatewayV2Response.BuilderImpl implements Builder {
        private List<Stage> items = DefaultSdkAutoConstructList.getInstance();

        private String nextToken;

        private BuilderImpl() {
        }

        private BuilderImpl(GetStagesResponse model) {
            super(model);
            items(model.items);
            nextToken(model.nextToken);
        }

        public final Collection<Stage.Builder> getItems() {
            return items != null ? items.stream().map(Stage::toBuilder).collect(Collectors.toList()) : null;
        }

        @Override
        public final Builder items(Collection<Stage> items) {
            this.items = ___listOfStageCopier.copy(items);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder items(Stage... items) {
            items(Arrays.asList(items));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder items(Consumer<Stage.Builder>... items) {
            items(Stream.of(items).map(c -> Stage.builder().applyMutation(c).build()).collect(Collectors.toList()));
            return this;
        }

        public final void setItems(Collection<Stage.BuilderImpl> items) {
            this.items = ___listOfStageCopier.copyFromBuilder(items);
        }

        public final String getNextToken() {
            return nextToken;
        }

        @Override
        public final Builder nextToken(String nextToken) {
            this.nextToken = nextToken;
            return this;
        }

        public final void setNextToken(String nextToken) {
            this.nextToken = nextToken;
        }

        @Override
        public GetStagesResponse build() {
            return new GetStagesResponse(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
