/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.apigatewayv2.model;

import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.MapTrait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructMap;
import software.amazon.awssdk.core.util.SdkAutoConstructMap;
import software.amazon.awssdk.utils.CollectionUtils;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * Creates a new Stage resource to represent a stage.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class CreateStageRequest extends ApiGatewayV2Request implements
        ToCopyableBuilder<CreateStageRequest.Builder, CreateStageRequest> {
    private static final SdkField<AccessLogSettings> ACCESS_LOG_SETTINGS_FIELD = SdkField
            .<AccessLogSettings> builder(MarshallingType.SDK_POJO).memberName("AccessLogSettings")
            .getter(getter(CreateStageRequest::accessLogSettings)).setter(setter(Builder::accessLogSettings))
            .constructor(AccessLogSettings::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("accessLogSettings").build()).build();

    private static final SdkField<String> API_ID_FIELD = SdkField.<String> builder(MarshallingType.STRING).memberName("ApiId")
            .getter(getter(CreateStageRequest::apiId)).setter(setter(Builder::apiId))
            .traits(LocationTrait.builder().location(MarshallLocation.PATH).locationName("apiId").build()).build();

    private static final SdkField<Boolean> AUTO_DEPLOY_FIELD = SdkField.<Boolean> builder(MarshallingType.BOOLEAN)
            .memberName("AutoDeploy").getter(getter(CreateStageRequest::autoDeploy)).setter(setter(Builder::autoDeploy))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("autoDeploy").build()).build();

    private static final SdkField<String> CLIENT_CERTIFICATE_ID_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("ClientCertificateId").getter(getter(CreateStageRequest::clientCertificateId))
            .setter(setter(Builder::clientCertificateId))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("clientCertificateId").build())
            .build();

    private static final SdkField<RouteSettings> DEFAULT_ROUTE_SETTINGS_FIELD = SdkField
            .<RouteSettings> builder(MarshallingType.SDK_POJO).memberName("DefaultRouteSettings")
            .getter(getter(CreateStageRequest::defaultRouteSettings)).setter(setter(Builder::defaultRouteSettings))
            .constructor(RouteSettings::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("defaultRouteSettings").build())
            .build();

    private static final SdkField<String> DEPLOYMENT_ID_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("DeploymentId").getter(getter(CreateStageRequest::deploymentId)).setter(setter(Builder::deploymentId))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("deploymentId").build()).build();

    private static final SdkField<String> DESCRIPTION_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("Description").getter(getter(CreateStageRequest::description)).setter(setter(Builder::description))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("description").build()).build();

    private static final SdkField<Map<String, RouteSettings>> ROUTE_SETTINGS_FIELD = SdkField
            .<Map<String, RouteSettings>> builder(MarshallingType.MAP)
            .memberName("RouteSettings")
            .getter(getter(CreateStageRequest::routeSettings))
            .setter(setter(Builder::routeSettings))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("routeSettings").build(),
                    MapTrait.builder()
                            .keyLocationName("key")
                            .valueLocationName("value")
                            .valueFieldInfo(
                                    SdkField.<RouteSettings> builder(MarshallingType.SDK_POJO)
                                            .constructor(RouteSettings::builder)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("value").build()).build()).build()).build();

    private static final SdkField<String> STAGE_NAME_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("StageName").getter(getter(CreateStageRequest::stageName)).setter(setter(Builder::stageName))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("stageName").build()).build();

    private static final SdkField<Map<String, String>> STAGE_VARIABLES_FIELD = SdkField
            .<Map<String, String>> builder(MarshallingType.MAP)
            .memberName("StageVariables")
            .getter(getter(CreateStageRequest::stageVariables))
            .setter(setter(Builder::stageVariables))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("stageVariables").build(),
                    MapTrait.builder()
                            .keyLocationName("key")
                            .valueLocationName("value")
                            .valueFieldInfo(
                                    SdkField.<String> builder(MarshallingType.STRING)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("value").build()).build()).build()).build();

    private static final SdkField<Map<String, String>> TAGS_FIELD = SdkField
            .<Map<String, String>> builder(MarshallingType.MAP)
            .memberName("Tags")
            .getter(getter(CreateStageRequest::tags))
            .setter(setter(Builder::tags))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("tags").build(),
                    MapTrait.builder()
                            .keyLocationName("key")
                            .valueLocationName("value")
                            .valueFieldInfo(
                                    SdkField.<String> builder(MarshallingType.STRING)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("value").build()).build()).build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(ACCESS_LOG_SETTINGS_FIELD,
            API_ID_FIELD, AUTO_DEPLOY_FIELD, CLIENT_CERTIFICATE_ID_FIELD, DEFAULT_ROUTE_SETTINGS_FIELD, DEPLOYMENT_ID_FIELD,
            DESCRIPTION_FIELD, ROUTE_SETTINGS_FIELD, STAGE_NAME_FIELD, STAGE_VARIABLES_FIELD, TAGS_FIELD));

    private final AccessLogSettings accessLogSettings;

    private final String apiId;

    private final Boolean autoDeploy;

    private final String clientCertificateId;

    private final RouteSettings defaultRouteSettings;

    private final String deploymentId;

    private final String description;

    private final Map<String, RouteSettings> routeSettings;

    private final String stageName;

    private final Map<String, String> stageVariables;

    private final Map<String, String> tags;

    private CreateStageRequest(BuilderImpl builder) {
        super(builder);
        this.accessLogSettings = builder.accessLogSettings;
        this.apiId = builder.apiId;
        this.autoDeploy = builder.autoDeploy;
        this.clientCertificateId = builder.clientCertificateId;
        this.defaultRouteSettings = builder.defaultRouteSettings;
        this.deploymentId = builder.deploymentId;
        this.description = builder.description;
        this.routeSettings = builder.routeSettings;
        this.stageName = builder.stageName;
        this.stageVariables = builder.stageVariables;
        this.tags = builder.tags;
    }

    /**
     * <p>
     * Settings for logging access in this stage.
     * </p>
     * 
     * @return Settings for logging access in this stage.
     */
    public AccessLogSettings accessLogSettings() {
        return accessLogSettings;
    }

    /**
     * <p>
     * The API identifier.
     * </p>
     * 
     * @return The API identifier.
     */
    public String apiId() {
        return apiId;
    }

    /**
     * <p>
     * Specifies whether updates to an API automatically trigger a new deployment. The default value is false.
     * </p>
     * 
     * @return Specifies whether updates to an API automatically trigger a new deployment. The default value is false.
     */
    public Boolean autoDeploy() {
        return autoDeploy;
    }

    /**
     * <p>
     * The identifier of a client certificate for a Stage. Supported only for WebSocket APIs.
     * </p>
     * 
     * @return The identifier of a client certificate for a Stage. Supported only for WebSocket APIs.
     */
    public String clientCertificateId() {
        return clientCertificateId;
    }

    /**
     * <p>
     * The default route settings for the stage.
     * </p>
     * 
     * @return The default route settings for the stage.
     */
    public RouteSettings defaultRouteSettings() {
        return defaultRouteSettings;
    }

    /**
     * <p>
     * The deployment identifier of the API stage.
     * </p>
     * 
     * @return The deployment identifier of the API stage.
     */
    public String deploymentId() {
        return deploymentId;
    }

    /**
     * <p>
     * The description for the API stage.
     * </p>
     * 
     * @return The description for the API stage.
     */
    public String description() {
        return description;
    }

    /**
     * Returns true if the RouteSettings property was specified by the sender (it may be empty), or false if the sender
     * did not specify the value (it will be empty). For responses returned by the SDK, the sender is the AWS service.
     */
    public boolean hasRouteSettings() {
        return routeSettings != null && !(routeSettings instanceof SdkAutoConstructMap);
    }

    /**
     * <p>
     * Route settings for the stage, by routeKey.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * You can use {@link #hasRouteSettings()} to see if a value was sent in this field.
     * </p>
     * 
     * @return Route settings for the stage, by routeKey.
     */
    public Map<String, RouteSettings> routeSettings() {
        return routeSettings;
    }

    /**
     * <p>
     * The name of the stage.
     * </p>
     * 
     * @return The name of the stage.
     */
    public String stageName() {
        return stageName;
    }

    /**
     * Returns true if the StageVariables property was specified by the sender (it may be empty), or false if the sender
     * did not specify the value (it will be empty). For responses returned by the SDK, the sender is the AWS service.
     */
    public boolean hasStageVariables() {
        return stageVariables != null && !(stageVariables instanceof SdkAutoConstructMap);
    }

    /**
     * <p>
     * A map that defines the stage variables for a Stage. Variable names can have alphanumeric and underscore
     * characters, and the values must match [A-Za-z0-9-._~:/?#&amp;=,]+.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * You can use {@link #hasStageVariables()} to see if a value was sent in this field.
     * </p>
     * 
     * @return A map that defines the stage variables for a Stage. Variable names can have alphanumeric and underscore
     *         characters, and the values must match [A-Za-z0-9-._~:/?#&amp;=,]+.
     */
    public Map<String, String> stageVariables() {
        return stageVariables;
    }

    /**
     * Returns true if the Tags property was specified by the sender (it may be empty), or false if the sender did not
     * specify the value (it will be empty). For responses returned by the SDK, the sender is the AWS service.
     */
    public boolean hasTags() {
        return tags != null && !(tags instanceof SdkAutoConstructMap);
    }

    /**
     * <p>
     * The collection of tags. Each tag element is associated with a given resource.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * You can use {@link #hasTags()} to see if a value was sent in this field.
     * </p>
     * 
     * @return The collection of tags. Each tag element is associated with a given resource.
     */
    public Map<String, String> tags() {
        return tags;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(accessLogSettings());
        hashCode = 31 * hashCode + Objects.hashCode(apiId());
        hashCode = 31 * hashCode + Objects.hashCode(autoDeploy());
        hashCode = 31 * hashCode + Objects.hashCode(clientCertificateId());
        hashCode = 31 * hashCode + Objects.hashCode(defaultRouteSettings());
        hashCode = 31 * hashCode + Objects.hashCode(deploymentId());
        hashCode = 31 * hashCode + Objects.hashCode(description());
        hashCode = 31 * hashCode + Objects.hashCode(hasRouteSettings() ? routeSettings() : null);
        hashCode = 31 * hashCode + Objects.hashCode(stageName());
        hashCode = 31 * hashCode + Objects.hashCode(hasStageVariables() ? stageVariables() : null);
        hashCode = 31 * hashCode + Objects.hashCode(hasTags() ? tags() : null);
        return hashCode;
    }

    @Override
    public boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof CreateStageRequest)) {
            return false;
        }
        CreateStageRequest other = (CreateStageRequest) obj;
        return Objects.equals(accessLogSettings(), other.accessLogSettings()) && Objects.equals(apiId(), other.apiId())
                && Objects.equals(autoDeploy(), other.autoDeploy())
                && Objects.equals(clientCertificateId(), other.clientCertificateId())
                && Objects.equals(defaultRouteSettings(), other.defaultRouteSettings())
                && Objects.equals(deploymentId(), other.deploymentId()) && Objects.equals(description(), other.description())
                && hasRouteSettings() == other.hasRouteSettings() && Objects.equals(routeSettings(), other.routeSettings())
                && Objects.equals(stageName(), other.stageName()) && hasStageVariables() == other.hasStageVariables()
                && Objects.equals(stageVariables(), other.stageVariables()) && hasTags() == other.hasTags()
                && Objects.equals(tags(), other.tags());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public String toString() {
        return ToString.builder("CreateStageRequest").add("AccessLogSettings", accessLogSettings()).add("ApiId", apiId())
                .add("AutoDeploy", autoDeploy()).add("ClientCertificateId", clientCertificateId())
                .add("DefaultRouteSettings", defaultRouteSettings()).add("DeploymentId", deploymentId())
                .add("Description", description()).add("RouteSettings", hasRouteSettings() ? routeSettings() : null)
                .add("StageName", stageName()).add("StageVariables", hasStageVariables() ? stageVariables() : null)
                .add("Tags", hasTags() ? tags() : null).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "AccessLogSettings":
            return Optional.ofNullable(clazz.cast(accessLogSettings()));
        case "ApiId":
            return Optional.ofNullable(clazz.cast(apiId()));
        case "AutoDeploy":
            return Optional.ofNullable(clazz.cast(autoDeploy()));
        case "ClientCertificateId":
            return Optional.ofNullable(clazz.cast(clientCertificateId()));
        case "DefaultRouteSettings":
            return Optional.ofNullable(clazz.cast(defaultRouteSettings()));
        case "DeploymentId":
            return Optional.ofNullable(clazz.cast(deploymentId()));
        case "Description":
            return Optional.ofNullable(clazz.cast(description()));
        case "RouteSettings":
            return Optional.ofNullable(clazz.cast(routeSettings()));
        case "StageName":
            return Optional.ofNullable(clazz.cast(stageName()));
        case "StageVariables":
            return Optional.ofNullable(clazz.cast(stageVariables()));
        case "Tags":
            return Optional.ofNullable(clazz.cast(tags()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<CreateStageRequest, T> g) {
        return obj -> g.apply((CreateStageRequest) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends ApiGatewayV2Request.Builder, SdkPojo, CopyableBuilder<Builder, CreateStageRequest> {
        /**
         * <p>
         * Settings for logging access in this stage.
         * </p>
         * 
         * @param accessLogSettings
         *        Settings for logging access in this stage.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder accessLogSettings(AccessLogSettings accessLogSettings);

        /**
         * <p>
         * Settings for logging access in this stage.
         * </p>
         * This is a convenience that creates an instance of the {@link AccessLogSettings.Builder} avoiding the need to
         * create one manually via {@link AccessLogSettings#builder()}.
         *
         * When the {@link Consumer} completes, {@link AccessLogSettings.Builder#build()} is called immediately and its
         * result is passed to {@link #accessLogSettings(AccessLogSettings)}.
         * 
         * @param accessLogSettings
         *        a consumer that will call methods on {@link AccessLogSettings.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #accessLogSettings(AccessLogSettings)
         */
        default Builder accessLogSettings(Consumer<AccessLogSettings.Builder> accessLogSettings) {
            return accessLogSettings(AccessLogSettings.builder().applyMutation(accessLogSettings).build());
        }

        /**
         * <p>
         * The API identifier.
         * </p>
         * 
         * @param apiId
         *        The API identifier.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder apiId(String apiId);

        /**
         * <p>
         * Specifies whether updates to an API automatically trigger a new deployment. The default value is false.
         * </p>
         * 
         * @param autoDeploy
         *        Specifies whether updates to an API automatically trigger a new deployment. The default value is
         *        false.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder autoDeploy(Boolean autoDeploy);

        /**
         * <p>
         * The identifier of a client certificate for a Stage. Supported only for WebSocket APIs.
         * </p>
         * 
         * @param clientCertificateId
         *        The identifier of a client certificate for a Stage. Supported only for WebSocket APIs.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder clientCertificateId(String clientCertificateId);

        /**
         * <p>
         * The default route settings for the stage.
         * </p>
         * 
         * @param defaultRouteSettings
         *        The default route settings for the stage.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder defaultRouteSettings(RouteSettings defaultRouteSettings);

        /**
         * <p>
         * The default route settings for the stage.
         * </p>
         * This is a convenience that creates an instance of the {@link RouteSettings.Builder} avoiding the need to
         * create one manually via {@link RouteSettings#builder()}.
         *
         * When the {@link Consumer} completes, {@link RouteSettings.Builder#build()} is called immediately and its
         * result is passed to {@link #defaultRouteSettings(RouteSettings)}.
         * 
         * @param defaultRouteSettings
         *        a consumer that will call methods on {@link RouteSettings.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #defaultRouteSettings(RouteSettings)
         */
        default Builder defaultRouteSettings(Consumer<RouteSettings.Builder> defaultRouteSettings) {
            return defaultRouteSettings(RouteSettings.builder().applyMutation(defaultRouteSettings).build());
        }

        /**
         * <p>
         * The deployment identifier of the API stage.
         * </p>
         * 
         * @param deploymentId
         *        The deployment identifier of the API stage.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder deploymentId(String deploymentId);

        /**
         * <p>
         * The description for the API stage.
         * </p>
         * 
         * @param description
         *        The description for the API stage.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder description(String description);

        /**
         * <p>
         * Route settings for the stage, by routeKey.
         * </p>
         * 
         * @param routeSettings
         *        Route settings for the stage, by routeKey.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder routeSettings(Map<String, RouteSettings> routeSettings);

        /**
         * <p>
         * The name of the stage.
         * </p>
         * 
         * @param stageName
         *        The name of the stage.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder stageName(String stageName);

        /**
         * <p>
         * A map that defines the stage variables for a Stage. Variable names can have alphanumeric and underscore
         * characters, and the values must match [A-Za-z0-9-._~:/?#&amp;=,]+.
         * </p>
         * 
         * @param stageVariables
         *        A map that defines the stage variables for a Stage. Variable names can have alphanumeric and
         *        underscore characters, and the values must match [A-Za-z0-9-._~:/?#&amp;=,]+.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder stageVariables(Map<String, String> stageVariables);

        /**
         * <p>
         * The collection of tags. Each tag element is associated with a given resource.
         * </p>
         * 
         * @param tags
         *        The collection of tags. Each tag element is associated with a given resource.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder tags(Map<String, String> tags);

        @Override
        Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration);

        @Override
        Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer);
    }

    static final class BuilderImpl extends ApiGatewayV2Request.BuilderImpl implements Builder {
        private AccessLogSettings accessLogSettings;

        private String apiId;

        private Boolean autoDeploy;

        private String clientCertificateId;

        private RouteSettings defaultRouteSettings;

        private String deploymentId;

        private String description;

        private Map<String, RouteSettings> routeSettings = DefaultSdkAutoConstructMap.getInstance();

        private String stageName;

        private Map<String, String> stageVariables = DefaultSdkAutoConstructMap.getInstance();

        private Map<String, String> tags = DefaultSdkAutoConstructMap.getInstance();

        private BuilderImpl() {
        }

        private BuilderImpl(CreateStageRequest model) {
            super(model);
            accessLogSettings(model.accessLogSettings);
            apiId(model.apiId);
            autoDeploy(model.autoDeploy);
            clientCertificateId(model.clientCertificateId);
            defaultRouteSettings(model.defaultRouteSettings);
            deploymentId(model.deploymentId);
            description(model.description);
            routeSettings(model.routeSettings);
            stageName(model.stageName);
            stageVariables(model.stageVariables);
            tags(model.tags);
        }

        public final AccessLogSettings.Builder getAccessLogSettings() {
            return accessLogSettings != null ? accessLogSettings.toBuilder() : null;
        }

        @Override
        public final Builder accessLogSettings(AccessLogSettings accessLogSettings) {
            this.accessLogSettings = accessLogSettings;
            return this;
        }

        public final void setAccessLogSettings(AccessLogSettings.BuilderImpl accessLogSettings) {
            this.accessLogSettings = accessLogSettings != null ? accessLogSettings.build() : null;
        }

        public final String getApiId() {
            return apiId;
        }

        @Override
        public final Builder apiId(String apiId) {
            this.apiId = apiId;
            return this;
        }

        public final void setApiId(String apiId) {
            this.apiId = apiId;
        }

        public final Boolean getAutoDeploy() {
            return autoDeploy;
        }

        @Override
        public final Builder autoDeploy(Boolean autoDeploy) {
            this.autoDeploy = autoDeploy;
            return this;
        }

        public final void setAutoDeploy(Boolean autoDeploy) {
            this.autoDeploy = autoDeploy;
        }

        public final String getClientCertificateId() {
            return clientCertificateId;
        }

        @Override
        public final Builder clientCertificateId(String clientCertificateId) {
            this.clientCertificateId = clientCertificateId;
            return this;
        }

        public final void setClientCertificateId(String clientCertificateId) {
            this.clientCertificateId = clientCertificateId;
        }

        public final RouteSettings.Builder getDefaultRouteSettings() {
            return defaultRouteSettings != null ? defaultRouteSettings.toBuilder() : null;
        }

        @Override
        public final Builder defaultRouteSettings(RouteSettings defaultRouteSettings) {
            this.defaultRouteSettings = defaultRouteSettings;
            return this;
        }

        public final void setDefaultRouteSettings(RouteSettings.BuilderImpl defaultRouteSettings) {
            this.defaultRouteSettings = defaultRouteSettings != null ? defaultRouteSettings.build() : null;
        }

        public final String getDeploymentId() {
            return deploymentId;
        }

        @Override
        public final Builder deploymentId(String deploymentId) {
            this.deploymentId = deploymentId;
            return this;
        }

        public final void setDeploymentId(String deploymentId) {
            this.deploymentId = deploymentId;
        }

        public final String getDescription() {
            return description;
        }

        @Override
        public final Builder description(String description) {
            this.description = description;
            return this;
        }

        public final void setDescription(String description) {
            this.description = description;
        }

        public final Map<String, RouteSettings.Builder> getRouteSettings() {
            if (routeSettings instanceof SdkAutoConstructMap) {
                return null;
            }
            return routeSettings != null ? CollectionUtils.mapValues(routeSettings, RouteSettings::toBuilder) : null;
        }

        @Override
        public final Builder routeSettings(Map<String, RouteSettings> routeSettings) {
            this.routeSettings = RouteSettingsMapCopier.copy(routeSettings);
            return this;
        }

        public final void setRouteSettings(Map<String, RouteSettings.BuilderImpl> routeSettings) {
            this.routeSettings = RouteSettingsMapCopier.copyFromBuilder(routeSettings);
        }

        public final String getStageName() {
            return stageName;
        }

        @Override
        public final Builder stageName(String stageName) {
            this.stageName = stageName;
            return this;
        }

        public final void setStageName(String stageName) {
            this.stageName = stageName;
        }

        public final Map<String, String> getStageVariables() {
            if (stageVariables instanceof SdkAutoConstructMap) {
                return null;
            }
            return stageVariables;
        }

        @Override
        public final Builder stageVariables(Map<String, String> stageVariables) {
            this.stageVariables = StageVariablesMapCopier.copy(stageVariables);
            return this;
        }

        public final void setStageVariables(Map<String, String> stageVariables) {
            this.stageVariables = StageVariablesMapCopier.copy(stageVariables);
        }

        public final Map<String, String> getTags() {
            if (tags instanceof SdkAutoConstructMap) {
                return null;
            }
            return tags;
        }

        @Override
        public final Builder tags(Map<String, String> tags) {
            this.tags = TagsCopier.copy(tags);
            return this;
        }

        public final void setTags(Map<String, String> tags) {
            this.tags = TagsCopier.copy(tags);
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public CreateStageRequest build() {
            return new CreateStageRequest(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
