/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.apigatewayv2.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * Validation constraints imposed on parameters of a request (path, query string, headers).
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class ParameterConstraints implements SdkPojo, Serializable,
        ToCopyableBuilder<ParameterConstraints.Builder, ParameterConstraints> {
    private static final SdkField<Boolean> REQUIRED_FIELD = SdkField.<Boolean> builder(MarshallingType.BOOLEAN)
            .memberName("Required").getter(getter(ParameterConstraints::required)).setter(setter(Builder::required))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("required").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(REQUIRED_FIELD));

    private static final long serialVersionUID = 1L;

    private final Boolean required;

    private ParameterConstraints(BuilderImpl builder) {
        this.required = builder.required;
    }

    /**
     * <p>
     * Whether or not the parameter is required.
     * </p>
     * 
     * @return Whether or not the parameter is required.
     */
    public Boolean required() {
        return required;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(required());
        return hashCode;
    }

    @Override
    public boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ParameterConstraints)) {
            return false;
        }
        ParameterConstraints other = (ParameterConstraints) obj;
        return Objects.equals(required(), other.required());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public String toString() {
        return ToString.builder("ParameterConstraints").add("Required", required()).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "Required":
            return Optional.ofNullable(clazz.cast(required()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<ParameterConstraints, T> g) {
        return obj -> g.apply((ParameterConstraints) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SdkPojo, CopyableBuilder<Builder, ParameterConstraints> {
        /**
         * <p>
         * Whether or not the parameter is required.
         * </p>
         * 
         * @param required
         *        Whether or not the parameter is required.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder required(Boolean required);
    }

    static final class BuilderImpl implements Builder {
        private Boolean required;

        private BuilderImpl() {
        }

        private BuilderImpl(ParameterConstraints model) {
            required(model.required);
        }

        public final Boolean getRequired() {
            return required;
        }

        @Override
        public final Builder required(Boolean required) {
            this.required = required;
            return this;
        }

        public final void setRequired(Boolean required) {
            this.required = required;
        }

        @Override
        public ParameterConstraints build() {
            return new ParameterConstraints(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
