/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.apigatewayv2.model;

import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.MapTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructMap;
import software.amazon.awssdk.core.util.SdkAutoConstructMap;
import software.amazon.awssdk.services.apigatewayv2.model.ApiGatewayV2Request;
import software.amazon.awssdk.services.apigatewayv2.model.ConnectionType;
import software.amazon.awssdk.services.apigatewayv2.model.ContentHandlingStrategy;
import software.amazon.awssdk.services.apigatewayv2.model.IntegrationParametersCopier;
import software.amazon.awssdk.services.apigatewayv2.model.IntegrationType;
import software.amazon.awssdk.services.apigatewayv2.model.PassthroughBehavior;
import software.amazon.awssdk.services.apigatewayv2.model.TemplateMapCopier;
import software.amazon.awssdk.services.apigatewayv2.model.TlsConfigInput;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class CreateIntegrationRequest
extends ApiGatewayV2Request
implements ToCopyableBuilder<Builder, CreateIntegrationRequest> {
    private static final SdkField<String> API_ID_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("ApiId").getter(CreateIntegrationRequest.getter(CreateIntegrationRequest::apiId)).setter(CreateIntegrationRequest.setter(Builder::apiId)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PATH).locationName("apiId").build()}).build();
    private static final SdkField<String> CONNECTION_ID_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("ConnectionId").getter(CreateIntegrationRequest.getter(CreateIntegrationRequest::connectionId)).setter(CreateIntegrationRequest.setter(Builder::connectionId)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("connectionId").build()}).build();
    private static final SdkField<String> CONNECTION_TYPE_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("ConnectionType").getter(CreateIntegrationRequest.getter(CreateIntegrationRequest::connectionTypeAsString)).setter(CreateIntegrationRequest.setter(Builder::connectionType)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("connectionType").build()}).build();
    private static final SdkField<String> CONTENT_HANDLING_STRATEGY_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("ContentHandlingStrategy").getter(CreateIntegrationRequest.getter(CreateIntegrationRequest::contentHandlingStrategyAsString)).setter(CreateIntegrationRequest.setter(Builder::contentHandlingStrategy)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("contentHandlingStrategy").build()}).build();
    private static final SdkField<String> CREDENTIALS_ARN_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("CredentialsArn").getter(CreateIntegrationRequest.getter(CreateIntegrationRequest::credentialsArn)).setter(CreateIntegrationRequest.setter(Builder::credentialsArn)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("credentialsArn").build()}).build();
    private static final SdkField<String> DESCRIPTION_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("Description").getter(CreateIntegrationRequest.getter(CreateIntegrationRequest::description)).setter(CreateIntegrationRequest.setter(Builder::description)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("description").build()}).build();
    private static final SdkField<String> INTEGRATION_METHOD_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("IntegrationMethod").getter(CreateIntegrationRequest.getter(CreateIntegrationRequest::integrationMethod)).setter(CreateIntegrationRequest.setter(Builder::integrationMethod)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("integrationMethod").build()}).build();
    private static final SdkField<String> INTEGRATION_SUBTYPE_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("IntegrationSubtype").getter(CreateIntegrationRequest.getter(CreateIntegrationRequest::integrationSubtype)).setter(CreateIntegrationRequest.setter(Builder::integrationSubtype)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("integrationSubtype").build()}).build();
    private static final SdkField<String> INTEGRATION_TYPE_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("IntegrationType").getter(CreateIntegrationRequest.getter(CreateIntegrationRequest::integrationTypeAsString)).setter(CreateIntegrationRequest.setter(Builder::integrationType)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("integrationType").build()}).build();
    private static final SdkField<String> INTEGRATION_URI_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("IntegrationUri").getter(CreateIntegrationRequest.getter(CreateIntegrationRequest::integrationUri)).setter(CreateIntegrationRequest.setter(Builder::integrationUri)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("integrationUri").build()}).build();
    private static final SdkField<String> PASSTHROUGH_BEHAVIOR_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("PassthroughBehavior").getter(CreateIntegrationRequest.getter(CreateIntegrationRequest::passthroughBehaviorAsString)).setter(CreateIntegrationRequest.setter(Builder::passthroughBehavior)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("passthroughBehavior").build()}).build();
    private static final SdkField<String> PAYLOAD_FORMAT_VERSION_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("PayloadFormatVersion").getter(CreateIntegrationRequest.getter(CreateIntegrationRequest::payloadFormatVersion)).setter(CreateIntegrationRequest.setter(Builder::payloadFormatVersion)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("payloadFormatVersion").build()}).build();
    private static final SdkField<Map<String, String>> REQUEST_PARAMETERS_FIELD = SdkField.builder((MarshallingType)MarshallingType.MAP).memberName("RequestParameters").getter(CreateIntegrationRequest.getter(CreateIntegrationRequest::requestParameters)).setter(CreateIntegrationRequest.setter(Builder::requestParameters)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("requestParameters").build(), MapTrait.builder().keyLocationName("key").valueLocationName("value").valueFieldInfo(SdkField.builder((MarshallingType)MarshallingType.STRING).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("value").build()}).build()).build()}).build();
    private static final SdkField<Map<String, String>> REQUEST_TEMPLATES_FIELD = SdkField.builder((MarshallingType)MarshallingType.MAP).memberName("RequestTemplates").getter(CreateIntegrationRequest.getter(CreateIntegrationRequest::requestTemplates)).setter(CreateIntegrationRequest.setter(Builder::requestTemplates)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("requestTemplates").build(), MapTrait.builder().keyLocationName("key").valueLocationName("value").valueFieldInfo(SdkField.builder((MarshallingType)MarshallingType.STRING).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("value").build()}).build()).build()}).build();
    private static final SdkField<String> TEMPLATE_SELECTION_EXPRESSION_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("TemplateSelectionExpression").getter(CreateIntegrationRequest.getter(CreateIntegrationRequest::templateSelectionExpression)).setter(CreateIntegrationRequest.setter(Builder::templateSelectionExpression)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("templateSelectionExpression").build()}).build();
    private static final SdkField<Integer> TIMEOUT_IN_MILLIS_FIELD = SdkField.builder((MarshallingType)MarshallingType.INTEGER).memberName("TimeoutInMillis").getter(CreateIntegrationRequest.getter(CreateIntegrationRequest::timeoutInMillis)).setter(CreateIntegrationRequest.setter(Builder::timeoutInMillis)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("timeoutInMillis").build()}).build();
    private static final SdkField<TlsConfigInput> TLS_CONFIG_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("TlsConfig").getter(CreateIntegrationRequest.getter(CreateIntegrationRequest::tlsConfig)).setter(CreateIntegrationRequest.setter(Builder::tlsConfig)).constructor(TlsConfigInput::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("tlsConfig").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(API_ID_FIELD, CONNECTION_ID_FIELD, CONNECTION_TYPE_FIELD, CONTENT_HANDLING_STRATEGY_FIELD, CREDENTIALS_ARN_FIELD, DESCRIPTION_FIELD, INTEGRATION_METHOD_FIELD, INTEGRATION_SUBTYPE_FIELD, INTEGRATION_TYPE_FIELD, INTEGRATION_URI_FIELD, PASSTHROUGH_BEHAVIOR_FIELD, PAYLOAD_FORMAT_VERSION_FIELD, REQUEST_PARAMETERS_FIELD, REQUEST_TEMPLATES_FIELD, TEMPLATE_SELECTION_EXPRESSION_FIELD, TIMEOUT_IN_MILLIS_FIELD, TLS_CONFIG_FIELD));
    private final String apiId;
    private final String connectionId;
    private final String connectionType;
    private final String contentHandlingStrategy;
    private final String credentialsArn;
    private final String description;
    private final String integrationMethod;
    private final String integrationSubtype;
    private final String integrationType;
    private final String integrationUri;
    private final String passthroughBehavior;
    private final String payloadFormatVersion;
    private final Map<String, String> requestParameters;
    private final Map<String, String> requestTemplates;
    private final String templateSelectionExpression;
    private final Integer timeoutInMillis;
    private final TlsConfigInput tlsConfig;

    private CreateIntegrationRequest(BuilderImpl builder) {
        super(builder);
        this.apiId = builder.apiId;
        this.connectionId = builder.connectionId;
        this.connectionType = builder.connectionType;
        this.contentHandlingStrategy = builder.contentHandlingStrategy;
        this.credentialsArn = builder.credentialsArn;
        this.description = builder.description;
        this.integrationMethod = builder.integrationMethod;
        this.integrationSubtype = builder.integrationSubtype;
        this.integrationType = builder.integrationType;
        this.integrationUri = builder.integrationUri;
        this.passthroughBehavior = builder.passthroughBehavior;
        this.payloadFormatVersion = builder.payloadFormatVersion;
        this.requestParameters = builder.requestParameters;
        this.requestTemplates = builder.requestTemplates;
        this.templateSelectionExpression = builder.templateSelectionExpression;
        this.timeoutInMillis = builder.timeoutInMillis;
        this.tlsConfig = builder.tlsConfig;
    }

    public String apiId() {
        return this.apiId;
    }

    public String connectionId() {
        return this.connectionId;
    }

    public ConnectionType connectionType() {
        return ConnectionType.fromValue(this.connectionType);
    }

    public String connectionTypeAsString() {
        return this.connectionType;
    }

    public ContentHandlingStrategy contentHandlingStrategy() {
        return ContentHandlingStrategy.fromValue(this.contentHandlingStrategy);
    }

    public String contentHandlingStrategyAsString() {
        return this.contentHandlingStrategy;
    }

    public String credentialsArn() {
        return this.credentialsArn;
    }

    public String description() {
        return this.description;
    }

    public String integrationMethod() {
        return this.integrationMethod;
    }

    public String integrationSubtype() {
        return this.integrationSubtype;
    }

    public IntegrationType integrationType() {
        return IntegrationType.fromValue(this.integrationType);
    }

    public String integrationTypeAsString() {
        return this.integrationType;
    }

    public String integrationUri() {
        return this.integrationUri;
    }

    public PassthroughBehavior passthroughBehavior() {
        return PassthroughBehavior.fromValue(this.passthroughBehavior);
    }

    public String passthroughBehaviorAsString() {
        return this.passthroughBehavior;
    }

    public String payloadFormatVersion() {
        return this.payloadFormatVersion;
    }

    public boolean hasRequestParameters() {
        return this.requestParameters != null && !(this.requestParameters instanceof SdkAutoConstructMap);
    }

    public Map<String, String> requestParameters() {
        return this.requestParameters;
    }

    public boolean hasRequestTemplates() {
        return this.requestTemplates != null && !(this.requestTemplates instanceof SdkAutoConstructMap);
    }

    public Map<String, String> requestTemplates() {
        return this.requestTemplates;
    }

    public String templateSelectionExpression() {
        return this.templateSelectionExpression;
    }

    public Integer timeoutInMillis() {
        return this.timeoutInMillis;
    }

    public TlsConfigInput tlsConfig() {
        return this.tlsConfig;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(this.apiId());
        hashCode = 31 * hashCode + Objects.hashCode(this.connectionId());
        hashCode = 31 * hashCode + Objects.hashCode(this.connectionTypeAsString());
        hashCode = 31 * hashCode + Objects.hashCode(this.contentHandlingStrategyAsString());
        hashCode = 31 * hashCode + Objects.hashCode(this.credentialsArn());
        hashCode = 31 * hashCode + Objects.hashCode(this.description());
        hashCode = 31 * hashCode + Objects.hashCode(this.integrationMethod());
        hashCode = 31 * hashCode + Objects.hashCode(this.integrationSubtype());
        hashCode = 31 * hashCode + Objects.hashCode(this.integrationTypeAsString());
        hashCode = 31 * hashCode + Objects.hashCode(this.integrationUri());
        hashCode = 31 * hashCode + Objects.hashCode(this.passthroughBehaviorAsString());
        hashCode = 31 * hashCode + Objects.hashCode(this.payloadFormatVersion());
        hashCode = 31 * hashCode + Objects.hashCode(this.hasRequestParameters() ? this.requestParameters() : null);
        hashCode = 31 * hashCode + Objects.hashCode(this.hasRequestTemplates() ? this.requestTemplates() : null);
        hashCode = 31 * hashCode + Objects.hashCode(this.templateSelectionExpression());
        hashCode = 31 * hashCode + Objects.hashCode(this.timeoutInMillis());
        hashCode = 31 * hashCode + Objects.hashCode(this.tlsConfig());
        return hashCode;
    }

    public boolean equals(Object obj) {
        return super.equals(obj) && this.equalsBySdkFields(obj);
    }

    public boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof CreateIntegrationRequest)) {
            return false;
        }
        CreateIntegrationRequest other = (CreateIntegrationRequest)((Object)obj);
        return Objects.equals(this.apiId(), other.apiId()) && Objects.equals(this.connectionId(), other.connectionId()) && Objects.equals(this.connectionTypeAsString(), other.connectionTypeAsString()) && Objects.equals(this.contentHandlingStrategyAsString(), other.contentHandlingStrategyAsString()) && Objects.equals(this.credentialsArn(), other.credentialsArn()) && Objects.equals(this.description(), other.description()) && Objects.equals(this.integrationMethod(), other.integrationMethod()) && Objects.equals(this.integrationSubtype(), other.integrationSubtype()) && Objects.equals(this.integrationTypeAsString(), other.integrationTypeAsString()) && Objects.equals(this.integrationUri(), other.integrationUri()) && Objects.equals(this.passthroughBehaviorAsString(), other.passthroughBehaviorAsString()) && Objects.equals(this.payloadFormatVersion(), other.payloadFormatVersion()) && this.hasRequestParameters() == other.hasRequestParameters() && Objects.equals(this.requestParameters(), other.requestParameters()) && this.hasRequestTemplates() == other.hasRequestTemplates() && Objects.equals(this.requestTemplates(), other.requestTemplates()) && Objects.equals(this.templateSelectionExpression(), other.templateSelectionExpression()) && Objects.equals(this.timeoutInMillis(), other.timeoutInMillis()) && Objects.equals(this.tlsConfig(), other.tlsConfig());
    }

    public String toString() {
        return ToString.builder((String)"CreateIntegrationRequest").add("ApiId", (Object)this.apiId()).add("ConnectionId", (Object)this.connectionId()).add("ConnectionType", (Object)this.connectionTypeAsString()).add("ContentHandlingStrategy", (Object)this.contentHandlingStrategyAsString()).add("CredentialsArn", (Object)this.credentialsArn()).add("Description", (Object)this.description()).add("IntegrationMethod", (Object)this.integrationMethod()).add("IntegrationSubtype", (Object)this.integrationSubtype()).add("IntegrationType", (Object)this.integrationTypeAsString()).add("IntegrationUri", (Object)this.integrationUri()).add("PassthroughBehavior", (Object)this.passthroughBehaviorAsString()).add("PayloadFormatVersion", (Object)this.payloadFormatVersion()).add("RequestParameters", this.hasRequestParameters() ? this.requestParameters() : null).add("RequestTemplates", this.hasRequestTemplates() ? this.requestTemplates() : null).add("TemplateSelectionExpression", (Object)this.templateSelectionExpression()).add("TimeoutInMillis", (Object)this.timeoutInMillis()).add("TlsConfig", (Object)this.tlsConfig()).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "ApiId": {
                return Optional.ofNullable(clazz.cast(this.apiId()));
            }
            case "ConnectionId": {
                return Optional.ofNullable(clazz.cast(this.connectionId()));
            }
            case "ConnectionType": {
                return Optional.ofNullable(clazz.cast(this.connectionTypeAsString()));
            }
            case "ContentHandlingStrategy": {
                return Optional.ofNullable(clazz.cast(this.contentHandlingStrategyAsString()));
            }
            case "CredentialsArn": {
                return Optional.ofNullable(clazz.cast(this.credentialsArn()));
            }
            case "Description": {
                return Optional.ofNullable(clazz.cast(this.description()));
            }
            case "IntegrationMethod": {
                return Optional.ofNullable(clazz.cast(this.integrationMethod()));
            }
            case "IntegrationSubtype": {
                return Optional.ofNullable(clazz.cast(this.integrationSubtype()));
            }
            case "IntegrationType": {
                return Optional.ofNullable(clazz.cast(this.integrationTypeAsString()));
            }
            case "IntegrationUri": {
                return Optional.ofNullable(clazz.cast(this.integrationUri()));
            }
            case "PassthroughBehavior": {
                return Optional.ofNullable(clazz.cast(this.passthroughBehaviorAsString()));
            }
            case "PayloadFormatVersion": {
                return Optional.ofNullable(clazz.cast(this.payloadFormatVersion()));
            }
            case "RequestParameters": {
                return Optional.ofNullable(clazz.cast(this.requestParameters()));
            }
            case "RequestTemplates": {
                return Optional.ofNullable(clazz.cast(this.requestTemplates()));
            }
            case "TemplateSelectionExpression": {
                return Optional.ofNullable(clazz.cast(this.templateSelectionExpression()));
            }
            case "TimeoutInMillis": {
                return Optional.ofNullable(clazz.cast(this.timeoutInMillis()));
            }
            case "TlsConfig": {
                return Optional.ofNullable(clazz.cast(this.tlsConfig()));
            }
        }
        return Optional.empty();
    }

    public List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<CreateIntegrationRequest, T> g) {
        return obj -> g.apply((CreateIntegrationRequest)((Object)((Object)obj)));
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    extends ApiGatewayV2Request.BuilderImpl
    implements Builder {
        private String apiId;
        private String connectionId;
        private String connectionType;
        private String contentHandlingStrategy;
        private String credentialsArn;
        private String description;
        private String integrationMethod;
        private String integrationSubtype;
        private String integrationType;
        private String integrationUri;
        private String passthroughBehavior;
        private String payloadFormatVersion;
        private Map<String, String> requestParameters = DefaultSdkAutoConstructMap.getInstance();
        private Map<String, String> requestTemplates = DefaultSdkAutoConstructMap.getInstance();
        private String templateSelectionExpression;
        private Integer timeoutInMillis;
        private TlsConfigInput tlsConfig;

        private BuilderImpl() {
        }

        private BuilderImpl(CreateIntegrationRequest model) {
            super(model);
            this.apiId(model.apiId);
            this.connectionId(model.connectionId);
            this.connectionType(model.connectionType);
            this.contentHandlingStrategy(model.contentHandlingStrategy);
            this.credentialsArn(model.credentialsArn);
            this.description(model.description);
            this.integrationMethod(model.integrationMethod);
            this.integrationSubtype(model.integrationSubtype);
            this.integrationType(model.integrationType);
            this.integrationUri(model.integrationUri);
            this.passthroughBehavior(model.passthroughBehavior);
            this.payloadFormatVersion(model.payloadFormatVersion);
            this.requestParameters(model.requestParameters);
            this.requestTemplates(model.requestTemplates);
            this.templateSelectionExpression(model.templateSelectionExpression);
            this.timeoutInMillis(model.timeoutInMillis);
            this.tlsConfig(model.tlsConfig);
        }

        public final String getApiId() {
            return this.apiId;
        }

        @Override
        public final Builder apiId(String apiId) {
            this.apiId = apiId;
            return this;
        }

        public final void setApiId(String apiId) {
            this.apiId = apiId;
        }

        public final String getConnectionId() {
            return this.connectionId;
        }

        @Override
        public final Builder connectionId(String connectionId) {
            this.connectionId = connectionId;
            return this;
        }

        public final void setConnectionId(String connectionId) {
            this.connectionId = connectionId;
        }

        public final String getConnectionType() {
            return this.connectionType;
        }

        @Override
        public final Builder connectionType(String connectionType) {
            this.connectionType = connectionType;
            return this;
        }

        @Override
        public final Builder connectionType(ConnectionType connectionType) {
            this.connectionType(connectionType == null ? null : connectionType.toString());
            return this;
        }

        public final void setConnectionType(String connectionType) {
            this.connectionType = connectionType;
        }

        public final String getContentHandlingStrategy() {
            return this.contentHandlingStrategy;
        }

        @Override
        public final Builder contentHandlingStrategy(String contentHandlingStrategy) {
            this.contentHandlingStrategy = contentHandlingStrategy;
            return this;
        }

        @Override
        public final Builder contentHandlingStrategy(ContentHandlingStrategy contentHandlingStrategy) {
            this.contentHandlingStrategy(contentHandlingStrategy == null ? null : contentHandlingStrategy.toString());
            return this;
        }

        public final void setContentHandlingStrategy(String contentHandlingStrategy) {
            this.contentHandlingStrategy = contentHandlingStrategy;
        }

        public final String getCredentialsArn() {
            return this.credentialsArn;
        }

        @Override
        public final Builder credentialsArn(String credentialsArn) {
            this.credentialsArn = credentialsArn;
            return this;
        }

        public final void setCredentialsArn(String credentialsArn) {
            this.credentialsArn = credentialsArn;
        }

        public final String getDescription() {
            return this.description;
        }

        @Override
        public final Builder description(String description) {
            this.description = description;
            return this;
        }

        public final void setDescription(String description) {
            this.description = description;
        }

        public final String getIntegrationMethod() {
            return this.integrationMethod;
        }

        @Override
        public final Builder integrationMethod(String integrationMethod) {
            this.integrationMethod = integrationMethod;
            return this;
        }

        public final void setIntegrationMethod(String integrationMethod) {
            this.integrationMethod = integrationMethod;
        }

        public final String getIntegrationSubtype() {
            return this.integrationSubtype;
        }

        @Override
        public final Builder integrationSubtype(String integrationSubtype) {
            this.integrationSubtype = integrationSubtype;
            return this;
        }

        public final void setIntegrationSubtype(String integrationSubtype) {
            this.integrationSubtype = integrationSubtype;
        }

        public final String getIntegrationType() {
            return this.integrationType;
        }

        @Override
        public final Builder integrationType(String integrationType) {
            this.integrationType = integrationType;
            return this;
        }

        @Override
        public final Builder integrationType(IntegrationType integrationType) {
            this.integrationType(integrationType == null ? null : integrationType.toString());
            return this;
        }

        public final void setIntegrationType(String integrationType) {
            this.integrationType = integrationType;
        }

        public final String getIntegrationUri() {
            return this.integrationUri;
        }

        @Override
        public final Builder integrationUri(String integrationUri) {
            this.integrationUri = integrationUri;
            return this;
        }

        public final void setIntegrationUri(String integrationUri) {
            this.integrationUri = integrationUri;
        }

        public final String getPassthroughBehavior() {
            return this.passthroughBehavior;
        }

        @Override
        public final Builder passthroughBehavior(String passthroughBehavior) {
            this.passthroughBehavior = passthroughBehavior;
            return this;
        }

        @Override
        public final Builder passthroughBehavior(PassthroughBehavior passthroughBehavior) {
            this.passthroughBehavior(passthroughBehavior == null ? null : passthroughBehavior.toString());
            return this;
        }

        public final void setPassthroughBehavior(String passthroughBehavior) {
            this.passthroughBehavior = passthroughBehavior;
        }

        public final String getPayloadFormatVersion() {
            return this.payloadFormatVersion;
        }

        @Override
        public final Builder payloadFormatVersion(String payloadFormatVersion) {
            this.payloadFormatVersion = payloadFormatVersion;
            return this;
        }

        public final void setPayloadFormatVersion(String payloadFormatVersion) {
            this.payloadFormatVersion = payloadFormatVersion;
        }

        public final Map<String, String> getRequestParameters() {
            if (this.requestParameters instanceof SdkAutoConstructMap) {
                return null;
            }
            return this.requestParameters;
        }

        @Override
        public final Builder requestParameters(Map<String, String> requestParameters) {
            this.requestParameters = IntegrationParametersCopier.copy(requestParameters);
            return this;
        }

        public final void setRequestParameters(Map<String, String> requestParameters) {
            this.requestParameters = IntegrationParametersCopier.copy(requestParameters);
        }

        public final Map<String, String> getRequestTemplates() {
            if (this.requestTemplates instanceof SdkAutoConstructMap) {
                return null;
            }
            return this.requestTemplates;
        }

        @Override
        public final Builder requestTemplates(Map<String, String> requestTemplates) {
            this.requestTemplates = TemplateMapCopier.copy(requestTemplates);
            return this;
        }

        public final void setRequestTemplates(Map<String, String> requestTemplates) {
            this.requestTemplates = TemplateMapCopier.copy(requestTemplates);
        }

        public final String getTemplateSelectionExpression() {
            return this.templateSelectionExpression;
        }

        @Override
        public final Builder templateSelectionExpression(String templateSelectionExpression) {
            this.templateSelectionExpression = templateSelectionExpression;
            return this;
        }

        public final void setTemplateSelectionExpression(String templateSelectionExpression) {
            this.templateSelectionExpression = templateSelectionExpression;
        }

        public final Integer getTimeoutInMillis() {
            return this.timeoutInMillis;
        }

        @Override
        public final Builder timeoutInMillis(Integer timeoutInMillis) {
            this.timeoutInMillis = timeoutInMillis;
            return this;
        }

        public final void setTimeoutInMillis(Integer timeoutInMillis) {
            this.timeoutInMillis = timeoutInMillis;
        }

        public final TlsConfigInput.Builder getTlsConfig() {
            return this.tlsConfig != null ? this.tlsConfig.toBuilder() : null;
        }

        @Override
        public final Builder tlsConfig(TlsConfigInput tlsConfig) {
            this.tlsConfig = tlsConfig;
            return this;
        }

        public final void setTlsConfig(TlsConfigInput.BuilderImpl tlsConfig) {
            this.tlsConfig = tlsConfig != null ? tlsConfig.build() : null;
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public CreateIntegrationRequest build() {
            return new CreateIntegrationRequest(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }

    public static interface Builder
    extends ApiGatewayV2Request.Builder,
    SdkPojo,
    CopyableBuilder<Builder, CreateIntegrationRequest> {
        public Builder apiId(String var1);

        public Builder connectionId(String var1);

        public Builder connectionType(String var1);

        public Builder connectionType(ConnectionType var1);

        public Builder contentHandlingStrategy(String var1);

        public Builder contentHandlingStrategy(ContentHandlingStrategy var1);

        public Builder credentialsArn(String var1);

        public Builder description(String var1);

        public Builder integrationMethod(String var1);

        public Builder integrationSubtype(String var1);

        public Builder integrationType(String var1);

        public Builder integrationType(IntegrationType var1);

        public Builder integrationUri(String var1);

        public Builder passthroughBehavior(String var1);

        public Builder passthroughBehavior(PassthroughBehavior var1);

        public Builder payloadFormatVersion(String var1);

        public Builder requestParameters(Map<String, String> var1);

        public Builder requestTemplates(Map<String, String> var1);

        public Builder templateSelectionExpression(String var1);

        public Builder timeoutInMillis(Integer var1);

        public Builder tlsConfig(TlsConfigInput var1);

        default public Builder tlsConfig(Consumer<TlsConfigInput.Builder> tlsConfig) {
            return this.tlsConfig((TlsConfigInput)((TlsConfigInput.Builder)TlsConfigInput.builder().applyMutation(tlsConfig)).build());
        }

        public Builder overrideConfiguration(AwsRequestOverrideConfiguration var1);

        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> var1);
    }
}

