/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.apigatewayv2.model;

import java.time.Instant;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.MapTrait;
import software.amazon.awssdk.core.traits.TimestampFormatTrait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructMap;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructMap;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public final class CreateApiResponse extends ApiGatewayV2Response implements
        ToCopyableBuilder<CreateApiResponse.Builder, CreateApiResponse> {
    private static final SdkField<String> API_ENDPOINT_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("ApiEndpoint").getter(getter(CreateApiResponse::apiEndpoint)).setter(setter(Builder::apiEndpoint))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("apiEndpoint").build()).build();

    private static final SdkField<Boolean> API_GATEWAY_MANAGED_FIELD = SdkField.<Boolean> builder(MarshallingType.BOOLEAN)
            .memberName("ApiGatewayManaged").getter(getter(CreateApiResponse::apiGatewayManaged))
            .setter(setter(Builder::apiGatewayManaged))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("apiGatewayManaged").build()).build();

    private static final SdkField<String> API_ID_FIELD = SdkField.<String> builder(MarshallingType.STRING).memberName("ApiId")
            .getter(getter(CreateApiResponse::apiId)).setter(setter(Builder::apiId))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("apiId").build()).build();

    private static final SdkField<String> API_KEY_SELECTION_EXPRESSION_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("ApiKeySelectionExpression").getter(getter(CreateApiResponse::apiKeySelectionExpression))
            .setter(setter(Builder::apiKeySelectionExpression))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("apiKeySelectionExpression").build())
            .build();

    private static final SdkField<Cors> CORS_CONFIGURATION_FIELD = SdkField.<Cors> builder(MarshallingType.SDK_POJO)
            .memberName("CorsConfiguration").getter(getter(CreateApiResponse::corsConfiguration))
            .setter(setter(Builder::corsConfiguration)).constructor(Cors::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("corsConfiguration").build()).build();

    private static final SdkField<Instant> CREATED_DATE_FIELD = SdkField
            .<Instant> builder(MarshallingType.INSTANT)
            .memberName("CreatedDate")
            .getter(getter(CreateApiResponse::createdDate))
            .setter(setter(Builder::createdDate))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("createdDate").build(),
                    TimestampFormatTrait.create(TimestampFormatTrait.Format.ISO_8601)).build();

    private static final SdkField<String> DESCRIPTION_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("Description").getter(getter(CreateApiResponse::description)).setter(setter(Builder::description))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("description").build()).build();

    private static final SdkField<Boolean> DISABLE_SCHEMA_VALIDATION_FIELD = SdkField.<Boolean> builder(MarshallingType.BOOLEAN)
            .memberName("DisableSchemaValidation").getter(getter(CreateApiResponse::disableSchemaValidation))
            .setter(setter(Builder::disableSchemaValidation))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("disableSchemaValidation").build())
            .build();

    private static final SdkField<Boolean> DISABLE_EXECUTE_API_ENDPOINT_FIELD = SdkField
            .<Boolean> builder(MarshallingType.BOOLEAN).memberName("DisableExecuteApiEndpoint")
            .getter(getter(CreateApiResponse::disableExecuteApiEndpoint)).setter(setter(Builder::disableExecuteApiEndpoint))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("disableExecuteApiEndpoint").build())
            .build();

    private static final SdkField<List<String>> IMPORT_INFO_FIELD = SdkField
            .<List<String>> builder(MarshallingType.LIST)
            .memberName("ImportInfo")
            .getter(getter(CreateApiResponse::importInfo))
            .setter(setter(Builder::importInfo))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("importInfo").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<String> builder(MarshallingType.STRING)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final SdkField<String> NAME_FIELD = SdkField.<String> builder(MarshallingType.STRING).memberName("Name")
            .getter(getter(CreateApiResponse::name)).setter(setter(Builder::name))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("name").build()).build();

    private static final SdkField<String> PROTOCOL_TYPE_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("ProtocolType").getter(getter(CreateApiResponse::protocolTypeAsString))
            .setter(setter(Builder::protocolType))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("protocolType").build()).build();

    private static final SdkField<String> ROUTE_SELECTION_EXPRESSION_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("RouteSelectionExpression").getter(getter(CreateApiResponse::routeSelectionExpression))
            .setter(setter(Builder::routeSelectionExpression))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("routeSelectionExpression").build())
            .build();

    private static final SdkField<Map<String, String>> TAGS_FIELD = SdkField
            .<Map<String, String>> builder(MarshallingType.MAP)
            .memberName("Tags")
            .getter(getter(CreateApiResponse::tags))
            .setter(setter(Builder::tags))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("tags").build(),
                    MapTrait.builder()
                            .keyLocationName("key")
                            .valueLocationName("value")
                            .valueFieldInfo(
                                    SdkField.<String> builder(MarshallingType.STRING)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("value").build()).build()).build()).build();

    private static final SdkField<String> VERSION_FIELD = SdkField.<String> builder(MarshallingType.STRING).memberName("Version")
            .getter(getter(CreateApiResponse::version)).setter(setter(Builder::version))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("version").build()).build();

    private static final SdkField<List<String>> WARNINGS_FIELD = SdkField
            .<List<String>> builder(MarshallingType.LIST)
            .memberName("Warnings")
            .getter(getter(CreateApiResponse::warnings))
            .setter(setter(Builder::warnings))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("warnings").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<String> builder(MarshallingType.STRING)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(API_ENDPOINT_FIELD,
            API_GATEWAY_MANAGED_FIELD, API_ID_FIELD, API_KEY_SELECTION_EXPRESSION_FIELD, CORS_CONFIGURATION_FIELD,
            CREATED_DATE_FIELD, DESCRIPTION_FIELD, DISABLE_SCHEMA_VALIDATION_FIELD, DISABLE_EXECUTE_API_ENDPOINT_FIELD,
            IMPORT_INFO_FIELD, NAME_FIELD, PROTOCOL_TYPE_FIELD, ROUTE_SELECTION_EXPRESSION_FIELD, TAGS_FIELD, VERSION_FIELD,
            WARNINGS_FIELD));

    private final String apiEndpoint;

    private final Boolean apiGatewayManaged;

    private final String apiId;

    private final String apiKeySelectionExpression;

    private final Cors corsConfiguration;

    private final Instant createdDate;

    private final String description;

    private final Boolean disableSchemaValidation;

    private final Boolean disableExecuteApiEndpoint;

    private final List<String> importInfo;

    private final String name;

    private final String protocolType;

    private final String routeSelectionExpression;

    private final Map<String, String> tags;

    private final String version;

    private final List<String> warnings;

    private CreateApiResponse(BuilderImpl builder) {
        super(builder);
        this.apiEndpoint = builder.apiEndpoint;
        this.apiGatewayManaged = builder.apiGatewayManaged;
        this.apiId = builder.apiId;
        this.apiKeySelectionExpression = builder.apiKeySelectionExpression;
        this.corsConfiguration = builder.corsConfiguration;
        this.createdDate = builder.createdDate;
        this.description = builder.description;
        this.disableSchemaValidation = builder.disableSchemaValidation;
        this.disableExecuteApiEndpoint = builder.disableExecuteApiEndpoint;
        this.importInfo = builder.importInfo;
        this.name = builder.name;
        this.protocolType = builder.protocolType;
        this.routeSelectionExpression = builder.routeSelectionExpression;
        this.tags = builder.tags;
        this.version = builder.version;
        this.warnings = builder.warnings;
    }

    /**
     * <p>
     * The URI of the API, of the form {api-id}.execute-api.{region}.amazonaws.com. The stage name is typically appended
     * to this URI to form a complete path to a deployed API stage.
     * </p>
     * 
     * @return The URI of the API, of the form {api-id}.execute-api.{region}.amazonaws.com. The stage name is typically
     *         appended to this URI to form a complete path to a deployed API stage.
     */
    public String apiEndpoint() {
        return apiEndpoint;
    }

    /**
     * <p>
     * Specifies whether an API is managed by API Gateway. You can't update or delete a managed API by using API
     * Gateway. A managed API can be deleted only through the tooling or service that created it.
     * </p>
     * 
     * @return Specifies whether an API is managed by API Gateway. You can't update or delete a managed API by using API
     *         Gateway. A managed API can be deleted only through the tooling or service that created it.
     */
    public Boolean apiGatewayManaged() {
        return apiGatewayManaged;
    }

    /**
     * <p>
     * The API ID.
     * </p>
     * 
     * @return The API ID.
     */
    public String apiId() {
        return apiId;
    }

    /**
     * <p>
     * An API key selection expression. Supported only for WebSocket APIs. See <a href=
     * "https://docs.aws.amazon.com/apigateway/latest/developerguide/apigateway-websocket-api-selection-expressions.html#apigateway-websocket-api-apikey-selection-expressions"
     * >API Key Selection Expressions</a>.
     * </p>
     * 
     * @return An API key selection expression. Supported only for WebSocket APIs. See <a href=
     *         "https://docs.aws.amazon.com/apigateway/latest/developerguide/apigateway-websocket-api-selection-expressions.html#apigateway-websocket-api-apikey-selection-expressions"
     *         >API Key Selection Expressions</a>.
     */
    public String apiKeySelectionExpression() {
        return apiKeySelectionExpression;
    }

    /**
     * <p>
     * A CORS configuration. Supported only for HTTP APIs.
     * </p>
     * 
     * @return A CORS configuration. Supported only for HTTP APIs.
     */
    public Cors corsConfiguration() {
        return corsConfiguration;
    }

    /**
     * <p>
     * The timestamp when the API was created.
     * </p>
     * 
     * @return The timestamp when the API was created.
     */
    public Instant createdDate() {
        return createdDate;
    }

    /**
     * <p>
     * The description of the API.
     * </p>
     * 
     * @return The description of the API.
     */
    public String description() {
        return description;
    }

    /**
     * <p>
     * Avoid validating models when creating a deployment. Supported only for WebSocket APIs.
     * </p>
     * 
     * @return Avoid validating models when creating a deployment. Supported only for WebSocket APIs.
     */
    public Boolean disableSchemaValidation() {
        return disableSchemaValidation;
    }

    /**
     * <p>
     * Specifies whether clients can invoke your API by using the default execute-api endpoint. By default, clients can
     * invoke your API with the default https://{api_id}.execute-api.{region}.amazonaws.com endpoint. To require that
     * clients use a custom domain name to invoke your API, disable the default endpoint.
     * </p>
     * 
     * @return Specifies whether clients can invoke your API by using the default execute-api endpoint. By default,
     *         clients can invoke your API with the default https://{api_id}.execute-api.{region}.amazonaws.com
     *         endpoint. To require that clients use a custom domain name to invoke your API, disable the default
     *         endpoint.
     */
    public Boolean disableExecuteApiEndpoint() {
        return disableExecuteApiEndpoint;
    }

    /**
     * Returns true if the ImportInfo property was specified by the sender (it may be empty), or false if the sender did
     * not specify the value (it will be empty). For responses returned by the SDK, the sender is the AWS service.
     */
    public boolean hasImportInfo() {
        return importInfo != null && !(importInfo instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * The validation information during API import. This may include particular properties of your OpenAPI definition
     * which are ignored during import. Supported only for HTTP APIs.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * You can use {@link #hasImportInfo()} to see if a value was sent in this field.
     * </p>
     * 
     * @return The validation information during API import. This may include particular properties of your OpenAPI
     *         definition which are ignored during import. Supported only for HTTP APIs.
     */
    public List<String> importInfo() {
        return importInfo;
    }

    /**
     * <p>
     * The name of the API.
     * </p>
     * 
     * @return The name of the API.
     */
    public String name() {
        return name;
    }

    /**
     * <p>
     * The API protocol.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #protocolType} will
     * return {@link ProtocolType#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #protocolTypeAsString}.
     * </p>
     * 
     * @return The API protocol.
     * @see ProtocolType
     */
    public ProtocolType protocolType() {
        return ProtocolType.fromValue(protocolType);
    }

    /**
     * <p>
     * The API protocol.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #protocolType} will
     * return {@link ProtocolType#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #protocolTypeAsString}.
     * </p>
     * 
     * @return The API protocol.
     * @see ProtocolType
     */
    public String protocolTypeAsString() {
        return protocolType;
    }

    /**
     * <p>
     * The route selection expression for the API. For HTTP APIs, the routeSelectionExpression must be ${request.method}
     * ${request.path}. If not provided, this will be the default for HTTP APIs. This property is required for WebSocket
     * APIs.
     * </p>
     * 
     * @return The route selection expression for the API. For HTTP APIs, the routeSelectionExpression must be
     *         ${request.method} ${request.path}. If not provided, this will be the default for HTTP APIs. This property
     *         is required for WebSocket APIs.
     */
    public String routeSelectionExpression() {
        return routeSelectionExpression;
    }

    /**
     * Returns true if the Tags property was specified by the sender (it may be empty), or false if the sender did not
     * specify the value (it will be empty). For responses returned by the SDK, the sender is the AWS service.
     */
    public boolean hasTags() {
        return tags != null && !(tags instanceof SdkAutoConstructMap);
    }

    /**
     * <p>
     * A collection of tags associated with the API.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * You can use {@link #hasTags()} to see if a value was sent in this field.
     * </p>
     * 
     * @return A collection of tags associated with the API.
     */
    public Map<String, String> tags() {
        return tags;
    }

    /**
     * <p>
     * A version identifier for the API.
     * </p>
     * 
     * @return A version identifier for the API.
     */
    public String version() {
        return version;
    }

    /**
     * Returns true if the Warnings property was specified by the sender (it may be empty), or false if the sender did
     * not specify the value (it will be empty). For responses returned by the SDK, the sender is the AWS service.
     */
    public boolean hasWarnings() {
        return warnings != null && !(warnings instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * The warning messages reported when failonwarnings is turned on during API import.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * You can use {@link #hasWarnings()} to see if a value was sent in this field.
     * </p>
     * 
     * @return The warning messages reported when failonwarnings is turned on during API import.
     */
    public List<String> warnings() {
        return warnings;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(apiEndpoint());
        hashCode = 31 * hashCode + Objects.hashCode(apiGatewayManaged());
        hashCode = 31 * hashCode + Objects.hashCode(apiId());
        hashCode = 31 * hashCode + Objects.hashCode(apiKeySelectionExpression());
        hashCode = 31 * hashCode + Objects.hashCode(corsConfiguration());
        hashCode = 31 * hashCode + Objects.hashCode(createdDate());
        hashCode = 31 * hashCode + Objects.hashCode(description());
        hashCode = 31 * hashCode + Objects.hashCode(disableSchemaValidation());
        hashCode = 31 * hashCode + Objects.hashCode(disableExecuteApiEndpoint());
        hashCode = 31 * hashCode + Objects.hashCode(hasImportInfo() ? importInfo() : null);
        hashCode = 31 * hashCode + Objects.hashCode(name());
        hashCode = 31 * hashCode + Objects.hashCode(protocolTypeAsString());
        hashCode = 31 * hashCode + Objects.hashCode(routeSelectionExpression());
        hashCode = 31 * hashCode + Objects.hashCode(hasTags() ? tags() : null);
        hashCode = 31 * hashCode + Objects.hashCode(version());
        hashCode = 31 * hashCode + Objects.hashCode(hasWarnings() ? warnings() : null);
        return hashCode;
    }

    @Override
    public boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof CreateApiResponse)) {
            return false;
        }
        CreateApiResponse other = (CreateApiResponse) obj;
        return Objects.equals(apiEndpoint(), other.apiEndpoint())
                && Objects.equals(apiGatewayManaged(), other.apiGatewayManaged()) && Objects.equals(apiId(), other.apiId())
                && Objects.equals(apiKeySelectionExpression(), other.apiKeySelectionExpression())
                && Objects.equals(corsConfiguration(), other.corsConfiguration())
                && Objects.equals(createdDate(), other.createdDate()) && Objects.equals(description(), other.description())
                && Objects.equals(disableSchemaValidation(), other.disableSchemaValidation())
                && Objects.equals(disableExecuteApiEndpoint(), other.disableExecuteApiEndpoint())
                && hasImportInfo() == other.hasImportInfo() && Objects.equals(importInfo(), other.importInfo())
                && Objects.equals(name(), other.name()) && Objects.equals(protocolTypeAsString(), other.protocolTypeAsString())
                && Objects.equals(routeSelectionExpression(), other.routeSelectionExpression()) && hasTags() == other.hasTags()
                && Objects.equals(tags(), other.tags()) && Objects.equals(version(), other.version())
                && hasWarnings() == other.hasWarnings() && Objects.equals(warnings(), other.warnings());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public String toString() {
        return ToString.builder("CreateApiResponse").add("ApiEndpoint", apiEndpoint())
                .add("ApiGatewayManaged", apiGatewayManaged()).add("ApiId", apiId())
                .add("ApiKeySelectionExpression", apiKeySelectionExpression()).add("CorsConfiguration", corsConfiguration())
                .add("CreatedDate", createdDate()).add("Description", description())
                .add("DisableSchemaValidation", disableSchemaValidation())
                .add("DisableExecuteApiEndpoint", disableExecuteApiEndpoint())
                .add("ImportInfo", hasImportInfo() ? importInfo() : null).add("Name", name())
                .add("ProtocolType", protocolTypeAsString()).add("RouteSelectionExpression", routeSelectionExpression())
                .add("Tags", hasTags() ? tags() : null).add("Version", version())
                .add("Warnings", hasWarnings() ? warnings() : null).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "ApiEndpoint":
            return Optional.ofNullable(clazz.cast(apiEndpoint()));
        case "ApiGatewayManaged":
            return Optional.ofNullable(clazz.cast(apiGatewayManaged()));
        case "ApiId":
            return Optional.ofNullable(clazz.cast(apiId()));
        case "ApiKeySelectionExpression":
            return Optional.ofNullable(clazz.cast(apiKeySelectionExpression()));
        case "CorsConfiguration":
            return Optional.ofNullable(clazz.cast(corsConfiguration()));
        case "CreatedDate":
            return Optional.ofNullable(clazz.cast(createdDate()));
        case "Description":
            return Optional.ofNullable(clazz.cast(description()));
        case "DisableSchemaValidation":
            return Optional.ofNullable(clazz.cast(disableSchemaValidation()));
        case "DisableExecuteApiEndpoint":
            return Optional.ofNullable(clazz.cast(disableExecuteApiEndpoint()));
        case "ImportInfo":
            return Optional.ofNullable(clazz.cast(importInfo()));
        case "Name":
            return Optional.ofNullable(clazz.cast(name()));
        case "ProtocolType":
            return Optional.ofNullable(clazz.cast(protocolTypeAsString()));
        case "RouteSelectionExpression":
            return Optional.ofNullable(clazz.cast(routeSelectionExpression()));
        case "Tags":
            return Optional.ofNullable(clazz.cast(tags()));
        case "Version":
            return Optional.ofNullable(clazz.cast(version()));
        case "Warnings":
            return Optional.ofNullable(clazz.cast(warnings()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<CreateApiResponse, T> g) {
        return obj -> g.apply((CreateApiResponse) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends ApiGatewayV2Response.Builder, SdkPojo, CopyableBuilder<Builder, CreateApiResponse> {
        /**
         * <p>
         * The URI of the API, of the form {api-id}.execute-api.{region}.amazonaws.com. The stage name is typically
         * appended to this URI to form a complete path to a deployed API stage.
         * </p>
         * 
         * @param apiEndpoint
         *        The URI of the API, of the form {api-id}.execute-api.{region}.amazonaws.com. The stage name is
         *        typically appended to this URI to form a complete path to a deployed API stage.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder apiEndpoint(String apiEndpoint);

        /**
         * <p>
         * Specifies whether an API is managed by API Gateway. You can't update or delete a managed API by using API
         * Gateway. A managed API can be deleted only through the tooling or service that created it.
         * </p>
         * 
         * @param apiGatewayManaged
         *        Specifies whether an API is managed by API Gateway. You can't update or delete a managed API by using
         *        API Gateway. A managed API can be deleted only through the tooling or service that created it.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder apiGatewayManaged(Boolean apiGatewayManaged);

        /**
         * <p>
         * The API ID.
         * </p>
         * 
         * @param apiId
         *        The API ID.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder apiId(String apiId);

        /**
         * <p>
         * An API key selection expression. Supported only for WebSocket APIs. See <a href=
         * "https://docs.aws.amazon.com/apigateway/latest/developerguide/apigateway-websocket-api-selection-expressions.html#apigateway-websocket-api-apikey-selection-expressions"
         * >API Key Selection Expressions</a>.
         * </p>
         * 
         * @param apiKeySelectionExpression
         *        An API key selection expression. Supported only for WebSocket APIs. See <a href=
         *        "https://docs.aws.amazon.com/apigateway/latest/developerguide/apigateway-websocket-api-selection-expressions.html#apigateway-websocket-api-apikey-selection-expressions"
         *        >API Key Selection Expressions</a>.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder apiKeySelectionExpression(String apiKeySelectionExpression);

        /**
         * <p>
         * A CORS configuration. Supported only for HTTP APIs.
         * </p>
         * 
         * @param corsConfiguration
         *        A CORS configuration. Supported only for HTTP APIs.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder corsConfiguration(Cors corsConfiguration);

        /**
         * <p>
         * A CORS configuration. Supported only for HTTP APIs.
         * </p>
         * This is a convenience that creates an instance of the {@link Cors.Builder} avoiding the need to create one
         * manually via {@link Cors#builder()}.
         *
         * When the {@link Consumer} completes, {@link Cors.Builder#build()} is called immediately and its result is
         * passed to {@link #corsConfiguration(Cors)}.
         * 
         * @param corsConfiguration
         *        a consumer that will call methods on {@link Cors.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #corsConfiguration(Cors)
         */
        default Builder corsConfiguration(Consumer<Cors.Builder> corsConfiguration) {
            return corsConfiguration(Cors.builder().applyMutation(corsConfiguration).build());
        }

        /**
         * <p>
         * The timestamp when the API was created.
         * </p>
         * 
         * @param createdDate
         *        The timestamp when the API was created.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder createdDate(Instant createdDate);

        /**
         * <p>
         * The description of the API.
         * </p>
         * 
         * @param description
         *        The description of the API.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder description(String description);

        /**
         * <p>
         * Avoid validating models when creating a deployment. Supported only for WebSocket APIs.
         * </p>
         * 
         * @param disableSchemaValidation
         *        Avoid validating models when creating a deployment. Supported only for WebSocket APIs.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder disableSchemaValidation(Boolean disableSchemaValidation);

        /**
         * <p>
         * Specifies whether clients can invoke your API by using the default execute-api endpoint. By default, clients
         * can invoke your API with the default https://{api_id}.execute-api.{region}.amazonaws.com endpoint. To require
         * that clients use a custom domain name to invoke your API, disable the default endpoint.
         * </p>
         * 
         * @param disableExecuteApiEndpoint
         *        Specifies whether clients can invoke your API by using the default execute-api endpoint. By default,
         *        clients can invoke your API with the default https://{api_id}.execute-api.{region}.amazonaws.com
         *        endpoint. To require that clients use a custom domain name to invoke your API, disable the default
         *        endpoint.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder disableExecuteApiEndpoint(Boolean disableExecuteApiEndpoint);

        /**
         * <p>
         * The validation information during API import. This may include particular properties of your OpenAPI
         * definition which are ignored during import. Supported only for HTTP APIs.
         * </p>
         * 
         * @param importInfo
         *        The validation information during API import. This may include particular properties of your OpenAPI
         *        definition which are ignored during import. Supported only for HTTP APIs.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder importInfo(Collection<String> importInfo);

        /**
         * <p>
         * The validation information during API import. This may include particular properties of your OpenAPI
         * definition which are ignored during import. Supported only for HTTP APIs.
         * </p>
         * 
         * @param importInfo
         *        The validation information during API import. This may include particular properties of your OpenAPI
         *        definition which are ignored during import. Supported only for HTTP APIs.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder importInfo(String... importInfo);

        /**
         * <p>
         * The name of the API.
         * </p>
         * 
         * @param name
         *        The name of the API.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder name(String name);

        /**
         * <p>
         * The API protocol.
         * </p>
         * 
         * @param protocolType
         *        The API protocol.
         * @see ProtocolType
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see ProtocolType
         */
        Builder protocolType(String protocolType);

        /**
         * <p>
         * The API protocol.
         * </p>
         * 
         * @param protocolType
         *        The API protocol.
         * @see ProtocolType
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see ProtocolType
         */
        Builder protocolType(ProtocolType protocolType);

        /**
         * <p>
         * The route selection expression for the API. For HTTP APIs, the routeSelectionExpression must be
         * ${request.method} ${request.path}. If not provided, this will be the default for HTTP APIs. This property is
         * required for WebSocket APIs.
         * </p>
         * 
         * @param routeSelectionExpression
         *        The route selection expression for the API. For HTTP APIs, the routeSelectionExpression must be
         *        ${request.method} ${request.path}. If not provided, this will be the default for HTTP APIs. This
         *        property is required for WebSocket APIs.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder routeSelectionExpression(String routeSelectionExpression);

        /**
         * <p>
         * A collection of tags associated with the API.
         * </p>
         * 
         * @param tags
         *        A collection of tags associated with the API.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder tags(Map<String, String> tags);

        /**
         * <p>
         * A version identifier for the API.
         * </p>
         * 
         * @param version
         *        A version identifier for the API.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder version(String version);

        /**
         * <p>
         * The warning messages reported when failonwarnings is turned on during API import.
         * </p>
         * 
         * @param warnings
         *        The warning messages reported when failonwarnings is turned on during API import.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder warnings(Collection<String> warnings);

        /**
         * <p>
         * The warning messages reported when failonwarnings is turned on during API import.
         * </p>
         * 
         * @param warnings
         *        The warning messages reported when failonwarnings is turned on during API import.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder warnings(String... warnings);
    }

    static final class BuilderImpl extends ApiGatewayV2Response.BuilderImpl implements Builder {
        private String apiEndpoint;

        private Boolean apiGatewayManaged;

        private String apiId;

        private String apiKeySelectionExpression;

        private Cors corsConfiguration;

        private Instant createdDate;

        private String description;

        private Boolean disableSchemaValidation;

        private Boolean disableExecuteApiEndpoint;

        private List<String> importInfo = DefaultSdkAutoConstructList.getInstance();

        private String name;

        private String protocolType;

        private String routeSelectionExpression;

        private Map<String, String> tags = DefaultSdkAutoConstructMap.getInstance();

        private String version;

        private List<String> warnings = DefaultSdkAutoConstructList.getInstance();

        private BuilderImpl() {
        }

        private BuilderImpl(CreateApiResponse model) {
            super(model);
            apiEndpoint(model.apiEndpoint);
            apiGatewayManaged(model.apiGatewayManaged);
            apiId(model.apiId);
            apiKeySelectionExpression(model.apiKeySelectionExpression);
            corsConfiguration(model.corsConfiguration);
            createdDate(model.createdDate);
            description(model.description);
            disableSchemaValidation(model.disableSchemaValidation);
            disableExecuteApiEndpoint(model.disableExecuteApiEndpoint);
            importInfo(model.importInfo);
            name(model.name);
            protocolType(model.protocolType);
            routeSelectionExpression(model.routeSelectionExpression);
            tags(model.tags);
            version(model.version);
            warnings(model.warnings);
        }

        public final String getApiEndpoint() {
            return apiEndpoint;
        }

        @Override
        public final Builder apiEndpoint(String apiEndpoint) {
            this.apiEndpoint = apiEndpoint;
            return this;
        }

        public final void setApiEndpoint(String apiEndpoint) {
            this.apiEndpoint = apiEndpoint;
        }

        public final Boolean getApiGatewayManaged() {
            return apiGatewayManaged;
        }

        @Override
        public final Builder apiGatewayManaged(Boolean apiGatewayManaged) {
            this.apiGatewayManaged = apiGatewayManaged;
            return this;
        }

        public final void setApiGatewayManaged(Boolean apiGatewayManaged) {
            this.apiGatewayManaged = apiGatewayManaged;
        }

        public final String getApiId() {
            return apiId;
        }

        @Override
        public final Builder apiId(String apiId) {
            this.apiId = apiId;
            return this;
        }

        public final void setApiId(String apiId) {
            this.apiId = apiId;
        }

        public final String getApiKeySelectionExpression() {
            return apiKeySelectionExpression;
        }

        @Override
        public final Builder apiKeySelectionExpression(String apiKeySelectionExpression) {
            this.apiKeySelectionExpression = apiKeySelectionExpression;
            return this;
        }

        public final void setApiKeySelectionExpression(String apiKeySelectionExpression) {
            this.apiKeySelectionExpression = apiKeySelectionExpression;
        }

        public final Cors.Builder getCorsConfiguration() {
            return corsConfiguration != null ? corsConfiguration.toBuilder() : null;
        }

        @Override
        public final Builder corsConfiguration(Cors corsConfiguration) {
            this.corsConfiguration = corsConfiguration;
            return this;
        }

        public final void setCorsConfiguration(Cors.BuilderImpl corsConfiguration) {
            this.corsConfiguration = corsConfiguration != null ? corsConfiguration.build() : null;
        }

        public final Instant getCreatedDate() {
            return createdDate;
        }

        @Override
        public final Builder createdDate(Instant createdDate) {
            this.createdDate = createdDate;
            return this;
        }

        public final void setCreatedDate(Instant createdDate) {
            this.createdDate = createdDate;
        }

        public final String getDescription() {
            return description;
        }

        @Override
        public final Builder description(String description) {
            this.description = description;
            return this;
        }

        public final void setDescription(String description) {
            this.description = description;
        }

        public final Boolean getDisableSchemaValidation() {
            return disableSchemaValidation;
        }

        @Override
        public final Builder disableSchemaValidation(Boolean disableSchemaValidation) {
            this.disableSchemaValidation = disableSchemaValidation;
            return this;
        }

        public final void setDisableSchemaValidation(Boolean disableSchemaValidation) {
            this.disableSchemaValidation = disableSchemaValidation;
        }

        public final Boolean getDisableExecuteApiEndpoint() {
            return disableExecuteApiEndpoint;
        }

        @Override
        public final Builder disableExecuteApiEndpoint(Boolean disableExecuteApiEndpoint) {
            this.disableExecuteApiEndpoint = disableExecuteApiEndpoint;
            return this;
        }

        public final void setDisableExecuteApiEndpoint(Boolean disableExecuteApiEndpoint) {
            this.disableExecuteApiEndpoint = disableExecuteApiEndpoint;
        }

        public final Collection<String> getImportInfo() {
            if (importInfo instanceof SdkAutoConstructList) {
                return null;
            }
            return importInfo;
        }

        @Override
        public final Builder importInfo(Collection<String> importInfo) {
            this.importInfo = ___listOf__stringCopier.copy(importInfo);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder importInfo(String... importInfo) {
            importInfo(Arrays.asList(importInfo));
            return this;
        }

        public final void setImportInfo(Collection<String> importInfo) {
            this.importInfo = ___listOf__stringCopier.copy(importInfo);
        }

        public final String getName() {
            return name;
        }

        @Override
        public final Builder name(String name) {
            this.name = name;
            return this;
        }

        public final void setName(String name) {
            this.name = name;
        }

        public final String getProtocolType() {
            return protocolType;
        }

        @Override
        public final Builder protocolType(String protocolType) {
            this.protocolType = protocolType;
            return this;
        }

        @Override
        public final Builder protocolType(ProtocolType protocolType) {
            this.protocolType(protocolType == null ? null : protocolType.toString());
            return this;
        }

        public final void setProtocolType(String protocolType) {
            this.protocolType = protocolType;
        }

        public final String getRouteSelectionExpression() {
            return routeSelectionExpression;
        }

        @Override
        public final Builder routeSelectionExpression(String routeSelectionExpression) {
            this.routeSelectionExpression = routeSelectionExpression;
            return this;
        }

        public final void setRouteSelectionExpression(String routeSelectionExpression) {
            this.routeSelectionExpression = routeSelectionExpression;
        }

        public final Map<String, String> getTags() {
            if (tags instanceof SdkAutoConstructMap) {
                return null;
            }
            return tags;
        }

        @Override
        public final Builder tags(Map<String, String> tags) {
            this.tags = TagsCopier.copy(tags);
            return this;
        }

        public final void setTags(Map<String, String> tags) {
            this.tags = TagsCopier.copy(tags);
        }

        public final String getVersion() {
            return version;
        }

        @Override
        public final Builder version(String version) {
            this.version = version;
            return this;
        }

        public final void setVersion(String version) {
            this.version = version;
        }

        public final Collection<String> getWarnings() {
            if (warnings instanceof SdkAutoConstructList) {
                return null;
            }
            return warnings;
        }

        @Override
        public final Builder warnings(Collection<String> warnings) {
            this.warnings = ___listOf__stringCopier.copy(warnings);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder warnings(String... warnings) {
            warnings(Arrays.asList(warnings));
            return this;
        }

        public final void setWarnings(Collection<String> warnings) {
            this.warnings = ___listOf__stringCopier.copy(warnings);
        }

        @Override
        public CreateApiResponse build() {
            return new CreateApiResponse(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
