/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.apigatewayv2.model;

import java.io.Serializable;
import java.time.Instant;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.TimestampFormatTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * The domain name configuration.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class DomainNameConfiguration implements SdkPojo, Serializable,
        ToCopyableBuilder<DomainNameConfiguration.Builder, DomainNameConfiguration> {
    private static final SdkField<String> API_GATEWAY_DOMAIN_NAME_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("ApiGatewayDomainName").getter(getter(DomainNameConfiguration::apiGatewayDomainName))
            .setter(setter(Builder::apiGatewayDomainName))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("apiGatewayDomainName").build())
            .build();

    private static final SdkField<String> CERTIFICATE_ARN_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("CertificateArn").getter(getter(DomainNameConfiguration::certificateArn))
            .setter(setter(Builder::certificateArn))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("certificateArn").build()).build();

    private static final SdkField<String> CERTIFICATE_NAME_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("CertificateName").getter(getter(DomainNameConfiguration::certificateName))
            .setter(setter(Builder::certificateName))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("certificateName").build()).build();

    private static final SdkField<Instant> CERTIFICATE_UPLOAD_DATE_FIELD = SdkField
            .<Instant> builder(MarshallingType.INSTANT)
            .memberName("CertificateUploadDate")
            .getter(getter(DomainNameConfiguration::certificateUploadDate))
            .setter(setter(Builder::certificateUploadDate))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("certificateUploadDate").build(),
                    TimestampFormatTrait.create(TimestampFormatTrait.Format.ISO_8601)).build();

    private static final SdkField<String> DOMAIN_NAME_STATUS_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("DomainNameStatus").getter(getter(DomainNameConfiguration::domainNameStatusAsString))
            .setter(setter(Builder::domainNameStatus))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("domainNameStatus").build()).build();

    private static final SdkField<String> DOMAIN_NAME_STATUS_MESSAGE_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("DomainNameStatusMessage").getter(getter(DomainNameConfiguration::domainNameStatusMessage))
            .setter(setter(Builder::domainNameStatusMessage))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("domainNameStatusMessage").build())
            .build();

    private static final SdkField<String> ENDPOINT_TYPE_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("EndpointType").getter(getter(DomainNameConfiguration::endpointTypeAsString))
            .setter(setter(Builder::endpointType))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("endpointType").build()).build();

    private static final SdkField<String> HOSTED_ZONE_ID_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("HostedZoneId").getter(getter(DomainNameConfiguration::hostedZoneId))
            .setter(setter(Builder::hostedZoneId))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("hostedZoneId").build()).build();

    private static final SdkField<String> SECURITY_POLICY_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("SecurityPolicy").getter(getter(DomainNameConfiguration::securityPolicyAsString))
            .setter(setter(Builder::securityPolicy))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("securityPolicy").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(API_GATEWAY_DOMAIN_NAME_FIELD,
            CERTIFICATE_ARN_FIELD, CERTIFICATE_NAME_FIELD, CERTIFICATE_UPLOAD_DATE_FIELD, DOMAIN_NAME_STATUS_FIELD,
            DOMAIN_NAME_STATUS_MESSAGE_FIELD, ENDPOINT_TYPE_FIELD, HOSTED_ZONE_ID_FIELD, SECURITY_POLICY_FIELD));

    private static final long serialVersionUID = 1L;

    private final String apiGatewayDomainName;

    private final String certificateArn;

    private final String certificateName;

    private final Instant certificateUploadDate;

    private final String domainNameStatus;

    private final String domainNameStatusMessage;

    private final String endpointType;

    private final String hostedZoneId;

    private final String securityPolicy;

    private DomainNameConfiguration(BuilderImpl builder) {
        this.apiGatewayDomainName = builder.apiGatewayDomainName;
        this.certificateArn = builder.certificateArn;
        this.certificateName = builder.certificateName;
        this.certificateUploadDate = builder.certificateUploadDate;
        this.domainNameStatus = builder.domainNameStatus;
        this.domainNameStatusMessage = builder.domainNameStatusMessage;
        this.endpointType = builder.endpointType;
        this.hostedZoneId = builder.hostedZoneId;
        this.securityPolicy = builder.securityPolicy;
    }

    /**
     * <p>
     * A domain name for the API.
     * </p>
     * 
     * @return A domain name for the API.
     */
    public String apiGatewayDomainName() {
        return apiGatewayDomainName;
    }

    /**
     * <p>
     * An AWS-managed certificate that will be used by the edge-optimized endpoint for this domain name. AWS Certificate
     * Manager is the only supported source.
     * </p>
     * 
     * @return An AWS-managed certificate that will be used by the edge-optimized endpoint for this domain name. AWS
     *         Certificate Manager is the only supported source.
     */
    public String certificateArn() {
        return certificateArn;
    }

    /**
     * <p>
     * The user-friendly name of the certificate that will be used by the edge-optimized endpoint for this domain name.
     * </p>
     * 
     * @return The user-friendly name of the certificate that will be used by the edge-optimized endpoint for this
     *         domain name.
     */
    public String certificateName() {
        return certificateName;
    }

    /**
     * <p>
     * The timestamp when the certificate that was used by edge-optimized endpoint for this domain name was uploaded.
     * </p>
     * 
     * @return The timestamp when the certificate that was used by edge-optimized endpoint for this domain name was
     *         uploaded.
     */
    public Instant certificateUploadDate() {
        return certificateUploadDate;
    }

    /**
     * <p>
     * The status of the domain name migration. The valid values are AVAILABLE and UPDATING. If the status is UPDATING,
     * the domain cannot be modified further until the existing operation is complete. If it is AVAILABLE, the domain
     * can be updated.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #domainNameStatus}
     * will return {@link DomainNameStatus#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available
     * from {@link #domainNameStatusAsString}.
     * </p>
     * 
     * @return The status of the domain name migration. The valid values are AVAILABLE and UPDATING. If the status is
     *         UPDATING, the domain cannot be modified further until the existing operation is complete. If it is
     *         AVAILABLE, the domain can be updated.
     * @see DomainNameStatus
     */
    public DomainNameStatus domainNameStatus() {
        return DomainNameStatus.fromValue(domainNameStatus);
    }

    /**
     * <p>
     * The status of the domain name migration. The valid values are AVAILABLE and UPDATING. If the status is UPDATING,
     * the domain cannot be modified further until the existing operation is complete. If it is AVAILABLE, the domain
     * can be updated.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #domainNameStatus}
     * will return {@link DomainNameStatus#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available
     * from {@link #domainNameStatusAsString}.
     * </p>
     * 
     * @return The status of the domain name migration. The valid values are AVAILABLE and UPDATING. If the status is
     *         UPDATING, the domain cannot be modified further until the existing operation is complete. If it is
     *         AVAILABLE, the domain can be updated.
     * @see DomainNameStatus
     */
    public String domainNameStatusAsString() {
        return domainNameStatus;
    }

    /**
     * <p>
     * An optional text message containing detailed information about status of the domain name migration.
     * </p>
     * 
     * @return An optional text message containing detailed information about status of the domain name migration.
     */
    public String domainNameStatusMessage() {
        return domainNameStatusMessage;
    }

    /**
     * <p>
     * The endpoint type.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #endpointType} will
     * return {@link EndpointType#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #endpointTypeAsString}.
     * </p>
     * 
     * @return The endpoint type.
     * @see EndpointType
     */
    public EndpointType endpointType() {
        return EndpointType.fromValue(endpointType);
    }

    /**
     * <p>
     * The endpoint type.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #endpointType} will
     * return {@link EndpointType#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #endpointTypeAsString}.
     * </p>
     * 
     * @return The endpoint type.
     * @see EndpointType
     */
    public String endpointTypeAsString() {
        return endpointType;
    }

    /**
     * <p>
     * The Amazon Route 53 Hosted Zone ID of the endpoint.
     * </p>
     * 
     * @return The Amazon Route 53 Hosted Zone ID of the endpoint.
     */
    public String hostedZoneId() {
        return hostedZoneId;
    }

    /**
     * <p>
     * The Transport Layer Security (TLS) version of the security policy for this domain name. The valid values are
     * TLS_1_0 and TLS_1_2.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #securityPolicy}
     * will return {@link SecurityPolicy#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available
     * from {@link #securityPolicyAsString}.
     * </p>
     * 
     * @return The Transport Layer Security (TLS) version of the security policy for this domain name. The valid values
     *         are TLS_1_0 and TLS_1_2.
     * @see SecurityPolicy
     */
    public SecurityPolicy securityPolicy() {
        return SecurityPolicy.fromValue(securityPolicy);
    }

    /**
     * <p>
     * The Transport Layer Security (TLS) version of the security policy for this domain name. The valid values are
     * TLS_1_0 and TLS_1_2.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #securityPolicy}
     * will return {@link SecurityPolicy#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available
     * from {@link #securityPolicyAsString}.
     * </p>
     * 
     * @return The Transport Layer Security (TLS) version of the security policy for this domain name. The valid values
     *         are TLS_1_0 and TLS_1_2.
     * @see SecurityPolicy
     */
    public String securityPolicyAsString() {
        return securityPolicy;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(apiGatewayDomainName());
        hashCode = 31 * hashCode + Objects.hashCode(certificateArn());
        hashCode = 31 * hashCode + Objects.hashCode(certificateName());
        hashCode = 31 * hashCode + Objects.hashCode(certificateUploadDate());
        hashCode = 31 * hashCode + Objects.hashCode(domainNameStatusAsString());
        hashCode = 31 * hashCode + Objects.hashCode(domainNameStatusMessage());
        hashCode = 31 * hashCode + Objects.hashCode(endpointTypeAsString());
        hashCode = 31 * hashCode + Objects.hashCode(hostedZoneId());
        hashCode = 31 * hashCode + Objects.hashCode(securityPolicyAsString());
        return hashCode;
    }

    @Override
    public boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof DomainNameConfiguration)) {
            return false;
        }
        DomainNameConfiguration other = (DomainNameConfiguration) obj;
        return Objects.equals(apiGatewayDomainName(), other.apiGatewayDomainName())
                && Objects.equals(certificateArn(), other.certificateArn())
                && Objects.equals(certificateName(), other.certificateName())
                && Objects.equals(certificateUploadDate(), other.certificateUploadDate())
                && Objects.equals(domainNameStatusAsString(), other.domainNameStatusAsString())
                && Objects.equals(domainNameStatusMessage(), other.domainNameStatusMessage())
                && Objects.equals(endpointTypeAsString(), other.endpointTypeAsString())
                && Objects.equals(hostedZoneId(), other.hostedZoneId())
                && Objects.equals(securityPolicyAsString(), other.securityPolicyAsString());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public String toString() {
        return ToString.builder("DomainNameConfiguration").add("ApiGatewayDomainName", apiGatewayDomainName())
                .add("CertificateArn", certificateArn()).add("CertificateName", certificateName())
                .add("CertificateUploadDate", certificateUploadDate()).add("DomainNameStatus", domainNameStatusAsString())
                .add("DomainNameStatusMessage", domainNameStatusMessage()).add("EndpointType", endpointTypeAsString())
                .add("HostedZoneId", hostedZoneId()).add("SecurityPolicy", securityPolicyAsString()).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "ApiGatewayDomainName":
            return Optional.ofNullable(clazz.cast(apiGatewayDomainName()));
        case "CertificateArn":
            return Optional.ofNullable(clazz.cast(certificateArn()));
        case "CertificateName":
            return Optional.ofNullable(clazz.cast(certificateName()));
        case "CertificateUploadDate":
            return Optional.ofNullable(clazz.cast(certificateUploadDate()));
        case "DomainNameStatus":
            return Optional.ofNullable(clazz.cast(domainNameStatusAsString()));
        case "DomainNameStatusMessage":
            return Optional.ofNullable(clazz.cast(domainNameStatusMessage()));
        case "EndpointType":
            return Optional.ofNullable(clazz.cast(endpointTypeAsString()));
        case "HostedZoneId":
            return Optional.ofNullable(clazz.cast(hostedZoneId()));
        case "SecurityPolicy":
            return Optional.ofNullable(clazz.cast(securityPolicyAsString()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<DomainNameConfiguration, T> g) {
        return obj -> g.apply((DomainNameConfiguration) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SdkPojo, CopyableBuilder<Builder, DomainNameConfiguration> {
        /**
         * <p>
         * A domain name for the API.
         * </p>
         * 
         * @param apiGatewayDomainName
         *        A domain name for the API.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder apiGatewayDomainName(String apiGatewayDomainName);

        /**
         * <p>
         * An AWS-managed certificate that will be used by the edge-optimized endpoint for this domain name. AWS
         * Certificate Manager is the only supported source.
         * </p>
         * 
         * @param certificateArn
         *        An AWS-managed certificate that will be used by the edge-optimized endpoint for this domain name. AWS
         *        Certificate Manager is the only supported source.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder certificateArn(String certificateArn);

        /**
         * <p>
         * The user-friendly name of the certificate that will be used by the edge-optimized endpoint for this domain
         * name.
         * </p>
         * 
         * @param certificateName
         *        The user-friendly name of the certificate that will be used by the edge-optimized endpoint for this
         *        domain name.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder certificateName(String certificateName);

        /**
         * <p>
         * The timestamp when the certificate that was used by edge-optimized endpoint for this domain name was
         * uploaded.
         * </p>
         * 
         * @param certificateUploadDate
         *        The timestamp when the certificate that was used by edge-optimized endpoint for this domain name was
         *        uploaded.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder certificateUploadDate(Instant certificateUploadDate);

        /**
         * <p>
         * The status of the domain name migration. The valid values are AVAILABLE and UPDATING. If the status is
         * UPDATING, the domain cannot be modified further until the existing operation is complete. If it is AVAILABLE,
         * the domain can be updated.
         * </p>
         * 
         * @param domainNameStatus
         *        The status of the domain name migration. The valid values are AVAILABLE and UPDATING. If the status is
         *        UPDATING, the domain cannot be modified further until the existing operation is complete. If it is
         *        AVAILABLE, the domain can be updated.
         * @see DomainNameStatus
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see DomainNameStatus
         */
        Builder domainNameStatus(String domainNameStatus);

        /**
         * <p>
         * The status of the domain name migration. The valid values are AVAILABLE and UPDATING. If the status is
         * UPDATING, the domain cannot be modified further until the existing operation is complete. If it is AVAILABLE,
         * the domain can be updated.
         * </p>
         * 
         * @param domainNameStatus
         *        The status of the domain name migration. The valid values are AVAILABLE and UPDATING. If the status is
         *        UPDATING, the domain cannot be modified further until the existing operation is complete. If it is
         *        AVAILABLE, the domain can be updated.
         * @see DomainNameStatus
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see DomainNameStatus
         */
        Builder domainNameStatus(DomainNameStatus domainNameStatus);

        /**
         * <p>
         * An optional text message containing detailed information about status of the domain name migration.
         * </p>
         * 
         * @param domainNameStatusMessage
         *        An optional text message containing detailed information about status of the domain name migration.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder domainNameStatusMessage(String domainNameStatusMessage);

        /**
         * <p>
         * The endpoint type.
         * </p>
         * 
         * @param endpointType
         *        The endpoint type.
         * @see EndpointType
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see EndpointType
         */
        Builder endpointType(String endpointType);

        /**
         * <p>
         * The endpoint type.
         * </p>
         * 
         * @param endpointType
         *        The endpoint type.
         * @see EndpointType
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see EndpointType
         */
        Builder endpointType(EndpointType endpointType);

        /**
         * <p>
         * The Amazon Route 53 Hosted Zone ID of the endpoint.
         * </p>
         * 
         * @param hostedZoneId
         *        The Amazon Route 53 Hosted Zone ID of the endpoint.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder hostedZoneId(String hostedZoneId);

        /**
         * <p>
         * The Transport Layer Security (TLS) version of the security policy for this domain name. The valid values are
         * TLS_1_0 and TLS_1_2.
         * </p>
         * 
         * @param securityPolicy
         *        The Transport Layer Security (TLS) version of the security policy for this domain name. The valid
         *        values are TLS_1_0 and TLS_1_2.
         * @see SecurityPolicy
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see SecurityPolicy
         */
        Builder securityPolicy(String securityPolicy);

        /**
         * <p>
         * The Transport Layer Security (TLS) version of the security policy for this domain name. The valid values are
         * TLS_1_0 and TLS_1_2.
         * </p>
         * 
         * @param securityPolicy
         *        The Transport Layer Security (TLS) version of the security policy for this domain name. The valid
         *        values are TLS_1_0 and TLS_1_2.
         * @see SecurityPolicy
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see SecurityPolicy
         */
        Builder securityPolicy(SecurityPolicy securityPolicy);
    }

    static final class BuilderImpl implements Builder {
        private String apiGatewayDomainName;

        private String certificateArn;

        private String certificateName;

        private Instant certificateUploadDate;

        private String domainNameStatus;

        private String domainNameStatusMessage;

        private String endpointType;

        private String hostedZoneId;

        private String securityPolicy;

        private BuilderImpl() {
        }

        private BuilderImpl(DomainNameConfiguration model) {
            apiGatewayDomainName(model.apiGatewayDomainName);
            certificateArn(model.certificateArn);
            certificateName(model.certificateName);
            certificateUploadDate(model.certificateUploadDate);
            domainNameStatus(model.domainNameStatus);
            domainNameStatusMessage(model.domainNameStatusMessage);
            endpointType(model.endpointType);
            hostedZoneId(model.hostedZoneId);
            securityPolicy(model.securityPolicy);
        }

        public final String getApiGatewayDomainName() {
            return apiGatewayDomainName;
        }

        @Override
        public final Builder apiGatewayDomainName(String apiGatewayDomainName) {
            this.apiGatewayDomainName = apiGatewayDomainName;
            return this;
        }

        public final void setApiGatewayDomainName(String apiGatewayDomainName) {
            this.apiGatewayDomainName = apiGatewayDomainName;
        }

        public final String getCertificateArn() {
            return certificateArn;
        }

        @Override
        public final Builder certificateArn(String certificateArn) {
            this.certificateArn = certificateArn;
            return this;
        }

        public final void setCertificateArn(String certificateArn) {
            this.certificateArn = certificateArn;
        }

        public final String getCertificateName() {
            return certificateName;
        }

        @Override
        public final Builder certificateName(String certificateName) {
            this.certificateName = certificateName;
            return this;
        }

        public final void setCertificateName(String certificateName) {
            this.certificateName = certificateName;
        }

        public final Instant getCertificateUploadDate() {
            return certificateUploadDate;
        }

        @Override
        public final Builder certificateUploadDate(Instant certificateUploadDate) {
            this.certificateUploadDate = certificateUploadDate;
            return this;
        }

        public final void setCertificateUploadDate(Instant certificateUploadDate) {
            this.certificateUploadDate = certificateUploadDate;
        }

        public final String getDomainNameStatus() {
            return domainNameStatus;
        }

        @Override
        public final Builder domainNameStatus(String domainNameStatus) {
            this.domainNameStatus = domainNameStatus;
            return this;
        }

        @Override
        public final Builder domainNameStatus(DomainNameStatus domainNameStatus) {
            this.domainNameStatus(domainNameStatus == null ? null : domainNameStatus.toString());
            return this;
        }

        public final void setDomainNameStatus(String domainNameStatus) {
            this.domainNameStatus = domainNameStatus;
        }

        public final String getDomainNameStatusMessage() {
            return domainNameStatusMessage;
        }

        @Override
        public final Builder domainNameStatusMessage(String domainNameStatusMessage) {
            this.domainNameStatusMessage = domainNameStatusMessage;
            return this;
        }

        public final void setDomainNameStatusMessage(String domainNameStatusMessage) {
            this.domainNameStatusMessage = domainNameStatusMessage;
        }

        public final String getEndpointType() {
            return endpointType;
        }

        @Override
        public final Builder endpointType(String endpointType) {
            this.endpointType = endpointType;
            return this;
        }

        @Override
        public final Builder endpointType(EndpointType endpointType) {
            this.endpointType(endpointType == null ? null : endpointType.toString());
            return this;
        }

        public final void setEndpointType(String endpointType) {
            this.endpointType = endpointType;
        }

        public final String getHostedZoneId() {
            return hostedZoneId;
        }

        @Override
        public final Builder hostedZoneId(String hostedZoneId) {
            this.hostedZoneId = hostedZoneId;
            return this;
        }

        public final void setHostedZoneId(String hostedZoneId) {
            this.hostedZoneId = hostedZoneId;
        }

        public final String getSecurityPolicy() {
            return securityPolicy;
        }

        @Override
        public final Builder securityPolicy(String securityPolicy) {
            this.securityPolicy = securityPolicy;
            return this;
        }

        @Override
        public final Builder securityPolicy(SecurityPolicy securityPolicy) {
            this.securityPolicy(securityPolicy == null ? null : securityPolicy.toString());
            return this;
        }

        public final void setSecurityPolicy(String securityPolicy) {
            this.securityPolicy = securityPolicy;
        }

        @Override
        public DomainNameConfiguration build() {
            return new DomainNameConfiguration(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
