/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.apigatewayv2.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.MapTrait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructMap;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructMap;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * Represents a domain name.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class DomainName implements SdkPojo, Serializable, ToCopyableBuilder<DomainName.Builder, DomainName> {
    private static final SdkField<String> API_MAPPING_SELECTION_EXPRESSION_FIELD = SdkField
            .<String> builder(MarshallingType.STRING)
            .memberName("ApiMappingSelectionExpression")
            .getter(getter(DomainName::apiMappingSelectionExpression))
            .setter(setter(Builder::apiMappingSelectionExpression))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("apiMappingSelectionExpression")
                    .build()).build();

    private static final SdkField<String> DOMAIN_NAME_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("DomainName").getter(getter(DomainName::domainName)).setter(setter(Builder::domainName))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("domainName").build()).build();

    private static final SdkField<List<DomainNameConfiguration>> DOMAIN_NAME_CONFIGURATIONS_FIELD = SdkField
            .<List<DomainNameConfiguration>> builder(MarshallingType.LIST)
            .memberName("DomainNameConfigurations")
            .getter(getter(DomainName::domainNameConfigurations))
            .setter(setter(Builder::domainNameConfigurations))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("domainNameConfigurations").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<DomainNameConfiguration> builder(MarshallingType.SDK_POJO)
                                            .constructor(DomainNameConfiguration::builder)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final SdkField<MutualTlsAuthentication> MUTUAL_TLS_AUTHENTICATION_FIELD = SdkField
            .<MutualTlsAuthentication> builder(MarshallingType.SDK_POJO).memberName("MutualTlsAuthentication")
            .getter(getter(DomainName::mutualTlsAuthentication)).setter(setter(Builder::mutualTlsAuthentication))
            .constructor(MutualTlsAuthentication::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("mutualTlsAuthentication").build())
            .build();

    private static final SdkField<Map<String, String>> TAGS_FIELD = SdkField
            .<Map<String, String>> builder(MarshallingType.MAP)
            .memberName("Tags")
            .getter(getter(DomainName::tags))
            .setter(setter(Builder::tags))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("tags").build(),
                    MapTrait.builder()
                            .keyLocationName("key")
                            .valueLocationName("value")
                            .valueFieldInfo(
                                    SdkField.<String> builder(MarshallingType.STRING)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("value").build()).build()).build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(
            API_MAPPING_SELECTION_EXPRESSION_FIELD, DOMAIN_NAME_FIELD, DOMAIN_NAME_CONFIGURATIONS_FIELD,
            MUTUAL_TLS_AUTHENTICATION_FIELD, TAGS_FIELD));

    private static final long serialVersionUID = 1L;

    private final String apiMappingSelectionExpression;

    private final String domainName;

    private final List<DomainNameConfiguration> domainNameConfigurations;

    private final MutualTlsAuthentication mutualTlsAuthentication;

    private final Map<String, String> tags;

    private DomainName(BuilderImpl builder) {
        this.apiMappingSelectionExpression = builder.apiMappingSelectionExpression;
        this.domainName = builder.domainName;
        this.domainNameConfigurations = builder.domainNameConfigurations;
        this.mutualTlsAuthentication = builder.mutualTlsAuthentication;
        this.tags = builder.tags;
    }

    /**
     * <p>
     * The API mapping selection expression.
     * </p>
     * 
     * @return The API mapping selection expression.
     */
    public final String apiMappingSelectionExpression() {
        return apiMappingSelectionExpression;
    }

    /**
     * <p>
     * The name of the DomainName resource.
     * </p>
     * 
     * @return The name of the DomainName resource.
     */
    public final String domainName() {
        return domainName;
    }

    /**
     * Returns true if the DomainNameConfigurations property was specified by the sender (it may be empty), or false if
     * the sender did not specify the value (it will be empty). For responses returned by the SDK, the sender is the AWS
     * service.
     */
    public final boolean hasDomainNameConfigurations() {
        return domainNameConfigurations != null && !(domainNameConfigurations instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * The domain name configurations.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * You can use {@link #hasDomainNameConfigurations()} to see if a value was sent in this field.
     * </p>
     * 
     * @return The domain name configurations.
     */
    public final List<DomainNameConfiguration> domainNameConfigurations() {
        return domainNameConfigurations;
    }

    /**
     * <p>
     * The mutual TLS authentication configuration for a custom domain name.
     * </p>
     * 
     * @return The mutual TLS authentication configuration for a custom domain name.
     */
    public final MutualTlsAuthentication mutualTlsAuthentication() {
        return mutualTlsAuthentication;
    }

    /**
     * Returns true if the Tags property was specified by the sender (it may be empty), or false if the sender did not
     * specify the value (it will be empty). For responses returned by the SDK, the sender is the AWS service.
     */
    public final boolean hasTags() {
        return tags != null && !(tags instanceof SdkAutoConstructMap);
    }

    /**
     * <p>
     * The collection of tags associated with a domain name.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * You can use {@link #hasTags()} to see if a value was sent in this field.
     * </p>
     * 
     * @return The collection of tags associated with a domain name.
     */
    public final Map<String, String> tags() {
        return tags;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(apiMappingSelectionExpression());
        hashCode = 31 * hashCode + Objects.hashCode(domainName());
        hashCode = 31 * hashCode + Objects.hashCode(hasDomainNameConfigurations() ? domainNameConfigurations() : null);
        hashCode = 31 * hashCode + Objects.hashCode(mutualTlsAuthentication());
        hashCode = 31 * hashCode + Objects.hashCode(hasTags() ? tags() : null);
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof DomainName)) {
            return false;
        }
        DomainName other = (DomainName) obj;
        return Objects.equals(apiMappingSelectionExpression(), other.apiMappingSelectionExpression())
                && Objects.equals(domainName(), other.domainName())
                && hasDomainNameConfigurations() == other.hasDomainNameConfigurations()
                && Objects.equals(domainNameConfigurations(), other.domainNameConfigurations())
                && Objects.equals(mutualTlsAuthentication(), other.mutualTlsAuthentication()) && hasTags() == other.hasTags()
                && Objects.equals(tags(), other.tags());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("DomainName").add("ApiMappingSelectionExpression", apiMappingSelectionExpression())
                .add("DomainName", domainName())
                .add("DomainNameConfigurations", hasDomainNameConfigurations() ? domainNameConfigurations() : null)
                .add("MutualTlsAuthentication", mutualTlsAuthentication()).add("Tags", hasTags() ? tags() : null).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "ApiMappingSelectionExpression":
            return Optional.ofNullable(clazz.cast(apiMappingSelectionExpression()));
        case "DomainName":
            return Optional.ofNullable(clazz.cast(domainName()));
        case "DomainNameConfigurations":
            return Optional.ofNullable(clazz.cast(domainNameConfigurations()));
        case "MutualTlsAuthentication":
            return Optional.ofNullable(clazz.cast(mutualTlsAuthentication()));
        case "Tags":
            return Optional.ofNullable(clazz.cast(tags()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<DomainName, T> g) {
        return obj -> g.apply((DomainName) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SdkPojo, CopyableBuilder<Builder, DomainName> {
        /**
         * <p>
         * The API mapping selection expression.
         * </p>
         * 
         * @param apiMappingSelectionExpression
         *        The API mapping selection expression.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder apiMappingSelectionExpression(String apiMappingSelectionExpression);

        /**
         * <p>
         * The name of the DomainName resource.
         * </p>
         * 
         * @param domainName
         *        The name of the DomainName resource.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder domainName(String domainName);

        /**
         * <p>
         * The domain name configurations.
         * </p>
         * 
         * @param domainNameConfigurations
         *        The domain name configurations.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder domainNameConfigurations(Collection<DomainNameConfiguration> domainNameConfigurations);

        /**
         * <p>
         * The domain name configurations.
         * </p>
         * 
         * @param domainNameConfigurations
         *        The domain name configurations.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder domainNameConfigurations(DomainNameConfiguration... domainNameConfigurations);

        /**
         * <p>
         * The domain name configurations.
         * </p>
         * This is a convenience that creates an instance of the {@link List<DomainNameConfiguration>.Builder} avoiding
         * the need to create one manually via {@link List<DomainNameConfiguration>#builder()}.
         *
         * When the {@link Consumer} completes, {@link List<DomainNameConfiguration>.Builder#build()} is called
         * immediately and its result is passed to {@link #domainNameConfigurations(List<DomainNameConfiguration>)}.
         * 
         * @param domainNameConfigurations
         *        a consumer that will call methods on {@link List<DomainNameConfiguration>.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #domainNameConfigurations(List<DomainNameConfiguration>)
         */
        Builder domainNameConfigurations(Consumer<DomainNameConfiguration.Builder>... domainNameConfigurations);

        /**
         * <p>
         * The mutual TLS authentication configuration for a custom domain name.
         * </p>
         * 
         * @param mutualTlsAuthentication
         *        The mutual TLS authentication configuration for a custom domain name.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder mutualTlsAuthentication(MutualTlsAuthentication mutualTlsAuthentication);

        /**
         * <p>
         * The mutual TLS authentication configuration for a custom domain name.
         * </p>
         * This is a convenience that creates an instance of the {@link MutualTlsAuthentication.Builder} avoiding the
         * need to create one manually via {@link MutualTlsAuthentication#builder()}.
         *
         * When the {@link Consumer} completes, {@link MutualTlsAuthentication.Builder#build()} is called immediately
         * and its result is passed to {@link #mutualTlsAuthentication(MutualTlsAuthentication)}.
         * 
         * @param mutualTlsAuthentication
         *        a consumer that will call methods on {@link MutualTlsAuthentication.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #mutualTlsAuthentication(MutualTlsAuthentication)
         */
        default Builder mutualTlsAuthentication(Consumer<MutualTlsAuthentication.Builder> mutualTlsAuthentication) {
            return mutualTlsAuthentication(MutualTlsAuthentication.builder().applyMutation(mutualTlsAuthentication).build());
        }

        /**
         * <p>
         * The collection of tags associated with a domain name.
         * </p>
         * 
         * @param tags
         *        The collection of tags associated with a domain name.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder tags(Map<String, String> tags);
    }

    static final class BuilderImpl implements Builder {
        private String apiMappingSelectionExpression;

        private String domainName;

        private List<DomainNameConfiguration> domainNameConfigurations = DefaultSdkAutoConstructList.getInstance();

        private MutualTlsAuthentication mutualTlsAuthentication;

        private Map<String, String> tags = DefaultSdkAutoConstructMap.getInstance();

        private BuilderImpl() {
        }

        private BuilderImpl(DomainName model) {
            apiMappingSelectionExpression(model.apiMappingSelectionExpression);
            domainName(model.domainName);
            domainNameConfigurations(model.domainNameConfigurations);
            mutualTlsAuthentication(model.mutualTlsAuthentication);
            tags(model.tags);
        }

        public final String getApiMappingSelectionExpression() {
            return apiMappingSelectionExpression;
        }

        @Override
        public final Builder apiMappingSelectionExpression(String apiMappingSelectionExpression) {
            this.apiMappingSelectionExpression = apiMappingSelectionExpression;
            return this;
        }

        public final void setApiMappingSelectionExpression(String apiMappingSelectionExpression) {
            this.apiMappingSelectionExpression = apiMappingSelectionExpression;
        }

        public final String getDomainName() {
            return domainName;
        }

        @Override
        public final Builder domainName(String domainName) {
            this.domainName = domainName;
            return this;
        }

        public final void setDomainName(String domainName) {
            this.domainName = domainName;
        }

        public final List<DomainNameConfiguration.Builder> getDomainNameConfigurations() {
            List<DomainNameConfiguration.Builder> result = DomainNameConfigurationsCopier
                    .copyToBuilder(this.domainNameConfigurations);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        @Override
        public final Builder domainNameConfigurations(Collection<DomainNameConfiguration> domainNameConfigurations) {
            this.domainNameConfigurations = DomainNameConfigurationsCopier.copy(domainNameConfigurations);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder domainNameConfigurations(DomainNameConfiguration... domainNameConfigurations) {
            domainNameConfigurations(Arrays.asList(domainNameConfigurations));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder domainNameConfigurations(Consumer<DomainNameConfiguration.Builder>... domainNameConfigurations) {
            domainNameConfigurations(Stream.of(domainNameConfigurations)
                    .map(c -> DomainNameConfiguration.builder().applyMutation(c).build()).collect(Collectors.toList()));
            return this;
        }

        public final void setDomainNameConfigurations(Collection<DomainNameConfiguration.BuilderImpl> domainNameConfigurations) {
            this.domainNameConfigurations = DomainNameConfigurationsCopier.copyFromBuilder(domainNameConfigurations);
        }

        public final MutualTlsAuthentication.Builder getMutualTlsAuthentication() {
            return mutualTlsAuthentication != null ? mutualTlsAuthentication.toBuilder() : null;
        }

        @Override
        public final Builder mutualTlsAuthentication(MutualTlsAuthentication mutualTlsAuthentication) {
            this.mutualTlsAuthentication = mutualTlsAuthentication;
            return this;
        }

        public final void setMutualTlsAuthentication(MutualTlsAuthentication.BuilderImpl mutualTlsAuthentication) {
            this.mutualTlsAuthentication = mutualTlsAuthentication != null ? mutualTlsAuthentication.build() : null;
        }

        public final Map<String, String> getTags() {
            if (tags instanceof SdkAutoConstructMap) {
                return null;
            }
            return tags;
        }

        @Override
        public final Builder tags(Map<String, String> tags) {
            this.tags = TagsCopier.copy(tags);
            return this;
        }

        public final void setTags(Map<String, String> tags) {
            this.tags = TagsCopier.copy(tags);
        }

        @Override
        public DomainName build() {
            return new DomainName(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
